/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.handler.IItemHandler;
import net.sf.l2j.gameserver.handler.ItemHandler;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.PcInventory;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.ShowCalculator;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class UseItem
extends ClientBasePacket {
    private static Logger _log = Logger.getLogger(UseItem.class.getName());
    private static final String _C__14_USEITEM = "[C] 14 UseItem";
    private final int _objectId = this.readD();

    public UseItem(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        if (activeChar == null) {
            return;
        }
        PcInventory pcInventory = activeChar.getInventory();
        synchronized (pcInventory) {
            L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._objectId);
            if (activeChar.isDead()) {
                SystemMessage sm = new SystemMessage(113);
                sm.addItemName(item.getItemId());
                this.getClient().getActiveChar().sendPacket(sm);
                return;
            }
            if (Config.DEBUG) {
                _log.finest(activeChar.getObjectId() + ": use item " + this._objectId);
            }
            if (item != null && item.isEquipable()) {
                L2ItemInstance[] items = activeChar.getInventory().equipItemAndRecord(item);
                SystemMessage sm = new SystemMessage(49);
                sm.addItemName(item.getItemId());
                activeChar.sendPacket(sm);
                InventoryUpdate iu = new InventoryUpdate(new ArrayList<L2ItemInstance>(Arrays.asList(items)));
                activeChar.sendPacket(iu);
                activeChar.abortAttack();
                activeChar.broadcastUserInfo();
            } else if (item != null && item.getItemId() == 4393) {
                activeChar.sendPacket(new ShowCalculator(4393));
            } else if (item != null) {
                IItemHandler handler = ItemHandler.getInstance().getItemHandler(item.getItemId());
                if (handler == null) {
                    _log.warning("no itemhandler registered for itemId:" + item.getItemId());
                } else {
                    handler.useItem(activeChar, item);
                }
            }
        }
    }

    public String getType() {
        return _C__14_USEITEM;
    }
}

