/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.handler.ItemHandler;

public class AdminCommandHandler {
    private static Logger _log = Logger.getLogger(ItemHandler.class.getName());
    private static AdminCommandHandler _instance;
    private Map<String, IAdminCommandHandler> _datatable = new HashMap<String, IAdminCommandHandler>();

    public static AdminCommandHandler getInstance() {
        if (_instance == null) {
            _instance = new AdminCommandHandler();
        }
        return _instance;
    }

    private AdminCommandHandler() {
    }

    public void registerAdminCommandHandler(IAdminCommandHandler handler) {
        String[] ids = handler.getAdminCommandList();
        for (int i = 0; i < ids.length; ++i) {
            if (Config.DEBUG) {
                _log.fine("Adding handler for command " + ids[i]);
            }
            this._datatable.put(new String(ids[i]), handler);
        }
    }

    public IAdminCommandHandler getAdminCommandHandler(String adminCommand) {
        String command = adminCommand;
        if (adminCommand.indexOf(" ") != -1) {
            command = adminCommand.substring(0, adminCommand.indexOf(" "));
        }
        if (Config.DEBUG) {
            _log.fine("getting handler for command: " + command + " -> " + (this._datatable.get(new String(command)) != null));
        }
        return this._datatable.get(command);
    }

    public int size() {
        return this._datatable.size();
    }
}

