/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.LeaveWorld;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminDisconnect
implements IAdminCommandHandler {
    private static String[] _adminCommands = new String[]{"admin_character_disconnect"};
    private static final int REQUIRED_LEVEL = Config.GM_KICK;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.equals("admin_character_disconnect")) {
            this.disconnectCharacter(activeChar);
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void disconnectCharacter(L2PcInstance activeChar) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            return;
        }
        player = (L2PcInstance)target;
        if (player.getObjectId() == activeChar.getObjectId()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("You cannot logout your character.");
            activeChar.sendPacket(sm);
        } else {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Character " + player.getName() + " disconnected from server.");
            activeChar.sendPacket(sm);
            LeaveWorld ql = new LeaveWorld();
            player.sendPacket(ql);
            player.closeNetConnection();
        }
    }
}

