/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClanTable;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.CharInfo;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.serverpackets.UserInfo;

public class AdminEditChar
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminEditChar.class.getName());
    private static String[] _adminCommands = new String[]{"admin_edit_character", "admin_current_player", "admin_nokarma", "admin_setkarma", "admin_setew", "admin_character_list", "admin_show_characters", "admin_find_character", "admin_save_modifications", "admin_rec"};
    private static final int REQUIRED_LEVEL = Config.GM_CHAR_EDIT;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.equals("admin_edit_character")) {
            this.editCharacter(activeChar);
        } else if (command.equals("admin_current_player")) {
            this.showCharacterList(activeChar);
        } else if (command.equals("admin_nokarma")) {
            this.setTargetKarma(activeChar, 0);
        } else if (command.startsWith("admin_setkarma")) {
            try {
                String val = command.substring(15);
                int karma = Integer.parseInt(val);
                this.setTargetKarma(activeChar, karma);
            }
            catch (StringIndexOutOfBoundsException e) {
                if (Config.DEVELOPER) {
                    System.out.println("Set karma error: " + e);
                }
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Please specify new karma value.");
                activeChar.sendPacket(sm);
            }
        } else if (command.startsWith("admin_setew")) {
            try {
                String val = command.substring(12);
                int ench = Integer.parseInt(val);
                this.setTargetEW(activeChar, ench);
            }
            catch (StringIndexOutOfBoundsException e) {
                if (Config.DEVELOPER) {
                    System.out.println("Set weapon enchant error: " + e);
                }
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Please specify new enchant value.");
                activeChar.sendPacket(sm);
            }
        } else if (command.startsWith("admin_character_list")) {
            try {
                this.showCharacterList(activeChar);
            }
            catch (StringIndexOutOfBoundsException e) {}
        } else if (command.startsWith("admin_show_characters")) {
            try {
                String val = command.substring(22);
                int page = Integer.parseInt(val);
                this.listCharacters(activeChar, page);
            }
            catch (StringIndexOutOfBoundsException e) {}
        } else if (command.startsWith("admin_find_character")) {
            try {
                String val = command.substring(21);
                this.findCharacter(activeChar, val);
            }
            catch (StringIndexOutOfBoundsException e) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("You didnt enter a character name to find.");
                activeChar.sendPacket(sm);
                this.listCharacters(activeChar, 0);
            }
        } else if (command.startsWith("admin_save_modifications")) {
            try {
                String val = command.substring(24);
                this.adminModifyCharacter(activeChar, val);
            }
            catch (StringIndexOutOfBoundsException e) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Error while modifying character.");
                activeChar.sendPacket(sm);
                this.listCharacters(activeChar, 0);
            }
        } else if (command.equals("admin_rec")) {
            L2Object target = activeChar.getTarget();
            L2PcInstance player = null;
            if (!(target instanceof L2PcInstance)) {
                return false;
            }
            player = (L2PcInstance)target;
            player.setRecomHave(player.getRecomHave() + 1);
            SystemMessage sm = new SystemMessage(614);
            sm.addString("You have been recommended by a GM");
            player.sendPacket(sm);
            player.broadcastUserInfo();
        } else if (command.startsWith("admin_rec")) {
            String val = command.substring(10);
            int recVal = Integer.parseInt(val);
            L2Object target = activeChar.getTarget();
            L2PcInstance player = null;
            if (!(target instanceof L2PcInstance)) {
                return false;
            }
            player = (L2PcInstance)target;
            player.setRecomHave(player.getRecomHave() + recVal);
            SystemMessage sm = new SystemMessage(614);
            sm.addString("You have been recommended by a GM");
            player.sendPacket(sm);
            player.broadcastUserInfo();
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void listCharacters(L2PcInstance activeChar, int page) {
        Collection<L2PcInstance> allPlayers = L2World.getInstance().getAllPlayers();
        L2PcInstance[] players = allPlayers.toArray(new L2PcInstance[allPlayers.size()]);
        int MaxCharactersPerPage = 20;
        int MaxPages = players.length / MaxCharactersPerPage;
        int modulus = players.length % MaxCharactersPerPage;
        if (modulus != 0) {
            ++MaxPages;
        }
        if (page > MaxPages) {
            page = MaxPages;
        }
        int CharactersStart = MaxCharactersPerPage * page;
        int CharactersEnd = players.length - CharactersStart;
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Character Selection Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br>");
        replyMSG.append("<table width=270>");
        replyMSG.append("<tr><td width=270>You can find a character by writing his name and</td></tr>");
        replyMSG.append("<tr><td width=270>clicking Find bellow.<br></td></tr>");
        replyMSG.append("<tr><td width=270>Note: Names should be written case sensitive.</td></tr>");
        replyMSG.append("</table><br>");
        replyMSG.append("<center><table><tr><td>");
        replyMSG.append("<edit var=\"character_name\" width=80></td><td><button value=\"Find\" action=\"bypass -h admin_find_character $character_name\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</td></tr></table></center><br><br>");
        for (int x = 0; x < MaxPages; ++x) {
            replyMSG.append("<center><a action=\"bypass -h admin_show_characters " + x + "\">Page " + x + 1 + "</a></center>");
        }
        replyMSG.append("<br>");
        replyMSG.append("<table width=270>");
        replyMSG.append("<tr><td width=80>Name:</td><td width=110>Class:</td><td width=40>Level:</td></tr>");
        for (int i = CharactersStart; i < CharactersEnd; ++i) {
            replyMSG.append("<tr><td width=80><a action=\"bypass -h admin_character_list " + players[i].getName() + "\">" + players[i].getName() + "</a></td><td width=110>" + players[i].getTemplate().className + "</td><td width=40>" + players[i].getLevel() + "</td></tr>");
        }
        replyMSG.append("</table>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    private void showCharacterList(L2PcInstance activeChar) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            return;
        }
        player = (L2PcInstance)target;
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Character Selection Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_show_characters 0\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br>");
        replyMSG.append("<center>Character Information:</center>");
        replyMSG.append("<br>");
        replyMSG.append("<table width=270>");
        replyMSG.append("<tr><td width=135>Name: " + player.getName() + "</td><td width=135>Lv: " + player.getLevel() + " " + player.getTemplate().className + "</td></tr>");
        replyMSG.append("<tr><td width=135>Clan: " + ClanTable.getInstance().getClan(player.getClanId()) + "</td><td width=135>Exp: " + player.getExp() + "</td></tr>");
        replyMSG.append("</table>");
        replyMSG.append("<table width=270>");
        replyMSG.append("<tr><td width=270>Class Template Id: " + (Object)((Object)player.getClassId()) + "</td></tr>");
        replyMSG.append("<tr><td width=270>Character Co-ordinates: " + player.getX() + " " + player.getY() + " " + player.getZ() + "</td></tr>");
        replyMSG.append("</table>");
        replyMSG.append("<br>");
        replyMSG.append("<table width=270>");
        replyMSG.append("<tr><td width=40></td><td width=70>Curent:</td><td width=70>Max:</td><td width=90></td></tr>");
        replyMSG.append("<tr><td width=40>HP:</td><td width=70>" + player.getCurrentHp() + "</td><td width=70>" + player.getMaxHp() + "</td><td width=70>Karma: " + player.getKarma() + "</td><td width=20></td></tr>");
        replyMSG.append("<tr><td width=40>MP:</td><td width=70>" + player.getCurrentMp() + "</td><td width=70>" + player.getMaxMp() + "</td><td width=70>Pvp Kills: " + player.getPvpKills() + "</td><td width=20></td></tr>");
        replyMSG.append("<tr><td width=40>Load:</td><td width=70>" + player.getCurrentLoad() + "</td><td width=70>" + player.getMaxLoad() + "</td><td width=70>Pvp Flag: " + player.getPvpFlag() + "</td><td width=20></td></tr>");
        replyMSG.append("<tr><td width=40>SP:</td><td width=70>" + player.getSp() + "</td><td width=70></td><td width=90></td></tr>");
        replyMSG.append("</table>");
        replyMSG.append("<table width=270>");
        replyMSG.append("<tr><td width=60>P.ATK: " + player.getPAtk(null) + "</td><td width=100>M.ATK: " + player.getMAtk(null, null) + "</td><td width=40>Manage:</td></tr>");
        replyMSG.append("<tr><td width=60>P.DEF: " + player.getPDef(null) + "</td><td width=100>M.DEF: " + player.getMDef(null, null) + "</td><td width=40></td></tr>");
        replyMSG.append("<tr><td width=90>Accuracy: " + player.getAccuracy() + "</td><td width=70>Evasion: " + player.getEvasionRate(null) + "</td><td width=40><button value=\"Skills\" action=\"bypass -h admin_show_skills\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("<tr><td width=90>Critical: " + player.getCriticalHit(null, null) + "</td><td width=70>Speed: " + player.getRunSpeed() + "</td><td width=40><button value=\"Stats\" action=\"bypass -h admin_edit_character\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("<tr><td width=90>ATK Spd: " + player.getPAtkSpd() + "</td><td width=70>Casting Spd: " + player.getMAtkSpd() + "</td><td width=40><button value=\"Exp & Sp\" action=\"bypass -h admin_add_exp_sp_to_character\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("</table>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setTargetEW(L2PcInstance activeChar, int ench) {
        L2Object target = activeChar.getTarget();
        if (target == null) {
            target = activeChar;
        }
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) return;
        player = (L2PcInstance)target;
        if (ench >= 0 && ench <= 65535) {
            int curEnchant = 0;
            String weapType = "NONE";
            int dropSlot = 7;
            int dropSlot2 = 14;
            boolean canEnchant = false;
            L2ItemInstance pWeapInstance = null;
            L2ItemInstance weaponToEnchant = null;
            if (canEnchant) return;
            pWeapInstance = player.getInventory().getPaperdollItem(dropSlot);
            if (pWeapInstance.getEquipSlot() == dropSlot) {
                weaponToEnchant = pWeapInstance;
                curEnchant = weaponToEnchant.getEnchantLevel();
                canEnchant = true;
                weapType = "R-Hand";
            } else {
                pWeapInstance = player.getInventory().getPaperdollItem(dropSlot2);
                if (pWeapInstance.getEquipSlot() == dropSlot2) {
                    weaponToEnchant = pWeapInstance;
                    curEnchant = weaponToEnchant.getEnchantLevel();
                    canEnchant = true;
                    weapType = "LR-Hand";
                }
            }
            if (canEnchant && weaponToEnchant != null) {
                player.getInventory().unEquipItemInSlotAndRecord(dropSlot);
                pWeapInstance.setEnchantLevel(ench);
                player.getInventory().equipItemAndRecord(weaponToEnchant);
                InventoryUpdate iu = new InventoryUpdate();
                iu.addModifiedItem(weaponToEnchant);
                player.sendPacket(iu);
                CharInfo info1 = new CharInfo(player);
                player.broadcastPacket(info1);
                UserInfo info2 = new UserInfo(player);
                player.sendPacket(info2);
                SystemMessage smA = new SystemMessage(614);
                smA.addString("Changed enchantment of equipped " + weapType + " weapon (" + weaponToEnchant.getItem().getName() + ") from (" + curEnchant + ") to (" + ench + ").");
                activeChar.sendPacket(smA);
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Admin has changed the enchantment of your equipped weapon (" + weaponToEnchant.getItem().getName() + ") from " + curEnchant + " to " + ench + ".");
                player.sendPacket(sm);
                return;
            }
            SystemMessage smA = new SystemMessage(614);
            smA.addString("Cannot enchant weapon for player " + player.getName() + ": No weapon equipped.");
            activeChar.sendPacket(smA);
            return;
        }
        SystemMessage smA = new SystemMessage(614);
        smA.addString("You must set the enchant level to be between 0-65535.");
        activeChar.sendPacket(smA);
    }

    private void setTargetKarma(L2PcInstance activeChar, int newKarma) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            return;
        }
        player = (L2PcInstance)target;
        if (newKarma >= 0) {
            int oldKarma = player.getKarma();
            player.setKarma(newKarma);
            StatusUpdate su = new StatusUpdate(player.getObjectId());
            su.addAttribute(StatusUpdate.KARMA, newKarma);
            player.sendPacket(su);
            CharInfo info1 = new CharInfo(player);
            player.broadcastPacket(info1);
            UserInfo info2 = new UserInfo(player);
            player.sendPacket(info2);
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Admin has changed your karma from " + oldKarma + " to " + newKarma + ".");
            player.sendPacket(sm);
            SystemMessage smA = new SystemMessage(614);
            smA.addString("Successfully Changed karma for " + player.getName() + " from (" + oldKarma + ") to (" + newKarma + ").");
            activeChar.sendPacket(smA);
            if (Config.DEBUG) {
                _log.fine("[SET KARMA] [GM]" + activeChar.getName() + " Changed karma for " + player.getName() + " from (" + oldKarma + ") to (" + newKarma + ").");
            }
        } else {
            SystemMessage smA = new SystemMessage(614);
            smA.addString("You must enter a value for karma greater than or equal to 0.");
            activeChar.sendPacket(smA);
            if (Config.DEBUG) {
                _log.fine("[SET KARMA] ERROR: [GM]" + activeChar.getName() + " entered an incorrect value for new karma: " + newKarma + " for " + player.getName() + ".");
            }
        }
    }

    private void adminModifyCharacter(L2PcInstance activeChar, String modifications) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            return;
        }
        player = (L2PcInstance)target;
        StringTokenizer st = new StringTokenizer(modifications);
        if (st.countTokens() != 9) {
            this.editCharacter(player);
        } else {
            String hp = st.nextToken();
            String hpmax = st.nextToken();
            String mp = st.nextToken();
            String mpmax = st.nextToken();
            String load = st.nextToken();
            String karma = st.nextToken();
            String pvpflag = st.nextToken();
            String pvpkills = st.nextToken();
            String classid = st.nextToken();
            int hpval = Integer.parseInt(hp);
            int hpmaxval = Integer.parseInt(hpmax);
            int mpval = Integer.parseInt(mp);
            int mpmaxval = Integer.parseInt(mpmax);
            int loadval = Integer.parseInt(load);
            int karmaval = Integer.parseInt(karma);
            int pvpflagval = Integer.parseInt(pvpflag);
            int pvpkillsval = Integer.parseInt(pvpkills);
            int classidval = Integer.parseInt(classid);
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Admin has changed your stats. Hp: " + hpval + " HpMax: " + hpmaxval + " Mp: " + mpval + " MpMax: " + mpmaxval + " MaxLoad: " + loadval + " Karma: " + karmaval + " Pvp: " + pvpflagval + " / " + pvpkillsval + " ClassId: " + classidval);
            player.sendPacket(sm);
            player.setCurrentHp(hpval);
            player.setCurrentMp(mpval);
            player.setMaxLoad(loadval);
            player.setKarma(karmaval);
            player.setPvpFlag(pvpflagval);
            player.setPvpKills(pvpkillsval);
            player.setClassId(classidval);
            StatusUpdate su = new StatusUpdate(player.getObjectId());
            su.addAttribute(StatusUpdate.CUR_HP, hpval);
            su.addAttribute(StatusUpdate.MAX_HP, hpmaxval);
            su.addAttribute(StatusUpdate.CUR_MP, mpval);
            su.addAttribute(StatusUpdate.MAX_MP, mpmaxval);
            su.addAttribute(StatusUpdate.MAX_LOAD, loadval);
            su.addAttribute(StatusUpdate.KARMA, karmaval);
            su.addAttribute(StatusUpdate.PVP_FLAG, pvpflagval);
            player.sendPacket(su);
            SystemMessage smA = new SystemMessage(614);
            smA.addString("Changed stats of " + player.getName() + ". " + " Hp: " + hpval + " HpMax: " + hpmaxval + " Mp: " + mpval + " MpMax: " + mpmaxval + " MaxLoad: " + loadval + " Karma: " + karmaval + " Pvp: " + pvpflagval + " / " + pvpkillsval + " ClassId: " + classidval);
            activeChar.sendPacket(smA);
            if (Config.DEBUG) {
                _log.fine("[GM]" + activeChar.getName() + " changed stats of " + player.getName() + ". " + " Hp: " + hpval + " HpMax: " + hpmaxval + " Mp: " + mpval + " MpMax: " + mpmaxval + " MaxLoad: " + loadval + " Karma: " + karmaval + " Pvp: " + pvpflagval + " / " + pvpkillsval + " ClassId: " + classidval);
            }
            this.showCharacterList(activeChar);
            CharInfo info1 = new CharInfo(player);
            player.broadcastPacket(info1);
            UserInfo info2 = new UserInfo(player);
            player.sendPacket(info2);
            player.decayMe();
            player.spawnMe(activeChar.getX(), activeChar.getY(), activeChar.getZ());
        }
    }

    private void editCharacter(L2PcInstance activeChar) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            return;
        }
        player = (L2PcInstance)target;
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Character Selection Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_current_player\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br>");
        replyMSG.append("<center>Editing character: " + player.getName() + "</center><br>");
        replyMSG.append("<table width=270>");
        replyMSG.append("<tr><td width=40></td><td width=70>Curent:</td><td width=70>Max:</td><td width=90></td></tr>");
        replyMSG.append("<tr><td width=40>HP:</td><td width=70>" + player.getCurrentHp() + "</td><td width=70>" + player.getMaxHp() + "</td><td width=70>Karma: " + player.getKarma() + "</td><td width=20></td></tr>");
        replyMSG.append("<tr><td width=40>MP:</td><td width=70>" + player.getCurrentMp() + "</td><td width=70>" + player.getMaxMp() + "</td><td width=70>Pvp Kills: " + player.getPvpKills() + "</td><td width=20></td></tr>");
        replyMSG.append("<tr><td width=40>Load:</td><td width=70>" + player.getCurrentLoad() + "</td><td width=70>" + player.getMaxLoad() + "</td><td width=70>Pvp Flag: " + player.getPvpFlag() + "</td><td width=20></td></tr>");
        replyMSG.append("</table>");
        replyMSG.append("<table width=270><tr><td>Class Template Id: " + (Object)((Object)player.getClassId()) + "</td></tr></table><br>");
        replyMSG.append("<table width=270>");
        replyMSG.append("<tr><td>Note: Fill all values before saving the modifications.</td></tr>");
        replyMSG.append("</table><br>");
        replyMSG.append("<table width=270>");
        replyMSG.append("<tr><td width=50>Hp:</td><td><edit var=\"hp\" width=50></td><td width=50>Karma:</td><td><edit var=\"karma\" width=50></td></tr>");
        replyMSG.append("<tr><td width=50>HpMax:</td><td><edit var=\"hpmax\" width=50></td><td width=50>Pvp Flag:</td><td><edit var=\"pvpflag\" width=50></td></tr>");
        replyMSG.append("<tr><td width=50>Mp:</td><td><edit var=\"mp\" width=50></td><td width=50>Pvp Kills:</td><td><edit var=\"pvpkills\" width=50></td></tr>");
        replyMSG.append("<tr><td width=50>MpMax:</td><td><edit var=\"mpmax\" width=50></td><td width=50>Class Id:</td><td><edit var=\"classid\" width=50></td></tr>");
        replyMSG.append("<tr><td width=50>MaxLoad:</td><td><edit var=\"load\" width=50></td><td width=50></td><td width=50></td></tr>");
        replyMSG.append("</table><br>");
        replyMSG.append("<center><button value=\"Save Changes\" action=\"bypass -h admin_save_modifications $hp $hpmax $mp $mpmax $load $karma $pvpflag $pvpkills $classid\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></center><br>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    private void findCharacter(L2PcInstance activeChar, String CharacterToFind) {
        Collection<L2PcInstance> allPlayers = L2World.getInstance().getAllPlayers();
        L2PcInstance[] players = allPlayers.toArray(new L2PcInstance[allPlayers.size()]);
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        int CharactersFound = 0;
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Character Selection Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_show_characters 0\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br>");
        for (int i = 0; i < players.length; ++i) {
            if (!players[i].getName().startsWith(CharacterToFind)) continue;
            ++CharactersFound;
            replyMSG.append("<table width=270>");
            replyMSG.append("<tr><td width=80>Name</td><td width=110>Class</td><td width=40>Level</td></tr>");
            replyMSG.append("<tr><td width=80><a action=\"bypass -h admin_character_list " + players[i].getName() + "\">" + players[i].getName() + "</a></td><td width=110>" + players[i].getTemplate().className + "</td><td width=40>" + players[i].getLevel() + "</td></tr>");
            replyMSG.append("</table>");
        }
        if (CharactersFound == 0) {
            replyMSG.append("<table width=270>");
            replyMSG.append("<tr><td width=270>Your search did not find any characters.</td></tr>");
            replyMSG.append("<tr><td width=270>Please try again.<br></td></tr>");
            replyMSG.append("</table><br>");
            replyMSG.append("<center><table><tr><td>");
            replyMSG.append("<edit var=\"character_name\" width=80></td><td><button value=\"Find\" action=\"bypass -h admin_find_character $character_name\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
            replyMSG.append("</td></tr></table></center>");
        } else {
            replyMSG.append("<center><br>Found " + CharactersFound + " character");
            if (CharactersFound == 1) {
                replyMSG.append(".");
            } else if (CharactersFound > 1) {
                replyMSG.append("s.");
            }
        }
        replyMSG.append("</center></body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }
}

