/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.TradeController;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminEditChar;
import net.sf.l2j.gameserver.model.L2BoxInstance;
import net.sf.l2j.gameserver.model.L2DropData;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2TradeList;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;
import net.sf.l2j.gameserver.templates.StatsSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminEditNpc
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminEditChar.class.getName());
    private static final int PAGE_LIMIT = 7;
    private static String[] _adminCommands = new String[]{"admin_edit_npc", "admin_save_npc", "admin_show_droplist", "admin_edit_drop", "admin_add_drop", "admin_del_drop", "admin_showShop", "admin_showShopList", "admin_addShopItem", "admin_delShopItem", "admin_box_access", "admin_editShopItem"};
    private static final int REQUIRED_LEVEL = Config.GM_NPC_EDIT;

    @Override
    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        block38: {
            block49: {
                block47: {
                    StringTokenizer st;
                    int itemId;
                    int npcId;
                    block48: {
                        block46: {
                            block45: {
                                block44: {
                                    block43: {
                                        block42: {
                                            block41: {
                                                block40: {
                                                    block39: {
                                                        block37: {
                                                            if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
                                                                return false;
                                                            }
                                                            if (!command.startsWith("admin_showShop ")) break block37;
                                                            String[] args = command.split(" ");
                                                            if (args.length <= 1) break block38;
                                                            this.showShop(activeChar, Integer.parseInt(command.split(" ")[1]));
                                                            break block38;
                                                        }
                                                        if (!command.startsWith("admin_showShopList ")) break block39;
                                                        String[] args = command.split(" ");
                                                        if (args.length <= 2) break block38;
                                                        this.showShopList(activeChar, Integer.parseInt(command.split(" ")[1]), Integer.parseInt(command.split(" ")[2]));
                                                        break block38;
                                                    }
                                                    if (!command.startsWith("admin_addShopItem ")) break block40;
                                                    String[] args = command.split(" ");
                                                    if (args.length <= 1) break block38;
                                                    this.addShopItem(activeChar, args);
                                                    break block38;
                                                }
                                                if (!command.startsWith("admin_delShopItem ")) break block41;
                                                String[] args = command.split(" ");
                                                if (args.length <= 2) break block38;
                                                this.delShopItem(activeChar, args);
                                                break block38;
                                            }
                                            if (!command.startsWith("admin_editShopItem ")) break block42;
                                            String[] args = command.split(" ");
                                            if (args.length <= 2) break block38;
                                            this.editShopItem(activeChar, args);
                                            break block38;
                                        }
                                        if (!command.startsWith("admin_edit_npc ")) break block43;
                                        int npcId2 = 0;
                                        try {
                                            npcId2 = Integer.parseInt(command.substring(15).trim());
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        if (npcId2 > 0) {
                                            L2NpcTemplate npc = NpcTable.getInstance().getTemplate(npcId2);
                                            this.Show_Npc_Property(activeChar, npc);
                                        } else {
                                            SystemMessage sm = new SystemMessage(614);
                                            sm.addString("Command error:");
                                            sm.addString("//edit_npc <npc_id>");
                                            activeChar.sendPacket(sm);
                                        }
                                        break block38;
                                    }
                                    if (!command.startsWith("admin_save_npc ")) break block44;
                                    this.save_npc_property(activeChar, command.substring(14).trim());
                                    break block38;
                                }
                                if (!command.startsWith("admin_show_droplist ")) break block45;
                                int npcId3 = 0;
                                try {
                                    npcId3 = Integer.parseInt(command.substring(20).trim());
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                if (npcId3 > 0) {
                                    this.showNpcDropList(activeChar, npcId3);
                                } else {
                                    SystemMessage sm = new SystemMessage(614);
                                    sm.addString("Command error:");
                                    sm.addString("//show_droplist <npc_id>");
                                    activeChar.sendPacket(sm);
                                }
                                break block38;
                            }
                            if (!command.startsWith("admin_edit_drop ")) break block46;
                            int npcId4 = -1;
                            int itemId2 = 0;
                            StringTokenizer st2 = new StringTokenizer(command.substring(16).trim());
                            if (st2.countTokens() == 2) {
                                try {
                                    npcId4 = Integer.parseInt(st2.nextToken());
                                    itemId2 = Integer.parseInt(st2.nextToken());
                                    this.showEditDropData(activeChar, npcId4, itemId2);
                                }
                                catch (Exception e) {}
                            } else if (st2.countTokens() == 6) {
                                try {
                                    npcId4 = Integer.parseInt(st2.nextToken());
                                    itemId2 = Integer.parseInt(st2.nextToken());
                                    int min = Integer.parseInt(st2.nextToken());
                                    int max = Integer.parseInt(st2.nextToken());
                                    boolean sweep = st2.nextToken().equalsIgnoreCase("true");
                                    int chance = Integer.parseInt(st2.nextToken());
                                    this.updateDropData(activeChar, npcId4, itemId2, min, max, sweep, chance);
                                }
                                catch (Exception e) {
                                    _log.fine("admin_edit_drop parements error: " + command);
                                }
                            } else {
                                SystemMessage sm = new SystemMessage(614);
                                sm.addString("Command error:");
                                sm.addString("//edit_drop <npc_id> <item_id> [<min> <max> <sweep> <chance>]");
                                activeChar.sendPacket(sm);
                            }
                            break block38;
                        }
                        if (!command.startsWith("admin_add_drop ")) break block47;
                        npcId = -1;
                        itemId = -1;
                        st = new StringTokenizer(command.substring(15).trim());
                        if (st.countTokens() != 1) break block48;
                        try {
                            String[] input = command.substring(15).split(" ");
                            if (input.length < 1) {
                                return true;
                            }
                            npcId = Integer.parseInt(input[0]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (npcId <= 0) break block38;
                        L2NpcTemplate npcData = NpcTable.getInstance().getTemplate(npcId);
                        this.showAddDropData(activeChar, npcData);
                        break block38;
                    }
                    if (st.countTokens() == 6) {
                        try {
                            npcId = Integer.parseInt(st.nextToken());
                            itemId = Integer.parseInt(st.nextToken());
                            int min = Integer.parseInt(st.nextToken());
                            int max = Integer.parseInt(st.nextToken());
                            boolean sweep = st.nextToken().equalsIgnoreCase("true");
                            int chance = Integer.parseInt(st.nextToken());
                            this.addDropData(activeChar, npcId, itemId, min, max, sweep, chance);
                        }
                        catch (Exception e) {
                            _log.fine("admin_add_drop parements error: " + command);
                        }
                    } else {
                        SystemMessage sm = new SystemMessage(614);
                        sm.addString("Command error:");
                        sm.addString("//add_drop <npc_id> [<item_id> <min> <max> <sweep> <chance>]");
                        activeChar.sendPacket(sm);
                    }
                    break block38;
                }
                if (!command.startsWith("admin_del_drop ")) break block49;
                int npcId = -1;
                int itemId = -1;
                try {
                    String[] input = command.substring(15).split(" ");
                    if (input.length >= 2) {
                        npcId = Integer.parseInt(input[0]);
                        itemId = Integer.parseInt(input[1]);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (npcId > 0) {
                    this.deleteDropData(activeChar, npcId, itemId);
                } else {
                    SystemMessage sm = new SystemMessage(614);
                    sm.addString("Command error:");
                    sm.addString("//del_drop <npc_id> <item_id>");
                    activeChar.sendPacket(sm);
                }
                break block38;
            }
            if (!command.startsWith("admin_box_access")) break block38;
            L2Object target = activeChar.getTarget();
            String[] players = command.split(" ");
            if (target instanceof L2BoxInstance) {
                L2BoxInstance box = (L2BoxInstance)target;
                if (players.length > 1) {
                    boolean access = true;
                    for (int i = 1; i < players.length; ++i) {
                        if (players[i].equals("no")) {
                            access = false;
                            continue;
                        }
                        box.grantAccess(players[i], access);
                    }
                } else {
                    try {
                        SystemMessage sm = new SystemMessage(614);
                        String msg = "Access:";
                        for (Object p : box.getAccess()) {
                            msg = msg + " " + (String)p;
                        }
                        sm.addString(msg);
                        activeChar.sendPacket(sm);
                    }
                    catch (Exception e) {
                        _log.info("box_access: " + e);
                    }
                }
            }
        }
        return true;
    }

    private void editShopItem(L2PcInstance admin, String[] args) {
        int tradeListID = Integer.parseInt(args[1]);
        int itemID = Integer.parseInt(args[2]);
        L2TradeList tradeList = TradeController.getInstance().getBuyList(tradeListID);
        L2Item item = ItemTable.getInstance().getTemplate(itemID);
        if (tradeList.getPriceForItemId(itemID) < 0) {
            return;
        }
        if (args.length > 3) {
            tradeList.replaceItem(itemID, Integer.parseInt(args[3]));
            this.storeTradeList(tradeList);
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Edited " + item.getName() + " in Trade List " + tradeListID);
            admin.sendPacket(sm);
            this.showShopList(admin, tradeListID, 1);
            return;
        }
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer();
        replyMSG.append("<html><title>Merchant Shop Item Edit</title>");
        replyMSG.append("<body>");
        replyMSG.append("<br>Edit an entry in merchantList.");
        replyMSG.append("<br>Editing Item: " + item.getName());
        replyMSG.append("<table>");
        replyMSG.append("<tr><td width=100>Property</td><td width=100>Edit Field</td><td width=100>Old Value</td></tr>");
        replyMSG.append("<tr><td><br></td><td></td></tr>");
        replyMSG.append("<tr><td>Price</td><td><edit var=\"price\" width=80></td><td>" + tradeList.getPriceForItemId(itemID) + "</td></tr>");
        replyMSG.append("</table>");
        replyMSG.append("<center><br><br><br>");
        replyMSG.append("<button value=\"Save\" action=\"bypass -h admin_editShopItem " + tradeListID + " " + itemID + " $price\"  width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<br><button value=\"Back\" action=\"bypass -h admin_showShopList " + tradeListID + " 1\"  width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        admin.sendPacket(adminReply);
    }

    private void delShopItem(L2PcInstance admin, String[] args) {
        int tradeListID = Integer.parseInt(args[1]);
        int itemID = Integer.parseInt(args[2]);
        L2TradeList tradeList = TradeController.getInstance().getBuyList(tradeListID);
        if (tradeList.getPriceForItemId(itemID) < 0) {
            return;
        }
        if (args.length > 3) {
            tradeList.removeItem(itemID);
            this.storeTradeList(tradeList);
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Deleted " + ItemTable.getInstance().getTemplate(itemID).getName() + " from Trade List " + tradeListID);
            admin.sendPacket(sm);
            this.showShopList(admin, tradeListID, 1);
            return;
        }
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer();
        replyMSG.append("<html><title>Merchant Shop Item Delete</title>");
        replyMSG.append("<body>");
        replyMSG.append("<br>Delete entry in merchantList.");
        replyMSG.append("<br>Item to Delete: " + ItemTable.getInstance().getTemplate(itemID).getName());
        replyMSG.append("<table>");
        replyMSG.append("<tr><td width=100>Property</td><td width=100>Value</td></tr>");
        replyMSG.append("<tr><td><br></td><td></td></tr>");
        replyMSG.append("<tr><td>Price</td><td>" + tradeList.getPriceForItemId(itemID) + "</td></tr>");
        replyMSG.append("</table>");
        replyMSG.append("<center><br><br><br>");
        replyMSG.append("<button value=\"Confirm\" action=\"bypass -h admin_delShopItem " + tradeListID + " " + itemID + " 1\"  width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<br><button value=\"Back\" action=\"bypass -h admin_showShopList " + tradeListID + " 1\"  width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        admin.sendPacket(adminReply);
    }

    private void addShopItem(L2PcInstance admin, String[] args) {
        int tradeListID = Integer.parseInt(args[1]);
        L2TradeList tradeList = TradeController.getInstance().getBuyList(tradeListID);
        if (args.length > 3) {
            int itemID = Integer.parseInt(args[2]);
            int price = Integer.parseInt(args[3]);
            L2ItemInstance newItem = ItemTable.getInstance().createDummyItem(itemID);
            newItem.setPriceToSell(price);
            tradeList.addItem(newItem);
            this.storeTradeList(tradeList);
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Added " + newItem.getItem().getName() + " to Trade List " + tradeList.getListId());
            admin.sendPacket(sm);
            this.showShopList(admin, tradeListID, 1);
            return;
        }
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer();
        replyMSG.append("<html><title>Merchant Shop Item Add</title>");
        replyMSG.append("<body>");
        replyMSG.append("<br>Add a new entry in merchantList.");
        replyMSG.append("<table>");
        replyMSG.append("<tr><td width=100>Property</td><td>Edit Field</td></tr>");
        replyMSG.append("<tr><td><br></td><td></td></tr>");
        replyMSG.append("<tr><td>ItemID</td><td><edit var=\"itemID\" width=80></td></tr>");
        replyMSG.append("<tr><td>Price</td><td><edit var=\"price\" width=80></td></tr>");
        replyMSG.append("</table>");
        replyMSG.append("<center><br><br><br>");
        replyMSG.append("<button value=\"Save\" action=\"bypass -h admin_addShopItem " + tradeListID + " $itemID $price\"  width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<br><button value=\"Back\" action=\"bypass -h admin_showShopList " + tradeListID + " 1\"  width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        admin.sendPacket(adminReply);
    }

    private void showShopList(L2PcInstance admin, int tradeListID, int page) {
        L2TradeList tradeList = TradeController.getInstance().getBuyList(tradeListID);
        if (page > tradeList.getItems().size() / 7 + 1 || page < 1) {
            return;
        }
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer html = this.itemListHtml(tradeList, page);
        adminReply.setHtml(html.toString());
        admin.sendPacket(adminReply);
    }

    private StringBuffer itemListHtml(L2TradeList tradeList, int page) {
        StringBuffer replyMSG = new StringBuffer();
        replyMSG.append("<html><title>Merchant Shop List Page: " + page + "</title>");
        replyMSG.append("<body>");
        replyMSG.append("<br>Edit, add or delete entries in a merchantList.");
        replyMSG.append("<table>");
        replyMSG.append("<tr><td width=150>Item Name</td><td width=60>Price</td><td width=40>Delete</td></tr>");
        int start = (page - 1) * 7;
        int end = Math.min((page - 1) * 7 + 6, tradeList.getItems().size() - 1);
        for (L2ItemInstance item : tradeList.getItems(start, end + 1)) {
            replyMSG.append("<tr><td><a action=\"bypass -h admin_editShopItem " + tradeList.getListId() + " " + item.getItemId() + "\">" + item.getItem().getName() + "</a></td>");
            replyMSG.append("<td>" + item.getPriceToSell() + "</td>");
            replyMSG.append("<td><button value=\"Del\" action=\"bypass -h admin_delShopItem " + tradeList.getListId() + " " + item.getItemId() + "\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
            replyMSG.append("</tr>");
        }
        replyMSG.append("<tr>");
        int min = 1;
        int max = tradeList.getItems().size() / 7 + 1;
        if (page > 1) {
            replyMSG.append("<td><button value=\"Page" + (page - 1) + "\" action=\"bypass -h admin_showShopList " + tradeList.getListId() + " " + (page - 1) + "\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        }
        if (page < max) {
            if (page <= min) {
                replyMSG.append("<td></td>");
            }
            replyMSG.append("<td><button value=\"Page" + (page + 1) + "\" action=\"bypass -h admin_showShopList " + tradeList.getListId() + " " + (page + 1) + "\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        }
        replyMSG.append("</tr><tr><td>.</td></tr>");
        replyMSG.append("</table>");
        replyMSG.append("<center>");
        replyMSG.append("<button value=\"Add\" action=\"bypass -h admin_addShopItem " + tradeList.getListId() + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<button value=\"Close\" action=\"bypass -h admin_close_window\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</center></body></html>");
        return replyMSG;
    }

    private void showShop(L2PcInstance admin, int merchantID) {
        ArrayList<L2TradeList> tradeLists = this.getTradeLists(merchantID);
        if (tradeLists == null) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Unknown npc template ID" + merchantID);
            admin.sendPacket(sm);
            return;
        }
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><title>Merchant Shop Lists</title>");
        replyMSG.append("<body>");
        replyMSG.append("<br>Select a list to view");
        replyMSG.append("<table>");
        replyMSG.append("<tr><td>Mecrchant List ID</td></tr>");
        for (L2TradeList tradeList : tradeLists) {
            if (tradeList == null) continue;
            replyMSG.append("<tr><td><a action=\"bypass -h admin_showShopList " + tradeList.getListId() + " 1\">Trade List " + tradeList.getListId() + "</a></td></tr>");
        }
        replyMSG.append("</table>");
        replyMSG.append("<center>");
        replyMSG.append("<button value=\"Close\" action=\"bypass -h admin_close_window\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</center></body></html>");
        adminReply.setHtml(replyMSG.toString());
        admin.sendPacket(adminReply);
    }

    private void storeTradeList(L2TradeList list) {
        String buff = new String();
        try {
            File buylistData = new File(Config.DATAPACK_ROOT, "data/buylists.csv");
            LineNumberReader reader = new LineNumberReader(new BufferedReader(new FileReader(buylistData)));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(list.getListId() + ";")) {
                    line = list.getListId() + "";
                    for (L2ItemInstance item : list.getItems()) {
                        line = line + ";" + item.getItemId() + ";" + item.getPriceToSell();
                    }
                }
                buff = buff + line + "\n";
                line = reader.readLine();
            }
            FileWriter writer = new FileWriter(buylistData);
            writer.write(buff.toString());
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            _log.warning("No buylists were found in data folder");
        }
    }

    private ArrayList<L2TradeList> getTradeLists(int merchantID) {
        String html = "data/html/merchant/" + merchantID + ".htm";
        String target = "npc_%objectId%_Buy";
        File merchantHtml = new File(Config.DATAPACK_ROOT, html);
        if (merchantHtml == null) {
            html = "data/html/merchant/7001.htm";
        }
        ArrayList<L2TradeList> tradeLists = new ArrayList<L2TradeList>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(merchantHtml));
            int pos = 0;
            String line = reader.readLine();
            while (line != null) {
                pos = line.indexOf(target);
                if (pos >= 0) {
                    int tradeListID = Integer.decode(line.substring(pos + target.length() + 1).split("\"")[0]);
                    tradeLists.add(TradeController.getInstance().getBuyList(tradeListID));
                }
                line = reader.readLine();
            }
            return tradeLists;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    @Override
    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Show_Npc_Property(L2PcInstance adminPlayer, L2NpcTemplate npc) {
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        File file = new File(Config.DATAPACK_ROOT, "data/html/admin/editnpc.htm");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] raw = new byte[fis.available()];
            fis.read(raw);
            String content = new String(raw, "UTF-8");
            content = content.replaceAll("%NpcName%", npc.name);
            content = content.replaceAll("%CollisionRadius%", String.valueOf(npc.collisionRadius));
            content = content.replaceAll("%CollisionHeight%", String.valueOf(npc.collisionHeight));
            content = content.replaceAll("%Level%", String.valueOf(npc.level));
            content = content.replaceAll("%Sex%", String.valueOf(npc.sex));
            content = content.replaceAll("%Type%", String.valueOf(npc.type));
            content = content.replaceAll("%AttackRange%", String.valueOf(npc.baseAtkRange));
            content = content.replaceAll("%MaxHp%", String.valueOf(npc.baseHpMax));
            content = content.replaceAll("%MaxBaseMp%", String.valueOf(npc.baseMpMax));
            content = content.replaceAll("%Exp%", String.valueOf(npc.revardExp));
            content = content.replaceAll("%Sp%", String.valueOf(npc.revardSp));
            content = content.replaceAll("%Patk%", String.valueOf(npc.basePAtk));
            content = content.replaceAll("%Pdef%", String.valueOf(npc.basePDef));
            content = content.replaceAll("%Matk%", String.valueOf(npc.baseMAtk));
            content = content.replaceAll("%Mdef%", String.valueOf(npc.baseMDef));
            content = content.replaceAll("%Atkspd%", String.valueOf(npc.basePAtkSpd));
            content = content.replaceAll("%Agro%", String.valueOf(npc.aggroRange));
            content = content.replaceAll("%Matkspd%", String.valueOf(npc.baseMAtkSpd));
            content = content.replaceAll("%Rhand%", String.valueOf(npc.rhand));
            content = content.replaceAll("%Lhand%", String.valueOf(npc.lhand));
            content = content.replaceAll("%Armor%", String.valueOf(npc.armor));
            content = content.replaceAll("%WalkSpeed%", String.valueOf((double)npc.baseRunSpd * 0.7));
            content = content.replaceAll("%RunSpeed%", String.valueOf(npc.baseRunSpd));
            content = content.replaceAll("%NpcId%", String.valueOf(npc.npcId));
            adminReply.setHtml(content);
        }
        catch (Exception e) {
            adminReply.setHtml("<html><head><body>File not found: data/html/admin/editnpc.htm</body></html>");
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception ee) {}
        }
        adminPlayer.sendPacket(adminReply);
    }

    private void save_npc_property(L2PcInstance adminPlayer, String modifications) {
        StatsSet npcData = new StatsSet();
        try {
            StringTokenizer st = new StringTokenizer(modifications, ",");
            while (st.hasMoreTokens()) {
                StringTokenizer st2 = new StringTokenizer(st.nextToken().trim());
                if (st2.countTokens() != 2) continue;
                String name = st2.nextToken().trim();
                String value = st2.nextToken().trim();
                if (name.equals("id")) {
                    npcData.set("npcId", Integer.parseInt(value));
                    continue;
                }
                if (name.equals("CollisionRadius") && npcData != null) {
                    npcData.set("collision_radius", Integer.parseInt(value));
                    continue;
                }
                if (name.equals("CollisionHeight") && npcData != null) {
                    npcData.set("collision_height", Integer.parseInt(value));
                    continue;
                }
                if (name.equals("Level") && npcData != null) {
                    npcData.set("level", Integer.parseInt(value));
                    continue;
                }
                if (name.equals("Sex") && npcData != null) {
                    if (value.equals("0")) {
                        npcData.set("sex", "male");
                        continue;
                    }
                    npcData.set("sex", "female");
                    continue;
                }
                if (name.equals("Type") && npcData != null) {
                    npcData.set("type", value);
                    continue;
                }
                if (name.equals("AttackRange") && npcData != null) {
                    npcData.set("attackrange", Integer.parseInt(value));
                    continue;
                }
                if (name.equals("MaxHp") && npcData != null) {
                    npcData.set("hp", Integer.parseInt(value));
                    continue;
                }
                if (name.equals("MaxBaseMp") && npcData != null) {
                    npcData.set("mp", Integer.parseInt(value));
                    continue;
                }
                if (name.equals("Exp") && npcData != null) {
                    npcData.set("exp", Integer.parseInt(value));
                    continue;
                }
                if (name.equals("Sp") && npcData != null) {
                    npcData.set("sp", Integer.parseInt(value));
                    continue;
                }
                if (name.endsWith("Patk") && npcData != null) {
                    npcData.set("patk", Integer.parseInt(value));
                    continue;
                }
                if (name.endsWith("Pdef") && npcData != null) {
                    npcData.set("pdef", Integer.parseInt(value));
                    continue;
                }
                if (name.endsWith("Matk") && npcData != null) {
                    npcData.set("matk", Integer.parseInt(value));
                    continue;
                }
                if (name.endsWith("Mdef") && npcData != null) {
                    npcData.set("mdef", Integer.parseInt(value));
                    continue;
                }
                if (name.endsWith("Atkspd") && npcData != null) {
                    npcData.set("atkspd", Integer.parseInt(value));
                    continue;
                }
                if (name.endsWith("Agro") && npcData != null) {
                    npcData.set("aggro", Integer.parseInt(value));
                    continue;
                }
                if (name.endsWith("Matkspd") && npcData != null) {
                    npcData.set("matkspd", Integer.parseInt(value));
                    continue;
                }
                if (name.endsWith("Rhand") && npcData != null) {
                    npcData.set("rhand", Integer.parseInt(value));
                    continue;
                }
                if (name.endsWith("Lhand") && npcData != null) {
                    npcData.set("lhand", Integer.parseInt(value));
                    continue;
                }
                if (name.endsWith("Armor") && npcData != null) {
                    npcData.set("armor", Integer.parseInt(value));
                    continue;
                }
                if (!name.endsWith("RunSpeed") || npcData == null) continue;
                npcData.set("runspd", Integer.parseInt(value));
            }
        }
        catch (Exception e) {
            _log.fine("save Npc data error");
        }
        NpcTable.getInstance().saveNpc(npcData);
        NpcTable.getInstance().reloadNpc(npcData.getInteger("npcId"));
    }

    private void showNpcDropList(L2PcInstance admin, int npcId) {
        L2NpcTemplate npcData = NpcTable.getInstance().getTemplate(npcId);
        if (npcData == null) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("unknown npc template id\u5360\uc3d9\uc619" + npcId);
            admin.sendPacket(sm);
            return;
        }
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><title>NPC: " + npcData.name + "(" + npcData.npcId + ") 's drop manage</title>");
        replyMSG.append("<body>");
        replyMSG.append("<br>Notes: click[drop_id]to show the detail of drop data,click[del] to delete the drop data!");
        replyMSG.append("<table>");
        replyMSG.append("<tr><td>npc_id itemId</td><td>item[id]</td><td>type</td><td>del</td></tr>");
        for (L2DropData drop2 : npcData.getDropData()) {
            replyMSG.append("<tr><td><a action=\"bypass -h admin_edit_drop " + npcData.npcId + " " + drop2.getItemId() + "\">" + npcData.npcId + " " + drop2.getItemId() + "</a></td>" + "<td>" + ItemTable.getInstance().getTemplate(drop2.getItemId()).getName() + "[" + drop2.getItemId() + "]" + "</td><td>" + (drop2.isQuestDrop() ? "Q" : (drop2.isSweep() ? "S" : "D")) + "</td><td>" + "<a action=\"bypass -h admin_del_drop " + npcData.npcId + " " + drop2.getItemId() + "\">del</a></td></tr>");
        }
        replyMSG.append("</table>");
        replyMSG.append("<center>");
        replyMSG.append("<button value=\"Add DropData\" action=\"bypass -h admin_add_drop " + npcId + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<button value=\"Close\" action=\"bypass -h admin_close_window\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</center></body></html>");
        adminReply.setHtml(replyMSG.toString());
        admin.sendPacket(adminReply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showEditDropData(L2PcInstance admin, int npcId, int itemId) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT mobId, itemId, min, max, sweep, chance FROM droplist WHERE mobId=" + npcId + " AND itemId=" + itemId);
            ResultSet dropData = statement.executeQuery();
            NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
            StringBuffer replyMSG = new StringBuffer("<html><title>the detail of dropdata: (" + npcId + " " + itemId + ")</title>");
            replyMSG.append("<body>");
            if (dropData.next()) {
                replyMSG.append("<table>");
                replyMSG.append("<tr><td>Appertain of NPC</td><td>" + NpcTable.getInstance().getTemplate((int)dropData.getInt((String)"mobId")).name + "</td></tr>");
                replyMSG.append("<tr><td>ItemName</td><td>" + ItemTable.getInstance().getTemplate(dropData.getInt("itemId")).getName() + "(" + dropData.getInt("itemId") + ")</td></tr>");
                replyMSG.append("<tr><td>MIN(" + dropData.getInt("min") + ")</td><td><edit var=\"min\" width=80></td></tr>");
                replyMSG.append("<tr><td>MAX(" + dropData.getInt("max") + ")</td><td><edit var=\"max\" width=80></td></tr>");
                replyMSG.append("<tr><td>IS SWEEP(" + (dropData.getInt("sweep") == 1) + ")</td><td><edit var=\"sweep\" width=80></td></tr>");
                replyMSG.append("<tr><td>CHANCE(" + dropData.getInt("chance") + ")</td><td><edit var=\"chance\" width=80></td></tr>");
                replyMSG.append("</table>");
                replyMSG.append("<center>");
                replyMSG.append("<button value=\"Save Modify\" action=\"bypass -h admin_edit_drop " + npcId + " " + itemId + " $min $max $sweep $chance\"  width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
                replyMSG.append("<br><button value=\"DropList\" action=\"bypass -h admin_show_droplist " + dropData.getInt("mobId") + "\"  width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
                replyMSG.append("</center>");
            }
            dropData.close();
            statement.close();
            replyMSG.append("</body></html>");
            adminReply.setHtml(replyMSG.toString());
            admin.sendPacket(adminReply);
        }
        catch (Exception e) {
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    private void showAddDropData(L2PcInstance admin, L2NpcTemplate npcData) {
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><title>Add dropdata to " + npcData.name + "(" + npcData.npcId + ")</title>");
        replyMSG.append("<body>");
        replyMSG.append("<table>");
        replyMSG.append("<tr><td>Item-Id</td><td><edit var=\"itemId\" width=80></td></tr>");
        replyMSG.append("<tr><td>MIN</td><td><edit var=\"min\" width=80></td></tr>");
        replyMSG.append("<tr><td>MAX</td><td><edit var=\"max\" width=80></td></tr>");
        replyMSG.append("<tr><td>SWEEP(true/false)</td><td><edit var=\"sweep\" width=80></td></tr>");
        replyMSG.append("<tr><td>CHANCE(0-1000000)</td><td><edit var=\"chance\" width=80></td></tr>");
        replyMSG.append("</table>");
        replyMSG.append("<center>");
        replyMSG.append("<button value=\"SAVE\" action=\"bypass -h admin_add_drop " + npcData.npcId + " $itemId $min $max $sweep $chance\"  width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<br><button value=\"DropList\" action=\"bypass -h admin_show_droplist " + npcData.npcId + "\"  width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        admin.sendPacket(adminReply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDropData(L2PcInstance admin, int npcId, int itemId, int min, int max, boolean sweep, int chance) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE droplist SET min=?, max=?, sweep=?, chance=? WHERE mobId=? AND itemId=?");
            statement.setInt(1, min);
            statement.setInt(2, max);
            if (sweep) {
                statement.setInt(3, 1);
            } else {
                statement.setInt(3, 0);
            }
            statement.setInt(4, chance);
            statement.setInt(5, npcId);
            statement.setInt(6, itemId);
            statement.execute();
            statement.close();
            PreparedStatement statement2 = con.prepareStatement("SELECT mobId FROM droplist WHERE mobId=? AND itemId=?");
            statement2.setInt(1, npcId);
            statement2.setInt(2, itemId);
            ResultSet npcIdRs = statement2.executeQuery();
            if (npcIdRs.next()) {
                npcId = npcIdRs.getInt("mobId");
            }
            npcIdRs.close();
            statement2.close();
            if (npcId > 0) {
                this.reLoadNpcDropList(npcId);
                NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
                StringBuffer replyMSG = new StringBuffer("<html><title>Drop data modify complete!</title>");
                replyMSG.append("<body>");
                replyMSG.append("<center><button value=\"DropList\" action=\"bypass -h admin_show_droplist " + npcId + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></center>");
                replyMSG.append("</body></html>");
                adminReply.setHtml(replyMSG.toString());
                admin.sendPacket(adminReply);
            } else {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("unknown error!");
                admin.sendPacket(sm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDropData(L2PcInstance admin, int npcId, int itemId, int min, int max, boolean sweep, int chance) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO droplist(mobId, itemId, min, max, sweep, chance) values(?,?,?,?,?,?)");
            statement.setInt(1, npcId);
            statement.setInt(2, itemId);
            statement.setInt(3, min);
            statement.setInt(4, max);
            if (sweep) {
                statement.setInt(5, 1);
            } else {
                statement.setInt(5, 0);
            }
            statement.setInt(6, chance);
            statement.execute();
            statement.close();
            this.reLoadNpcDropList(npcId);
            NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
            StringBuffer replyMSG = new StringBuffer("<html><title>Add drop data complete!</title>");
            replyMSG.append("<body>");
            replyMSG.append("<center><button value=\"Continue add\" action=\"bypass -h admin_add_drop " + npcId + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
            replyMSG.append("<br><br><button value=\"DropList\" action=\"bypass -h admin_show_droplist " + npcId + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
            replyMSG.append("</center></body></html>");
            adminReply.setHtml(replyMSG.toString());
            admin.sendPacket(adminReply);
        }
        catch (Exception e) {
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDropData(L2PcInstance admin, int npcId, int itemId) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            if (npcId > 0) {
                PreparedStatement statement2 = con.prepareStatement("DELETE FROM droplist WHERE mobId=? AND itemId=?");
                statement2.setInt(1, npcId);
                statement2.setInt(2, itemId);
                statement2.execute();
                statement2.close();
                this.reLoadNpcDropList(npcId);
                NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
                StringBuffer replyMSG = new StringBuffer("<html><title>Delete drop data(" + npcId + ", " + itemId + ")complete</title>");
                replyMSG.append("<body>");
                replyMSG.append("<center><button value=\"DropList\" action=\"bypass -h admin_show_droplist " + npcId + "\" width=100 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></center>");
                replyMSG.append("</body></html>");
                adminReply.setHtml(replyMSG.toString());
                admin.sendPacket(adminReply);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reLoadNpcDropList(int npcId) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            L2NpcTemplate npcData = NpcTable.getInstance().getTemplate(npcId);
            L2DropData dropData = null;
            npcData.getDropData().clear();
            PreparedStatement statement = con.prepareStatement("SELECT mobId, itemId, min, max, sweep, chance FROM droplist WHERE mobId=?");
            statement.setInt(1, npcId);
            ResultSet dropDataList = statement.executeQuery();
            int i = 1;
            while (dropDataList.next()) {
                dropData = new L2DropData();
                dropData.setItemId(dropDataList.getInt("itemId"));
                dropData.setMinDrop(dropDataList.getInt("min"));
                dropData.setMaxDrop(dropDataList.getInt("max"));
                dropData.setSweep(dropDataList.getInt("sweep") == 1);
                dropData.setChance(dropDataList.getInt("chance"));
                npcData.addDropData(dropData);
                ++i;
            }
            dropDataList.close();
            statement.close();
        }
        catch (Exception e) {
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }
}

