/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public class AdminForth
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminForth.class.getName());
    private static String[] _adminCommands = new String[]{"admin_forth", "admin_do", "admin_bsh", "admin_jython", "admin_reload_quest"};
    private static final int REQUIRED_LEVEL = Config.GM_GODMODE;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.startsWith("admin_forth ")) {
            this.handleForth(activeChar, command.substring(12));
        }
        if (command.startsWith("admin_do ")) {
            this.handleForth(activeChar, command.substring(9));
        } else if (command.startsWith("admin_bsh ")) {
            this.handleBsh(activeChar, command.substring(10));
        } else if (command.startsWith("admin_jython ")) {
            this.handleJython(activeChar, command.substring(13));
        } else if (command.startsWith("admin_reload_quest ")) {
            this.handleJython(activeChar, "from data.jscript.quests import " + command.substring(19) + "; reload(" + command.substring(19) + ")");
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void handleForth(L2PcInstance activeChar, String code) {
        try {
            String res;
            try {
                res = activeChar.jbf.exec(code);
                res = res + " ok.";
            }
            catch (Exception e) {
                res = "" + e;
            }
            SystemMessage sm = new SystemMessage(614);
            sm.addString(res);
            activeChar.sendPacket(sm);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void handleBsh(L2PcInstance activeChar, String code) {
        Object result;
        try {
            BSFManager bsf = new BSFManager();
            result = bsf.eval("beanshell", "admin", 0, 0, code);
        }
        catch (BSFException e) {
            result = e;
        }
        SystemMessage sm = new SystemMessage(614);
        sm.addString("BeanShell: " + result);
        activeChar.sendPacket(sm);
    }

    private void handleJython(L2PcInstance activeChar, String code) {
        Object result;
        try {
            BSFManager bsf = new BSFManager();
            if (code.equals("reset")) {
                bsf.exec("jython", "admin", 0, 0, "from data.jscript.quests import Tutorial; reload(Tutorial)");
                result = "reset";
            } else {
                bsf.exec("jython", "admin", 0, 0, code);
                result = null;
            }
        }
        catch (BSFException e) {
            result = e;
        }
        SystemMessage sm = new SystemMessage(614);
        sm.addString("Jython: " + result);
        activeChar.sendPacket(sm);
    }
}

