/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminGm
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminGm.class.getName());
    private static String[] _adminCommands = new String[]{"admin_gm"};
    private static final int REQUIRED_LEVEL = Config.GM_ACCESSLEVEL;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel())) {
            return false;
        }
        if (command.equals("admin_gm")) {
            this.handleGm(activeChar);
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void handleGm(L2PcInstance activeChar) {
        SystemMessage sm = new SystemMessage(614);
        if (activeChar.isGM()) {
            activeChar.setIsGM(false);
            sm.addString("You no longer have GM status.");
            if (Config.DEBUG) {
                _log.fine("GM: " + activeChar.getObjectId() + " turned his GM status off");
            }
        } else {
            activeChar.setIsGM(true);
            sm.addString("You have GM status now.");
            if (Config.DEBUG) {
                _log.fine("GM: " + activeChar.getObjectId() + " turned his GM status on");
            }
        }
    }
}

