/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminKill
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminKill.class.getName());
    private static String[] _adminCommands = new String[]{"admin_kill"};
    private static final int REQUIRED_LEVEL = Config.GM_NPC_EDIT;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.startsWith("admin_kill ")) {
            this.handleKill(activeChar, command.split(" ")[1]);
        }
        if (command.equals("admin_kill")) {
            this.handleKill(activeChar);
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void handleKill(L2PcInstance activeChar) {
        this.handleKill(activeChar, null);
    }

    private void handleKill(L2PcInstance activeChar, String player) {
        L2Object obj = activeChar.getTarget();
        if (player != null) {
            L2PcInstance plyr = L2World.getInstance().getPlayer(player);
            if (plyr != null) {
                obj = plyr;
            } else {
                int radius = Integer.parseInt(player);
                for (L2Object object : L2World.getInstance().getVisibleObjects(activeChar, radius)) {
                    if (!(object instanceof L2Character)) continue;
                    L2Character character = (L2Character)object;
                    character.reduceCurrentHp(character.getMaxHp() + 1, character);
                }
                activeChar.sendMessage("Killed within " + radius + " unit radius.");
                return;
            }
        }
        if (obj != null && obj instanceof L2Character) {
            L2Character target = (L2Character)obj;
            target.reduceCurrentHp(target.getMaxHp() + 1, activeChar);
            if (Config.DEBUG) {
                _log.fine("GM: Admin id " + activeChar.getObjectId() + " killed character " + target.getObjectId());
            }
        } else {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
        }
    }
}

