/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminDelete;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.MagicSkillUser;
import net.sf.l2j.gameserver.serverpackets.SetupGauge;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminPolymorph
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminDelete.class.getName());
    private static String[] _adminCommands = new String[]{"admin_polymorph"};
    private static final int REQUIRED_LEVEL = Config.GM_NPC_EDIT;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.startsWith("admin_polymorph")) {
            StringTokenizer st = new StringTokenizer(command);
            try {
                st.nextToken();
                String type = st.nextToken();
                String id = st.nextToken();
                L2Object target = activeChar.getTarget();
                this.doPolymorph(activeChar, target, id, type);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void doPolymorph(L2PcInstance activeChar, L2Object obj, String id, String type) {
        if (obj != null) {
            obj.setPolyInfo(type, id);
            if (obj instanceof L2Character) {
                L2Character Char = (L2Character)obj;
                MagicSkillUser msk = new MagicSkillUser(Char, 1008, 1, 4000, 0);
                Char.sendPacket(msk);
                Char.broadcastPacket(msk);
                SetupGauge sg = new SetupGauge(0, 4000);
                Char.sendPacket(sg);
            }
            obj.decayMe();
            obj.spawnMe(obj.getX(), obj.getY(), obj.getZ());
        } else {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
        }
    }
}

