/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.Ride;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminRideWyvern
implements IAdminCommandHandler {
    private static String[] _adminCommands = new String[]{"admin_ride_wyvern", "admin_ride_strider", "admin_unride_wyvern", "admin_unride_strider", "admin_unride"};
    private static final int REQUIRED_LEVEL = Config.GM_RIDER;
    private int PetRideId;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (activeChar.getLevel() >= 70 || this.checkLevel(activeChar.getAccessLevel()) && activeChar.isGM()) {
            if (command.startsWith("admin_ride")) {
                if (activeChar.isMounted() || activeChar.getPet() != null) {
                    SystemMessage sm = new SystemMessage(614);
                    sm.addString("Already Have a Pet or Mounted.");
                    activeChar.sendPacket(sm);
                    return false;
                }
                if (command.startsWith("admin_ride_wyvern")) {
                    this.PetRideId = 12621;
                } else if (command.startsWith("admin_ride_strider")) {
                    this.PetRideId = 12526;
                } else {
                    SystemMessage sm = new SystemMessage(614);
                    sm.addString("Command '" + command + "' not recognized");
                    activeChar.sendPacket(sm);
                    return false;
                }
                Ride mount = new Ride(activeChar.getObjectId(), 1, this.PetRideId);
                activeChar.sendPacket(mount);
                activeChar.broadcastPacket(mount);
                activeChar.setMountType(mount.getMountType());
            } else if (command.startsWith("admin_unride")) {
                Ride dismount = new Ride(activeChar.getObjectId(), 0, 0);
                activeChar.broadcastPacket(dismount);
                activeChar.setMountType(0);
            }
            return true;
        }
        SystemMessage sm = new SystemMessage(614);
        sm.addString("Not a GM.");
        activeChar.sendPacket(sm);
        return false;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }
}

