/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.TradeController;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminHelpPage;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2TradeList;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.BuyList;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminShop
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminShop.class.getName());
    private static String[] _adminCommands = new String[]{"admin_buy", "admin_gmshop"};
    private static final int REQUIRED_LEVEL = Config.GM_CREATE_ITEM;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.startsWith("admin_buy")) {
            try {
                this.handleBuyRequest(activeChar, command.substring(10));
            }
            catch (IndexOutOfBoundsException e) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Please specify buylist.");
                activeChar.sendPacket(sm);
            }
        } else if (command.equals("admin_gmshop")) {
            AdminHelpPage.showHelpPage(activeChar, "gmshops.htm");
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void handleBuyRequest(L2PcInstance activeChar, String command) {
        int val = -1;
        try {
            val = Integer.parseInt(command);
        }
        catch (Exception e) {
            _log.warning("admin buylist failed:" + command);
        }
        L2TradeList list = TradeController.getInstance().getBuyList(val);
        if (list != null) {
            BuyList bl = new BuyList(list, activeChar.getAdena());
            activeChar.sendPacket(bl);
            if (Config.DEBUG) {
                _log.fine("GM: " + activeChar.getObjectId() + " opened GM shop id " + val);
            }
        } else {
            _log.warning("no buylist with id:" + val);
        }
        activeChar.sendPacket(new ActionFailed());
    }
}

