/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.Shutdown;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;

public class AdminShutdown
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminShutdown.class.getName());
    private static String[] _adminCommands = new String[]{"admin_server_shutdown", "admin_server_restart", "admin_server_abort"};
    private static final int REQUIRED_LEVEL = Config.GM_RESTART;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.startsWith("admin_server_shutdown")) {
            try {
                int val = Integer.parseInt(command.substring(22));
                this.serverShutdown(activeChar, val, false);
            }
            catch (StringIndexOutOfBoundsException e) {
                this.sendHtmlForm(activeChar);
            }
        } else if (command.startsWith("admin_server_restart")) {
            try {
                int val = Integer.parseInt(command.substring(21));
                this.serverShutdown(activeChar, val, true);
            }
            catch (StringIndexOutOfBoundsException e) {
                this.sendHtmlForm(activeChar);
            }
        } else if (command.startsWith("admin_server_abort")) {
            this.serverAbort(activeChar);
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void sendHtmlForm(L2PcInstance activeChar) {
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        int t = GameTimeController.getInstance().getGameTime();
        int h = t / 60;
        int m = t % 60;
        SimpleDateFormat format = new SimpleDateFormat("h:mm a");
        Calendar cal = Calendar.getInstance();
        cal.set(11, h);
        cal.set(12, m);
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Server Management Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br>");
        replyMSG.append("<table>");
        replyMSG.append("<tr><td>Players Online: " + L2World.getInstance().getAllPlayers().size() + "</td></tr>");
        replyMSG.append("<tr><td>Used Memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + " bytes</td></tr>");
        replyMSG.append("<tr><td>Server Rates: " + Config.RATE_XP + "x, " + Config.RATE_SP + "x, " + Config.RATE_DROP_ADENA + "x, " + Config.RATE_DROP_ITEMS + "x</td></tr>");
        replyMSG.append("<tr><td>Game Time: " + format.format(cal.getTime()) + "</td></tr>");
        replyMSG.append("</table><br>");
        replyMSG.append("<table width=270>");
        replyMSG.append("<tr><td>Enter in seconds the time till the server shutdowns bellow:</td></tr>");
        replyMSG.append("<br>");
        replyMSG.append("<tr><td><center>Seconds till: <edit var=\"shutdown_time\" width=60></center></td></tr>");
        replyMSG.append("</table><br>");
        replyMSG.append("<center><table><tr><td>");
        replyMSG.append("<button value=\"Shutdown\" action=\"bypass -h admin_server_shutdown $shutdown_time\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td><td>");
        replyMSG.append("<button value=\"Restart\" action=\"bypass -h admin_server_restart $shutdown_time\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td><td>");
        replyMSG.append("<button value=\"Abort\" action=\"bypass -h admin_server_abort\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</td></tr></table></center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    private void serverShutdown(L2PcInstance activeChar, int seconds, boolean restart) {
        Shutdown.getInstance().startShutdown(activeChar, seconds, restart);
    }

    private void serverAbort(L2PcInstance activeChar) {
        Shutdown.getInstance().abort(activeChar);
    }
}

