/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.StringTokenizer;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.SpawnTable;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminHelpPage;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class AdminSpawn
implements IAdminCommandHandler {
    private static String[] _adminCommands = new String[]{"admin_show_spawns", "admin_spawn", "admin_spawn_monster", "admin_spawn_index"};
    private static final int REQUIRED_LEVEL = Config.GM_NPC_EDIT;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.equals("admin_show_spawns")) {
            AdminHelpPage.showHelpPage(activeChar, "spawns.htm");
        } else if (command.startsWith("admin_spawn_index")) {
            String val = command.substring(18);
            AdminHelpPage.showHelpPage(activeChar, "spawns/" + val + ".htm");
        } else if (command.startsWith("admin_spawn") || command.startsWith("admin_spawn_monster")) {
            StringTokenizer st = new StringTokenizer(command);
            try {
                st.nextToken();
                String id = st.nextToken();
                int respawnTime = 15;
                if (st.hasMoreTokens()) {
                    respawnTime = Integer.parseInt(st.nextToken());
                }
                this.spawnMonster(activeChar, id, respawnTime);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void spawnMonster(L2PcInstance activeChar, String monsterId) {
        this.spawnMonster(activeChar, monsterId, 60);
    }

    private void spawnMonster(L2PcInstance activeChar, String monsterId, int respawnTime) {
        L2Object target = activeChar.getTarget();
        if (target == null) {
            target = activeChar;
        }
        int monsterTemplate = Integer.parseInt(monsterId);
        L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(monsterTemplate);
        if (template1 == null) {
            // empty if block
        }
        try {
            L2Spawn spawn = new L2Spawn(template1);
            spawn.setLocx(target.getX());
            spawn.setLocy(target.getY());
            spawn.setLocz(target.getZ());
            spawn.setAmount(1);
            spawn.setHeading(activeChar.getHeading());
            spawn.setRespawnDelay(respawnTime);
            SpawnTable.getInstance().addNewSpawn(spawn, true);
            spawn.init();
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Created " + template1.name + " on " + target.getObjectId() + ".");
            activeChar.sendPacket(sm);
        }
        catch (Exception e) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Target is not ingame.");
            activeChar.sendPacket(sm);
        }
    }
}

