/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.SpawnTable;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminHelpPage;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class AdminTeleport
implements IAdminCommandHandler {
    private static final Logger _log = Logger.getLogger(AdminTeleport.class.getName());
    private static String[] _adminCommands = new String[]{"admin_show_moves", "admin_show_moves_other", "admin_show_teleport", "admin_teleport_to_character", "admin_teleportto", "admin_move_to", "admin_teleport_character", "admin_recall", "admin_walk", "admin_explore", "teleportto", "recall", "admin_recall_npc", "admin_gonorth", "admin_gosouth", "admin_goeast", "admin_gowest", "admin_goup", "admin_godown", "admin_tele", "admin_failed"};
    private static final int REQUIRED_LEVEL = Config.GM_TELEPORT;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.equals("admin_show_moves")) {
            AdminHelpPage.showHelpPage(activeChar, "teleports.htm");
        }
        if (command.equals("admin_show_moves_other")) {
            AdminHelpPage.showHelpPage(activeChar, "tele/other.html");
        } else if (command.equals("admin_show_teleport")) {
            this.showTeleportCharWindow(activeChar);
        } else if (command.equals("admin_recall_npc")) {
            this.recallNPC(activeChar);
        } else if (command.equals("admin_teleport_to_character")) {
            this.teleportToCharacter(activeChar, activeChar.getTarget());
        } else if (command.equals("admin_explore") && Config.ACTIVATE_POSITION_RECORDER) {
            activeChar._exploring = !activeChar._exploring;
            activeChar.explore();
        } else if (command.startsWith("admin_walk")) {
            try {
                String val = command.substring(11);
                StringTokenizer st = new StringTokenizer(val);
                String x1 = st.nextToken();
                int x = Integer.parseInt(x1);
                String y1 = st.nextToken();
                int y = Integer.parseInt(y1);
                String z1 = st.nextToken();
                int z = Integer.parseInt(z1);
                L2CharPosition pos = new L2CharPosition(x, y, z, 0);
                activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos);
            }
            catch (Exception e) {
                _log.info("admin_walk: " + e);
            }
        } else if (command.startsWith("admin_move_to")) {
            try {
                String val = command.substring(14);
                this.teleportTo(activeChar, val);
            }
            catch (StringIndexOutOfBoundsException e) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Wrong or no Co-ordinates given.");
                activeChar.sendPacket(sm);
            }
        } else if (command.startsWith("admin_teleport_character")) {
            try {
                String val = command.substring(25);
                this.teleportCharacter(activeChar, val);
            }
            catch (StringIndexOutOfBoundsException e) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Wrong or no Co-ordinates given.");
                activeChar.sendPacket(sm);
                this.showTeleportCharWindow(activeChar);
            }
        } else if (command.startsWith("admin_teleportto ")) {
            String targetName = command.substring(17);
            L2PcInstance player = L2World.getInstance().getPlayer(targetName);
            this.teleportToCharacter(activeChar, player);
        } else if (command.startsWith("admin_recall ")) {
            String targetName = command.substring(13);
            L2PcInstance player = L2World.getInstance().getPlayer(targetName);
            this.teleportCharacter(player, activeChar.getX(), activeChar.getY(), activeChar.getZ());
        } else if (command.startsWith("admin_failed")) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Trying ActionFailed...");
            activeChar.sendPacket(sm);
            activeChar.sendPacket(new ActionFailed());
        } else if (command.equals("admin_tele")) {
            this.showTeleportWindow(activeChar);
        } else if (command.equals("admin_goup")) {
            int x = activeChar.getX();
            int y = activeChar.getY();
            int z = activeChar.getZ() + 150;
            activeChar.teleToLocation(x, y, z);
            this.showTeleportWindow(activeChar);
        } else if (command.startsWith("admin_goup")) {
            String val = command.substring(11);
            int intVal = Integer.parseInt(val);
            int x = activeChar.getX();
            int y = activeChar.getY();
            int z = activeChar.getZ() + intVal;
            activeChar.teleToLocation(x, y, z);
            this.showTeleportWindow(activeChar);
        } else if (command.equals("admin_godown")) {
            int x = activeChar.getX();
            int y = activeChar.getY();
            int z = activeChar.getZ();
            activeChar.teleToLocation(x, y, z - 150);
            this.showTeleportWindow(activeChar);
        } else if (command.startsWith("admin_goup")) {
            String val = command.substring(11);
            int intVal = Integer.parseInt(val);
            int x = activeChar.getX();
            int y = activeChar.getY();
            int z = activeChar.getZ() - intVal;
            activeChar.teleToLocation(x, y, z);
            this.showTeleportWindow(activeChar);
        } else if (command.equals("admin_goeast")) {
            int x = activeChar.getX();
            int y = activeChar.getY();
            int z = activeChar.getZ();
            activeChar.teleToLocation(x + 150, y, z);
            this.showTeleportWindow(activeChar);
        } else if (command.startsWith("admin_goup")) {
            String val = command.substring(11);
            int intVal = Integer.parseInt(val);
            int x = activeChar.getX() + intVal;
            int y = activeChar.getY();
            int z = activeChar.getZ();
            activeChar.teleToLocation(x, y, z);
            this.showTeleportWindow(activeChar);
        } else if (command.equals("admin_gowest")) {
            int x = activeChar.getX();
            int y = activeChar.getY();
            int z = activeChar.getZ();
            activeChar.teleToLocation(x - 150, y, z);
            this.showTeleportWindow(activeChar);
        } else if (command.startsWith("admin_goup")) {
            String val = command.substring(11);
            int intVal = Integer.parseInt(val);
            int x = activeChar.getX() - intVal;
            int y = activeChar.getY();
            int z = activeChar.getZ();
            activeChar.teleToLocation(x, y, z);
            this.showTeleportWindow(activeChar);
        } else if (command.equals("admin_gosouth")) {
            int x = activeChar.getX();
            int y = activeChar.getY() + 150;
            int z = activeChar.getZ();
            activeChar.teleToLocation(x, y, z);
            this.showTeleportWindow(activeChar);
        } else if (command.startsWith("admin_goup")) {
            String val = command.substring(11);
            int intVal = Integer.parseInt(val);
            int x = activeChar.getX();
            int y = activeChar.getY() + intVal;
            int z = activeChar.getZ();
            activeChar.teleToLocation(x, y, z);
            this.showTeleportWindow(activeChar);
        } else if (command.equals("admin_gonorth")) {
            int x = activeChar.getX();
            int y = activeChar.getY();
            int z = activeChar.getZ();
            activeChar.teleToLocation(x, y - 150, z);
            this.showTeleportWindow(activeChar);
        } else if (command.startsWith("admin_goup")) {
            String val = command.substring(11);
            int intVal = Integer.parseInt(val);
            int x = activeChar.getX();
            int y = activeChar.getY() - intVal;
            int z = activeChar.getZ();
            activeChar.teleToLocation(x, y, z);
            this.showTeleportWindow(activeChar);
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void teleportTo(L2PcInstance activeChar, String Cords) {
        StringTokenizer st = new StringTokenizer(Cords);
        String x1 = st.nextToken();
        int x = Integer.parseInt(x1);
        String y1 = st.nextToken();
        int y = Integer.parseInt(y1);
        String z1 = st.nextToken();
        int z = Integer.parseInt(z1);
        activeChar.teleToLocation(x, y, z);
        SystemMessage sm = new SystemMessage(614);
        sm.addString("You have been teleported to " + Cords);
        activeChar.sendPacket(sm);
    }

    private void showTeleportWindow(L2PcInstance activeChar) {
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><title>Teleport Menu</title>");
        replyMSG.append("<body>");
        replyMSG.append("<br>");
        replyMSG.append("<center><table>");
        replyMSG.append("<tr><td><button value=\"  \" action=\"bypass -h admin_tele\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"North\" action=\"bypass -h admin_gonorth\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"Up\" action=\"bypass -h admin_goup\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("<tr><td><button value=\"West\" action=\"bypass -h admin_gowest\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"  \" action=\"bypass -h admin_tele\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"East\" action=\"bypass -h admin_goeast\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("<tr><td><button value=\"  \" action=\"bypass -h admin_tele\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"South\" action=\"bypass -h admin_gosouth\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"Down\" action=\"bypass -h admin_godown\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("</table></center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    private void showTeleportCharWindow(L2PcInstance activeChar) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><title>Teleport Character</title>");
        replyMSG.append("<body>");
        replyMSG.append("The character you will teleport is " + player.getName() + ".");
        replyMSG.append("<br>");
        replyMSG.append("Co-ordinate x");
        replyMSG.append("<edit var=\"char_cord_x\" width=110>");
        replyMSG.append("Co-ordinate y");
        replyMSG.append("<edit var=\"char_cord_y\" width=110>");
        replyMSG.append("Co-ordinate z");
        replyMSG.append("<edit var=\"char_cord_z\" width=110>");
        replyMSG.append("<button value=\"Teleport\" action=\"bypass -h admin_teleport_character $char_cord_x $char_cord_y $char_cord_z\" width=60 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<button value=\"Teleport near you\" action=\"bypass -h admin_teleport_character " + activeChar.getX() + " " + activeChar.getY() + " " + activeChar.getZ() + "\" width=115 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<center><button value=\"Back\" action=\"bypass -h admin_current_player\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    private void teleportCharacter(L2PcInstance activeChar, String Cords) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        if (player.getObjectId() == activeChar.getObjectId()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("You cannot teleport your character.");
            player.sendPacket(sm);
        } else {
            StringTokenizer st = new StringTokenizer(Cords);
            String x1 = st.nextToken();
            int x = Integer.parseInt(x1);
            String y1 = st.nextToken();
            int y = Integer.parseInt(y1);
            String z1 = st.nextToken();
            int z = Integer.parseInt(z1);
            this.teleportCharacter(player, x, y, z);
        }
    }

    private void teleportCharacter(L2PcInstance player, int x, int y, int z) {
        if (player != null) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Admin is teleporting you.");
            player.sendPacket(sm);
            player.teleToLocation(x, y, z);
        }
    }

    private void teleportToCharacter(L2PcInstance activeChar, L2Object target) {
        L2PcInstance player = null;
        if (target == null || !(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        if (player.getObjectId() == activeChar.getObjectId()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("You cannot self teleport.");
            activeChar.sendPacket(sm);
        } else {
            int x = player.getX();
            int y = player.getY();
            int z = player.getZ();
            activeChar.teleToLocation(x, y, z);
            SystemMessage sm = new SystemMessage(614);
            sm.addString("You have teleported to character " + player.getName() + ".");
            activeChar.sendPacket(sm);
        }
    }

    private void recallNPC(L2PcInstance activeChar) {
        L2Object obj = activeChar.getTarget();
        if (obj != null && obj instanceof L2NpcInstance) {
            L2NpcInstance target = (L2NpcInstance)obj;
            L2Spawn spawn = target.getSpawn();
            int monsterTemplate = target.getTemplate().npcId;
            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(monsterTemplate);
            if (template1 == null) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Incorrect monster template.");
                activeChar.sendPacket(sm);
                return;
            }
            int respawnTime = spawn.getRespawnDelay();
            target.deleteMe();
            spawn.stopRespawn();
            SpawnTable.getInstance().deleteSpawn(spawn, true);
            try {
                spawn = new L2Spawn(template1);
                spawn.setLocx(activeChar.getX());
                spawn.setLocy(activeChar.getY());
                spawn.setLocz(activeChar.getZ());
                spawn.setAmount(1);
                spawn.setHeading(activeChar.getHeading());
                spawn.setRespawnDelay(respawnTime);
                SpawnTable.getInstance().addNewSpawn(spawn, true);
                spawn.init();
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Created " + template1.name + " on " + target.getObjectId() + ".");
                _log.fine("Spawn at X=" + spawn.getLocx() + " Y=" + spawn.getLocy() + " Z=" + spawn.getLocz());
                activeChar.sendPacket(sm);
                _log.warning("GM: Admin id " + activeChar.getObjectId() + " moved NPC" + target.getObjectId());
            }
            catch (Exception e) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Target is not in game.");
                activeChar.sendPacket(sm);
            }
        } else {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
        }
    }
}

