/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.Universe;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.waypoint.WayPointNode;

public class AdminTest
implements IAdminCommandHandler {
    private static final int REQUIRED_LEVEL = Config.ADMIN_TEST;
    private L2Object testObject = null;
    public static final String[] ADMIN_TEST_COMMANDS = new String[]{"admin_test"};

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (command.startsWith("admin_test hash ")) {
            try {
                int count = Integer.parseInt(command.substring("admin_test hash ".length()));
                this.testHashMap(activeChar, count);
            }
            catch (NumberFormatException e) {
                activeChar.sendMessage("Command format is //test hash <Number>");
            }
        } else if (command.startsWith("admin_test uni flush")) {
            Universe.getInstance().flush();
            activeChar.sendMessage("Universe Map Saved.");
        } else if (command.startsWith("admin_test uni")) {
            activeChar.sendMessage("Universe Map Size is: " + Universe.getInstance().size());
        } else if (command.equals("admin_test hash")) {
            this.testHashMap(activeChar);
        }
        return true;
    }

    private void testHashMap(L2PcInstance activeChar) {
        this.testHashMap(activeChar, 1);
    }

    private void testHashMap(L2PcInstance activeChar, int objectCount) {
        WayPointNode[] nodes = new WayPointNode[objectCount];
        for (int i = 0; i < objectCount; ++i) {
            nodes[i] = new WayPointNode(IdFactory.getInstance().getNextId());
            nodes[i].setXYZ(0, 0, 0);
        }
        long start = 0L;
        long end = 0L;
        start = System.currentTimeMillis();
        for (WayPointNode node : nodes) {
            L2World.getInstance().addVisibleObject(node, L2World.getInstance().getRegion(0, 0), null);
        }
        end = System.currentTimeMillis();
        long timeStore = new Long(end - start);
        start = System.currentTimeMillis();
        for (WayPointNode node : nodes) {
            L2World.getInstance().findObject(node.getObjectId());
        }
        end = System.currentTimeMillis();
        long timeFind = end - start;
        start = System.currentTimeMillis();
        for (WayPointNode node : nodes) {
            L2World.getInstance().removeVisibleObject(node, L2World.getInstance().getRegion(0, 0));
        }
        end = System.currentTimeMillis();
        long timeRemove = end - start;
        for (int i = 0; i < objectCount; ++i) {
            IdFactory.getInstance().releaseId(nodes[i].getObjectId());
        }
        nodes = null;
        activeChar.sendMessage("Testing HashMap on " + objectCount + " object(s).");
        activeChar.sendMessage("WorldObjectTable Insert:     " + timeStore + " ms.");
        activeChar.sendMessage("WorldObjectTable Retreive: " + timeFind + " ms.");
        activeChar.sendMessage("WorldObjectTable Remove:  " + timeRemove + " ms.");
    }

    public String[] getAdminCommandList() {
        return ADMIN_TEST_COMMANDS;
    }
}

