/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.logging.Logger;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.Formulas;

public class Continuous
implements ISkillHandler {
    private static Logger _log = Logger.getLogger(Continuous.class.getName());
    private static L2Skill.SkillType[] _skillIds = new L2Skill.SkillType[]{L2Skill.SkillType.BUFF, L2Skill.SkillType.DEBUFF, L2Skill.SkillType.DOT, L2Skill.SkillType.MDOT, L2Skill.SkillType.POISON, L2Skill.SkillType.BLEED, L2Skill.SkillType.HOT, L2Skill.SkillType.FEAR, L2Skill.SkillType.CONT, L2Skill.SkillType.WEAKNESS, L2Skill.SkillType.REFLECT, L2Skill.SkillType.UNDEAD_DEFENSE};

    public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets) {
        L2Character target = null;
        for (int index = 0; index < targets.length; ++index) {
            boolean acted;
            target = (L2Character)targets[index];
            if (skill.isOffensive() && !(acted = Formulas.getInstance().calcMagicAffected(activeChar, target, skill))) {
                activeChar.sendPacket(new SystemMessage(43));
                continue;
            }
            boolean stopped = false;
            L2Effect[] effects = target.getAllEffects();
            if (effects != null) {
                for (L2Effect e : effects) {
                    if (e.getSkill().getId() != skill.getId()) continue;
                    e.exit();
                    stopped = true;
                }
            }
            if (skill.isToggle() && stopped) {
                return;
            }
            skill.getEffects(activeChar, target);
        }
    }

    public L2Skill.SkillType[] getSkillIds() {
        return _skillIds;
    }
}

