/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.logging.Logger;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class Sweep
implements ISkillHandler {
    private static Logger _log = Logger.getLogger(Sweep.class.getName());
    protected L2Skill.SkillType[] _skillIds = new L2Skill.SkillType[]{L2Skill.SkillType.SWEEP};

    public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets) {
        if (!(activeChar instanceof L2PcInstance)) {
            return;
        }
        L2PcInstance player = (L2PcInstance)activeChar;
        InventoryUpdate iu = new InventoryUpdate();
        boolean send = false;
        for (int index = 0; index < targets.length; ++index) {
            L2ItemInstance[] items;
            L2Attackable target;
            if (!(targets[index] instanceof L2Attackable) || !(target = (L2Attackable)targets[index]).isSweepActive() || (items = target.takeSweep()) == null || items.length == 0) continue;
            for (L2ItemInstance item : items) {
                if (player.isInParty() && player.getParty().isDistributeSpoilLoot()) {
                    player.getParty().distributeItem(player, item);
                    continue;
                }
                int itemCount = item.getCount();
                item = player.getInventory().addItem(item);
                if (item.getLastChange() == 1) {
                    iu.addNewItem(item);
                } else {
                    iu.addModifiedItem(item);
                }
                send = true;
                SystemMessage smsg = new SystemMessage(29);
                smsg.addNumber(itemCount);
                smsg.addItemName(item.getItemId());
                player.sendPacket(smsg);
            }
        }
        if (send) {
            player.sendPacket(iu);
        }
    }

    public L2Skill.SkillType[] getSkillIds() {
        return this._skillIds;
    }
}

