/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.logging.Logger;
import net.sf.l2j.gameserver.Announcements;
import net.sf.l2j.gameserver.CastleUpdater;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.handler.skillhandlers.SiegeFlag;
import net.sf.l2j.gameserver.model.L2ArtefactInstance;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2World;

public class TakeCastle
implements ISkillHandler {
    private static Logger _log = Logger.getLogger(SiegeFlag.class.getName());
    protected L2Skill.SkillType[] _skillIds = new L2Skill.SkillType[]{L2Skill.SkillType.TAKECASTLE};
    private static final String[] castleNames = new String[]{"Nowhere", "Gludio", "Giran", "Dion", "Oren", "Aden"};

    public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets) {
        if (!(activeChar instanceof L2PcInstance)) {
            return;
        }
        L2Object target = ((L2PcInstance)activeChar).getTarget();
        int currentCastle = L2Siege.getSiege() - 1;
        activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        if (currentCastle != -1 && target instanceof L2ArtefactInstance) {
            int x1 = L2World.castlewinareas[currentCastle][0];
            int y1 = L2World.castlewinareas[currentCastle][1];
            int x2 = L2World.castlewinareas[currentCastle][2];
            int y2 = L2World.castlewinareas[currentCastle][3];
            int z = L2World.castlewinareas[currentCastle][4];
            if (activeChar.getX() >= Math.min(x1, x2) && activeChar.getX() <= Math.max(x1, x2) && activeChar.getY() >= Math.min(y1, y2) && activeChar.getY() <= Math.max(y1, y2) && activeChar.getZ() <= z + 30 && activeChar.getZ() >= z - 30) {
                int castleNum = currentCastle + 1;
                L2PcInstance player = (L2PcInstance)activeChar;
                L2Clan playersClan = player.getClan();
                if (playersClan != null) {
                    int previousCastle = playersClan.getHasCastle();
                    Announcements anounce = new Announcements();
                    if (castleNum != 0) {
                        if (L2Siege.getCastleOwner() != -1) {
                            L2Clan loosingClan = new L2Clan(L2Siege.getCastleOwner());
                            anounce.announceToAll(loosingClan.getName() + " has lost " + castleNames[castleNum] + " castle!");
                            loosingClan.setHasCastle(0);
                        }
                        anounce.announceToAll(playersClan.getName() + " has taken " + castleNames[castleNum] + " castle!");
                        L2Siege.setCastleOwner(playersClan.getClanId());
                        playersClan.setHasCastle(castleNum);
                    }
                    CastleUpdater cu = new CastleUpdater(playersClan);
                    ClientScheduler.getInstance().scheduleLow(cu, 30000L);
                    EndSiegeTask est = new EndSiegeTask();
                    anounce.announceToAll("The Siege will end in 10 seconds, and all normal rules will resume!");
                    ClientScheduler.getInstance().scheduleLow(est, 10000L);
                }
            }
        }
    }

    public L2Skill.SkillType[] getSkillIds() {
        return this._skillIds;
    }

    public class EndSiegeTask
    implements Runnable {
        EndSiegeTask() {
        }

        public void run() {
            try {
                L2Siege.endSiege();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

