/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.logging.Logger;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.Formulas;

public class Unlock
implements ISkillHandler {
    private static Logger _log = Logger.getLogger(Unlock.class.getName());
    protected L2Skill.SkillType[] _skillIds = new L2Skill.SkillType[]{L2Skill.SkillType.UNLOCK};

    public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets) {
        L2Object[] targetList = skill.getTargetList(activeChar);
        for (int index = 0; index < targetList.length; ++index) {
            SystemMessage systemmessage;
            L2DoorInstance target = (L2DoorInstance)targetList[index];
            boolean success = Formulas.getInstance().calculateUnlockChance(skill);
            if (!target.isUnlockable()) {
                systemmessage = new SystemMessage(614);
                systemmessage.addString("You cannot unlock this door!");
                activeChar.sendPacket(systemmessage);
                return;
            }
            if (success && target.getOpen() == 1) {
                target.openMe();
                target.onOpen();
                continue;
            }
            systemmessage = new SystemMessage(614);
            systemmessage.addString("UnLock failed!");
            activeChar.sendPacket(systemmessage);
        }
    }

    public L2Skill.SkillType[] getSkillIds() {
        return this._skillIds;
    }
}

