/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.usercommandhandlers;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.MapRegionTable;
import net.sf.l2j.gameserver.handler.IUserCommandHandler;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.Location;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.MagicSkillUser;
import net.sf.l2j.gameserver.serverpackets.SetupGauge;
import net.sf.l2j.gameserver.serverpackets.StopMove;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class Escape
implements IUserCommandHandler {
    private static final int[] COMMAND_IDS = new int[]{52};
    private static final int REQUIRED_LEVEL = Config.GM_ESCAPE;

    public boolean useUserCommand(int id, L2PcInstance activeChar) {
        int _unstuckTimer = activeChar.getAccessLevel() >= REQUIRED_LEVEL ? 5000 : 300000;
        SystemMessage sm = new SystemMessage(614);
        sm.addString("After " + _unstuckTimer / 60000 + " min. you be returned to near village.");
        activeChar.sendPacket(sm);
        activeChar.setTarget(activeChar);
        MagicSkillUser msk = new MagicSkillUser(activeChar, 1050, 1, _unstuckTimer, 0);
        activeChar.sendPacket(msk);
        activeChar.broadcastPacket(msk);
        SetupGauge sg = new SetupGauge(0, _unstuckTimer);
        activeChar.sendPacket(sg);
        activeChar.disableAllSkills();
        EscapeFinalizer ef = new EscapeFinalizer(activeChar);
        ClientScheduler.getInstance().scheduleLow(ef, _unstuckTimer - 200);
        return true;
    }

    public int[] getUserCommandList() {
        return COMMAND_IDS;
    }

    static class EscapeFinalizer
    implements Runnable {
        private L2PcInstance _activeChar;

        EscapeFinalizer(L2PcInstance activeChar) {
            this._activeChar = activeChar;
        }

        public void run() {
            try {
                Location townCords = MapRegionTable.getInstance().getClosestTownCords(this._activeChar);
                StopMove sm = new StopMove(this._activeChar);
                this._activeChar.sendPacket(sm);
                this._activeChar.broadcastPacket(sm);
                ActionFailed af = new ActionFailed();
                this._activeChar.sendPacket(af);
                this._activeChar.enableAllSkills();
                this._activeChar.teleToLocation(townCords.getX(), townCords.getY(), townCords.getZ());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

