/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib.jbf;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.lib.jbf.JBData;
import net.sf.l2j.gameserver.lib.jbf.Variable;
import net.sf.l2j.gameserver.lib.jbf.words.Compile;
import net.sf.l2j.gameserver.lib.jbf.words.Core;
import net.sf.l2j.gameserver.lib.jbf.words.CoreExt;
import net.sf.l2j.gameserver.lib.jbf.words.Dict;
import net.sf.l2j.gameserver.lib.jbf.words.FileSystem;
import net.sf.l2j.gameserver.lib.jbf.words.Find;
import net.sf.l2j.gameserver.lib.jbf.words.FloatOps;
import net.sf.l2j.gameserver.lib.jbf.words.Flow;
import net.sf.l2j.gameserver.lib.jbf.words.JBFext;
import net.sf.l2j.gameserver.lib.jbf.words.L2j;
import net.sf.l2j.gameserver.lib.jbf.words.L2j_Hire;
import net.sf.l2j.gameserver.lib.jbf.words.L2j_effects;
import net.sf.l2j.gameserver.lib.jbf.words.L2j_items;
import net.sf.l2j.gameserver.lib.jbf.words.L2j_ride;
import net.sf.l2j.gameserver.lib.jbf.words.Lists;
import net.sf.l2j.gameserver.lib.jbf.words.Literal;
import net.sf.l2j.gameserver.lib.jbf.words.Memory;
import net.sf.l2j.gameserver.lib.jbf.words.Parse;
import net.sf.l2j.gameserver.lib.jbf.words.RStack;
import net.sf.l2j.gameserver.lib.jbf.words.SQL;
import net.sf.l2j.gameserver.lib.jbf.words.StackOps;
import net.sf.l2j.gameserver.lib.jbf.words.Strings;
import net.sf.l2j.gameserver.lib.jbf.words.Timer;
import net.sf.l2j.gameserver.lib.jbf.words.Vars;
import net.sf.l2j.gameserver.lib.jbf.words.Word;

public class JBCore {
    static Logger _log = Logger.getLogger(JBCore.class.getName());
    public static Dict dict;
    public ArrayList<Object> current_code;
    public Word current_word;
    public String current_name;
    public Word last_word;
    public Variable state = new Variable();
    public Variable current = new Variable();
    public Variable context = new Variable();
    public ArrayList<Dict> s_o = new ArrayList();
    public ConcurrentHashMap<String, Variable> global_vars = new ConcurrentHashMap();
    private static JBCore _instance;

    public void reload(JBData data) {
        dict = new Dict("FORTH");
        this.current.set(dict);
        this.context.set(dict);
        this.s_o.clear();
        this.s_o.add(dict);
        new Parse(dict);
        new Compile(dict);
        new Memory(dict);
        new Lists(dict);
        new RStack(dict);
        new StackOps(dict);
        new Core(dict);
        new CoreExt(dict);
        new FloatOps(dict);
        new Flow(dict);
        new FileSystem(dict);
        new Vars(dict);
        new L2j(dict);
        new L2j_effects(dict);
        new L2j_items(dict);
        new L2j_ride(dict);
        new L2j_Hire(dict);
        new JBFext(dict);
        new SQL(dict);
        new Strings(dict);
        new Timer(dict);
        new Find(dict);
        this.exec("Main", data);
    }

    public static JBCore getInstance() {
        if (_instance == null) {
            _instance = new JBCore();
            JBData data = new JBData();
            _instance.reload(data);
            _log.config("JBForth instance load: " + data.stdout);
        }
        return _instance;
    }

    public void do_word(Word w, JBData data) {
        if ((Integer)this.state.get() != 0 && !w.isImmediate()) {
            this.current_code.add(w);
            ++this.current_word.Count;
        } else {
            try {
                w.exec(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void literal(Object n, JBData data) {
        if ((Integer)this.state.get() != 0) {
            this.current_code.add(new Literal(n));
            ++this.current_word.Count;
        } else {
            data.st.push(n);
        }
    }

    public void abort() {
        this.state.set(0);
    }

    public void exec(String code, JBData data) {
        String word_name;
        data.fst.push(data.in.get());
        data.fst.push(data.commands);
        data.in.set(0);
        data.commands = code;
        boolean cont = true;
        while ((word_name = this.nextWord(data)) != null && cont) {
            String rest2;
            Word w = dict.get(word_name);
            String rest1 = word_name.length() > 1 ? word_name.substring(1) : "";
            String string = rest2 = rest1.length() > 1 ? rest1.substring(0, rest1.length() - 1) : "";
            if (w != null) {
                this.do_word(w, data);
                continue;
            }
            if (word_name.matches("^[\\-\\+]?[\\d]+$")) {
                this.literal(Integer.parseInt(word_name), data);
                continue;
            }
            if (word_name.matches("^[\\-\\+]?0x[\\da-fA-F]+$")) {
                word_name = word_name.replaceAll("0x", "");
                this.literal(Integer.parseInt(word_name, 16), data);
                continue;
            }
            if (word_name.matches("^[\\-\\+]?[\\d]+\\.?[\\d]*[Ee]*[\\d]*$")) {
                this.literal(Double.parseDouble(word_name), data);
                continue;
            }
            if (word_name.equals("\"")) {
                this.literal(rest1 + this.nextWord("\"", data), data);
                continue;
            }
            if (word_name.startsWith("\"")) {
                if (word_name.endsWith("\"")) {
                    this.literal(rest2, data);
                    continue;
                }
                this.literal(rest1 + this.nextWord("\"", data), data);
                continue;
            }
            if (word_name.startsWith("'")) {
                if (word_name.endsWith("'")) {
                    this.literal(rest2, data);
                    continue;
                }
                this.literal(rest1 + this.nextWord("'", data), data);
                continue;
            }
            String fname = "data/jbforth/" + word_name;
            File file = new File(Config.DATAPACK_ROOT, fname);
            if (file.exists()) {
                this.exec("\"" + fname + "\" INCLUDED", data);
                continue;
            }
            fname = "data/jbforth/" + word_name + ".f";
            file = new File(Config.DATAPACK_ROOT, fname);
            if (file.exists()) {
                this.exec("\"" + fname + "\" INCLUDED", data);
                continue;
            }
            data.stdout = data.stdout + "\nAbort: Unknown word " + word_name + "\n";
            this.abort();
            cont = false;
        }
        data.commands = (String)data.fst.pop();
        data.in.set(data.fst.pop());
    }

    public String nextWord(JBData data) {
        boolean skip = true;
        int start = -1;
        for (int i = ((Integer)data.in.get()).intValue(); i < data.commands.length(); ++i) {
            String ch = data.commands.substring(i, i + 1);
            if (ch.equals(" ") || ch.equals("\t") || ch.equals("\n") || ch.equals("\r")) {
                if (skip) continue;
                data.in.set(i);
                return data.commands.substring(start, i);
            }
            if (!skip) continue;
            skip = false;
            start = i;
        }
        data.in.set(data.commands.length());
        return start >= 0 ? data.commands.substring(start, (Integer)data.in.get()) : null;
    }

    public String nextWord(String delim, JBData data) {
        int start;
        for (int i = start = ((Integer)data.in.get()).intValue(); i < data.commands.length(); ++i) {
            String ch = data.commands.substring(i, i + 1);
            if (!ch.equals(delim)) continue;
            data.in.set(i + 1);
            return data.commands.substring(start, i);
        }
        data.in.set(data.commands.length());
        return data.commands.substring(start, (Integer)data.in.get());
    }
}

