/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib.jbf;

public class Stack {
    private Object[] _st = null;
    private int _sp = -1;

    public Stack() {
        this.setStack(1024);
    }

    public Stack(int size) {
        this.setStack(size);
    }

    public void reset() {
        this._sp = -1;
    }

    public void setStack(int n) {
        Object[] new_stack = new Object[n];
        if (this._st != null) {
            for (int i = 0; i < Math.min(this._st.length, n) && i <= this._sp; ++i) {
                new_stack[i] = this._st[i];
            }
        }
        this._st = new_stack;
    }

    public void push(Object n) {
        this._st[++this._sp] = n;
    }

    public Object pop() {
        return this._sp >= 0 ? this._st[this._sp--] : null;
    }

    public Integer pop_i() {
        return this._sp >= 0 ? (Integer)this._st[this._sp--] : 0;
    }

    public String pop_s() {
        return this._sp >= 0 ? (String)this._st[this._sp--] : "";
    }

    public Object[] pop2() {
        Object[] x = new Object[2];
        if (this._sp < 1) {
            x[0] = 0;
            x[1] = 0;
        } else {
            x[0] = this._st[this._sp--];
            x[1] = this._st[this._sp--];
        }
        return x;
    }

    public void swap() {
        if (this._sp < 1) {
            return;
        }
        Object n = this._st[this._sp];
        this._st[this._sp] = this._st[this._sp - 1];
        this._st[this._sp - 1] = n;
    }

    public void drop() {
        if (this._sp >= 0) {
            --this._sp;
        }
    }

    public void ddrop() {
        if (this._sp > 0) {
            this._sp -= 2;
        }
    }

    public void dup() {
        this.push(this.top());
    }

    public void ndrop(int n) {
        if (n > this._sp) {
            n = this._sp;
        }
        this._sp -= n;
    }

    public void rot() {
        if (this._sp < 2) {
            return;
        }
        Object tmp = this._st[this._sp];
        this._st[this._sp] = this._st[this._sp - 2];
        this._st[this._sp - 2] = this._st[this._sp - 1];
        this._st[this._sp - 1] = tmp;
    }

    public Object peek(int n) {
        return n <= this._sp ? this._st[this._sp - n] : null;
    }

    public Integer peek_i(int n) {
        return n <= this._sp ? (Integer)this._st[this._sp - n] : 0;
    }

    public Object top() {
        return this._st[this._sp];
    }

    public Integer top_i() {
        return (Integer)this._st[this._sp];
    }

    public void set(Object x) {
        this._st[this._sp] = x;
    }

    public int depth() {
        return this._sp + 1;
    }

    public void setDepth(int size) {
        this._sp = size - 1;
    }

    public void dup2() {
        if (this._sp < 1) {
            return;
        }
        this._sp += 2;
        this._st[this._sp] = this._st[this._sp - 2];
        this._st[this._sp - 1] = this._st[this._sp - 3];
    }

    public void over() {
        if (this._sp < 1) {
            return;
        }
        this._st[++this._sp] = this._st[this._sp - 2];
    }
}

