/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib.jbf.words;

import java.util.ArrayList;
import net.sf.l2j.gameserver.lib.jbf.JBCore;
import net.sf.l2j.gameserver.lib.jbf.JBData;
import net.sf.l2j.gameserver.lib.jbf.words.Dict;
import net.sf.l2j.gameserver.lib.jbf.words.Literal;
import net.sf.l2j.gameserver.lib.jbf.words.Word;

public class Compile {
    public Compile(Dict d) {
        d.reg(":", new colon());
        d.reg(";", new semicolon(), true);
        d.reg("STATE", new state());
        d.reg("HERE", new here());
        d.reg("?PAIR", new qpair());
        d.reg("IMMEDIATE", new immediate());
        d.reg("[']", new comp_apo(), true);
        d.reg("POSTPONE", new postpone(), true);
    }

    public class postpone
    extends Word {
        public void exec(JBData data) throws Exception {
            String name = this.jbc.nextWord(data);
            Word w = JBCore.dict.get(name);
            if (w == null) {
                throw new Exception("Word '" + name + "' not found for POSTPONE");
            }
            if (w.isImmediate()) {
                this.jbc.literal(w, data);
            } else {
                this.jbc.current_code.add(new Literal(w));
                ++this.jbc.current_word.Count;
                this.jbc.current_code.add(new Literal(JBCore.dict.get(",")));
                ++this.jbc.current_word.Count;
            }
        }
    }

    public class comp_apo
    extends Word {
        public void exec(JBData data) throws Exception {
            String name = this.jbc.nextWord(data);
            Word w = JBCore.dict.get(name);
            if (w == null) {
                throw new Exception("Word '" + name + "' not found for [']");
            }
            this.jbc.literal(w, data);
        }
    }

    public class qpair
    extends Word {
        public void exec(JBData data) throws Exception {
            Object[] x = data.st.pop2();
            if (x[0] != x[1]) {
                throw new Exception("Non pair operators! " + x[0] + "!=" + x[1]);
            }
        }
    }

    public class immediate
    extends Word {
        public void exec(JBData data) {
            this.jbc.last_word.immediate = true;
        }
    }

    public class here
    extends Word {
        public void exec(JBData data) {
            data.st.push(this.jbc.current_word.Count);
        }
    }

    public class state
    extends Word {
        public void exec(JBData data) {
            data.st.push(this.jbc.state);
        }
    }

    public class semicolon
    extends Word {
        public void exec(JBData data) {
            this.jbc.current_word.make(this.jbc.current_code);
            JBCore.dict.reg(this.jbc.current_name, this.jbc.current_word);
            this.jbc.last_word = this.jbc.current_word;
            this.jbc.state.set(0);
        }
    }

    public class colon
    extends Word {
        public void exec(JBData data) {
            this.jbc.state.set(1);
            this.jbc.current_word = new Word();
            this.jbc.current_code = new ArrayList();
            this.jbc.current_name = this.jbc.nextWord(data);
            this.jbc.last_word = null;
            this.jbc.current_word.Count = 0;
        }
    }
}

