/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib.jbf.words;

import net.sf.l2j.gameserver.lib.jbf.JBData;
import net.sf.l2j.gameserver.lib.jbf.words.Dict;
import net.sf.l2j.gameserver.lib.jbf.words.Word;

public class Core {
    public Core(Dict d) {
        d.reg("+", new add());
        d.reg("-", new sub());
        d.reg("*", new mul());
        d.reg("/", new div());
        d.reg("NEGATE", new negate());
        d.reg("NOT", new not());
        d.reg("<", new less());
        d.reg(">", new great());
        d.reg("<=", new less_eq());
        d.reg(">=", new great_eq());
        d.reg("<>", new not_eq());
        d.reg("!=", new not_eq());
        d.reg("=", new eq());
        d.reg("0=", new zeq());
        d.reg("0<>", new zne());
        d.reg("1+", new oneplus());
        d.reg("1-", new oneminus());
        d.reg("2-", new twominus());
        d.reg(".", new dot());
        d.reg(".F", new dotf());
        d.reg(".S", new dots());
        d.reg("._S", new xdots());
        d.reg("D.S", new ddots());
    }

    public class not
    extends Word {
        public void exec(JBData data) {
            data.st.set(~((Integer)data.st.top()).intValue());
        }
    }

    public class negate
    extends Word {
        public void exec(JBData data) {
            data.st.set(-((Integer)data.st.top()).intValue());
        }
    }

    public class zne
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.top() != 0 ? -1 : 0);
        }
    }

    public class zeq
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.top() == 0 ? -1 : 0);
        }
    }

    public class not_eq
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.pop() != (Integer)data.st.top() ? -1 : 0);
        }
    }

    public class eq
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.pop() == (Integer)data.st.top() ? -1 : 0);
        }
    }

    public class great_eq
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.pop() <= (Integer)data.st.top() ? -1 : 0);
        }
    }

    public class less_eq
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.pop() >= (Integer)data.st.top() ? -1 : 0);
        }
    }

    public class great
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.pop() < (Integer)data.st.top() ? -1 : 0);
        }
    }

    public class less
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.pop() > (Integer)data.st.top() ? -1 : 0);
        }
    }

    public class twominus
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.top() - 2);
        }
    }

    public class oneminus
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.top() - 1);
        }
    }

    public class oneplus
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.top() + 1);
        }
    }

    public class ddots
    extends Word {
        public void exec(JBData data) {
            System.out.print("Stack:");
            for (int i = data.st.depth() - 1; i >= 0; --i) {
                System.out.print(data.st.peek(i) + " ");
            }
            System.out.println(" ");
        }
    }

    public class xdots
    extends Word {
        public void exec(JBData data) {
            for (int i = data.st.depth() - 1; i >= 0; --i) {
                System.out.print("" + data.st.peek(i) + " ");
            }
            System.out.print("\n");
        }
    }

    public class dots
    extends Word {
        public void exec(JBData data) {
            for (int i = data.st.depth() - 1; i >= 0; --i) {
                data.stdout = data.stdout + "" + data.st.peek(i) + " ";
            }
        }
    }

    public class dotf
    extends Word {
        public void exec(JBData data) {
            data.stdout = data.stdout + String.format((String)data.st.pop(), data.st.pop());
        }
    }

    public class dot
    extends Word {
        public void exec(JBData data) {
            data.stdout = data.stdout + "" + data.st.pop() + " ";
        }
    }

    public class div
    extends Word {
        public void exec(JBData data) {
            Integer n = (Integer)data.st.pop();
            data.st.set((Integer)data.st.top() / n);
        }
    }

    public class mul
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.pop() * (Integer)data.st.top());
        }
    }

    public class sub
    extends Word {
        public void exec(JBData data) {
            Integer n = (Integer)data.st.pop();
            data.st.set((Integer)data.st.top() - n);
        }
    }

    public class add
    extends Word {
        public void exec(JBData data) {
            data.st.set((Integer)data.st.pop() + (Integer)data.st.top());
        }
    }
}

