/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib.jbf.words;

import net.sf.l2j.gameserver.lib.jbf.JBData;
import net.sf.l2j.gameserver.lib.jbf.words.Dict;
import net.sf.l2j.gameserver.lib.jbf.words.Word;

public class Flow {
    public Flow(Dict d) {
        d.reg("?COMP", new qcomp(), true);
        d.reg("BRANCH", new branch());
        d.reg("?BRANCH", new zbranch());
        d.reg("RECURSE", new recurse(), true);
        d.reg("EXIT", new exit());
        d.reg("EXEC", new _exec());
        d.reg("(DO)", new br_do());
        d.reg("(?DO)", new br_qdo());
        d.reg("(LOOP)", new br_loop());
        d.reg("(+LOOP)", new br_ploop());
    }

    public class br_ploop
    extends Word {
        public void exec(JBData data) {
            Integer step = data.st.pop_i();
            data.rst.set(data.rst.top_i() + step);
            if (data.rst.top_i() < data.rst.peek_i(1) && step >= 0 || data.rst.top_i() > data.rst.peek_i(1) && step < 0) {
                data.cws.wp = (Integer)data.cws.w.code[data.cws.wp + 1] - 1;
            } else {
                data.rst.pop();
                data.rst.pop();
                ++data.cws.wp;
            }
        }
    }

    public class br_loop
    extends Word {
        public void exec(JBData data) {
            data.rst.set(data.rst.top_i() + 1);
            if (data.rst.top_i() != data.rst.peek_i(1)) {
                data.cws.wp = (Integer)data.cws.w.code[data.cws.wp + 1] - 1;
            } else {
                data.rst.pop();
                data.rst.pop();
                ++data.cws.wp;
            }
        }
    }

    public class br_qdo
    extends Word {
        public void exec(JBData data) {
            Integer end;
            Integer start = data.st.pop_i();
            if (start == (end = data.st.pop_i())) {
                data.cws.wp = (Integer)data.cws.w.code[data.cws.wp + 1] - 1;
            } else {
                ++data.cws.wp;
                data.rst.push(end);
                data.rst.push(start);
            }
        }
    }

    public class br_do
    extends Word {
        public void exec(JBData data) {
            Integer start = data.st.pop_i();
            data.rst.push(data.st.pop());
            data.rst.push(start);
        }
    }

    public class _exec
    extends Word {
        public void exec(JBData data) {
        }
    }

    public class exit
    extends Word {
        public void exec(JBData data) throws Exception {
            data.cws.wp = 9999999;
        }
    }

    public class recurse
    extends Word {
        public void exec(JBData data) throws Exception {
            this.jbc.do_word(this.jbc.current_word, data);
        }
    }

    public class zbranch
    extends Word {
        public void exec(JBData data) throws Exception {
            int pos = (Integer)data.cws.w.code[++data.cws.wp];
            Object x = data.st.pop();
            Integer cond = 0;
            if (x instanceof Integer) {
                cond = (Integer)x;
            } else if (x instanceof String) {
                cond = (String)x != "" ? -1 : 0;
            }
            if (cond == 0) {
                data.cws.wp = pos - 1;
            }
        }
    }

    public class branch
    extends Word {
        public void exec(JBData data) throws Exception {
            data.cws.wp = (Integer)data.cws.w.code[data.cws.wp + 1] - 1;
        }
    }

    public class qcomp
    extends Word {
        public void exec(JBData data) throws Exception {
            if ((Integer)this.jbc.state.get() == 0) {
                throw new Exception("Compile only word using while non-compile time!");
            }
        }
    }

    public class mark
    extends Word {
        public void exec(JBData data) {
            data.st.push(this.jbc.current_word.Count);
            this.jbc.current_code.add(null);
        }
    }
}

