/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib.jbf.words;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.lib.Rnd;
import net.sf.l2j.gameserver.lib.jbf.JBData;
import net.sf.l2j.gameserver.lib.jbf.words.Dict;
import net.sf.l2j.gameserver.lib.jbf.words.Word;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.Dice;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2j {
    static Logger _log = Logger.getLogger(L2j.class.getName());

    public L2j(Dict d) {
        d.reg("PLAYER!", new player_sto());
        d.reg("PLAYER@", new player_at());
        d.reg("SHOW", new show());
        d.reg("COORDS@", new coords_at());
        d.reg("TELEPORT_PLAYER_TO", new teleport_player_to());
        d.reg("TELEPORT-PLAYER-TO", new teleport_player_to2());
        d.reg("NPC_NAME>ID", new npc_name_to_id());
        d.reg("NPC_ID>NAME", new npc_id_to_name());
        d.reg("NPC_ID>SPAWN", new npc_id_to_spawn());
        d.reg("JBF_RELOAD", new jbf_reload());
        d.reg("DICE", new dice());
        d.reg("P!", new dset());
        d.reg("IP!", new psto_i());
        d.reg("BP!", new psto_b());
        d.reg("P@", new dget());
        d.reg("P?", new prop_is_cond());
        d.reg("TARGET@", new target_at());
        d.reg("REMOVE-FROM-ALL-PLAYERS", new remove_from_all_players());
        d.reg("DO-PLAYERS", new do_players());
        d.reg("CLASS?", new getclass());
        d.reg("CLASS!", new setclass());
    }

    public class setclass
    extends Word {
        public void exec(JBData data) {
            L2PcInstance player = (L2PcInstance)data.st.pop();
            int classId = data.st.pop_i();
            player.setClassId(classId);
            player.broadcastUserInfo();
            data.stdout = data.stdout + "You accupation changed to " + (Object)((Object)player.getClassId());
        }
    }

    public class getclass
    extends Word {
        public void exec(JBData data) {
            L2PcInstance player = (L2PcInstance)data.st.pop();
            data.st.push(player.getClassId().getId());
        }
    }

    public class do_players
    extends Word {
        public void exec(JBData data) {
            String code = data.st.pop_s();
            for (L2PcInstance player : L2World.getInstance().getAllPlayers()) {
                player.jbf.exec(code);
            }
        }
    }

    public class remove_from_all_players
    extends Word {
        public void exec(JBData data) {
            L2World.getInstance().removeFromAllPlayers((L2PcInstance)data.st.pop());
        }
    }

    public class target_at
    extends Word {
        public void exec(JBData data) {
            Object ch = data.st.pop();
            data.st.push(ch != null && ch instanceof L2Character ? ((L2Character)ch).getTarget() : new Integer(0));
        }
    }

    public class prop_is_cond
    extends Word {
        public void exec(JBData data) {
            String method = "is" + data.st.pop();
            Object obj = data.st.pop();
            try {
                Method m = obj.getClass().getMethod(method, new Class[0]);
                data.st.push((Boolean)m.invoke(obj, new Object[0]) != false ? -1 : 0);
            }
            catch (Exception e) {
                _log.warning("" + e);
                e.printStackTrace();
            }
        }
    }

    public class dget
    extends Word {
        public void exec(JBData data) {
            String method = "get" + data.st.pop();
            Object obj = data.st.pop();
            try {
                Method m = obj.getClass().getMethod(method, new Class[0]);
                data.st.push(m.invoke(obj, new Object[0]));
            }
            catch (Exception e) {
                _log.warning("" + e);
                e.printStackTrace();
            }
        }
    }

    public class psto_b
    extends Word {
        public void exec(JBData data) {
            String method = "set" + data.st.pop();
            Object obj = data.st.pop();
            try {
                Method m = obj.getClass().getMethod(method, Boolean.class);
                m.invoke(obj, (Integer)data.st.pop() == -1);
            }
            catch (Exception e) {
                _log.warning("" + e);
                e.printStackTrace();
            }
        }
    }

    public class psto_i
    extends Word {
        public void exec(JBData data) {
            String method = "set" + data.st.pop();
            Object obj = data.st.pop();
            try {
                Method m = obj.getClass().getMethod(method, Integer.class);
                m.invoke(obj, (Integer)data.st.pop());
            }
            catch (Exception e) {
                _log.warning("" + e);
                e.printStackTrace();
            }
        }
    }

    public class dset
    extends Word {
        public void exec(JBData data) {
            String method = "set" + data.st.pop();
            Object obj = data.st.pop();
            try {
                Method m = obj.getClass().getMethod(method, String.class);
                m.invoke(obj, (String)data.st.pop());
            }
            catch (Exception e) {
                _log.warning("" + e);
                e.printStackTrace();
            }
        }
    }

    public class dice
    extends Word {
        public void exec(JBData data) {
            int number = Rnd.get(1, 6);
            int item_id = (Integer)data.st.pop();
            L2PcInstance activeChar = (L2PcInstance)data.st.pop();
            Dice d = new Dice(activeChar.getObjectId(), item_id, number, activeChar.getX() - 30 + Rnd.get(60), activeChar.getY() - 30 + Rnd.get(60), activeChar.getZ());
            activeChar.broadcastPacket(d);
            SystemMessage sm = new SystemMessage(834);
            sm.addString(activeChar.getName());
            sm.addNumber(number);
            activeChar.sendPacket(sm);
            activeChar.broadcastPacket(sm);
            data.st.push(number);
        }
    }

    public class jbf_reload
    extends Word {
        public void exec(JBData data) {
            this.jbc.reload(data);
        }
    }

    public class npc_id_to_spawn
    extends Word {
        public void exec(JBData data) {
            data.st.push(null);
        }
    }

    public class npc_id_to_name
    extends Word {
        public void exec(JBData data) {
            int npc_id = (Integer)data.st.pop();
            L2NpcTemplate npc_template = NpcTable.getInstance().getTemplate(npc_id);
            data.st.push(npc_template.name);
        }
    }

    public class npc_name_to_id
    extends Word {
        public void exec(JBData data) {
            data.st.push(null);
        }
    }

    public class teleport_player_to2
    extends Word {
        public void exec(JBData data) {
            L2PcInstance player = (L2PcInstance)data.st.pop();
            int z = (Integer)data.st.pop();
            int y = (Integer)data.st.pop();
            int x = (Integer)data.st.pop();
            player.teleToLocation(x, y, z);
            if (player.getPet() != null) {
                player.getPet().teleToLocation(x + 100, y, z);
            }
        }
    }

    public class teleport_player_to
    extends Word {
        public void exec(JBData data) {
            int z = (Integer)data.st.pop();
            int y = (Integer)data.st.pop();
            int x = (Integer)data.st.pop();
            L2PcInstance player = (L2PcInstance)data.st.pop();
            player.teleToLocation(x, y, z);
            if (player.getPet() != null) {
                player.getPet().teleToLocation(x + 100, y, z);
            }
        }
    }

    public class coords_at
    extends Word {
        public void exec(JBData data) {
            Object x = data.st.pop();
            if (x instanceof L2Character) {
                L2Character ch = (L2Character)x;
                data.st.push(ch.getX());
                data.st.push(ch.getY());
                data.st.push(ch.getZ());
                return;
            }
            if (x instanceof L2Spawn) {
                L2Spawn sp = (L2Spawn)x;
                data.st.push(sp.getLocx());
                data.st.push(sp.getLocy());
                data.st.push(sp.getLocz());
                return;
            }
            data.st.push(null);
            data.st.push(null);
            data.st.push(null);
        }
    }

    public class show
    extends Word {
        public void exec(JBData data) {
            NpcHtmlMessage msg = new NpcHtmlMessage(5);
            String s = "<html><title>Message:</title><body><br><br><br>";
            s = s + "" + data.st.pop();
            s = s + "</body></html>";
            msg.setHtml(s);
            data.player.sendPacket(msg);
        }
    }

    public class player_at
    extends Word {
        public void exec(JBData data) {
            data.st.push(data.player);
        }
    }

    public class player_sto
    extends Word {
        public void exec(JBData data) {
            data.player = (L2PcInstance)data.st.pop();
        }
    }
}

