/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.templates.L2EtcItem;
import net.sf.l2j.gameserver.templates.L2EtcItemType;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2WeaponType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Inventory {
    protected static final Logger _log = Logger.getLogger(Inventory.class.getName());
    public static final int PAPERDOLL_UNDER = 0;
    public static final int PAPERDOLL_LEAR = 1;
    public static final int PAPERDOLL_REAR = 2;
    public static final int PAPERDOLL_NECK = 3;
    public static final int PAPERDOLL_LFINGER = 4;
    public static final int PAPERDOLL_RFINGER = 5;
    public static final int PAPERDOLL_HEAD = 6;
    public static final int PAPERDOLL_RHAND = 7;
    public static final int PAPERDOLL_LHAND = 8;
    public static final int PAPERDOLL_GLOVES = 9;
    public static final int PAPERDOLL_CHEST = 10;
    public static final int PAPERDOLL_LEGS = 11;
    public static final int PAPERDOLL_FEET = 12;
    public static final int PAPERDOLL_BACK = 13;
    public static final int PAPERDOLL_LRHAND = 14;
    public static final int PAPERDOLL_HAIR = 15;
    public static final double MAX_ARMOR_WEIGHT = 12000.0;
    private final L2ItemInstance[] _paperdoll = new L2ItemInstance[16];
    private final CopyOnWriteArrayList<PaperdollListener> _paperdollListeners;
    protected final ArrayList<L2ItemInstance> _items = new ArrayList();
    private int _totalWeight;
    private int _wearedMask;

    protected Inventory() {
        this._paperdollListeners = new CopyOnWriteArrayList();
        this.addPaperdollListener(new BowListener());
        this.addPaperdollListener(new StatsListener());
    }

    protected abstract L2Character getOwner();

    protected abstract L2ItemInstance.ItemLocation getBaseLocation();

    protected abstract L2ItemInstance.ItemLocation getEquipLocation();

    public int getOwnerId() {
        return this.getOwner() == null ? 0 : this.getOwner().getObjectId();
    }

    public ChangeRecorder newRecorder() {
        return new ChangeRecorder(this);
    }

    public int getSize() {
        return this._items.size();
    }

    public L2ItemInstance[] getItems() {
        return this._items.toArray(new L2ItemInstance[this._items.size()]);
    }

    public L2ItemInstance addItem(L2ItemInstance newItem) {
        return this.addItem(newItem, true);
    }

    protected L2ItemInstance addItem(L2ItemInstance newItem, boolean dbUpdate) {
        int itemId;
        L2ItemInstance old;
        L2ItemInstance result = newItem;
        boolean stackableFound = false;
        if (newItem.isStackable() && (old = this.findItemByItemId(itemId = newItem.getItemId())) != null) {
            old.setCount(old.getCount() + newItem.getCount());
            newItem.setCount(0);
            newItem.setOwnerId(0);
            newItem.setLocation(L2ItemInstance.ItemLocation.VOID);
            stackableFound = true;
            old.setLastChange(2);
            if (dbUpdate) {
                old.updateDatabase();
                newItem.updateDatabase();
            }
            result = old;
        }
        if (!stackableFound) {
            this._items.add(newItem);
            if (newItem.getOwnerId() != this.getOwnerId() || dbUpdate) {
                newItem.setOwnerId(this.getOwnerId());
                newItem.setLocation(this.getBaseLocation());
                newItem.setLastChange(1);
            }
            if (dbUpdate) {
                newItem.updateDatabase();
            }
        }
        this.refreshWeight();
        return result;
    }

    public L2ItemInstance findItemByItemId(int itemId) {
        for (L2ItemInstance temp : this._items) {
            if (temp.getItemId() != itemId) continue;
            return temp;
        }
        return null;
    }

    public L2ItemInstance getPaperdollItem(int slot) {
        return this._paperdoll[slot];
    }

    public int getPaperdollItemId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        if (item != null) {
            return item.getItemId();
        }
        return 0;
    }

    public int getPaperdollObjectId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        if (item != null) {
            return item.getObjectId();
        }
        return 0;
    }

    public synchronized void addPaperdollListener(PaperdollListener listener) {
        if (Config.ASSERT) assert (!this._paperdollListeners.contains(listener));
        this._paperdollListeners.add(listener);
    }

    public synchronized void removePaperdollListener(PaperdollListener listener) {
        this._paperdollListeners.remove(listener);
    }

    L2ItemInstance setPaperdollItem(int slot, L2ItemInstance item) {
        L2ItemInstance old = this._paperdoll[slot];
        if (old != item) {
            if (old != null) {
                this._paperdoll[slot] = null;
                old.setLocation(this.getBaseLocation());
                old.setLastChange(2);
                int mask = 0;
                for (int i = 0; i < 14; ++i) {
                    L2ItemInstance pi = this._paperdoll[i];
                    if (pi == null) continue;
                    mask |= pi.getItem().getItemMask();
                }
                this._wearedMask = mask;
                for (PaperdollListener listener : this._paperdollListeners) {
                    listener.notifyUnequiped(slot, old);
                }
                old.updateDatabase();
            }
            if (item != null) {
                this._paperdoll[slot] = item;
                item.setLocation(this.getEquipLocation(), slot);
                item.setLastChange(2);
                this._wearedMask |= item.getItem().getItemMask();
                for (PaperdollListener listener : this._paperdollListeners) {
                    listener.notifyEquiped(slot, item);
                }
                item.updateDatabase();
            }
        }
        return old;
    }

    public int getWearedMask() {
        return this._wearedMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance[] unEquipItemInBodySlotAndRecord(int slot) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.unEquipItemInBodySlot(slot);
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    public L2ItemInstance unEquipItemInSlot(int pdollSlot) {
        return this.setPaperdollItem(pdollSlot, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance[] unEquipItemInSlotAndRecord(int slot) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.unEquipItemInSlot(slot);
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    private void unEquipItemInBodySlot(int slot) {
        if (Config.DEBUG) {
            _log.fine("--- unequip body slot:" + slot);
        }
        int pdollSlot = -1;
        switch (slot) {
            case 4: {
                pdollSlot = 1;
                break;
            }
            case 2: {
                pdollSlot = 2;
                break;
            }
            case 8: {
                pdollSlot = 3;
                break;
            }
            case 16: {
                pdollSlot = 5;
                break;
            }
            case 32: {
                pdollSlot = 4;
                break;
            }
            case 65536: {
                pdollSlot = 15;
                break;
            }
            case 64: {
                pdollSlot = 6;
                break;
            }
            case 128: {
                pdollSlot = 7;
                break;
            }
            case 256: {
                pdollSlot = 8;
                break;
            }
            case 512: {
                pdollSlot = 9;
                break;
            }
            case 1024: 
            case 32768: {
                pdollSlot = 10;
                break;
            }
            case 2048: {
                pdollSlot = 11;
                break;
            }
            case 8192: {
                pdollSlot = 13;
                break;
            }
            case 4096: {
                pdollSlot = 12;
                break;
            }
            case 1: {
                pdollSlot = 0;
                break;
            }
            case 16384: {
                this.setPaperdollItem(8, null);
                this.setPaperdollItem(7, null);
                pdollSlot = 14;
            }
        }
        if (pdollSlot >= 0) {
            this.setPaperdollItem(pdollSlot, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance[] equipItemAndRecord(L2ItemInstance item) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.equipItem(item, true);
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    public void equipItem(L2ItemInstance item) {
        this.equipItem(item, true);
    }

    public synchronized void equipItem(L2ItemInstance item, boolean dbUpdate) {
        int targetSlot = item.getItem().getBodyPart();
        switch (targetSlot) {
            case 16384: {
                if (this.setPaperdollItem(8, null) != null) {
                    this.setPaperdollItem(7, null);
                    this.setPaperdollItem(8, null);
                } else {
                    this.setPaperdollItem(7, null);
                }
                this.setPaperdollItem(7, item);
                this.setPaperdollItem(14, item);
                break;
            }
            case 256: {
                L2ItemInstance old1;
                if (!(item.getItem() instanceof L2EtcItem && item.getItem().getItemType() == L2EtcItemType.ARROW || (old1 = this.setPaperdollItem(14, null)) == null)) {
                    this.setPaperdollItem(7, null);
                }
                this.setPaperdollItem(8, null);
                this.setPaperdollItem(8, item);
                break;
            }
            case 128: {
                if (this._paperdoll[14] != null) {
                    this.setPaperdollItem(14, null);
                    this.setPaperdollItem(8, null);
                    this.setPaperdollItem(7, null);
                } else {
                    this.setPaperdollItem(7, null);
                }
                this.setPaperdollItem(7, item);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                if (this._paperdoll[1] == null) {
                    this.setPaperdollItem(1, item);
                    break;
                }
                if (this._paperdoll[2] == null) {
                    this.setPaperdollItem(2, item);
                    break;
                }
                this.setPaperdollItem(1, null);
                this.setPaperdollItem(1, item);
                break;
            }
            case 16: 
            case 32: 
            case 48: {
                if (this._paperdoll[4] == null) {
                    this.setPaperdollItem(4, item);
                    break;
                }
                if (this._paperdoll[5] == null) {
                    this.setPaperdollItem(5, item);
                    break;
                }
                this.setPaperdollItem(4, null);
                this.setPaperdollItem(4, item);
                break;
            }
            case 8: {
                this.setPaperdollItem(3, item);
                break;
            }
            case 32768: {
                this.setPaperdollItem(10, null);
                this.setPaperdollItem(11, null);
                this.setPaperdollItem(10, item);
                break;
            }
            case 1024: {
                this.setPaperdollItem(10, item);
                break;
            }
            case 2048: {
                L2ItemInstance chest = this.getPaperdollItem(10);
                if (chest != null && chest.getItem().getBodyPart() == 32768) {
                    this.setPaperdollItem(10, null);
                }
                this.setPaperdollItem(11, null);
                this.setPaperdollItem(11, item);
                break;
            }
            case 4096: {
                this.setPaperdollItem(12, item);
                break;
            }
            case 512: {
                this.setPaperdollItem(9, item);
                break;
            }
            case 64: {
                this.setPaperdollItem(6, item);
                break;
            }
            case 65536: {
                this.setPaperdollItem(15, item);
                break;
            }
            case 1: {
                this.setPaperdollItem(0, item);
                break;
            }
            case 8192: {
                this.setPaperdollItem(13, item);
                break;
            }
            default: {
                _log.warning("unknown body slot:" + targetSlot);
            }
        }
    }

    public L2ItemInstance getItemByItemId(int itemId) {
        for (L2ItemInstance temp : this._items) {
            if (temp.getItemId() != itemId) continue;
            return temp;
        }
        return null;
    }

    public L2ItemInstance getItemByObjectId(int objectId) {
        for (L2ItemInstance temp : this._items) {
            if (temp.getObjectId() != objectId) continue;
            return temp;
        }
        return null;
    }

    public L2ItemInstance destroyItem(int objectId, int count) {
        L2ItemInstance item = this.getItemByObjectId(objectId);
        if (item == null) {
            return null;
        }
        if (item.getCount() <= count) {
            this.removeItemFromInventory(item, true);
        } else {
            item.setCount(item.getCount() - count);
            item.setLastChange(2);
            item.updateDatabase();
        }
        this.refreshWeight();
        return item;
    }

    public L2ItemInstance destroyItemByItemId(int itemId, int count) {
        L2ItemInstance item = this.findItemByItemId(itemId);
        if (item == null) {
            return null;
        }
        if (item.getCount() < count) {
            count = item.getCount();
        }
        if (item.getCount() == count) {
            this.removeItemFromInventory(item, true);
        } else {
            item.setCount(item.getCount() - count);
            item.setLastChange(2);
            item.updateDatabase();
        }
        this.refreshWeight();
        return item;
    }

    private void removeItemFromInventory(L2ItemInstance item, boolean clearCount) {
        this.unequipIfEquipped(item);
        this._items.remove(item);
        if (clearCount) {
            item.setCount(0);
        }
        item.setOwnerId(0);
        item.setLocation(L2ItemInstance.ItemLocation.VOID);
        item.setLastChange(3);
        item.updateDatabase();
        if (this.getOwner() instanceof L2PcInstance) {
            ((L2PcInstance)this.getOwner()).removeItemFromShortCut(item.getObjectId());
        }
    }

    private void unequipIfEquipped(L2ItemInstance itemToUnequip) {
        if (itemToUnequip == null) {
            return;
        }
        for (int slot = 0; slot < this._paperdoll.length; ++slot) {
            L2ItemInstance itemSlot = this._paperdoll[slot];
            if (itemSlot == null || !itemSlot.equals(itemToUnequip)) continue;
            this.unEquipItemInSlot(slot);
        }
    }

    public L2ItemInstance dropItem(int objectId, int count) {
        L2ItemInstance oldItem = this.getItemByObjectId(objectId);
        return this.dropItem(oldItem, count);
    }

    public L2ItemInstance dropItem(L2ItemInstance oldItem, int count) {
        if (oldItem == null) {
            _log.warning("DropItem: item id does not exist in inventory");
            return null;
        }
        if (Config.ASSERT) assert (oldItem.getOwnerId() == this.getOwnerId());
        if (oldItem.isEquipped()) {
            this.setPaperdollItem(oldItem.getEquipSlot(), null);
        }
        if (oldItem.getCount() <= count || oldItem.getCount() < 1) {
            if (Config.DEBUG) {
                _log.fine(" count = count  --> remove");
            }
            this.removeItemFromInventory(oldItem, false);
            this.refreshWeight();
            return oldItem;
        }
        if (Config.DEBUG) {
            _log.fine(" count != count  --> reduce");
        }
        oldItem.setCount(oldItem.getCount() - count);
        oldItem.setLastChange(2);
        L2ItemInstance newItem = ItemTable.getInstance().createItem(oldItem.getItemId());
        newItem.setCount(count);
        oldItem.updateDatabase();
        this.refreshWeight();
        return newItem;
    }

    private void refreshWeight() {
        int weight = 0;
        for (L2ItemInstance element : this._items) {
            weight += element.getItem().getWeight() * element.getCount();
        }
        this._totalWeight = weight;
        if (this.getOwner() instanceof L2PcInstance) {
            ((L2PcInstance)this.getOwner()).refreshOverloaded();
        }
    }

    public int getTotalWeight() {
        return this._totalWeight;
    }

    public L2ItemInstance findArrowForBow(L2Item bow) {
        int arrowsId = 0;
        switch (bow.getCrystalType()) {
            default: {
                arrowsId = 17;
                break;
            }
            case 1: {
                arrowsId = 1341;
                break;
            }
            case 2: {
                arrowsId = 1342;
                break;
            }
            case 3: {
                arrowsId = 1343;
                break;
            }
            case 4: {
                arrowsId = 1344;
                break;
            }
            case 5: {
                arrowsId = 1345;
            }
        }
        return this.findItemByItemId(arrowsId);
    }

    public void deleteMe() {
        ArrayList<L2ItemInstance> items = new ArrayList<L2ItemInstance>(this._items);
        this._items.clear();
        try {
            this.updateDatabase(items);
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "deletedMe()", t);
        }
        L2World world = L2World.getInstance();
        for (L2ItemInstance inst : items) {
            try {
                world.removeObject(inst);
            }
            catch (Throwable t) {
                _log.log(Level.SEVERE, "deletedMe()", t);
            }
        }
    }

    public void updateDatabase() {
        this.updateDatabase(this._items);
    }

    private void updateDatabase(ArrayList<L2ItemInstance> items) {
        if (this.getOwner() != null) {
            for (L2ItemInstance inst : items) {
                inst.updateDatabase();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id FROM items WHERE owner_id=? AND (loc=? OR loc=?) ORDER BY object_id DESC");
            statement.setInt(1, this.getOwner().getObjectId());
            statement.setString(2, this.getBaseLocation().name());
            statement.setString(3, this.getEquipLocation().name());
            ResultSet inv = statement.executeQuery();
            while (inv.next()) {
                int objectId = inv.getInt(1);
                L2ItemInstance item = L2ItemInstance.restoreFromDb(objectId);
                if (item == null) continue;
                L2ItemInstance newItem = this.addItem(item, false);
                if (item.isEquipped()) {
                    this.equipItem(item, false);
                }
                if (newItem == item) {
                    L2World.getInstance().storeObject(item);
                    continue;
                }
                item.updateDatabase();
                newItem.updateDatabase();
            }
            inv.close();
            statement.close();
            this.refreshWeight();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not restore inventory:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    final class StatsListener
    implements PaperdollListener {
        StatsListener() {
        }

        public void notifyUnequiped(int slot, L2ItemInstance item) {
            if (slot == 14) {
                return;
            }
            Inventory.this.getOwner().removeStatsOwner(item);
        }

        public void notifyEquiped(int slot, L2ItemInstance item) {
            if (slot == 14) {
                return;
            }
            Inventory.this.getOwner().addStatFuncs(item.getStatFuncs(Inventory.this.getOwner()));
        }
    }

    final class BowListener
    implements PaperdollListener {
        BowListener() {
        }

        public void notifyUnequiped(int slot, L2ItemInstance item) {
            L2ItemInstance arrow;
            if (slot != 14) {
                return;
            }
            if (Config.ASSERT) assert (null == Inventory.this.getPaperdollItem(14));
            if (item.getItemType() == L2WeaponType.BOW && (arrow = Inventory.this.getPaperdollItem(8)) != null) {
                Inventory.this.setPaperdollItem(8, null);
            }
        }

        public void notifyEquiped(int slot, L2ItemInstance item) {
            L2ItemInstance arrow;
            if (slot != 14) {
                return;
            }
            if (Config.ASSERT) assert (item == Inventory.this.getPaperdollItem(14));
            if (item.getItemType() == L2WeaponType.BOW && (arrow = Inventory.this.findArrowForBow(item.getItem())) != null) {
                Inventory.this.setPaperdollItem(8, arrow);
            }
        }
    }

    public static final class ChangeRecorder
    implements PaperdollListener {
        private final Inventory _inventory;
        private final ArrayList<L2ItemInstance> _changed;

        ChangeRecorder(Inventory inventory) {
            this._inventory = inventory;
            this._changed = new ArrayList();
            this._inventory.addPaperdollListener(this);
        }

        public void notifyEquiped(int slot, L2ItemInstance item) {
            if (!this._changed.contains(item)) {
                this._changed.add(item);
            }
        }

        public void notifyUnequiped(int slot, L2ItemInstance item) {
            if (!this._changed.contains(item)) {
                this._changed.add(item);
            }
        }

        public L2ItemInstance[] getChangedItems() {
            return this._changed.toArray(new L2ItemInstance[this._changed.size()]);
        }
    }

    public static interface PaperdollListener {
        public void notifyEquiped(int var1, L2ItemInstance var2);

        public void notifyUnequiped(int var1, L2ItemInstance var2);
    }
}

