/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.handler.SkillHandler;
import net.sf.l2j.gameserver.model.L2ArtefactInstance;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2CastleGuardInstance;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2Summon;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.Attack;
import net.sf.l2j.gameserver.serverpackets.ChangeMoveType;
import net.sf.l2j.gameserver.serverpackets.MagicEffectIcons;
import net.sf.l2j.gameserver.serverpackets.MagicSkillCanceld;
import net.sf.l2j.gameserver.serverpackets.MagicSkillLaunched;
import net.sf.l2j.gameserver.serverpackets.MagicSkillUser;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.SetupGauge;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.serverpackets.TeleportToLocation;
import net.sf.l2j.gameserver.skills.Calculator;
import net.sf.l2j.gameserver.skills.Env;
import net.sf.l2j.gameserver.skills.Formulas;
import net.sf.l2j.gameserver.skills.Func;
import net.sf.l2j.gameserver.skills.Stats;
import net.sf.l2j.gameserver.templates.L2CharTemplate;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;
import net.sf.l2j.gameserver.templates.L2Weapon;
import net.sf.l2j.gameserver.templates.L2WeaponType;
import net.sf.l2j.util.L2ObjectHashSet;
import net.sf.l2j.util.L2ObjectSet;
import net.sf.l2j.util.WorldObjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class L2Character
extends L2Object {
    protected static final Logger _log = Logger.getLogger(L2Character.class.getName());
    public static final int ABNORMAL_EFFECT_BLEEDING = 1;
    public static final int ABNORMAL_EFFECT_POISON = 2;
    public static final int ABNORMAL_EFFECT_UNKNOWN_3 = 4;
    public static final int ABNORMAL_EFFECT_UNKNOWN_4 = 8;
    public static final int ABNORMAL_EFFECT_UNKNOWN_5 = 16;
    public static final int ABNORMAL_EFFECT_UNKNOWN_6 = 32;
    public static final int ABNORMAL_EFFECT_STUN = 64;
    public static final int ABNORMAL_EFFECT_SLEEP = 128;
    public static final int ABNORMAL_EFFECT_MUTED = 256;
    public static final int ABNORMAL_EFFECT_ROOT = 512;
    public static final int ABNORMAL_EFFECT_HOLD_1 = 1024;
    public static final int ABNORMAL_EFFECT_HOLD_2 = 2048;
    public static final int ABNORMAL_EFFECT_UNKNOWN_13 = 4096;
    public static final int ABNORMAL_EFFECT_BIG_HEAD = 8192;
    public static final int ABNORMAL_EFFECT_FLAME = 16384;
    public static final int ABNORMAL_EFFECT_CONFUSED = 32;
    public static final int ABNORMAL_EFFECT_AFFRAID = 16;
    protected L2CharTemplate _template;
    protected List<Integer> _disabledSkills;
    private boolean _allSkillsDisabled;
    protected final HashMap<Integer, L2Skill> _skills;
    private CopyOnWriteArraySet<L2Character> _statusListener;
    private Future _regTask;
    private int _flagsRegenActive;
    private static final int HP_REGEN_FLAG = 1;
    private static final int MP_REGEN_FLAG = 2;
    private static final int CP_REGEN_FLAG = 4;
    private static final Random _rnd = new Random();
    private String _name;
    protected String _title;
    private double _currentHp;
    private double _currentMp;
    private double _currentCp;
    private boolean _running;
    private boolean _flying = false;
    private boolean _ridding = false;
    private MoveData _move;
    private L2Character _attackingChar;
    private L2Skill _attackingCharSkill;
    private int _heading;
    private static final L2Effect[] EMPTY_EFFECTS = new L2Effect[0];
    private ConcurrentHashMap<Integer, L2Effect> _effects;
    protected HashMap<String, LinkedList<Integer>> _stackedEffects;
    private L2Object _target;
    private int _castEndTime;
    private int _castInterruptTime;
    private boolean _killedAlready;
    private boolean _inCombat;
    private int _attackEndTime;
    private int _attacking;
    private int _disableBowAttackEndTime;
    private boolean _paralyzed;
    private boolean _stuned;
    private boolean _rooted;
    private boolean _sleeping;
    private boolean _fake_death;
    private boolean _muted;
    private boolean _confused;
    private boolean _affraid;
    private boolean _overloaded;
    private short _abnormalEffects;
    private boolean _imobilised;
    private static final Calculator[] NPC_STD_CALCULATOR = Formulas.getInstance().getStdNPCCalculators();
    private Calculator[] _calculators;
    private L2ObjectSet<L2Object> _knownObjects;
    private L2ObjectSet<L2PcInstance> _knownPlayer;
    protected L2CharacterAI _ai;
    private Future _PvPRegTask;
    private Object _PvPLock = new Object();
    private boolean _PvPRegActive;
    private long _lastPvpAttack;

    public L2Character(int objectId, L2CharTemplate template) {
        super(objectId);
        this._template = template;
        this._overloaded = false;
        switch (Config.SET_TYPE) {
            case WorldObjectSet: {
                this._knownObjects = new WorldObjectSet<L2Object>();
                this._knownPlayer = new WorldObjectSet<L2PcInstance>();
            }
        }
        this._knownObjects = new L2ObjectHashSet<L2Object>();
        this._knownPlayer = new L2ObjectHashSet<L2PcInstance>();
        if (template != null && this instanceof L2NpcInstance) {
            this._skills = ((L2NpcTemplate)template).getSkills();
            this._calculators = NPC_STD_CALCULATOR;
        } else {
            this._skills = new HashMap();
            this._calculators = new Calculator[Stats.NUM_STATS];
            Formulas.getInstance().addFuncsToNewCharacter(this);
        }
    }

    public L2CharTemplate getTemplate() {
        return this._template;
    }

    protected final void setTemplate(L2CharTemplate template) {
        if (Config.ASSERT) assert (this instanceof L2Character);
        this._template = template;
    }

    public void setAttackingChar(L2Character player) {
        if (player != this) {
            this._attackingChar = player;
        }
    }

    public void setAttackingCharSkill(L2Skill skill) {
        this._attackingCharSkill = skill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CharacterAI getAI() {
        if (this._ai == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._ai == null) {
                    this._ai = new L2CharacterAI(new AIAccessor());
                }
            }
        }
        return this._ai;
    }

    public boolean hasAI() {
        return this._ai != null;
    }

    public void onDecay() {
        this.decayMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(L2Character object) {
        CopyOnWriteArraySet<L2Character> listeners;
        if (object == this) {
            return;
        }
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (this._statusListener == null) {
                this._statusListener = new CopyOnWriteArraySet();
            }
            listeners = this._statusListener;
        }
        listeners.add(object);
    }

    private CopyOnWriteArraySet<L2Character> getStatusListener() {
        return this._statusListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(L2Character object) {
        CopyOnWriteArraySet<L2Character> listeners;
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (this._statusListener == null) {
                return;
            }
            listeners = this._statusListener;
        }
        listeners.remove(object);
        if (listeners.isEmpty()) {
            l2Character = this;
            synchronized (l2Character) {
                if (this._statusListener != null && this._statusListener.isEmpty()) {
                    this._statusListener = null;
                }
            }
        }
    }

    public final synchronized void addStatFunc(Func f) {
        int stat;
        if (f == null) {
            return;
        }
        if (this._calculators == NPC_STD_CALCULATOR) {
            this._calculators = new Calculator[Stats.NUM_STATS];
            for (int i = 0; i < Stats.NUM_STATS; ++i) {
                if (NPC_STD_CALCULATOR[i] == null) continue;
                this._calculators[i] = new Calculator(NPC_STD_CALCULATOR[i]);
            }
        }
        if (this._calculators[stat = f._stat.ordinal()] == null) {
            this._calculators[stat] = new Calculator();
        }
        this._calculators[stat].addFunc(f);
    }

    public final synchronized void addStatFuncs(Func[] funcs) {
        for (Func f : funcs) {
            this.addStatFunc(f);
        }
    }

    public final synchronized void removeStatFunc(Func f) {
        if (f == null) {
            return;
        }
        int stat = f._stat.ordinal();
        if (this._calculators[stat] == null) {
            return;
        }
        this._calculators[stat].removeFunc(f);
        if (this._calculators[stat].size() == 0) {
            this._calculators[stat] = null;
        }
        if (this instanceof L2NpcInstance) {
            int i;
            for (i = 0; i < Stats.NUM_STATS && Calculator.equalsCals(this._calculators[i], NPC_STD_CALCULATOR[i]); ++i) {
            }
            if (i >= Stats.NUM_STATS) {
                this._calculators = NPC_STD_CALCULATOR;
            }
        }
    }

    public final synchronized void removeStatFuncs(Func[] funcs) {
        for (Func f : funcs) {
            this.removeStatFunc(f);
        }
    }

    public final synchronized void removeStatsOwner(Object owner) {
        int i;
        for (i = 0; i < this._calculators.length; ++i) {
            if (this._calculators[i] == null) continue;
            this._calculators[i].removeOwner(owner);
            if (this._calculators[i].size() != 0) continue;
            this._calculators[i] = null;
        }
        if (this instanceof L2NpcInstance) {
            for (i = 0; i < Stats.NUM_STATS && Calculator.equalsCals(this._calculators[i], NPC_STD_CALCULATOR[i]); ++i) {
            }
            if (i >= Stats.NUM_STATS) {
                this._calculators = NPC_STD_CALCULATOR;
            }
        }
    }

    public final double calcStat(Stats stat, double init, L2Character target, L2Skill skill) {
        int id = stat.ordinal();
        Calculator c = this._calculators[id];
        if (c == null || c.size() == 0) {
            return init;
        }
        Env env = new Env();
        env._player = this;
        env._target = target;
        env._skill = skill;
        env.value = init;
        c.calc(env);
        return env.value;
    }

    public short getAbnormalEffect() {
        short ae = this._abnormalEffects;
        if (this._stuned) {
            ae = (short)(ae | 0x40);
        }
        if (this._rooted) {
            ae = (short)(ae | 0x200);
        }
        if (this._sleeping) {
            ae = (short)(ae | 0x80);
        }
        if (this._confused) {
            ae = (short)(ae | 0x20);
        }
        if (this._muted) {
            ae = (short)(ae | 0x100);
        }
        if (this._affraid) {
            ae = (short)(ae | 0x10);
        }
        return ae;
    }

    public abstract void updateAbnormalEffect();

    public final boolean isAllSkillsDisabled() {
        return this._allSkillsDisabled || this._stuned || this._sleeping || this._paralyzed;
    }

    public final boolean isMovementDisabled() {
        return this._stuned || this._rooted || this._sleeping || this._overloaded || this._paralyzed || this._imobilised;
    }

    public final boolean isAttackingDisabled() {
        return this._stuned || this._sleeping || this._attackEndTime > GameTimeController.getGameTicks();
    }

    public final boolean isConfused() {
        return this._confused;
    }

    public final boolean isAffraid() {
        return this._affraid;
    }

    public boolean isOutOfControl() {
        return this._confused || this._affraid;
    }

    public final boolean isMuted() {
        return this._muted;
    }

    public final boolean getImobilised() {
        return this._imobilised;
    }

    public final void setImobilised(boolean imobilised) {
        this._imobilised = imobilised;
    }

    public void setOverloaded(boolean overloaded) {
        this._overloaded = overloaded;
    }

    public final void setParalyzed(boolean paralyzed) {
        this._paralyzed = paralyzed;
    }

    public final void startStunning() {
        if (this._attackingChar == null) {
            return;
        }
        boolean success = Formulas.getInstance().calcSkillSuccess(this._attackingChar, this, this._attackingCharSkill);
        if (success) {
            this._stuned = true;
            this.getAI().notifyEvent(CtrlEvent.EVT_STUNNED, null);
            this.updateAbnormalEffect();
            if (this._attackingChar instanceof L2PcInstance) {
                ((L2PcInstance)this._attackingChar).checkPvP(this);
            }
        } else if (this._attackingChar instanceof L2PcInstance) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString(this._attackingCharSkill.getName() + " failed.");
            this._attackingChar.sendPacket(sm);
        }
    }

    public final void startSleeping() {
        this._sleeping = true;
        this.getAI().notifyEvent(CtrlEvent.EVT_SLEEPING, null);
        this.updateAbnormalEffect();
    }

    public final void startRooted() {
        this._rooted = true;
        this.getAI().notifyEvent(CtrlEvent.EVT_ROOTED, null);
        this.updateAbnormalEffect();
    }

    public final void startFakeDeath() {
        this._fake_death = true;
        this.getAI().notifyEvent(CtrlEvent.EVT_DEAD, null);
    }

    public final void startConfused() {
        this._confused = true;
        this.getAI().notifyEvent(CtrlEvent.EVT_CONFUSED);
        this.updateAbnormalEffect();
    }

    public final void startMuted() {
        this._muted = true;
        this.getAI().notifyEvent(CtrlEvent.EVT_MUTED);
        this.updateAbnormalEffect();
    }

    public final void startFear() {
        this._affraid = true;
        this.getAI().notifyEvent(CtrlEvent.EVT_AFFRAID);
        this.updateAbnormalEffect();
    }

    public final void startAbnormalEffect(short mask) {
        this._abnormalEffects = (short)(this._abnormalEffects | mask);
        this.updateAbnormalEffect();
    }

    public final void stopStunning(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2Effect.EffectType.STUN);
        } else {
            this.removeEffect(effect);
        }
        this._stuned = false;
        this.getAI().notifyEvent(CtrlEvent.EVT_THINK, null);
        this.updateAbnormalEffect();
    }

    public final void stopSleeping(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2Effect.EffectType.SLEEP);
        } else {
            this.removeEffect(effect);
        }
        this._sleeping = false;
        this.getAI().notifyEvent(CtrlEvent.EVT_THINK, null);
        this.updateAbnormalEffect();
    }

    public final void stopRooting(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2Effect.EffectType.ROOT);
        } else {
            this.removeEffect(effect);
        }
        this._rooted = false;
        this.getAI().notifyEvent(CtrlEvent.EVT_THINK, null);
        this.updateAbnormalEffect();
    }

    public final void stopFakeDeath(L2Effect effect) {
        this._fake_death = false;
        if (effect == null) {
            this.stopEffects(L2Effect.EffectType.FAKE_DEATH);
        } else {
            this.removeEffect(effect);
        }
        this.getAI().notifyEvent(CtrlEvent.EVT_THINK, null);
    }

    public final void stopConfused(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2Effect.EffectType.CONFUSION);
        } else {
            this.removeEffect(effect);
        }
        this._confused = false;
        this.getAI().notifyEvent(CtrlEvent.EVT_THINK, null);
        this.updateAbnormalEffect();
    }

    public final void stopMuted(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2Effect.EffectType.MUTE);
        } else {
            this.removeEffect(effect);
        }
        this._muted = false;
        this.updateAbnormalEffect();
    }

    public final void stopFear(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2Effect.EffectType.FEAR);
        } else {
            this.removeEffect(effect);
        }
        this._affraid = false;
        this.updateAbnormalEffect();
    }

    public final void stopAbnormalEffect(short mask) {
        this._abnormalEffects = (short)(this._abnormalEffects & ~mask);
        this.updateAbnormalEffect();
    }

    public final int getHeading() {
        return this._heading;
    }

    public final void setHeading(int heading) {
        this._heading = heading;
    }

    public final int getXdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._xDestination;
        }
        return this.getX();
    }

    public final int getYdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._yDestination;
        }
        return this.getY();
    }

    public final int getZdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._zDestination;
        }
        return this.getZ();
    }

    public final boolean isInCombat() {
        return this._inCombat;
    }

    public final boolean isMoving() {
        return this._move != null;
    }

    public final boolean isCastingNow() {
        return this._castEndTime > GameTimeController.getGameTicks();
    }

    public final boolean canAbortCast() {
        return this._castInterruptTime > GameTimeController.getGameTicks();
    }

    public final boolean isAttackingNow() {
        return this._attackEndTime > GameTimeController.getGameTicks();
    }

    public final boolean isAttackAborted() {
        return this._attacking <= 0;
    }

    public final void abortAttack() {
        if (this.isAttackingNow()) {
            this._attacking = 0;
            this.sendPacket(new ActionFailed());
        }
    }

    public final int getAttackingBodyPart() {
        return this._attacking;
    }

    public final void abortCast() {
        if (this.isCastingNow()) {
            this._castEndTime = 0;
            this._castInterruptTime = 0;
            this.broadcastPacket(new MagicSkillCanceld(this.getObjectId()));
            this.sendPacket(new ActionFailed());
        }
    }

    public final boolean updatePosition(int gameTicks) {
        MoveData m = this._move;
        if (m == null) {
            return true;
        }
        if (!this.isVisible()) {
            this._move = null;
            return true;
        }
        if (m._moveTimestamp == gameTicks) {
            return false;
        }
        int elapsed = gameTicks - m._moveStartTime;
        if (elapsed >= m._ticksToMove) {
            m._moveTimestamp = gameTicks;
            super.setXYZ(m._xDestination, m._yDestination, m._zDestination);
            this._move = null;
            return true;
        }
        super.setXYZ(m._xMoveFrom + (int)((float)elapsed * m._xSpeedTicks), m._yMoveFrom + (int)((float)elapsed * m._ySpeedTicks), super.getZ());
        m._moveTimestamp = gameTicks;
        return false;
    }

    protected void stopMove(L2CharPosition pos) {
        this._move = null;
        if (pos != null) {
            this.setXYZ(pos.x, pos.y, pos.z);
            this.setHeading(pos.heading);
        }
        this.updateKnownObjects();
    }

    public final double getCurrentHp() {
        return this._currentHp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCurrentHp(double newHp) {
        int maxHp = this.getMaxHp();
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (newHp >= (double)maxHp) {
                this._currentHp = maxHp;
                this._flagsRegenActive &= 0xFFFFFFFE;
                if (this._flagsRegenActive == 0) {
                    this.stopHpMpRegeneration();
                }
            } else {
                this._currentHp = newHp;
                this._flagsRegenActive |= 1;
                this.startHpMpRegeneration();
            }
        }
        this.broadcastStatusUpdate();
    }

    protected synchronized void stopHpMpRegeneration() {
        if (this._regTask != null) {
            this._regTask.cancel(false);
            this._regTask = null;
            this._flagsRegenActive = 0;
            if (Config.DEBUG) {
                _log.fine("HP/MP/CP regen stop");
            }
        }
    }

    private synchronized void startHpMpRegeneration() {
        if (this._regTask == null && !this.isDead()) {
            if (Config.DEBUG) {
                _log.fine("HP/MP/CP regen started");
            }
            int period = Formulas.getInstance().getRegeneratePeriod(this);
            this._regTask = ClientScheduler.getInstance().scheduleMedAtFixedRate(new RegenTask(), period, period);
        }
    }

    public final double getCurrentMp() {
        return this._currentMp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCurrentMp(double newMp) {
        int maxMp = this.getMaxMp();
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (newMp >= (double)maxMp) {
                this._currentMp = maxMp;
                this._flagsRegenActive &= 0xFFFFFFFD;
                if (this._flagsRegenActive == 0) {
                    this.stopHpMpRegeneration();
                }
            } else {
                this._currentMp = newMp;
                this._flagsRegenActive |= 2;
                this.startHpMpRegeneration();
            }
        }
        this.broadcastStatusUpdate();
    }

    public final double getCurrentCp() {
        return this._currentCp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCurrentCp(double newCp) {
        int maxCp = this.getMaxCp();
        if (newCp < 0.0) {
            newCp = 0.0;
        }
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (newCp >= (double)maxCp) {
                this._currentCp = maxCp;
                this._flagsRegenActive &= 0xFFFFFFFB;
                if (this._flagsRegenActive == 0) {
                    this.stopHpMpRegeneration();
                }
            } else {
                this._currentCp = newCp;
                this._flagsRegenActive |= 4;
                this.startHpMpRegeneration();
            }
        }
        this.broadcastStatusUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCurrentHpMp(double newHp, double newMp) {
        int maxHp = this.getMaxHp();
        int maxMp = this.getMaxMp();
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (newHp >= (double)maxHp) {
                this._killedAlready = false;
                this._currentHp = maxHp;
                this._flagsRegenActive &= 0xFFFFFFFE;
            } else {
                this._currentHp = newHp;
                if (!this.isDead()) {
                    this._killedAlready = false;
                    this._flagsRegenActive |= 1;
                    this.startHpMpRegeneration();
                }
            }
            if (newMp >= (double)maxMp) {
                this._currentMp = maxMp;
                this._flagsRegenActive &= 0xFFFFFFFD;
            } else {
                this._currentMp = newMp;
                if (!this.isDead()) {
                    this._flagsRegenActive |= 2;
                    this.startHpMpRegeneration();
                }
            }
            if (this._flagsRegenActive == 0) {
                this.stopHpMpRegeneration();
            }
        }
        this.broadcastStatusUpdate();
    }

    public void broadcastStatusUpdate() {
        CopyOnWriteArraySet<L2Character> list = this.getStatusListener();
        if (list == null || list.isEmpty()) {
            return;
        }
        StatusUpdate su = new StatusUpdate(this.getObjectId());
        su.addAttribute(StatusUpdate.CUR_HP, (int)this.getCurrentHp());
        su.addAttribute(StatusUpdate.CUR_MP, (int)this.getCurrentMp());
        for (L2Character temp : list) {
            temp.sendPacket(su);
        }
    }

    public int getSTR() {
        return (int)this.calcStat(Stats.STAT_STR, this._template.baseSTR, null, null);
    }

    public int getCON() {
        return (int)this.calcStat(Stats.STAT_CON, this._template.baseCON, null, null);
    }

    public int getDEX() {
        return (int)this.calcStat(Stats.STAT_DEX, this._template.baseDEX, null, null);
    }

    public int getINT() {
        return (int)this.calcStat(Stats.STAT_INT, this._template.baseINT, null, null);
    }

    public int getWIT() {
        return (int)this.calcStat(Stats.STAT_WIT, this._template.baseWIT, null, null);
    }

    public int getMEN() {
        return (int)this.calcStat(Stats.STAT_MEN, this._template.baseMEN, null, null);
    }

    public int getMaxHp() {
        double val = this.calcStat(Stats.MAX_HP, this._template.baseHpMax, null, null);
        return (int)val;
    }

    public int getMaxMp() {
        double val = this.calcStat(Stats.MAX_MP, this._template.baseMpMax, null, null);
        return (int)val;
    }

    public final int getMaxCp() {
        return this.getMaxHp();
    }

    public final int getAccuracy() {
        double val = this.calcStat(Stats.ACCURACY_COMBAT, 0.0, null, null);
        return (int)(val /= (double)this.getWeaponExpertisePenalty());
    }

    public int getMAtk(L2Character target, L2Skill skill) {
        Stats stat;
        double attack = this._template.baseMAtk;
        Stats stats = stat = skill == null ? null : skill.getStat();
        if (stat != null) {
            switch (stat) {
                case AGGRESSION: {
                    attack += (double)this._template.baseAggression;
                    break;
                }
                case BLEED: {
                    attack += (double)this._template.baseBleed;
                    break;
                }
                case POISON: {
                    attack += (double)this._template.basePoison;
                    break;
                }
                case STUN: {
                    attack += (double)this._template.baseStun;
                    break;
                }
                case ROOT: {
                    attack += (double)this._template.baseRoot;
                    break;
                }
                case MOVEMENT: {
                    attack += (double)this._template.baseMovement;
                    break;
                }
                case CONFUSION: {
                    attack += (double)this._template.baseConfusion;
                    break;
                }
                case SLEEP: {
                    attack += (double)this._template.baseSleep;
                    break;
                }
                case FIRE: {
                    attack += (double)this._template.baseFire;
                    break;
                }
                case WIND: {
                    attack += (double)this._template.baseWind;
                    break;
                }
                case WATER: {
                    attack += (double)this._template.baseWater;
                    break;
                }
                case EARTH: {
                    attack += (double)this._template.baseEarth;
                }
            }
        }
        if (skill != null) {
            attack += skill.getPower();
        }
        return (int)this.calcStat(Stats.MAGIC_ATTACK, attack, target, skill);
    }

    public int getMDef(L2Character target, L2Skill skill) {
        Stats stat;
        double defence = this._template.baseMDef;
        Stats stats = stat = skill == null ? null : skill.getStat();
        if (stat != null) {
            switch (stat) {
                case AGGRESSION: {
                    defence += (double)this._template.baseAggressionRes;
                    break;
                }
                case BLEED: {
                    defence += (double)this._template.baseBleedRes;
                    break;
                }
                case POISON: {
                    defence += (double)this._template.basePoisonRes;
                    break;
                }
                case STUN: {
                    defence += (double)this._template.baseStunRes;
                    break;
                }
                case ROOT: {
                    defence += (double)this._template.baseRootRes;
                    break;
                }
                case MOVEMENT: {
                    defence += (double)this._template.baseMovementRes;
                    break;
                }
                case CONFUSION: {
                    defence += (double)this._template.baseConfusionRes;
                    break;
                }
                case SLEEP: {
                    defence += (double)this._template.baseSleepRes;
                    break;
                }
                case FIRE: {
                    defence += (double)this._template.baseFireRes;
                    break;
                }
                case WIND: {
                    defence += (double)this._template.baseWindRes;
                    break;
                }
                case WATER: {
                    defence += (double)this._template.baseWaterRes;
                    break;
                }
                case EARTH: {
                    defence += (double)this._template.baseEarthRes;
                }
            }
        }
        if (skill != null) {
            switch (skill.getElement()) {
                case 4: {
                    defence = this.calcStat(Stats.EARTH_RES, defence, target, skill);
                    break;
                }
                case 2: {
                    defence = this.calcStat(Stats.FIRE_RES, defence, target, skill);
                    break;
                }
                case 3: {
                    defence = this.calcStat(Stats.WATER_RES, defence, target, skill);
                    break;
                }
                case 1: {
                    defence = this.calcStat(Stats.WIND_RES, defence, target, skill);
                }
            }
        }
        return (int)this.calcStat(Stats.MAGIC_DEFENCE, defence, target, skill);
    }

    public final int getMCriticalHit(L2Character target, L2Skill skill) {
        double mrate = this.calcStat(Stats.MCRITICAL_RATE, 40.0, target, skill);
        return (int)mrate;
    }

    public final int getCriticalHit(L2Character target, L2Skill skill) {
        double rate = this.calcStat(Stats.CRITICAL_RATE, this._template.baseCritRate, target, skill);
        return (int)rate;
    }

    public final double getCriticalDmg(L2Character target, double init) {
        double val = this.calcStat(Stats.CRITICAL_DAMAGE, init, target, null);
        return val;
    }

    public final int getAtkCancel() {
        double rate = this.calcStat(Stats.ATTACK_CANCEL, this._template.baseAttackCancel, null, null);
        return (int)rate;
    }

    public final int getEvasionRate(L2Character target) {
        double val = this.calcStat(Stats.EVASION_RATE, 0.0, target, null);
        return (int)(val /= (double)this.getArmourExpertisePenalty());
    }

    public int getPAtk(L2Character target) {
        return (int)this.calcStat(Stats.POWER_ATTACK, this._template.basePAtk, target, null);
    }

    public int getPDef(L2Character target) {
        return (int)this.calcStat(Stats.POWER_DEFENCE, this._template.basePDef, target, null);
    }

    public final int getMAtkSpd() {
        double val = this.calcStat(Stats.MAGIC_ATTACK_SPEED, this._template.baseMAtkSpd, null, null);
        return (int)(val /= (double)this.getArmourExpertisePenalty());
    }

    public final int getPAtkSpd() {
        double val = this.calcStat(Stats.POWER_ATTACK_SPEED, this._template.basePAtkSpd, null, null);
        return (int)(val /= (double)this.getArmourExpertisePenalty());
    }

    public final double getMReuseRate(L2Skill skill) {
        return this.calcStat(Stats.MAGIC_REUSE_RATE, this._template.baseMReuseRate, null, skill);
    }

    public final int getShldDef() {
        return (int)this.calcStat(Stats.SHIELD_DEFENCE, 0.0, null, null);
    }

    public final int getRunSpeed() {
        int val = (int)this.calcStat(Stats.RUN_SPEED, this._template.baseRunSpd, null, null);
        if (this.isFlying()) {
            return val += Config.WYVERN_SPEED;
        }
        if (this.isRidding()) {
            return val += Config.STRIDER_SPEED;
        }
        val = (int)((float)val / this.getArmourExpertisePenalty());
        return val;
    }

    public float getMovementSpeedMultiplier() {
        return (float)this.getRunSpeed() * 1.0f / (float)this._template.baseRunSpd;
    }

    public final int getWalkSpeed() {
        return this.getRunSpeed() * 70 / 100;
    }

    public final float getMoveSpeed() {
        if (this.isRunning()) {
            return this.getRunSpeed();
        }
        return this.getWalkSpeed();
    }

    public final int getPhysicalAttackRange() {
        return (int)this.calcStat(Stats.POWER_ATTACK_RANGE, this.getTemplate().baseAtkRange, null, null);
    }

    public final int getMagicalAttackRange(L2Skill skill) {
        if (skill != null) {
            return (int)this.calcStat(Stats.MAGIC_ATTACK_RANGE, skill.getCastRange(), null, skill);
        }
        return this.getTemplate().baseAtkRange;
    }

    public final float getAttackSpeedMultiplier() {
        return (float)(1.1 * (double)this.getPAtkSpd() / (double)this.getTemplate().basePAtkSpd);
    }

    public abstract int getLevel();

    public final String getName() {
        return this._name;
    }

    public final void setName(String name) {
        this._name = name;
    }

    public void setTarget(L2Object object) {
        if (object != null && !object.isVisible()) {
            object = null;
        }
        if (object != null && object != this._target) {
            this.addKnownObject(object, null);
            object.addKnownObject(this, null);
        }
        if (object == null) {
            SystemMessage sm;
            if (this.isAttackingNow()) {
                this.abortAttack();
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                if (this instanceof L2PcInstance) {
                    this.sendPacket(new ActionFailed());
                    sm = new SystemMessage(614);
                    sm.addString("Attack is aborted");
                    this.sendPacket(sm);
                }
            }
            if (this.isCastingNow() && this.canAbortCast()) {
                this.abortCast();
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                if (this instanceof L2PcInstance) {
                    this.sendPacket(new ActionFailed());
                    sm = new SystemMessage(614);
                    sm.addString("Casting is aborted");
                    this.sendPacket(sm);
                }
            }
        }
        this._target = object;
    }

    public final int getTargetId() {
        if (this._target != null) {
            return this._target.getObjectId();
        }
        return -1;
    }

    public final L2Object getTarget() {
        return this._target;
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setTitle(String title) {
        this._title = title;
    }

    public final boolean isRunning() {
        return this._running;
    }

    public final boolean isFlying() {
        return this._flying;
    }

    public final boolean isRidding() {
        return this._ridding;
    }

    public final void setRunning() {
        if (!this._running) {
            this._running = true;
            this.broadcastPacket(new ChangeMoveType(this));
        }
    }

    public final void setFlying(boolean mode) {
        this._flying = mode;
    }

    public final void setRidding(boolean mode) {
        this._ridding = mode;
    }

    public final void setWalking() {
        if (this._running) {
            this._running = false;
            this.broadcastPacket(new ChangeMoveType(this));
        }
    }

    public void reduceCurrentMp(double i) {
        i = this.getCurrentMp() - i;
        if (i < 0.0) {
            i = 0.0;
        }
        this.setCurrentMp(i);
    }

    public void reduceCurrentHp(double i, L2Character attacker) {
        this.reduceCurrentHp(i, attacker, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduceCurrentHp(double i, L2Character attacker, boolean awake) {
        if (this.isDead()) {
            return;
        }
        if (awake && this._sleeping) {
            this.stopSleeping(null);
        }
        if (this._stuned && _rnd.nextInt(10) == 0) {
            this.stopStunning(null);
        }
        if ((i = this.getCurrentHp() - i) < 0.0) {
            i = 0.0;
        }
        this.setCurrentHp(i);
        if (this.isDead()) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._killedAlready) {
                    return;
                }
                this._killedAlready = true;
            }
            if (Config.DEBUG) {
                _log.fine("char is dead.");
            }
            this.stopMove(null);
            this.doDie(attacker);
            this._currentHp = 0.0;
        }
    }

    protected void doDie(L2Character killer) {
        this.setTarget(null);
        this.stopMove(null);
        this.stopHpMpRegeneration();
        this.stopAllEffects();
        this.broadcastStatusUpdate();
        this.getAI().notifyEvent(CtrlEvent.EVT_DEAD, null);
    }

    protected void moveToLocation(int x, int y, int z, int offset) {
        double cos;
        double sin;
        int curX = super.getX();
        int curY = super.getY();
        int curZ = super.getZ();
        int dx = x - curX;
        int dy = y - curY;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (Config.DEBUG) {
            _log.fine("distance to target:" + distance);
        }
        if (offset > 0 || distance < 1.0) {
            if (distance < 1.0 || distance - (double)offset <= 0.0) {
                double sin2 = 0.0;
                double cos2 = 1.0;
                distance = 0.0;
                x = curX;
                y = curY;
                if (Config.DEBUG) {
                    _log.fine("already in range, no movement needed.");
                }
                this.getAI().notifyEvent(CtrlEvent.EVT_ARRIVED, null);
                return;
            }
            sin = (double)dy / distance;
            cos = (double)dx / distance;
            x = curX + (int)((distance -= (double)(offset - 5)) * cos);
            y = curY + (int)(distance * sin);
        } else {
            sin = (double)dy / distance;
            cos = (double)dx / distance;
        }
        float speed = this.getMoveSpeed();
        MoveData m = new MoveData();
        m._ticksToMove = (int)(10.0 * distance / (double)speed);
        m._xSpeedTicks = (float)(cos * (double)speed / 10.0);
        m._ySpeedTicks = (float)(sin * (double)speed / 10.0);
        int heading = (int)(Math.atan2(-sin, -cos) * 10430.378350470453);
        this.setHeading(heading += 32768);
        if (Config.DEBUG) {
            _log.fine("dist:" + distance + "speed:" + speed + " ttt:" + m._ticksToMove + " dx:" + (int)m._xSpeedTicks + " dy:" + (int)m._ySpeedTicks + " heading:" + heading);
        }
        m._xDestination = x;
        m._yDestination = y;
        m._zDestination = z;
        m._moveStartTime = GameTimeController.getGameTicks();
        m._xMoveFrom = curX;
        m._yMoveFrom = curY;
        m._zMoveFrom = curZ;
        if (m._ticksToMove < 1) {
            m._ticksToMove = 1;
        }
        if (Config.DEBUG) {
            _log.fine("time to target:" + m._ticksToMove);
        }
        this._move = m;
        GameTimeController.getInstance().registerMovingObject(this);
        int tm = m._ticksToMove * 100;
        if (tm > 3000) {
            ClientScheduler.getInstance().scheduleMed(new NotifyAITask(CtrlEvent.EVT_ARRIVED_REVALIDATE), 2000L);
        }
    }

    @Override
    public boolean addKnownObject(L2Object object, L2Character dropper) {
        if (object == null || !this.isVisible()) {
            return false;
        }
        if (this.knowsObject(object)) {
            if (!object.isVisible()) {
                this.removeKnownObject(object);
            }
            return false;
        }
        double farAway = this.getDistanceToWatchObject(object);
        if (this.getDistance(object.getX(), object.getY()) >= farAway) {
            return false;
        }
        this._knownObjects.put(object);
        if (object instanceof L2PcInstance) {
            this._knownPlayer.put((L2PcInstance)object);
        }
        return true;
    }

    @Override
    public void removeKnownObject(L2Object object) {
        this._knownObjects.remove(object);
        if (object instanceof L2PcInstance) {
            this._knownPlayer.remove((L2PcInstance)object);
        }
        if (object == this.getTarget()) {
            this.setTarget(null);
        }
    }

    @Override
    public final boolean knowsObject(L2Object object) {
        return this == object || this._knownObjects.contains(object);
    }

    @Override
    public final void removeAllKnownObjects() {
        this._knownObjects.clear();
        this._knownPlayer.clear();
        this.setTarget(null);
        if (this.hasAI()) {
            this._ai = null;
        }
    }

    public final L2ObjectSet<L2PcInstance> getKnownPlayers() {
        return this._knownPlayer;
    }

    public final L2ObjectSet<L2Object> getKnownObjects() {
        return this._knownObjects;
    }

    public final boolean knowsThePlayer(L2PcInstance player) {
        return this == player || this._knownPlayer.contains(player);
    }

    protected abstract int getDistanceToWatchObject(L2Object var1);

    protected abstract int getDistanceToForgetObject(L2Object var1);

    public final synchronized void updateKnownObjects() {
        this.forgetDistantObjects();
        this.findCloseObjects();
    }

    private void forgetDistantObjects() {
        for (L2Object object : this._knownObjects) {
            double farAway;
            double dy;
            if (!object.isVisible()) {
                this.removeKnownObject(object);
                continue;
            }
            double dx = this.getX() - object.getX();
            if (!(dx * dx + (dy = (double)(this.getY() - object.getY())) * dy > (farAway = (double)this.getDistanceToForgetObject(object)) * farAway)) continue;
            this.removeKnownObject(object);
        }
    }

    private void findCloseObjects() {
        L2Object[] objects;
        if (this.isDead() || !this.isVisible()) {
            return;
        }
        for (L2Object object : objects = L2World.getInstance().getVisibleObjects(this)) {
            if (this._knownObjects.contains(object)) {
                if (!(object instanceof L2Character) || object.knowsObject(this)) continue;
                L2Character tgt = (L2Character)object;
                tgt.addKnownObject(this, null);
                continue;
            }
            this.addKnownObject(object, null);
        }
    }

    public final double getDistance(int x, int y) {
        long dx = x - this.getX();
        long dy = y - this.getY();
        double distance = Math.sqrt(dx * dx + dy * dy);
        return distance;
    }

    public final void broadcastPacketToOthers(ServerBasePacket mov) {
        if (Config.DEBUG) {
            _log.fine("players to notify:" + this.getKnownPlayers().size() + " packet:" + mov.getType());
        }
        for (L2PcInstance player : this.getKnownPlayers()) {
            if (player == this) continue;
            player.sendPacket(mov);
        }
    }

    public final void broadcastPacket(ServerBasePacket mov) {
        if (Config.DEBUG) {
            _log.fine("players to notify:" + this.getKnownPlayers().size() + " packet:" + mov.getType());
        }
        this.sendPacket(mov);
        for (L2PcInstance player : this.getKnownPlayers()) {
            if (player == this) continue;
            player.sendPacket(mov);
        }
    }

    public void sendPacket(ServerBasePacket mov) {
    }

    public final boolean isDead() {
        return !this._fake_death && !(this._currentHp > 0.5);
    }

    public final boolean isAlikeDead() {
        return this._fake_death || !(this._currentHp > 0.5);
    }

    public static final Random getRnd() {
        return _rnd;
    }

    public float getWeaponExpertisePenalty() {
        return 1.0f;
    }

    public float getArmourExpertisePenalty() {
        return 1.0f;
    }

    public void setAttackingBodypart() {
        this._attacking = 10;
    }

    protected void doAttack(L2Character target) {
        if (Config.DEBUG) {
            _log.fine("doAttack: target=" + target);
        }
        if (target == null) {
            return;
        }
        if (this.isAttackingDisabled()) {
            return;
        }
        L2ItemInstance weaponInst = this.getActiveWeaponInstance();
        L2Weapon weaponItem = this.getActiveWeaponItem();
        if (weaponItem != null && weaponItem.getItemType() == L2WeaponType.BOW) {
            if (this instanceof L2PcInstance) {
                if (this._disableBowAttackEndTime <= GameTimeController.getGameTicks()) {
                    if (!(this instanceof L2NpcInstance)) {
                        if (this.getCurrentMp() < (double)weaponItem.getMpConsume()) {
                            ClientScheduler.getInstance().scheduleMed(new NotifyAITask(CtrlEvent.EVT_READY_TO_ACT), 1000L);
                            this.sendPacket(new SystemMessage(24));
                            ActionFailed af = new ActionFailed();
                            this.sendPacket(af);
                            return;
                        }
                        this.reduceCurrentMp(weaponItem.getMpConsume());
                    }
                } else {
                    ClientScheduler.getInstance().scheduleMed(new NotifyAITask(CtrlEvent.EVT_READY_TO_ACT), 1000L);
                    ActionFailed af = new ActionFailed();
                    this.sendPacket(af);
                    return;
                }
                this._disableBowAttackEndTime = 50 + GameTimeController.getGameTicks();
                if (!this.checkAndEquipArrows()) {
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    ActionFailed af = new ActionFailed();
                    this.sendPacket(af);
                    this.sendPacket(new SystemMessage(112));
                    return;
                }
            } else if (this instanceof L2NpcInstance && this._disableBowAttackEndTime > GameTimeController.getGameTicks()) {
                return;
            }
        }
        if (this.isAlikeDead() || target == null || target.isAlikeDead() || !this.knowsObject(target)) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            ActionFailed af = new ActionFailed();
            this.sendPacket(af);
            return;
        }
        target.addKnownObject(this, null);
        if (Config.ALT_GAME_TIREDNESS) {
            this.setCurrentCp(this.getCurrentCp() - 10.0);
        }
        boolean wasSSCharged = weaponInst != null && weaponInst.getChargedSoulshot() == 1;
        int sAtk = this.calculateAttackSpeed(target, weaponInst);
        this._attackEndTime = GameTimeController.getGameTicks();
        this._attackEndTime += sAtk / 100;
        --this._attackEndTime;
        Attack attack = new Attack(this, wasSSCharged);
        this.setAttackingBodypart();
        boolean hitted = weaponItem == null ? this.doAttakHitSimple(attack, target) : (weaponItem.getItemType() == L2WeaponType.BOW ? this.doAttakHitByBow(attack, target, sAtk) : (weaponItem.getItemType() == L2WeaponType.POLE ? this.doAttakHitByPole(attack) : (this.isUsingDualWeapon() ? this.doAttakHitByDual(attack, target) : this.doAttakHitSimple(attack, target))));
        if (hitted) {
            if (wasSSCharged) {
                weaponInst.setChargedSoulshot(0);
            }
        } else {
            this.abortAttack();
        }
        if (attack.hasHits()) {
            this.broadcastPacket(attack);
        }
        int reuse = weaponItem == null ? 0 : weaponItem.getAttackReuseDelay();
        ClientScheduler.getInstance().scheduleMed(new NotifyAITask(CtrlEvent.EVT_READY_TO_ACT), sAtk + reuse);
    }

    private boolean doAttakHitSimple(Attack attack, L2Character target) {
        int damage1 = 0;
        boolean shld1 = false;
        boolean crit1 = false;
        boolean miss1 = Formulas.getInstance().calcHitMiss(this, target);
        if (!miss1) {
            shld1 = Formulas.getInstance().calcShldUse(this, target);
            crit1 = Formulas.getInstance().calcCrit(this.getCriticalHit(target, null));
            damage1 = (int)Formulas.getInstance().calcPhysDam(this, target, null, shld1, crit1, false, attack._soulshot);
        }
        ClientScheduler.getInstance().scheduleMed(new HitTask(target, damage1, crit1, miss1, attack._soulshot, shld1), 980L);
        attack.addHit(target, damage1, miss1, crit1, shld1);
        return !miss1;
    }

    private boolean doAttakHitByBow(Attack attack, L2Character target, int sAtk) {
        L2Weapon bow;
        int damage1 = 0;
        boolean shld1 = false;
        boolean crit1 = false;
        boolean miss1 = Formulas.getInstance().calcHitMiss(this, target);
        this.reduceArrowCount();
        if (!miss1) {
            shld1 = Formulas.getInstance().calcShldUse(this, target);
            crit1 = Formulas.getInstance().calcCrit(this.getCriticalHit(target, null));
            damage1 = (int)Formulas.getInstance().calcPhysDam(this, target, null, shld1, crit1, false, attack._soulshot);
        }
        int reuse = (bow = this.getActiveWeaponItem()) == null ? 1500 : bow.getAttackReuseDelay();
        if (this instanceof L2PcInstance) {
            this.sendPacket(new SystemMessage(41));
            SetupGauge sg = new SetupGauge(1, sAtk + reuse);
            this.sendPacket(sg);
        }
        ClientScheduler.getInstance().scheduleMed(new HitTask(target, damage1, crit1, miss1, attack._soulshot, shld1), sAtk);
        this._disableBowAttackEndTime = (sAtk + reuse) / 100 + GameTimeController.getGameTicks();
        attack.addHit(target, damage1, miss1, crit1, shld1);
        return !miss1;
    }

    private boolean doAttakHitByDual(Attack attack, L2Character target) {
        int damage1 = 0;
        int damage2 = 0;
        boolean shld1 = false;
        boolean shld2 = false;
        boolean crit1 = false;
        boolean crit2 = false;
        boolean miss1 = Formulas.getInstance().calcHitMiss(this, target);
        boolean miss2 = Formulas.getInstance().calcHitMiss(this, target);
        if (!miss1) {
            shld1 = Formulas.getInstance().calcShldUse(this, target);
            crit1 = Formulas.getInstance().calcCrit(this.getCriticalHit(target, null));
            damage1 = (int)Formulas.getInstance().calcPhysDam(this, target, null, shld1, crit1, true, attack._soulshot);
        }
        if (!miss2) {
            shld2 = Formulas.getInstance().calcShldUse(this, target);
            crit2 = Formulas.getInstance().calcCrit(this.getCriticalHit(target, null));
            damage2 = (int)Formulas.getInstance().calcPhysDam(this, target, null, shld2, crit2, true, attack._soulshot);
        }
        ClientScheduler.getInstance().scheduleMed(new HitTask(target, damage1, crit1, miss1, attack._soulshot, shld1), 650L);
        ClientScheduler.getInstance().scheduleMed(new HitTask(target, damage2, crit2, miss2, attack._soulshot, shld2), 1250L);
        attack.addHit(target, damage1, miss1, crit1, shld1);
        attack.addHit(target, damage2, miss2, crit2, shld2);
        return !miss1 || !miss2;
    }

    private boolean doAttakHitByPole(Attack attack) {
        L2Character target;
        int i;
        boolean hitted = false;
        L2Object[] possibleTargets = L2World.getInstance().getVisibleObjects3D(this, 80);
        for (i = 0; i < possibleTargets.length; ++i) {
            if (!(possibleTargets[i] instanceof L2Character) || (target = (L2Character)possibleTargets[i]).isAlikeDead() || target != this.getAI().getAttackTarget()) continue;
            hitted |= this.doAttakHitSimple(attack, target);
        }
        for (i = 0; i < possibleTargets.length; ++i) {
            if (!(possibleTargets[i] instanceof L2Character) || (target = (L2Character)possibleTargets[i]).isAlikeDead() || !target.isAutoAttackable(this) || target == this.getAI().getAttackTarget()) continue;
            hitted |= this.doAttakHitSimple(attack, target);
            target.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, this);
        }
        return hitted;
    }

    protected boolean checkAndEquipArrows() {
        return true;
    }

    public void addExpAndSp(int addToExp, int addToSp) {
    }

    public abstract L2ItemInstance getActiveWeaponInstance();

    public abstract L2Weapon getActiveWeaponItem();

    public abstract L2ItemInstance getSecondaryWeaponInstance();

    public abstract L2Weapon getSecondaryWeaponItem();

    protected void onHitTimer(L2Character target, int damage, boolean crit, boolean miss, boolean soulshot, boolean shld) {
        if (this.isAlikeDead()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        if (target.isAlikeDead() || !this.knowsObject(target) && !(this instanceof L2DoorInstance)) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            ActionFailed af = new ActionFailed();
            this.sendPacket(af);
            return;
        }
        if (!this.isAttackAborted()) {
            target.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, this);
            if (this instanceof L2PcInstance) {
                SystemMessage sm;
                if (crit) {
                    this.sendPacket(new SystemMessage(44));
                }
                if (miss) {
                    this.sendPacket(new SystemMessage(43));
                } else if (damage < 1) {
                    sm = new SystemMessage(614);
                    sm.addString("Enemy's armour hit");
                    this.sendPacket(sm);
                } else {
                    sm = new SystemMessage(35);
                    sm.addNumber(damage);
                    this.sendPacket(sm);
                }
            }
            if (target instanceof L2PcInstance) {
                L2PcInstance enemy = (L2PcInstance)target;
                if (shld) {
                    enemy.sendPacket(new SystemMessage(111));
                } else if (!miss && damage < 1) {
                    SystemMessage smsg = new SystemMessage(614);
                    smsg.addString("Armour hit");
                    enemy.sendPacket(smsg);
                }
            }
            if (!miss && damage > 0) {
                double reflectPercent = target.calcStat(Stats.REFLECT_DAMAGE_PERCENT, 0.0, null, null);
                if (reflectPercent > 0.0) {
                    int reflectedDamage = (int)(reflectPercent / 100.0 * (double)damage);
                    damage -= reflectedDamage;
                    this.reduceCurrentHp(reflectedDamage, target);
                }
                target.reduceCurrentHp(damage, this);
            }
            if (!miss && damage > 0) {
                double cancel = target.getAtkCancel();
                boolean abort = Formulas.getInstance().calcAtkBreak(target, cancel);
                if (abort) {
                    target.breakAttack();
                    target.breakCast();
                }
            }
        }
    }

    public void breakAttack() {
        if (this.isAttackingNow()) {
            this.abortAttack();
            if (this instanceof L2PcInstance) {
                this.sendPacket(new ActionFailed());
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Attack is broken");
                this.sendPacket(sm);
            }
        }
    }

    public void breakCast() {
        if (this.isCastingNow() && this.canAbortCast()) {
            this.abortCast();
            if (this instanceof L2PcInstance) {
                this.sendPacket(new ActionFailed());
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Casting is broken");
                this.sendPacket(sm);
            }
        }
    }

    protected void reduceArrowCount() {
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        if (this.withinZones(L2World.zones) || player.withinZones(L2World.zones)) {
            player.sendPacket(new SystemMessage(85));
            ActionFailed af = new ActionFailed();
            player.sendPacket(af);
        } else if (player.isConfused()) {
            ActionFailed af = new ActionFailed();
            player.sendPacket(af);
        } else if (this instanceof L2ArtefactInstance) {
            ActionFailed af = new ActionFailed();
            player.sendPacket(af);
        } else {
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
        }
    }

    public int calculateAttackSpeed(L2Character target, L2ItemInstance weaponInst) {
        return Formulas.getInstance().calcPAtkSpd(this, target, this.getPAtkSpd());
    }

    public boolean isUsingDualWeapon() {
        return false;
    }

    public L2Skill addSkill(L2Skill newSkill) {
        L2Skill oldSkill = null;
        if (newSkill != null) {
            oldSkill = this._skills.put(newSkill.getId(), newSkill);
            if (oldSkill != null) {
                this.removeStatsOwner(oldSkill);
            }
            this.addStatFuncs(newSkill.getStatFuncs(null, this));
        }
        return oldSkill;
    }

    public L2Skill removeSkill(L2Skill skill) {
        L2Skill oldSkill = this._skills.remove(skill.getId());
        if (oldSkill != null) {
            this.removeStatsOwner(oldSkill);
        }
        return oldSkill;
    }

    public final L2Skill[] getAllSkills() {
        if (this._skills == null) {
            return new L2Skill[0];
        }
        return this._skills.values().toArray(new L2Skill[this._skills.values().size()]);
    }

    public final int getSkillLevel(int skillId) {
        if (this._skills == null) {
            return -1;
        }
        L2Skill skill = this._skills.get(skillId);
        if (skill == null) {
            return -1;
        }
        return skill.getLevel();
    }

    public final L2Skill getKnownSkill(int skillId) {
        if (this._skills == null) {
            return null;
        }
        return this._skills.get(skillId);
    }

    protected void useMagic(L2Skill skill) {
        if (skill == null || this.isDead()) {
            return;
        }
        if (this.isAllSkillsDisabled()) {
            _log.warning("currently casting or sleeping, skill disabled");
            return;
        }
        if (skill.isPassive()) {
            return;
        }
        if (skill.getSkillType() == L2Skill.SkillType.SIEGEFLAG && !L2Siege.okToPlaceFlag(((L2PcInstance)this).getClanId())) {
            return;
        }
        L2Object target = null;
        switch (skill.getTargetType()) {
            case TARGET_AURA: 
            case TARGET_AURA_CLOSE: 
            case TARGET_PARTY: 
            case TARGET_CLAN: {
                target = this;
                break;
            }
            default: {
                L2Object[] targets = skill.getTargetList(this);
                if (targets == null || targets.length == 0) {
                    return;
                }
                target = targets[0];
            }
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
    }

    protected void doCast(L2Skill skill) {
        if (skill == null) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        if (skill.isMagic() && this.isMuted()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        L2Object[] targets = skill.getTargetList(this);
        if (targets == null) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        L2Character target = null;
        target = skill.getSkillType() == L2Skill.SkillType.BUFF || skill.getSkillType() == L2Skill.SkillType.HEAL || skill.getSkillType() == L2Skill.SkillType.MANAHEAL || skill.getSkillType() == L2Skill.SkillType.REFLECT || skill.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF ? (L2Character)targets[0] : (L2Character)this.getTarget();
        if (skill.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || skill.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA_CLOSE || skill.getTargetType() == L2Skill.SkillTargetType.TARGET_PARTY || skill.getTargetType() == L2Skill.SkillTargetType.TARGET_CLAN) {
            target = this;
        }
        if (target == null) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        int magicId = skill.getId();
        int displayId = skill.getDisplayId();
        int level = this.getSkillLevel(magicId);
        if (Config.DEBUG) {
            _log.fine("Cast skill " + skill + " by " + this + " to " + target);
        }
        int skillTime = skill.getSkillTime();
        int skillInterruptTime = skill.getSkillInterruptTime();
        skillTime = Formulas.getInstance().calcMAtkSpd(this, target, skill, skillTime);
        skillInterruptTime = skill.isMagic() ? Formulas.getInstance().calcMAtkSpd(this, target, skill, skillInterruptTime) : 0;
        this._castEndTime = 10 + GameTimeController.getGameTicks() + skillTime / 100;
        this._castInterruptTime = GameTimeController.getGameTicks() + skillInterruptTime / 100;
        int reuseDelay = (int)((double)skill.getReuseDelay() * this.getMReuseRate(skill));
        MagicSkillUser msu = new MagicSkillUser(this, target, displayId, level, skillTime, reuseDelay);
        this.broadcastPacket(msu);
        if (this instanceof L2PcInstance) {
            SystemMessage sm = new SystemMessage(46);
            sm.addSkillName(magicId);
            this.sendPacket(sm);
        }
        if (reuseDelay > 10) {
            this.disableSkill(skill.getId());
            ClientScheduler.getInstance().scheduleMed(new EnableSkill(skill.getId()), reuseDelay);
        }
        if (skillTime > 50) {
            if (this instanceof L2PcInstance) {
                SetupGauge sg = new SetupGauge(0, skillTime);
                this.sendPacket(sg);
            }
            this.disableAllSkills();
            ClientScheduler.getInstance().scheduleMed(new EnableAllSkills(skill), skillTime);
            ClientScheduler.getInstance().scheduleMed(new MagicUseTask(targets, skill), skillTime);
        } else {
            this.onMagicUseTimer(targets, skill);
        }
    }

    public void onMagicUseTimer(L2Object[] targets, L2Skill skill) {
        if (this.isAlikeDead()) {
            this._castEndTime = 0;
            this._castInterruptTime = 0;
            return;
        }
        if (this.isCastingNow()) {
            this._castEndTime = 0;
            this._castInterruptTime = 0;
            int magicId = skill.getDisplayId();
            int level = this.getSkillLevel(skill.getId());
            if (skill.getTargetType() == L2Skill.SkillTargetType.TARGET_AREA || skill.getTargetType() == L2Skill.SkillTargetType.TARGET_AREA_CORPSE_MOB) {
                L2Character target = (L2Character)targets[0];
                if (Config.DEBUG) {
                    _log.fine("msl: " + this.getName() + " " + magicId + " " + level + " " + target.getName());
                }
                MagicSkillLaunched msl = new MagicSkillLaunched(this, magicId, level, target);
                this.broadcastPacket(msl);
            } else {
                for (int i = 0; i < targets.length; ++i) {
                    if (targets[i] instanceof L2Character) {
                        L2Character target = (L2Character)targets[i];
                        if (Config.DEBUG) {
                            _log.fine("msl: " + this.getName() + " " + magicId + " " + level + " " + target.getTitle());
                        }
                        MagicSkillLaunched msl = new MagicSkillLaunched(this, magicId, level, target);
                        this.broadcastPacket(msl);
                        continue;
                    }
                    if (!Config.DEBUG) continue;
                    _log.config("Class cast bad: " + targets.getClass().toString());
                }
            }
            if (skill.getMpConsume() > 0) {
                this.reduceCurrentMp(skill.getMpConsume());
            }
            if (skill.getHpConsume() > 0) {
                this.reduceCurrentHp(skill.getHpConsume(), null);
            }
            if (skill.getItemConsume() > 0) {
                this.consumeItem(skill.getItemConsumeId(), skill.getItemConsume());
            }
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(StatusUpdate.CUR_MP, (int)this.getCurrentMp());
            this.sendPacket(su);
            this.callSkill(skill, targets);
            if (skill.getSkillType() == L2Skill.SkillType.PDAM && this.getTarget() != null && this.getTarget() instanceof L2Character) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this.getTarget());
            }
            this.getAI().notifyEvent(CtrlEvent.EVT_FINISH_CASTING);
        }
    }

    public void consumeItem(int itemConsumeId, int itemCount) {
    }

    public synchronized void enableSkill(int skillId) {
        if (this._disabledSkills == null) {
            return;
        }
        this._disabledSkills.remove(new Integer(skillId));
    }

    public synchronized void disableSkill(int skillId) {
        if (this._disabledSkills == null) {
            this._disabledSkills = new ArrayList<Integer>();
        }
        this._disabledSkills.add(skillId);
    }

    public boolean isSkillDisabled(int skillId) {
        if (this.isAllSkillsDisabled()) {
            return true;
        }
        if (this._disabledSkills == null) {
            return false;
        }
        return this._disabledSkills.contains(skillId);
    }

    public void disableAllSkills() {
        if (Config.DEBUG) {
            _log.fine("all skills disabled");
        }
        this._allSkillsDisabled = true;
    }

    public void enableAllSkills() {
        if (Config.DEBUG) {
            _log.fine("all skills enabled");
        }
        this._allSkillsDisabled = false;
    }

    private void callSkill(L2Skill skill, L2Object[] targets) {
        try {
            if (this instanceof L2PcInstance) {
                L2PcInstance activeChar = (L2PcInstance)this;
                for (L2Object target : targets) {
                    if (!(target instanceof L2Character)) continue;
                    L2Character player = (L2Character)target;
                    player.setAttackingChar(this);
                    player.setAttackingCharSkill(skill);
                    if (skill.isOffensive()) {
                        if (player instanceof L2PcInstance && ((L2PcInstance)player).getKarma() == 0) {
                            activeChar.checkPvP(player);
                        }
                        if (!(player instanceof L2Attackable)) continue;
                        ((L2Attackable)player).addDamageHate(this, 1, 1);
                        continue;
                    }
                    if (player instanceof L2PcInstance && (((L2PcInstance)player).getPvpFlag() > 0 || ((L2PcInstance)player).getKarma() > 0)) {
                        activeChar.checkPvP(player);
                    }
                    if (!(player instanceof L2Attackable)) continue;
                    activeChar.checkPvP(this);
                }
            }
            ISkillHandler handler = null;
            if (skill.isToggle() && this.getEffect(skill.getId()) != null) {
                handler = SkillHandler.getInstance().getSkillHandler(skill.getSkillType());
                if (handler != null) {
                    handler.useSkill(this, skill, targets);
                } else {
                    skill.useSkill(this, targets);
                }
                return;
            }
            handler = SkillHandler.getInstance().getSkillHandler(skill.getSkillType());
            if (handler != null) {
                handler.useSkill(this, skill, targets);
            } else {
                skill.useSkill(this, targets);
            }
            if (this instanceof L2PcInstance) {
                for (L2Object obj : targets) {
                    if (!(obj instanceof L2CastleGuardInstance)) continue;
                    L2CastleGuardInstance guard = (L2CastleGuardInstance)obj;
                    guard.maybeLearnSkill((L2PcInstance)this, skill);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
        }
    }

    public boolean isBehindTarget() {
        if (this.getTarget() instanceof L2Character) {
            int i;
            L2Character target = (L2Character)this.getTarget();
            int tarheading = target.getHeading();
            int heading = this.getHeading();
            int count = tarheading;
            for (i = 0; i < 3500; ++i) {
                if (count > 65535) {
                    count = 1;
                }
                if (heading == count) {
                    return true;
                }
                ++count;
            }
            count = tarheading;
            for (i = 0; i < 3500; ++i) {
                if (count < 1) {
                    count = 65535;
                }
                if (heading == count) {
                    return true;
                }
                --count;
            }
        } else {
            _log.fine("isBehindTarget's target not an L2 Character.");
        }
        return false;
    }

    public final void updateEffectIcons() {
        MagicEffectIcons mi = new MagicEffectIcons();
        L2Effect[] effects = this.getAllEffects();
        for (int i = 0; effects != null && i < effects.length; ++i) {
            L2Effect effect = effects[i];
            if (!effect.getInUse()) continue;
            effect.addIcon(mi);
        }
        this.sendPacket(mi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEffect(L2Effect newEffect) {
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (this._effects == null) {
                this._effects = new ConcurrentHashMap();
            }
            if (this._stackedEffects == null) {
                this._stackedEffects = new HashMap();
            }
        }
        L2Effect tempEffect = this._effects.put(newEffect.getSkill().getId(), newEffect);
        if (newEffect.getStackType().equals("none")) {
            if (tempEffect != null) {
                this.removeStatsOwner(tempEffect);
            }
            tempEffect = this._effects.get(newEffect.getSkill().getId());
            tempEffect.setInUse(true);
            this.addStatFuncs(newEffect.getStatFuncs());
            this.updateEffectIcons();
            return;
        }
        LinkedList<Integer> stackQueue = this._stackedEffects.get(newEffect.getStackType());
        if (stackQueue == null) {
            stackQueue = new LinkedList();
        }
        if (stackQueue.size() > 0 && (tempEffect = this._effects.get(stackQueue.peek())) != null) {
            this.removeStatsOwner(tempEffect);
            tempEffect.setInUse(false);
        }
        stackQueue = this.effectQueueInsert(newEffect.getSkill().getId(), newEffect.getStackOrder(), stackQueue);
        this._stackedEffects.put(newEffect.getStackType(), stackQueue);
        tempEffect = this._effects.get(stackQueue.peek());
        tempEffect.setInUse(true);
        this.addStatFuncs(tempEffect.getStatFuncs());
        this.updateEffectIcons();
        this._stackedEffects.put(newEffect.getStackType(), stackQueue);
    }

    private LinkedList<Integer> effectQueueInsert(int id, int stackOrder, LinkedList<Integer> stackQueue) {
        L2Effect tempEffect = this._effects.get(id);
        Iterator queueIterator = stackQueue.iterator();
        int i = 0;
        while (queueIterator.hasNext() && tempEffect.getStackOrder() < this._effects.get(queueIterator.next()).getStackOrder()) {
            ++i;
        }
        stackQueue.add(i, id);
        if (Config.EFFECT_CANCELING && stackQueue.size() > 1) {
            stackQueue.remove(1);
        }
        return stackQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeEffect(L2Effect effect) {
        if (effect.getStackType() == "none") {
            this.removeStatsOwner(effect);
        } else {
            LinkedList<Integer> stackQueue = this._stackedEffects.get(effect.getStackType());
            if (stackQueue.size() < 1) {
                stackQueue = null;
            }
            if (stackQueue == null) {
                return;
            }
            int frontEffect = stackQueue.peek();
            boolean removed = stackQueue.remove((Object)effect.getSkill().getId());
            if (removed && frontEffect == effect.getSkill().getId()) {
                this.removeStatsOwner(effect);
                if (stackQueue.size() > 0) {
                    this.addStatFuncs(this._effects.get(stackQueue.peek()).getStatFuncs());
                    this._effects.get(stackQueue.peek()).setInUse(true);
                }
            }
            this._stackedEffects.put(effect.getStackType(), stackQueue);
        }
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (this._effects == null) {
                return;
            }
            this._effects.remove(effect.getSkill().getId());
            if (this._effects.isEmpty()) {
                this._effects = null;
            }
        }
        this.updateEffectIcons();
    }

    public final L2Effect getEffect(int index) {
        ConcurrentHashMap<Integer, L2Effect> effects = this._effects;
        if (effects == null) {
            return null;
        }
        return effects.get(index);
    }

    public final L2Effect getEffect(L2Skill skill) {
        ConcurrentHashMap<Integer, L2Effect> effects = this._effects;
        if (effects == null) {
            return null;
        }
        for (L2Effect e : effects.values()) {
            if (e.getSkill() != skill) continue;
            return e;
        }
        return null;
    }

    public final L2Effect getEffect(L2Effect.EffectType tp) {
        ConcurrentHashMap<Integer, L2Effect> effects = this._effects;
        if (effects == null) {
            return null;
        }
        for (L2Effect e : effects.values()) {
            if (e.getEffectType() != tp) continue;
            return e;
        }
        return null;
    }

    public final L2Effect[] getAllEffects() {
        ConcurrentHashMap<Integer, L2Effect> effects = this._effects;
        if (effects == null || effects.isEmpty()) {
            return EMPTY_EFFECTS;
        }
        return effects.values().toArray(new L2Effect[effects.size()]);
    }

    public final void stopEffect(int effectId) {
        L2Effect effect = this.getEffect(effectId);
        if (effect != null) {
            effect.exit();
        }
    }

    public final void stopEffects(L2Effect.EffectType type) {
        L2Effect[] effects = this.getAllEffects();
        if (effects != null) {
            for (L2Effect e : effects) {
                if (e.getEffectType() != type) continue;
                e.exit();
            }
        }
    }

    public final void stopAllEffects() {
        L2Effect[] effects = this.getAllEffects();
        if (effects != null) {
            for (L2Effect e : effects) {
                this.stopEffect(e.getSkill().getId());
            }
        }
    }

    public double getLevelMod() {
        return 1.0;
    }

    public void updateStats() {
    }

    public void setlastPvpAttack(long time) {
        this._lastPvpAttack = time;
    }

    public long getlastPvpAttack() {
        return this._lastPvpAttack;
    }

    public void startPvPFlag() {
        this.updatePvPFlag(1);
        this._PvPRegTask = ClientScheduler.getInstance().scheduleLowAtFixedRate(new PvPFlag(), 1000L, 1000L);
        this._PvPRegActive = true;
    }

    public void stopPvPFlag() {
        if (this._PvPRegTask != null) {
            this._PvPRegTask.cancel(false);
        }
        this.updatePvPFlag(0);
        this._PvPRegTask = null;
        this._PvPRegActive = false;
    }

    public void updatePvPFlag(int value) {
        if (!(this instanceof L2PcInstance)) {
            return;
        }
        L2PcInstance player = (L2PcInstance)this;
        if (player.getPvpFlag() == value) {
            return;
        }
        player.setPvpFlag(value);
        if (player.getKarma() < 1) {
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(StatusUpdate.PVP_FLAG, value);
            this.sendPacket(su);
            this.broadcastPacket(su);
        }
    }

    public void teleToLocation(int x, int y, int z) {
        this.stopMove(null);
        if (Config.DEBUG) {
            _log.fine("Teleporting to: " + x + ", " + y + ", " + z);
        }
        this.setXYZ(x, y, z);
        TeleportToLocation teleport = new TeleportToLocation(this, x, y, z);
        this.broadcastPacket(teleport);
        if (this.getPet() != null) {
            this.getPet().teleToLocation(this.getX(), this.getY(), this.getZ());
        }
    }

    public L2Summon getPet() {
        return null;
    }

    public final int getRandomDamage(L2Character target) {
        L2Weapon weaponItem = this.getActiveWeaponItem();
        if (weaponItem == null) {
            return 5 + (int)Math.sqrt(this.getLevel());
        }
        return weaponItem.getRandomDamage();
    }

    public String toString() {
        return "mob " + this.getObjectId();
    }

    public boolean isUndead() {
        return false;
    }

    static class MoveData {
        int _moveTimestamp;
        int _xDestination;
        int _yDestination;
        int _zDestination;
        int _xMoveFrom;
        int _yMoveFrom;
        int _zMoveFrom;
        int _moveStartTime;
        int _ticksToMove;
        float _xSpeedTicks;
        float _ySpeedTicks;

        MoveData() {
        }
    }

    class DecayTask
    implements Runnable {
        DecayTask() {
        }

        public void run() {
            try {
                L2Character.this.onDecay();
            }
            catch (Throwable e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    class PvPFlag
    implements Runnable {
        PvPFlag() {
        }

        public void run() {
            try {
                if (Math.abs(System.currentTimeMillis() - L2Character.this.getlastPvpAttack()) > (long)Config.PVP_TIME) {
                    L2Character.this.stopPvPFlag();
                } else if (Math.abs(System.currentTimeMillis() - L2Character.this.getlastPvpAttack()) > (long)(Config.PVP_TIME - 5000)) {
                    L2Character.this.updatePvPFlag(2);
                } else {
                    L2Character.this.updatePvPFlag(1);
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "error in pvp flag task:", e);
            }
        }
    }

    class EnableAllSkills
    implements Runnable {
        L2Skill _skill;

        public EnableAllSkills(L2Skill skill) {
            this._skill = skill;
        }

        public void run() {
            try {
                L2Character.this.enableAllSkills();
            }
            catch (Throwable e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    class EnableSkill
    implements Runnable {
        int _skillId;

        public EnableSkill(int skillId) {
            this._skillId = skillId;
        }

        public void run() {
            try {
                L2Character.this.enableSkill(this._skillId);
            }
            catch (Throwable e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    class MagicUseTask
    implements Runnable {
        L2Object[] _targets;
        L2Skill _skill;

        public MagicUseTask(L2Object[] targets, L2Skill skill) {
            this._targets = targets;
            this._skill = skill;
        }

        public void run() {
            try {
                L2Character.this.onMagicUseTimer(this._targets, this._skill);
            }
            catch (Throwable e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    class RegenTask
    implements Runnable {
        RegenTask() {
        }

        public void run() {
            try {
                double addHp = 0.0;
                double addMp = 0.0;
                if (L2Character.this.getCurrentHp() < (double)L2Character.this.getMaxHp()) {
                    addHp = Formulas.getInstance().calcHpRegen(L2Character.this);
                }
                if (L2Character.this.getCurrentMp() < (double)L2Character.this.getMaxMp()) {
                    addMp = Formulas.getInstance().calcMpRegen(L2Character.this);
                }
                L2Character.this.setCurrentHpMp(L2Character.this.getCurrentHp() + addHp, L2Character.this.getCurrentMp() + addMp);
                if (L2Character.this.getCurrentCp() < (double)L2Character.this.getMaxCp()) {
                    double addCp = Formulas.getInstance().calcCpRegen(L2Character.this);
                    L2Character.this.setCurrentCp(L2Character.this.getCurrentCp() + addCp);
                }
            }
            catch (Throwable e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    class HitTask
    implements Runnable {
        L2Character _hitTarget;
        int _damage;
        boolean _crit;
        boolean _miss;
        boolean _shld;
        boolean _soulshot;

        public HitTask(L2Character target, int damage, boolean crit, boolean miss, boolean soulshot, boolean shld) {
            this._hitTarget = target;
            this._damage = damage;
            this._crit = crit;
            this._shld = shld;
            this._miss = miss;
            this._soulshot = soulshot;
        }

        public void run() {
            try {
                L2Character.this.onHitTimer(this._hitTarget, this._damage, this._crit, this._miss, this._soulshot, this._shld);
            }
            catch (Throwable e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public class NotifyAITask
    implements Runnable {
        private final CtrlEvent _evt;

        NotifyAITask(CtrlEvent evt) {
            this._evt = evt;
        }

        public void run() {
            try {
                L2Character.this.getAI().notifyEvent(this._evt, null);
            }
            catch (Throwable t) {
                _log.log(Level.WARNING, "", t);
            }
        }
    }

    public class AIAccessor {
        protected AIAccessor() {
        }

        public L2Character getActor() {
            return L2Character.this;
        }

        public void moveTo(int x, int y, int z, int offset) {
            L2Character.this.moveToLocation(x, y, z, offset);
        }

        public void moveTo(int x, int y, int z) {
            L2Character.this.moveToLocation(x, y, z, 0);
        }

        public void stopMove(L2CharPosition pos) {
            L2Character.this.stopMove(pos);
        }

        public void doAttack(L2Character target) {
            L2Character.this.doAttack(target);
        }

        public void doCast(L2Skill skill) {
            L2Character.this.doCast(skill);
        }

        public NotifyAITask newNotifyTask(CtrlEvent evt) {
            return new NotifyAITask(evt);
        }

        public void detachAI() {
            L2Character.this._ai = null;
        }
    }
}

