/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.model.ClanWarehouse;
import net.sf.l2j.gameserver.model.L2ClanMember;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.Warehouse;
import net.sf.l2j.gameserver.serverpackets.PledgeStatusChanged;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class L2Clan {
    private static final Logger _log = Logger.getLogger(L2Clan.class.getName());
    private String _name;
    private int _clanId;
    private L2ClanMember _leader;
    private Map<String, L2ClanMember> _members = new TreeMap<String, L2ClanMember>();
    private String _allyName;
    private int _allyId;
    private int _level;
    private int _hasCastle;
    private int _hasHideout;
    private boolean _hasCrest;
    private int _hiredGuards;
    private Warehouse _warehouse = new ClanWarehouse(this);
    private ArrayList<Integer> _atWarWith;

    public L2Clan(int clanId) {
        this._clanId = clanId;
        this.restore();
        File crestFile = new File(Config.DATAPACK_ROOT, "data/crests/Pledge_" + this._clanId + ".bmp");
        this._hasCrest = crestFile.exists();
    }

    public L2Clan(int clanId, String clanName, L2ClanMember leader) {
        this._clanId = clanId;
        this._name = clanName;
        this.setLeader(leader);
    }

    public int getClanId() {
        return this._clanId;
    }

    public void setClanId(int clanId) {
        this._clanId = clanId;
    }

    public int getLeaderId() {
        return this._leader.getObjectId();
    }

    public void setLeader(L2ClanMember leader) {
        this._leader = leader;
        this._members.put(leader.getName(), leader);
    }

    public void setNewLeader() {
        int maxLevel = 0;
        L2ClanMember newLeader = null;
        for (L2ClanMember member : this.getMembers()) {
            if (member.getLevel() <= maxLevel) continue;
            maxLevel = member.getLevel();
            newLeader = member;
        }
        if (newLeader != null) {
            this.setLeader(newLeader);
            this.updateClanInDB();
            this.broadcastToOnlineMembers(new PledgeStatusChanged(this));
            this.broadcastToOnlineMembers(SystemMessage.sendString(newLeader.getName() + " is the new clan leader."));
        }
    }

    public String getLeaderName() {
        return this._leader.getName();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    private void addClanMember(L2ClanMember member) {
        this._members.put(member.getName(), member);
    }

    public void addClanMember(L2PcInstance player) {
        L2ClanMember member = new L2ClanMember(player);
        this.storeNewMemberInDatabase(member);
        this.addClanMember(member);
    }

    public L2ClanMember getClanMember(String name) {
        return this._members.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClan() {
        this.broadcastToOnlineMembers(new SystemMessage(199));
        for (L2ClanMember member : this.getMembers()) {
            this.removeClanMember(member.getName());
        }
        for (L2ItemInstance item : this._warehouse.listItems()) {
            this._warehouse.destroyItem(item.getItemId(), item.getCount());
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM clan_data WHERE clan_id=?");
            statement.setInt(1, this.getClanId());
            statement.execute();
            statement.close();
            if (Config.DEBUG) {
                _log.fine("clan removed in db: " + this.getClanId());
            }
        }
        catch (Exception e) {
            _log.warning("error while removing clan in db " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public void removeClanMember(String name) {
        L2ClanMember exMember = this._members.remove(name);
        if (exMember.getName().equals(this.getLeaderName())) {
            this.setNewLeader();
        }
        this.removeMemberInDatabase(exMember);
        if (this._members.isEmpty()) {
            this.removeClan();
        }
    }

    public L2ClanMember[] getMembers() {
        return this._members.values().toArray(new L2ClanMember[this._members.size()]);
    }

    public L2PcInstance[] getOnlineMembers(String exclude) {
        ArrayList<L2PcInstance> result = new ArrayList<L2PcInstance>();
        for (L2ClanMember temp : this._members.values()) {
            if (!temp.isOnline() || temp.getPlayerInstance() == null || temp.getName().equals(exclude)) continue;
            result.add(temp.getPlayerInstance());
        }
        return result.toArray(new L2PcInstance[result.size()]);
    }

    public int getAllyId() {
        return this._allyId;
    }

    public String getAllyName() {
        return this._allyName;
    }

    public int getAllyCrestId() {
        return this._allyId;
    }

    public int getLevel() {
        return this._level;
    }

    public int getHasCastle() {
        return this._hasCastle;
    }

    public int getHasHideout() {
        return this._hasHideout;
    }

    public int getCrestId() {
        return this._clanId;
    }

    public void setAllyId(int allyId) {
        this._allyId = allyId;
    }

    public void setAllyName(String allyName) {
        this._allyName = allyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasCastle(int hasCastle) {
        this._hasCastle = hasCastle;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET hasCastle=? WHERE clan_id=?");
            statement.setInt(1, hasCastle);
            statement.setInt(2, this.getClanId());
            statement.execute();
            statement.close();
            if (Config.DEBUG) {
                _log.fine("Castle ownership set for clan: " + this.getClanId());
            }
        }
        catch (Exception e) {
            _log.warning("error while saving new clan member to db " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setHasHideout(int hasHideout) {
        this._hasHideout = hasHideout;
    }

    public void setLevel(int level) {
        this._level = level;
    }

    public boolean isMember(String name) {
        return this._members.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClanInDB() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET leader_id=? WHERE clan_id=?");
            statement.setInt(1, this.getLeaderId());
            statement.setInt(2, this.getClanId());
            statement.execute();
            statement.close();
            if (Config.DEBUG) {
                _log.fine("New clan leader saved in db: " + this.getClanId());
            }
        }
        catch (Exception e) {
            _log.warning("error while saving new clan leader to db " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO clan_data (clan_id,clan_name,clan_level,hasCastle,hasHideout,ally_id,ally_name,leader_id) values (?,?,?,?,?,?,?,?)");
            statement.setInt(1, this.getClanId());
            statement.setString(2, this.getName());
            statement.setInt(3, this.getLevel());
            statement.setInt(4, this.getHasCastle());
            statement.setInt(5, this.getHasHideout());
            statement.setInt(6, this.getAllyId());
            statement.setString(7, this.getAllyName());
            statement.setInt(8, this.getLeaderId());
            statement.execute();
            statement.close();
            statement = con.prepareStatement("UPDATE characters SET clanid=? WHERE obj_Id=?");
            statement.setInt(1, this.getClanId());
            statement.setInt(2, this.getLeaderId());
            statement.execute();
            statement.close();
            if (Config.DEBUG) {
                _log.fine("New clan saved in db: " + this.getClanId());
            }
        }
        catch (Exception e) {
            _log.warning("error while saving new clan to db " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeNewMemberInDatabase(L2ClanMember member) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET clanid=? WHERE obj_Id=?");
            statement.setInt(1, this.getClanId());
            statement.setInt(2, member.getObjectId());
            statement.execute();
            statement.close();
            if (Config.DEBUG) {
                _log.fine("New clan member saved in db: " + this.getClanId());
            }
        }
        catch (Exception e) {
            _log.warning("error while saving new clan member to db " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMemberInDatabase(L2ClanMember member) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET clanid=0, title=? WHERE obj_Id=?");
            statement.setString(1, "");
            statement.setInt(2, member.getObjectId());
            statement.execute();
            statement.close();
            if (Config.DEBUG) {
                _log.fine("clan member removed in db: " + this.getClanId());
            }
        }
        catch (Exception e) {
            _log.warning("error while removing clan member in db " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorewars() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clan1, clan2, wantspeace1, wantspeace2 FROM clan_wars");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                if (rset.getString("clan1").equals(this.getName())) {
                    this.setEnemyClan(Integer.parseInt(rset.getString("clan2")));
                }
                if (!rset.getString("clan2").equals(this.getName())) continue;
                this.setEnemyClan(Integer.parseInt(rset.getString("clan1")));
            }
        }
        catch (Exception e) {
            _log.warning("could not restore castle guard data:" + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore() {
        this.restorewars();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clan_name,clan_level,hasCastle,hasHideout,ally_id,ally_name,leader_id FROM clan_data where clan_id=?");
            statement.setInt(1, this.getClanId());
            ResultSet clanData = statement.executeQuery();
            if (clanData.next()) {
                this.setName(clanData.getString("clan_name"));
                this.setLevel(clanData.getInt("clan_level"));
                this.setHasCastle(clanData.getInt("hasCastle"));
                this.setHasHideout(clanData.getInt("hasHideout"));
                this.setAllyId(clanData.getInt("ally_id"));
                this.setAllyName(clanData.getString("ally_name"));
                int leaderId = clanData.getInt("leader_id");
                PreparedStatement statement2 = con.prepareStatement("SELECT char_name,level,classid,obj_Id FROM characters WHERE clanid=?");
                statement2.setInt(1, this.getClanId());
                ResultSet clanMembers = statement2.executeQuery();
                while (clanMembers.next()) {
                    L2ClanMember member = new L2ClanMember(clanMembers.getString("char_name"), clanMembers.getInt("level"), clanMembers.getInt("classid"), clanMembers.getInt("obj_id"));
                    if (member.getObjectId() == leaderId) {
                        this.setLeader(member);
                        continue;
                    }
                    this.addClanMember(member);
                }
                clanMembers.close();
                statement2.close();
            }
            clanData.close();
            statement.close();
            _log.config("restored clan " + this.getName() + " from db");
        }
        catch (Exception e) {
            _log.warning("error while restoring clan " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public void broadcastToOnlineMembers(ServerBasePacket packet) {
        for (L2ClanMember member : this._members.values()) {
            if (!member.isOnline() || member.getPlayerInstance() == null) continue;
            member.getPlayerInstance().sendPacket(packet);
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean hasCrest() {
        return this._hasCrest;
    }

    public void setHasCrest(boolean flag) {
        this._hasCrest = flag;
    }

    public Warehouse getWarehouse() {
        return this._warehouse;
    }

    public boolean isAtWarWith(Integer id) {
        return this._atWarWith != null && this._atWarWith.size() > 0 && this._atWarWith.contains(id);
    }

    public void setEnemyClan(L2Clan clan) {
        Integer id = clan.getClanId();
        this._atWarWith.add(id);
    }

    public void setEnemyClan(Integer clan) {
        this._atWarWith.add(clan);
    }

    public void deleteEnemyClan(L2Clan clan) {
        Integer id = clan.getClanId();
        this._atWarWith.remove(id);
    }

    public int getHiredGuards() {
        return this._hiredGuards;
    }

    public void incrementHiredGuards() {
        ++this._hiredGuards;
    }
}

