/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import net.sf.l2j.gameserver.model.L2PcInstance;

public class L2ClanMember {
    private int _objectId;
    private String _name;
    private int _level;
    private int _classId;
    private L2PcInstance _player;

    public L2ClanMember(String name, int level, int classId, int objectId) {
        this._name = name;
        this._level = level;
        this._classId = classId;
        this._objectId = objectId;
    }

    public L2ClanMember(L2PcInstance player) {
        this._player = player;
    }

    public void setPlayerInstance(L2PcInstance player) {
        if (player == null && this._player != null) {
            this._name = this._player.getName();
            this._level = this._player.getLevel();
            this._classId = this._player.getClassId().getId();
            this._objectId = this._player.getObjectId();
        }
        this._player = player;
    }

    public L2PcInstance getPlayerInstance() {
        return this._player;
    }

    public boolean isOnline() {
        return this._player != null;
    }

    public int getClassId() {
        if (this._player != null) {
            return this._player.getClassId().getId();
        }
        return this._classId;
    }

    public int getLevel() {
        if (this._player != null) {
            return this._player.getLevel();
        }
        return this._level;
    }

    public String getName() {
        if (this._player != null) {
            return this._player.getName();
        }
        return this._name;
    }

    public int getObjectId() {
        if (this._player != null) {
            return this._player.getObjectId();
        }
        return this._objectId;
    }

    public String getTitle() {
        if (this._player != null) {
            return this._player.getTitle();
        }
        return " ";
    }
}

