/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.ai.L2ControllableMobAI;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2MonsterInstance;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2ControllableMobInstance
extends L2MonsterInstance {
    private boolean invul;
    private L2ControllableMobAI _aiBackup;
    private boolean _killedAlready = false;

    public boolean isAggressive() {
        return true;
    }

    public int getAggroRange() {
        return 500;
    }

    public L2ControllableMobInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CharacterAI getAI() {
        if (this._ai == null) {
            L2ControllableMobInstance l2ControllableMobInstance = this;
            synchronized (l2ControllableMobInstance) {
                if (this._ai == null && this._aiBackup == null) {
                    this._ai = new L2ControllableMobAI(new ControllableAIAcessor());
                    this._aiBackup = (L2ControllableMobAI)this._ai;
                } else {
                    this._ai = this._aiBackup;
                }
            }
        }
        return this._ai;
    }

    public boolean isInvul() {
        return this.invul;
    }

    public void setInvul(boolean invul) {
        this.invul = invul;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduceCurrentHp(double i, L2Character attacker, boolean awake) {
        if (this.invul) {
            return;
        }
        if (this.isDead()) {
            return;
        }
        if (awake) {
            this.stopSleeping(null);
        }
        if ((i = this.getCurrentHp() - i) < 0.0) {
            i = 0.0;
        }
        this.setCurrentHp(i);
        if (this.isDead()) {
            L2ControllableMobInstance l2ControllableMobInstance = this;
            synchronized (l2ControllableMobInstance) {
                if (this._killedAlready) {
                    return;
                }
                this._killedAlready = true;
            }
            if (Config.DEBUG) {
                _log.fine("char is dead.");
            }
            this.stopMove(null);
            this.doDie(attacker);
            this.setCurrentHp(0.0);
        }
    }

    protected void doDie(L2Character killer) {
        this.removeAI();
        super.doDie(killer);
    }

    public void deleteMe() {
        this.removeAI();
        super.deleteMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAI() {
        L2ControllableMobInstance l2ControllableMobInstance = this;
        synchronized (l2ControllableMobInstance) {
            if (this._aiBackup != null) {
                this._aiBackup.setIntention(CtrlIntention.AI_INTENTION_IDLE);
                this._aiBackup = null;
                this._ai = null;
            }
        }
    }

    protected class ControllableAIAcessor
    extends L2Character.AIAccessor {
        protected ControllableAIAcessor() {
        }

        public void detachAI() {
        }
    }
}

