/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2FriendlyMobInstance
extends L2Attackable {
    public L2FriendlyMobInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    public boolean isAutoAttackable(L2Character attacker) {
        if (attacker instanceof L2PcInstance) {
            return ((L2PcInstance)attacker).getKarma() > 0;
        }
        return false;
    }

    public boolean isAggressive() {
        return true;
    }

    public boolean hasRandomAnimation() {
        return false;
    }

    public boolean addKnownObject(L2Object object, L2Character dropper) {
        boolean ret = super.addKnownObject(object, dropper);
        if (!ret) {
            return false;
        }
        if (object instanceof L2PcInstance && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
        }
        return true;
    }

    public void removeKnownObject(L2Object object) {
        super.removeKnownObject(object);
        if (!(object instanceof L2Character)) {
            return;
        }
        if (this.hasAI()) {
            L2Character temp = (L2Character)object;
            this.getAI().notifyEvent(CtrlEvent.EVT_FORGET_OBJECT, object);
            if (this.getTarget() == temp) {
                this.setTarget(null);
            }
        }
        if (this.isVisible() && this.getKnownPlayers().isEmpty()) {
            this.clearAggroList();
            this.removeAllKnownObjects();
            if (this.hasAI()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
            }
            return;
        }
    }
}

