/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.Random;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2MonsterInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.SocialAction;
import net.sf.l2j.gameserver.serverpackets.ValidateLocation;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public final class L2GuardInstance
extends L2Attackable {
    private int _homeX;
    private int _homeY;
    private int _homeZ;

    public L2GuardInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    public boolean isAutoAttackable(L2Character attacker) {
        return attacker instanceof L2MonsterInstance;
    }

    public boolean addKnownObject(L2Object object, L2Character dropper) {
        L2MonsterInstance mob;
        boolean ret = super.addKnownObject(object, dropper);
        if (!ret) {
            return false;
        }
        if (this._homeX == 0) {
            this.getHomeLocation();
        }
        if (object instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)object;
            if (player.getKarma() > 0) {
                if (Config.DEBUG) {
                    _log.fine(this.getObjectId() + ": PK " + player.getObjectId() + " entered scan range");
                }
                if (this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
                }
            }
        } else if (Config.ALLOW_GUARDS && object instanceof L2MonsterInstance && (mob = (L2MonsterInstance)object).isAggressive()) {
            if (Config.DEBUG) {
                _log.fine(this.getObjectId() + ": Aggressive mob " + mob.getObjectId() + " entered scan range");
            }
            if (this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
            }
        }
        return ret;
    }

    public void removeKnownObject(L2Object object) {
        super.removeKnownObject(object);
        if (this.noTarget()) {
            this.removeAllKnownObjects();
            if (this.getAI() != null) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
            }
            this.returnHome();
        }
    }

    private void getHomeLocation() {
        this._homeX = this.getX();
        this._homeY = this.getY();
        this._homeZ = this.getZ();
        if (Config.DEBUG) {
            _log.finer(this.getObjectId() + ": Home location set to" + " X:" + this._homeX + " Y:" + this._homeY + " Z:" + this._homeZ);
        }
    }

    public void returnHome() {
        if (this.getDistance(this._homeX, this._homeY) > 40.0) {
            if (Config.DEBUG) {
                _log.fine(this.getObjectId() + ": moving hometo" + " X:" + this._homeX + " Y:" + this._homeY + " Z:" + this._homeZ);
            }
            this.clearAggroList();
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(this._homeX, this._homeY, this._homeZ, 0));
        }
    }

    public void OnSpawn() {
        this._homeX = this.getX();
        this._homeY = this.getY();
        this._homeZ = this.getZ();
        if (Config.DEBUG) {
            _log.finer(this.getObjectId() + ": Home location set to" + " X:" + this._homeX + " Y:" + this._homeY + " Z:" + this._homeZ);
        }
    }

    public String getHtmlPath(int npcId, int val) {
        String pom = "";
        pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/guard/" + pom + ".htm";
    }

    public void onAction(L2PcInstance player) {
        if (this.getObjectId() != player.getTargetId()) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
            if (Config.DEBUG) {
                _log.fine(player.getObjectId() + ": Targetted guard " + this.getObjectId());
            }
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), 0);
            player.sendPacket(my);
            player.sendPacket(new ValidateLocation(this));
        } else if (this.containsTarget(player)) {
            if (Config.DEBUG) {
                _log.fine(player.getObjectId() + ": Attacked guard " + this.getObjectId());
            }
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
        } else {
            double distance = this.getDistance(player.getX(), player.getY());
            if (distance > 150.0) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
            } else {
                Random rnd = new Random();
                SocialAction sa = new SocialAction(this.getObjectId(), rnd.nextInt(8));
                this.broadcastPacket(sa);
                this.showChatWindow(player, 0);
                player.sendPacket(new ActionFailed());
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, null);
            }
        }
    }
}

