/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.L2WorldRegion;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.GetItem;

public abstract class L2Object {
    private static final Logger _log = Logger.getLogger(L2Object.class.getName());
    private int _objectId;
    private int _x;
    private int _y;
    private int _z;
    private L2WorldRegion _worldRegion;
    private int _polyid;
    private String _polytype;
    private boolean _hidden;

    public L2Object(int objectId) {
        this._objectId = objectId;
        if (!Config.COMPACTION) {
            IdFactory.getInstance().setObjectIDAsUsed(this._objectId);
        }
    }

    public final int hashCode() {
        return this._objectId;
    }

    public final int getObjectId() {
        return this._objectId;
    }

    public final int getX() {
        if (Config.ASSERT) assert (this._worldRegion != null || this._hidden);
        return this._x;
    }

    public final int getY() {
        if (Config.ASSERT) assert (this._worldRegion != null || this._hidden);
        return this._y;
    }

    public final int getZ() {
        if (Config.ASSERT) assert (this._worldRegion != null || this._hidden);
        return this._z;
    }

    public void setPolyInfo(String polytype, String polyid) {
        this._polytype = polytype;
        this._polyid = Integer.parseInt(polyid);
    }

    public final void setXYZ(int x, int y, int z) {
        if (Config.ASSERT) assert (this._worldRegion != null);
        this._x = x;
        this._y = y;
        this._z = z;
        try {
            if (L2World.getInstance().getRegion(this._x, this._y) != this._worldRegion) {
                this.updateCurrentWorldRegion();
            }
        }
        catch (Exception e) {
            _log.warning("Object Id at bad coords: (" + this._x + ", " + this._y + ").");
        }
    }

    public final void setXYZInvisible(int x, int y, int z) {
        if (Config.ASSERT) assert (this._worldRegion == null);
        this._x = x;
        this._y = y;
        this._z = z;
        this._hidden = true;
    }

    public boolean isPolymorphed() {
        return this._polytype != null;
    }

    public String getPolytype() {
        return this._polytype;
    }

    public int getPolyid() {
        return this._polyid;
    }

    public final boolean isVisible() {
        return this._worldRegion != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropMe(L2Character dropper, int x, int y, int z) {
        if (Config.ASSERT) assert (this instanceof L2ItemInstance);
        if (Config.ASSERT) assert (this._worldRegion == null);
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._hidden = false;
            this._x = x;
            this._y = y;
            this._z = z;
            this._worldRegion = L2World.getInstance().getRegion(this._x, this._y);
            this._worldRegion.addVisibleObject(this);
        }
        L2World.getInstance().addVisibleObject(this, this._worldRegion, dropper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void spawnMe(int x, int y, int z) {
        if (Config.ASSERT) assert (this._worldRegion == null);
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._hidden = false;
            this._x = x;
            this._y = y;
            this._z = z;
            this._worldRegion = L2World.getInstance().getRegion(this._x, this._y);
            L2World.getInstance().storeObject(this);
            this._worldRegion.addVisibleObject(this);
        }
        L2World.getInstance().addVisibleObject(this, this._worldRegion, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void spawnMe() {
        if (Config.ASSERT) assert (this._worldRegion == null && this._x != 0 && this._y != 0 && this._z != 0);
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._hidden = false;
            this._worldRegion = L2World.getInstance().getRegion(this._x, this._y);
            L2World.getInstance().storeObject(this);
            this._worldRegion.addVisibleObject(this);
        }
        L2World.getInstance().addVisibleObject(this, this._worldRegion, null);
    }

    public void toggleVisible() {
        if (this.isVisible()) {
            this.decayMe();
        } else {
            this.spawnMe();
        }
    }

    public void OnSpawn() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pickupMe(L2Character player) {
        if (Config.ASSERT) assert (this instanceof L2ItemInstance);
        if (Config.ASSERT) assert (this._worldRegion != null);
        L2WorldRegion oldregion = this._worldRegion;
        GetItem gi = new GetItem((L2ItemInstance)this, player.getObjectId());
        player.broadcastPacket(gi);
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._hidden = true;
            this._worldRegion = null;
        }
        L2World.getInstance().removeVisibleObject(this, oldregion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decayMe() {
        if (Config.ASSERT) assert (this._worldRegion != null);
        L2WorldRegion reg = this._worldRegion;
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._hidden = true;
            this._worldRegion = null;
        }
        L2World.getInstance().removeVisibleObject(this, reg);
    }

    public void onAction(L2PcInstance player) {
        player.sendPacket(new ActionFailed());
    }

    public void onActionShift(ClientThread client) {
        client.getActiveChar().sendPacket(new ActionFailed());
    }

    public void onForcedAttack(L2PcInstance player) {
        player.sendPacket(new ActionFailed());
    }

    public boolean addKnownObject(L2Object object, L2Character dropper) {
        return false;
    }

    public void removeKnownObject(L2Object object) {
    }

    public boolean knowsObject(L2Object object) {
        return false;
    }

    public void removeAllKnownObjects() {
    }

    public L2WorldRegion getCurrentWorldRegion() {
        return this._worldRegion;
    }

    public void updateCurrentWorldRegion() {
        if (!this.isVisible()) {
            return;
        }
        L2WorldRegion newRegion = L2World.getInstance().getRegion(this._x, this._y);
        if (newRegion != this._worldRegion) {
            this._worldRegion.removeVisibleObject(this);
            this._worldRegion = newRegion;
            this._worldRegion.addVisibleObject(this);
        }
    }

    public boolean withinZones(int[][] zoneList) {
        int x = this.getX();
        int y = this.getY();
        for (int i = 0; i < zoneList.length; ++i) {
            int x1 = zoneList[i][0];
            int y1 = zoneList[i][1];
            int x2 = zoneList[i][2];
            int y2 = zoneList[i][3];
            if (x < Math.min(x1, x2) || x > Math.max(x1, x2) || y < Math.min(y1, y2) || y > Math.max(y1, y2)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public abstract boolean isAutoAttackable(L2Character var1);

    public boolean isMarker() {
        return false;
    }

    public void refreshID() {
        int newObjectId = IdFactory.getInstance().getNextId();
        int oldObjectId = this.getObjectId();
        this._objectId = newObjectId;
        IdFactory.getInstance().releaseId(oldObjectId);
    }
}

