/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2TeleporterInstance;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public final class L2ObservationInstance
extends L2FolkInstance {
    private static Logger _log = Logger.getLogger(L2TeleporterInstance.class.getName());
    private ArrayList _tpLocs;
    private int _tpId;

    public L2ObservationInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        super.onBypassFeedback(player, command);
        if (command.startsWith("observeSiege")) {
            if (L2Siege.getSiege() > 0) {
                this.doObserve(player, command.substring(13));
            } else {
                player.sendMessage("You may only view castles during a siege");
            }
        } else if (command.startsWith("observe")) {
            this.doObserve(player, command.substring(8));
        }
    }

    public String getHtmlPath(int npcId, int val) {
        String pom = "";
        pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/observation/" + pom + ".htm";
    }

    public void onAction(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("Teleporter activated");
        }
        super.onAction(player);
    }

    private void doObserve(L2PcInstance player, String val) {
        StringTokenizer st = new StringTokenizer(val);
        int cost = Integer.parseInt(st.nextToken());
        int x = Integer.parseInt(st.nextToken());
        int y = Integer.parseInt(st.nextToken());
        int z = Integer.parseInt(st.nextToken());
        if (player.getAdena() >= cost) {
            player.reduceAdena(cost);
            player.enterObserverMode(x, y, z);
        } else {
            SystemMessage sm = new SystemMessage(279);
            player.sendPacket(sm);
        }
        player.sendPacket(new ActionFailed());
    }
}

