/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.CharTemplateTable;
import net.sf.l2j.gameserver.ClanTable;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.Connection;
import net.sf.l2j.gameserver.GmListTable;
import net.sf.l2j.gameserver.HennaTable;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.RecipeController;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.SkillTreeTable;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.ai.L2PlayerAI;
import net.sf.l2j.gameserver.handler.IItemHandler;
import net.sf.l2j.gameserver.handler.ItemHandler;
import net.sf.l2j.gameserver.lib.JBForth;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.model.Experience;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2CubicInstance;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2DropData;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2HennaInstance;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Macro;
import net.sf.l2j.gameserver.model.L2ManufactureList;
import net.sf.l2j.gameserver.model.L2MonsterInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Party;
import net.sf.l2j.gameserver.model.L2PetInstance;
import net.sf.l2j.gameserver.model.L2PlayableInstance;
import net.sf.l2j.gameserver.model.L2Radar;
import net.sf.l2j.gameserver.model.L2RecipeList;
import net.sf.l2j.gameserver.model.L2ShortCut;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2Summon;
import net.sf.l2j.gameserver.model.L2TradeList;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.MacroList;
import net.sf.l2j.gameserver.model.PcInventory;
import net.sf.l2j.gameserver.model.PcWarehouse;
import net.sf.l2j.gameserver.model.Race;
import net.sf.l2j.gameserver.model.ShortCuts;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.model.Warehouse;
import net.sf.l2j.gameserver.model.quest.Quest;
import net.sf.l2j.gameserver.model.quest.QuestState;
import net.sf.l2j.gameserver.model.waypoint.WayPointNode;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.ChangeWaitType;
import net.sf.l2j.gameserver.serverpackets.CharInfo;
import net.sf.l2j.gameserver.serverpackets.DeleteObject;
import net.sf.l2j.gameserver.serverpackets.DoorInfo;
import net.sf.l2j.gameserver.serverpackets.DoorStatusUpdate;
import net.sf.l2j.gameserver.serverpackets.DropItem;
import net.sf.l2j.gameserver.serverpackets.HennaInfo;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.MagicSkillCanceld;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.NpcInfo;
import net.sf.l2j.gameserver.serverpackets.ObservationMode;
import net.sf.l2j.gameserver.serverpackets.ObservationReturn;
import net.sf.l2j.gameserver.serverpackets.PartySmallWindowUpdate;
import net.sf.l2j.gameserver.serverpackets.PetInfo;
import net.sf.l2j.gameserver.serverpackets.PetItemList;
import net.sf.l2j.gameserver.serverpackets.PrivateBuyListBuy;
import net.sf.l2j.gameserver.serverpackets.PrivateBuyListSell;
import net.sf.l2j.gameserver.serverpackets.PrivateStoreMsgSell;
import net.sf.l2j.gameserver.serverpackets.RecipeShopSellList;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.SocialAction;
import net.sf.l2j.gameserver.serverpackets.SpawnItem;
import net.sf.l2j.gameserver.serverpackets.SpawnItemPoly;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.StopMove;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.serverpackets.UserInfo;
import net.sf.l2j.gameserver.skills.Stats;
import net.sf.l2j.gameserver.templates.L2Henna;
import net.sf.l2j.gameserver.templates.L2Item;
import net.sf.l2j.gameserver.templates.L2PcTemplate;
import net.sf.l2j.gameserver.templates.L2Weapon;
import net.sf.l2j.gameserver.templates.L2WeaponType;
import net.sf.l2j.util.Point3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class L2PcInstance
extends L2PlayableInstance {
    private static final String DELETE_SKILL_FROM_CHAR = "DELETE FROM character_skills WHERE skill_id=? AND char_obj_id=?";
    private static final String ADD_NEW_SKILL = "INSERT INTO character_skills (char_obj_id,skill_id,skill_level,skill_name) values(?,?,?,?)";
    private static final String UPDATE_CHARACTER_SKILL_LEVEL = "UPDATE character_skills SET skill_level=? WHERE skill_id=? AND char_obj_id=?";
    private static final String GET_ALL_SKILLS_FOR_CHAR = "SELECT skill_id,skill_level FROM character_skills WHERE char_obj_id=?";
    private static final String COLUMN_SKILL_LEVEL = "skill_level";
    private static final String COLUMN_SKILL_ID = "skill_id";
    public static final int STORE_PRIVATE_NONE = 0;
    public static final int STORE_PRIVATE_SELL = 1;
    public static final int STORE_PRIVATE_BUY = 3;
    public static final int STORE_PRIVATE_MANUFACTURE = 5;
    private static final int[] EXPERTISE_LEVELS = new int[]{SkillTreeTable.getExpertiseLevel(0), SkillTreeTable.getExpertiseLevel(1), SkillTreeTable.getExpertiseLevel(2), SkillTreeTable.getExpertiseLevel(3), SkillTreeTable.getExpertiseLevel(4), SkillTreeTable.getExpertiseLevel(5)};
    private static Logger _log = Logger.getLogger(L2PcInstance.class.getName());
    private Connection _connection;
    private int _level;
    private int _charId = 199546;
    private int _exp;
    private int _expBeforeDeath = 0;
    private int _sp;
    private int _karma;
    private int _pvpKills;
    private int _pkKills;
    private int _pvpFlag;
    private int _recomHave;
    private int _recomLeft;
    private static final Random _rnd = new Random();
    private int _maxLoad;
    private int _deleteTimer;
    private boolean _inStoreMode;
    private PcInventory _inventory = new PcInventory(this);
    private PcWarehouse _warehouse = new PcWarehouse(this);
    private boolean _waitTypeSitting;
    private int _crestId;
    public JBForth jbf = new JBForth();
    private int _face;
    private int _hairStyle;
    private int _hairColor;
    private HashMap<String, QuestState> _quests = new HashMap();
    private ShortCuts _shortCuts = new ShortCuts(this);
    private MacroList _macroses = new MacroList(this);
    private int _allyId;
    private L2TradeList _tradeList;
    private L2ManufactureList _createList;
    private ArrayList<TradeItem> _sellList;
    private ArrayList<TradeItem> _buyList;
    private int _privatestore;
    private ClassId _skillLearningClassId;
    private L2HennaInstance[] _henna = new L2HennaInstance[3];
    private int _hennaSTR;
    private int _hennaINT;
    private int _hennaDEX;
    private int _hennaMEN;
    private int _hennaWIT;
    private int _hennaCON;
    private L2Summon _summon = null;
    public L2Radar radar;
    private boolean _partyMatchingAutomaticRegistration;
    private boolean _partyMatchingShowLevel;
    private boolean _partyMatchingShowClass;
    private String _partyMatchingMemo;
    private L2Party _party;
    private int _clanId;
    private L2Clan _clan;
    private boolean _clanLeader;
    private boolean _isInvul;
    private boolean _isGm;
    private int _accessLevel;
    public boolean _exploring = false;
    private L2PcInstance _currentTransactionRequester;
    private L2ItemInstance _arrowItem;
    private L2Weapon _fistsWeaponItem;
    private long _uptime;
    private String _accountName;
    public byte updateKnownCounter = 0;
    private Map<Integer, L2RecipeList> _recipebook = new TreeMap<Integer, L2RecipeList>();
    private int _mountType;
    int oldMaxHP;
    int oldMaxMP;
    int expertiseIndex;
    private L2ItemInstance _enchantScroll = null;
    private boolean _usingClanWarehouse;
    private boolean _isOnline = false;
    protected boolean _inventoryDisable = false;
    protected HashMap<Integer, L2CubicInstance> _cubics = new HashMap();
    private L2FolkInstance _lastFolkNpc = null;
    private boolean _isSilentMoving = false;
    private Future _taskAutoSoulShot = null;
    protected HashSet<Integer> _activeSoulShots = new HashSet();
    private boolean isPathNodeMode;
    private boolean isPathNodesVisible;
    private Map<WayPointNode, CopyOnWriteArrayList<WayPointNode>> pathNodeMap;
    private WayPointNode selectedNode;
    private int clanPrivileges;
    private boolean linkToggle = true;
    private int _invisible = 0;
    private int _obsX;
    private int _obsY;
    private int _obsZ;
    private boolean _observerMode = false;

    public static L2PcInstance create(int objectId, L2PcTemplate template, String accountName, String name, int hairStyle, int hairColor, int face) {
        L2PcInstance player = new L2PcInstance(objectId, template, accountName);
        player.setName(name);
        player.setHairStyle(hairStyle);
        player.setHairColor(hairColor);
        player.setFace(face);
        boolean ok = player.createDb();
        if (!ok) {
            return null;
        }
        return player;
    }

    public static L2PcInstance load(int objectId) {
        return L2PcInstance.restore(objectId);
    }

    private L2PcInstance(int objectId, L2PcTemplate template, String accountName) {
        super(objectId, template);
        this._accountName = accountName;
        this._level = 1;
    }

    private L2PcInstance(int objectId, L2PcTemplate template) {
        this(objectId, template, null);
        this._ai = new L2PlayerAI(new AIAccessor());
        this.radar = new L2Radar(this);
        this.restoreSkills();
        this.getInventory().restore();
        this._macroses.restore();
        this._shortCuts.restore();
        this.restoreHenna();
    }

    @Override
    public final L2PcTemplate getTemplate() {
        return (L2PcTemplate)this._template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        if (this._ai == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._ai == null) {
                    this._ai = new L2PlayerAI(new AIAccessor());
                }
            }
        }
        return this._ai;
    }

    public void explore() {
        if (!this._exploring) {
            return;
        }
        if (this.getMountType() == 2) {
            return;
        }
        int x = this.getX() + L2PcInstance.getRnd().nextInt(6000) - 3000;
        int y = this.getY() + L2PcInstance.getRnd().nextInt(6000) - 3000;
        if (x > 194327) {
            x = 194327;
        }
        if (x < -127900) {
            x = -127900;
        }
        if (y > 259536) {
            y = 259536;
        }
        if (y < -30000) {
            y = -30000;
        }
        int z = this.getZ();
        L2CharPosition pos = new L2CharPosition(x, y, z, 0);
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos);
    }

    @Override
    public final int getLevel() {
        return this._level;
    }

    public int getSex() {
        return this.getTemplate().isMale ? 0 : 1;
    }

    public int getFace() {
        return this._face;
    }

    public void setFace(int face) {
        this._face = face;
    }

    public int getHairColor() {
        return this._hairColor;
    }

    public void setHairColor(int hairColor) {
        this._hairColor = hairColor;
    }

    public int getHairStyle() {
        return this._hairStyle;
    }

    public void setHairStyle(int hairStyle) {
        this._hairStyle = hairStyle;
    }

    public void isInStoreMode(boolean b) {
        this._inStoreMode = b;
    }

    @Override
    public int getMaxHp() {
        int val = super.getMaxHp();
        if (val != this.oldMaxHP) {
            this.oldMaxHP = val;
            if (this.getCurrentHp() != (double)val) {
                this.setCurrentHp(this.getCurrentHp());
            }
        }
        return val;
    }

    @Override
    public int getMaxMp() {
        int val = super.getMaxMp();
        if (val != this.oldMaxMP) {
            this.oldMaxMP = val;
            if (this.getCurrentMp() != (double)val) {
                this.setCurrentMp(this.getCurrentMp());
            }
        }
        return val;
    }

    public void logout() {
        this.clearPathNodes();
        this._connection.close();
    }

    public L2RecipeList[] getRecipeBook() {
        return this._recipebook.values().toArray(new L2RecipeList[this._recipebook.values().size()]);
    }

    public void registerRecipeList(L2RecipeList recipe) {
        this._recipebook.put(recipe.getId(), recipe);
    }

    public void unregisterRecipeList(int RecipeID) {
        if (this._recipebook.containsKey(RecipeID)) {
            this._recipebook.remove(RecipeID);
        } else {
            _log.warning("Attempted to remove unknown RecipeList" + RecipeID);
        }
    }

    public void fillQuestDrops(L2NpcInstance npc, ArrayList<L2DropData> drops) {
        for (QuestState qs : this._quests.values()) {
            qs.fillQuestDrops(npc, drops);
        }
    }

    public QuestState getQuestState(String quest) {
        return this._quests.get(quest);
    }

    public void setQuestState(QuestState qs) {
        this._quests.put(qs.getQuest().name, qs);
    }

    public void delQuestState(String quest) {
        this._quests.remove(quest);
    }

    public Quest[] getAllActiveQuests() {
        ArrayList<Quest> quests = new ArrayList<Quest>();
        for (QuestState qs : this._quests.values()) {
            if (qs.isCompleted() && !Config.DEVELOPER || !qs.isStarted() && !Config.DEVELOPER) continue;
            quests.add(qs.getQuest());
        }
        return quests.toArray(new Quest[quests.size()]);
    }

    public QuestState[] getQuestsForTalk(int npcId) {
        QuestState[] states = null;
        for (QuestState qs : this._quests.values()) {
            if (!qs.waitsForTalk(npcId)) continue;
            if (states == null) {
                states = new QuestState[]{qs};
                continue;
            }
            int len = states.length;
            QuestState[] tmp = new QuestState[len + 1];
            for (int i = 0; i < len; ++i) {
                tmp[i] = states[i];
            }
            tmp[len] = qs;
            states = tmp;
        }
        return states;
    }

    public QuestState[] getQuestsForKills(int npcId) {
        QuestState[] states = null;
        for (QuestState qs : this._quests.values()) {
            if (!qs.waitsForKill(npcId)) continue;
            if (states == null) {
                states = new QuestState[]{qs};
                continue;
            }
            int len = states.length;
            QuestState[] tmp = new QuestState[len + 1];
            for (int i = 0; i < len; ++i) {
                tmp[i] = states[i];
            }
            tmp[len] = qs;
            states = tmp;
        }
        return states;
    }

    public QuestState processQuestEvent(String quest, String event) {
        QuestState qs;
        if (event == null) {
            event = "";
        }
        if ((qs = this.getQuestState(quest)) == null && event.length() == 0) {
            return null;
        }
        if (qs == null) {
            Quest q = Quest.findQuest(quest);
            if (q == null) {
                return null;
            }
            qs = q.newQuestState(this);
        }
        if (qs != null && qs.getQuest().notifyEvent(event, qs)) {
            this.showQuestWindow(quest, qs.getStateId());
        }
        return qs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showQuestWindow(String questId, String stateId) {
        FileInputStream fis = null;
        try {
            File f = new File(Config.DATAPACK_ROOT, "data/jscript/quests/" + questId + "/" + stateId + ".htm");
            if (f.exists()) {
                if (Config.DEBUG) {
                    _log.fine("Showing quest window for quest " + questId + " state " + stateId + " html path: " + f);
                }
                fis = new FileInputStream(f);
                byte[] raw = new byte[fis.available()];
                fis.read(raw);
                String content = new String(raw, "UTF-8");
                NpcHtmlMessage npcReply = new NpcHtmlMessage(5);
                npcReply.setHtml(content);
                this.sendPacket(npcReply);
            }
        }
        catch (Exception e) {
            _log.warning("problem with npc text " + e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
        }
        this.sendPacket(new ActionFailed());
    }

    public L2ShortCut[] getAllShortCuts() {
        return this._shortCuts.getAllShortCuts();
    }

    public L2ShortCut getShortCut(int slot, int page) {
        return this._shortCuts.getShortCut(slot, page);
    }

    public void registerShortCut(L2ShortCut shortcut) {
        this._shortCuts.registerShortCut(shortcut);
    }

    public void deleteShortCut(int slot, int page) {
        this._shortCuts.deleteShortCut(slot, page);
    }

    public void registerMacro(L2Macro macro) {
        this._macroses.registerMacro(macro);
    }

    public void deleteMacro(int id) {
        this._macroses.deleteMacro(id);
    }

    public MacroList getMacroses() {
        return this._macroses;
    }

    public void setPvpFlag(int pvpFlag) {
        this._pvpFlag = pvpFlag;
    }

    public boolean getCanCraft() {
        return this.getSkillLevel(172) >= 1;
    }

    public int getPkKills() {
        return this._pkKills;
    }

    public void setPkKills(int pkKills) {
        this._pkKills = pkKills;
    }

    public int getDeleteTimer() {
        return this._deleteTimer;
    }

    public void setDeleteTimer(int deleteTimer) {
        this._deleteTimer = deleteTimer;
    }

    public int getCurrentLoad() {
        return this._inventory.getTotalWeight();
    }

    public int getRecomHave() {
        return this._recomHave;
    }

    public int setRecomHave(int recom) {
        if (recom > 255) {
            recom = 255;
        }
        this._recomHave = recom;
        return this._recomHave;
    }

    public int getRecomLeft() {
        return this._recomLeft;
    }

    public int setRecomLeft(int recom) {
        this._recomLeft = recom;
        return this._recomLeft;
    }

    public int getKarma() {
        return this._karma;
    }

    public void setKarma(int karma) {
        this._karma = karma;
        if (karma > 0) {
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(StatusUpdate.KARMA, karma);
            this.broadcastPacket(su);
        }
    }

    public int getMaxLoad() {
        return (int)this.calcStat(Stats.MAX_LOAD, this._maxLoad, this, null);
    }

    public void setMaxLoad(int maxLoad) {
        this._maxLoad = maxLoad;
    }

    public void refreshOverloaded() {
        if (this.getMaxLoad() > 0) {
            this.setOverloaded(this.getCurrentLoad() > this.getMaxLoad());
        }
    }

    public int getPvpKills() {
        return this._pvpKills;
    }

    public void setPvpKills(int pvpKills) {
        this._pvpKills = pvpKills;
    }

    public ClassId getClassId() {
        return this.getTemplate().classId;
    }

    public void setClassId(int Id) {
        L2PcTemplate t = CharTemplateTable.getInstance().getTemplate(Id, this.getSex() == 1);
        if (t == null) {
            _log.severe("Missing template for classId: " + Id);
            throw new Error();
        }
        this.setTemplate(t);
    }

    public int getExp() {
        return this._exp;
    }

    public void setEnchantScroll(L2ItemInstance scroll) {
        this._enchantScroll = scroll;
    }

    public L2ItemInstance getEnchantScroll() {
        return this._enchantScroll;
    }

    public void setFistsWeaponItem(L2Weapon weaponItem) {
        this._fistsWeaponItem = weaponItem;
    }

    public L2Weapon getFistsWeaponItem() {
        return this._fistsWeaponItem;
    }

    public L2Weapon findFistsWeaponItem(int classId) {
        L2Weapon weaponItem = null;
        if (classId >= 0 && classId <= 9) {
            L2Item temp = ItemTable.getInstance().getTemplate(246);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 10 && classId <= 17) {
            L2Item temp = ItemTable.getInstance().getTemplate(251);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 18 && classId <= 24) {
            L2Item temp = ItemTable.getInstance().getTemplate(244);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 25 && classId <= 30) {
            L2Item temp = ItemTable.getInstance().getTemplate(249);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 31 && classId <= 37) {
            L2Item temp = ItemTable.getInstance().getTemplate(245);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 38 && classId <= 43) {
            L2Item temp = ItemTable.getInstance().getTemplate(250);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 44 && classId <= 48) {
            L2Item temp = ItemTable.getInstance().getTemplate(248);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 49 && classId <= 52) {
            L2Item temp = ItemTable.getInstance().getTemplate(252);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 53 && classId <= 57) {
            L2Item temp = ItemTable.getInstance().getTemplate(247);
            weaponItem = (L2Weapon)temp;
        }
        return weaponItem;
    }

    @Override
    public void addExpAndSp(int addToExp, int addToSp) {
        int max_xp;
        if (Config.DEBUG) {
            _log.fine("adding " + addToExp + " exp and " + addToSp + " sp to " + this.getName());
        }
        if (this._exp > Experience.LEVEL[76]) {
            this._exp = Experience.LEVEL[76];
        }
        this._exp = addToExp > (max_xp = Experience.LEVEL[76] - this._exp) ? (this._exp += max_xp) : (this._exp += addToExp);
        this._sp += addToSp;
        if (this._exp != 0 || this.isGM()) {
            int karmaRemove = addToExp;
            int xpDivi = Config.KARMA_XP_DIVIDER;
            if ((karmaRemove /= xpDivi) < 0) {
                karmaRemove = 1;
            }
            this._karma -= karmaRemove;
            if (Config.DEBUG) {
                _log.fine("removed " + karmaRemove + " karma from " + this.getName());
            }
        }
        if (this._karma < 0) {
            this._karma = 0;
        }
        StatusUpdate su = new StatusUpdate(this.getObjectId());
        su.addAttribute(StatusUpdate.EXP, this._exp);
        su.addAttribute(StatusUpdate.SP, this._sp);
        su.addAttribute(StatusUpdate.KARMA, this._karma);
        this.sendPacket(su);
        SystemMessage sm = new SystemMessage(95);
        sm.addNumber(addToExp);
        sm.addNumber(addToSp);
        this.sendPacket(sm);
        if (this._exp >= Experience.LEVEL[this.getLevel() + 1] && this._exp < Experience.LEVEL[76]) {
            SocialAction sa = new SocialAction(this.getObjectId(), 15);
            this.broadcastPacket(sa);
        }
        while (this._exp >= Experience.LEVEL[this.getLevel() + 1] && this._exp < Experience.LEVEL[76]) {
            this.increaseLevel();
            this.sendPacket(new UserInfo(this));
        }
    }

    private void rewardSkills() {
        int lvl = this.getLevel();
        if (lvl == 5) {
            L2Skill skill = SkillTable.getInstance().getInfo(194, 1);
            skill = this.removeSkill(skill);
            if (Config.DEBUG && skill != null) {
                _log.fine("removed skill 'Lucky' from " + this.getName());
            }
        }
        for (int i = 0; i < EXPERTISE_LEVELS.length; ++i) {
            if (lvl < EXPERTISE_LEVELS[i]) continue;
            this.expertiseIndex = i;
        }
        if (this.expertiseIndex > 0) {
            L2Skill skill = SkillTable.getInstance().getInfo(239, this.expertiseIndex);
            this.addSkill(skill);
            if (Config.DEBUG) {
                _log.fine("awarded " + this.getName() + " with new expertise.");
            }
        } else if (Config.DEBUG) {
            _log.fine("No skills awarded at lvl: " + lvl);
        }
        this.refreshOverloaded();
    }

    public void setExp(int exp) {
        if (exp < 0) {
            exp = 0;
        }
        this._exp = exp;
    }

    public Race getRace() {
        return this.getTemplate().race;
    }

    public int getSp() {
        return this._sp;
    }

    public void setSp(int sp) {
        if (sp < 0) {
            sp = 0;
        }
        this._sp = sp;
    }

    public int getPvpFlag() {
        return this._pvpFlag;
    }

    public int getClanId() {
        return this._clanId;
    }

    public int getClanCrestId() {
        if (this._clan != null && this._clan.hasCrest()) {
            return this._clanId;
        }
        return 0;
    }

    public PcInventory getInventory() {
        return this._inventory;
    }

    @Override
    public void removeItemFromInventory(L2ItemInstance item, int count) {
        L2ItemInstance item2 = this.getInventory().destroyItem(item.getObjectId(), count);
        if (item2 == null) {
            return;
        }
        InventoryUpdate iu = new InventoryUpdate();
        if (item2.getCount() == 0) {
            iu.addRemovedItem(item2);
        } else {
            iu.addModifiedItem(item2);
        }
        this.sendPacket(iu);
    }

    public void removeItemFromShortCut(int objectId) {
        this._shortCuts.deleteShortCutByObjectId(objectId);
    }

    public boolean isSitting() {
        return this._waitTypeSitting;
    }

    public void sitDown() {
        if (!this._waitTypeSitting && !this.isAttackingDisabled()) {
            this._waitTypeSitting = true;
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_REST);
            this.broadcastPacket(new ChangeWaitType(this, false));
        }
    }

    public void standUp() {
        if (this._waitTypeSitting && !this._inStoreMode) {
            this._waitTypeSitting = false;
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            this.broadcastPacket(new ChangeWaitType(this, true));
        }
    }

    public Warehouse getWarehouse() {
        return this._warehouse;
    }

    public int getCharId() {
        return this._charId;
    }

    public void setCharId(int charId) {
        this._charId = charId;
    }

    public int getAdena() {
        return this._inventory.getAdena();
    }

    public void reduceAdena(int adena) {
        this._inventory.reduceAdena(adena);
    }

    public void addAdena(int adena) {
        this._inventory.addAdena(adena);
    }

    public Connection getNetConnection() {
        return this._connection;
    }

    public void setNetConnection(Connection connection) {
        this._connection = connection;
    }

    public void closeNetConnection() {
        this._connection.close();
    }

    public int getCrestId() {
        return this._crestId;
    }

    public void setCrestId(int crestId) {
        this._crestId = crestId;
    }

    @Override
    public void onAction(L2PcInstance player) {
        if (player.isConfused()) {
            ActionFailed af = new ActionFailed();
            player.sendPacket(af);
        }
        if (player.getTarget() != this) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), 0);
            player.sendPacket(my);
        } else if (this.getPrivateStoreType() != 0) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
        } else if (this.isAutoAttackable(player)) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
        } else {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, this);
        }
    }

    @Override
    public void broadcastStatusUpdate() {
        super.broadcastStatusUpdate();
        StatusUpdate su = new StatusUpdate(this.getObjectId());
        su.addAttribute(StatusUpdate.CUR_HP, (int)this.getCurrentHp());
        su.addAttribute(StatusUpdate.CUR_MP, (int)this.getCurrentMp());
        su.addAttribute(StatusUpdate.CUR_CP, (int)this.getCurrentCp());
        su.addAttribute(StatusUpdate.MAX_CP, this.getMaxCp());
        this.sendPacket(su);
        if (this.isInParty()) {
            PartySmallWindowUpdate update2 = new PartySmallWindowUpdate(this);
            this.getParty().broadcastToPartyMembers(this, update2);
        }
    }

    public final void broadcastUserInfo() {
        UserInfo ui = new UserInfo(this);
        this.sendPacket(ui);
        CharInfo info = new CharInfo(this);
        if (Config.DEBUG) {
            _log.fine("players to notify:" + this.getKnownPlayers().size() + " packet:" + info.getType());
        }
        this.broadcastPacketToOthers(info);
    }

    public int getAllyId() {
        return this._allyId;
    }

    public void setAllyId(int allyId) {
        this._allyId = allyId;
    }

    @Override
    protected void onHitTimer(L2Character target, int damage, boolean crit, boolean miss, boolean soulshot, boolean shld) {
        super.onHitTimer(target, damage, crit, miss, soulshot, shld);
    }

    @Override
    public void sendPacket(ServerBasePacket packet) {
        try {
            if (this._connection != null) {
                this._connection.sendPacket(packet);
            }
        }
        catch (Exception e) {
            _log.log(Level.INFO, "", e);
        }
    }

    public void doInteract(L2Character target) {
        if (target instanceof L2PcInstance) {
            L2PcInstance temp = (L2PcInstance)target;
            this.sendPacket(new ActionFailed());
            if (temp.getPrivateStoreType() == 1) {
                this.sendPacket(new PrivateBuyListSell(this, temp));
            } else if (temp.getPrivateStoreType() == 3) {
                this.sendPacket(new PrivateBuyListBuy(temp, this));
            } else if (temp.getPrivateStoreType() == 5) {
                this.sendPacket(new RecipeShopSellList(this, temp));
            }
        } else if (target != null) {
            target.onAction(this);
        }
    }

    public void doAutoLoot(L2ItemInstance target) {
        if (!this.isInParty()) {
            SystemMessage smsg;
            if (target.getItemId() == 57) {
                smsg = new SystemMessage(28);
                smsg.addNumber(target.getCount());
                this.sendPacket(smsg);
            } else {
                smsg = new SystemMessage(29);
                smsg.addNumber(target.getCount());
                smsg.addItemName(target.getItemId());
                this.sendPacket(smsg);
            }
            L2ItemInstance target2 = this.getInventory().addItem(target);
            InventoryUpdate iu = new InventoryUpdate();
            if (target2.getLastChange() == 1) {
                iu.addNewItem(target);
            } else {
                iu.addModifiedItem(target2);
            }
            this.sendPacket(iu);
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(StatusUpdate.CUR_LOAD, this.getCurrentLoad());
            this.sendPacket(su);
        } else if (target.getItemId() == 57) {
            this.getParty().distributeAdena(target);
        } else {
            this.getParty().distributeItem(this, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPickupItem(L2Object object) {
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        if (!(object instanceof L2ItemInstance)) {
            _log.warning("trying to pickup wrong target." + this.getTarget());
            return;
        }
        L2ItemInstance target = (L2ItemInstance)object;
        this.sendPacket(new ActionFailed());
        StopMove sm = new StopMove(this.getObjectId(), this.getX(), this.getY(), this.getZ(), this.getHeading());
        if (Config.DEBUG) {
            _log.fine("pickup pos: " + target.getX() + " " + target.getY() + " " + target.getZ());
        }
        this.sendPacket(sm);
        L2ItemInstance l2ItemInstance = target;
        synchronized (l2ItemInstance) {
            if (!target.isVisible()) {
                this.sendPacket(new ActionFailed());
                return;
            }
            target.pickupMe(this);
        }
        if (!this.isInParty()) {
            SystemMessage smsg;
            if (target.getItemId() == 57) {
                smsg = new SystemMessage(28);
                smsg.addNumber(target.getCount());
                this.sendPacket(smsg);
            } else {
                smsg = new SystemMessage(29);
                smsg.addNumber(target.getCount());
                smsg.addItemName(target.getItemId());
                this.sendPacket(smsg);
            }
            L2ItemInstance target2 = this.getInventory().addItem(target);
            InventoryUpdate iu = new InventoryUpdate();
            if (target2.getLastChange() == 1) {
                iu.addNewItem(target);
            } else {
                iu.addModifiedItem(target2);
            }
            this.sendPacket(iu);
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(StatusUpdate.CUR_LOAD, this.getCurrentLoad());
            this.sendPacket(su);
        } else if (target.getItemId() == 57) {
            this.getParty().distributeAdena(target);
        } else {
            this.getParty().distributeItem(this, target);
        }
    }

    @Override
    public void setTarget(L2Object newTarget) {
        L2Object oldTarget;
        if (newTarget != null && !newTarget.isVisible()) {
            newTarget = null;
        }
        if ((oldTarget = this.getTarget()) != null) {
            if (oldTarget.equals(newTarget)) {
                return;
            }
            if (oldTarget instanceof L2Character) {
                ((L2Character)oldTarget).removeStatusListener(this);
            }
        }
        if (newTarget != null && newTarget instanceof L2Character) {
            ((L2Character)newTarget).addStatusListener(this);
        }
        super.setTarget(newTarget);
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return this.getInventory().getPaperdollItem(7);
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        if (weapon == null) {
            return this.getFistsWeaponItem();
        }
        return (L2Weapon)weapon.getItem();
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return this.getInventory().getPaperdollItem(8);
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        L2ItemInstance weapon = this.getSecondaryWeaponInstance();
        if (weapon == null) {
            return this.getFistsWeaponItem();
        }
        L2Item item = weapon.getItem();
        if (item instanceof L2Weapon) {
            return (L2Weapon)item;
        }
        return null;
    }

    @Override
    public void reduceCurrentHp(double i, L2Character attacker) {
        if (this.isInvul()) {
            return;
        }
        super.reduceCurrentHp(i, attacker);
        if (!this.isDead()) {
            if (attacker != null && attacker instanceof L2PcInstance) {
                ((L2PcInstance)attacker).checkPvP(this);
            }
            if (this.isSitting()) {
                this.standUp();
            }
        }
        if (attacker != null) {
            SystemMessage smsg = new SystemMessage(36);
            if (Config.DEBUG) {
                _log.fine("Attacker:" + attacker.getName());
            }
            if (attacker instanceof L2MonsterInstance || attacker instanceof L2NpcInstance) {
                int mobId = ((L2NpcInstance)attacker).getTemplate().npcId;
                if (Config.DEBUG) {
                    _log.fine("mob id:" + mobId);
                }
                smsg.addNpcName(mobId);
            } else {
                smsg.addString(attacker.getName());
            }
            smsg.addNumber((int)i);
            this.sendPacket(smsg);
        }
    }

    @Override
    protected void doDie(L2Character killer) {
        if (Config.ALT_GAME_DELEVEL && !this.isInsidePvPZone() && this.getSkillLevel(194) < 0) {
            this.deathPenalty();
        }
        if (this.getPet() != null) {
            this.getPet().unSummon(this);
        }
        if (killer != null) {
            if (!this.isInsidePvPZone() && killer.getObjectId() != this.getObjectId()) {
                if (killer instanceof L2PcInstance) {
                    L2PcInstance pk = (L2PcInstance)killer;
                    if (this.getPvpFlag() == 0) {
                        if (this.getKarma() == 0) {
                            int baseKarma;
                            int pkLVL = pk.getLevel();
                            int pkPKCount = pk.getPkKills();
                            int targLVL = this.getLevel();
                            int newKarma = baseKarma = Config.KARMA_MIN_KARMA;
                            int karmaLimit = Config.KARMA_MAX_KARMA;
                            int pkCountMulti = 0;
                            pkCountMulti = pkPKCount > 0 ? pkPKCount / 2 : 1;
                            if (pkCountMulti < 1) {
                                pkCountMulti = 1;
                            }
                            int lvlDiffMulti = 0;
                            lvlDiffMulti = pkLVL > targLVL ? pkLVL / targLVL : 1;
                            if (lvlDiffMulti < 1) {
                                lvlDiffMulti = 1;
                            }
                            newKarma *= pkCountMulti;
                            if ((newKarma *= lvlDiffMulti) < baseKarma) {
                                newKarma = baseKarma;
                            }
                            if (newKarma > karmaLimit) {
                                newKarma = karmaLimit;
                            }
                            pk.increaseKarma(newKarma);
                            int newPKCount = pk.getPkKills() + 1;
                            pk.setPkKills(newPKCount);
                            pk.sendPacket(new UserInfo(pk));
                        } else if (this.getKarma() > 0 && Config.KARMA_AWARD_PK_KILL) {
                            pk.setPvpKills(pk.getPvpKills() + 1);
                            pk.sendPacket(new UserInfo(pk));
                        }
                    } else if (this.getPvpFlag() != 0) {
                        pk.setPvpKills(pk.getPvpKills() + 1);
                        pk.sendPacket(new UserInfo(pk));
                    }
                }
                if (this.getKarma() > 0) {
                    double baseKarmaLost;
                    int finalKarma = 0;
                    double karmaLost = baseKarmaLost = (double)Config.KARMA_LOST_BASE;
                    double thisLVL = this.getLevel();
                    double tempMulti = thisLVL / 100.0;
                    karmaLost *= thisLVL;
                    karmaLost *= tempMulti;
                    finalKarma = (int)(karmaLost = (double)Math.round(karmaLost));
                    if (finalKarma < 0) {
                        finalKarma = 1;
                    }
                    this.redreaseKarma(finalKarma);
                }
            }
            int thisKarma = this.getKarma();
            int thisPKCount = this.getPkKills();
            if (thisKarma > 0) {
                Random rand = new Random();
                boolean dropEquip = Config.KARMA_DROP_EQUIPPED_ITEMS;
                boolean dropWeapon = Config.KARMA_DROP_EQUIPPED_WEAPONS;
                boolean dropPet = Config.KARMA_DROP_INVENTORY_PETS;
                boolean dropGM = Config.KARMA_DROP_GM;
                boolean gmStat = false;
                int dropConstant = Config.KARMA_DROP_CONSTANT;
                int dropPKLim = Config.KARMA_PK_LIMIT;
                int dropLim = Config.KARMA_DROP_ITEM_LIMIT;
                int randDropLim = Config.KARMA_RANDOM_DROP_LOCATION_LIMIT;
                double dropRate = Config.RATE_DROP_EQUIPMENT;
                double dropMin = Config.KARMA_DROPCHANCE_MINIMUM;
                double dropChanceINIT = Config.KARMA_DROPCHANCE_INITIAL_CHECK;
                double dropChanceEQUIP = Config.KARMA_DROPCHANCE_EQUIPMENT;
                double dropChanceEQUIP_WEAP = Config.KARMA_DROPCHANCE_EQUIPPED_WEAPON;
                double dropChanceEQUIP_OTHER = Config.KARMA_DROPCHANCE_EQUIPPED_OTHER;
                double dropChanceUEQUIP = Config.KARMA_DROPCHANCE_UNEQUIPPED_ITEMS;
                ArrayList<Object> petList = new ArrayList();
                ArrayList<Object> noDropList = new ArrayList();
                petList = Config.KARMA_LIST_NONDROPPABLE_PET_ITEMS;
                noDropList = Config.KARMA_LIST_NONDROPPABLE_ITEMS;
                if (!dropGM && this.isGM()) {
                    gmStat = true;
                }
                if (thisPKCount >= dropPKLim && !gmStat) {
                    double newDropLim;
                    double dropMultiplier = (double)(thisKarma / dropConstant) * dropRate;
                    if ((dropChanceINIT *= (double)Math.round(dropMultiplier)) > 100.0) {
                        dropChanceINIT = 100.0;
                    }
                    if (dropChanceINIT < 1.0) {
                        dropChanceINIT = dropMin;
                    }
                    if ((newDropLim = (double)(rand.nextInt(dropLim) * (int)dropMultiplier)) > (double)dropLim) {
                        newDropLim = dropLim;
                    }
                    if (newDropLim < 1.0) {
                        newDropLim = 1.0;
                    }
                    dropLim = (int)Math.round(newDropLim);
                    double chanceOfDrop = rand.nextInt(100);
                    if (chanceOfDrop <= dropChanceINIT) {
                        L2ItemInstance[] inv = this._inventory.getItems();
                        int countDrops = 0;
                        L2ItemInstance dropedItem = null;
                        InventoryUpdate iu = new InventoryUpdate();
                        for (int index = 0; index < inv.length && countDrops < dropLim; ++index) {
                            L2ItemInstance item = inv[index];
                            int drop_itemID = item.getObjectId();
                            int drop_ID = item.getItemId();
                            int drop_slot = item.getEquipSlot();
                            int drop_amount = item.getCount();
                            dropedItem = null;
                            if (!noDropList.contains(drop_ID)) {
                                if (drop_slot > 0 && dropEquip) {
                                    chanceOfDrop = rand.nextInt(100);
                                    if (chanceOfDrop <= dropChanceEQUIP) {
                                        chanceOfDrop = rand.nextInt(100);
                                        if (dropWeapon && (item.getEquipSlot() == 7 || item.getEquipSlot() == 14) && chanceOfDrop <= dropChanceEQUIP_WEAP) {
                                            ++countDrops;
                                            this.getInventory().unEquipItemInSlotAndRecord(drop_slot);
                                            this.getInventory().setPaperdollItem(drop_slot, null);
                                            dropedItem = this.getInventory().dropItem(drop_itemID, drop_amount);
                                        } else if (chanceOfDrop <= dropChanceEQUIP_OTHER && (item.getEquipSlot() != 7 || item.getEquipSlot() != 14)) {
                                            ++countDrops;
                                            this.getInventory().unEquipItemInSlotAndRecord(drop_slot);
                                            this.getInventory().setPaperdollItem(drop_slot, null);
                                            dropedItem = this.getInventory().dropItem(drop_itemID, drop_amount);
                                        }
                                    }
                                } else if (drop_slot > 0) {
                                    if (Config.DEBUG) {
                                        _log.fine(this.getName() + " | Item equipped...can not drop");
                                    }
                                } else {
                                    chanceOfDrop = rand.nextInt(100);
                                    if (chanceOfDrop <= dropChanceUEQUIP && 3 != item.getItem().getType2() && drop_ID != 57) {
                                        if (!dropPet) {
                                            if (!petList.contains(drop_ID)) {
                                                ++countDrops;
                                                dropedItem = this.getInventory().dropItem(drop_itemID, drop_amount);
                                            }
                                        } else {
                                            ++countDrops;
                                            dropedItem = this.getInventory().dropItem(drop_itemID, drop_amount);
                                        }
                                    }
                                }
                            }
                            if (dropedItem == null || drop_ID == 57) continue;
                            int randPlusMin = 1;
                            chanceOfDrop = rand.nextInt(randDropLim);
                            randPlusMin = rand.nextInt(2);
                            if (randPlusMin == 1) {
                                chanceOfDrop *= -1.0;
                            }
                            int newX = this.getX() + (int)Math.round(chanceOfDrop);
                            chanceOfDrop = rand.nextInt(randDropLim);
                            randPlusMin = rand.nextInt(2);
                            if (randPlusMin == 1) {
                                chanceOfDrop *= -1.0;
                            }
                            int newY = this.getY() + (int)Math.round(chanceOfDrop);
                            dropedItem.dropMe(this, newX, newY, this.getZ());
                            iu.addRemovedItem(item);
                            SystemMessage sm = new SystemMessage(298);
                            sm.addItemName(dropedItem.getItemId());
                            this.sendPacket(sm);
                            this.sendPacket(new UserInfo(this));
                        }
                        this.sendPacket(iu);
                        if (Config.DEBUG) {
                            if (countDrops > 0) {
                                _log.fine("Character (" + this.getName() + ") has died with " + thisKarma + " karma. # of items removed: " + countDrops + ".");
                            } else {
                                _log.fine("Character (" + this.getName() + ") has died with " + thisKarma + " karma and has not dropped any items!");
                            }
                        }
                    }
                }
            }
        }
        this.setPvpFlag(0);
        super.doDie(killer);
    }

    public void restoreExp() {
        if (this._expBeforeDeath != 0) {
            this._exp = this._expBeforeDeath;
            this._expBeforeDeath = 0;
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(StatusUpdate.EXP, this._exp);
            this.sendPacket(su);
        }
    }

    public void deathPenalty() {
        int lvl = this.getLevel();
        double percentLost = -0.07 * (double)lvl + 6.5;
        int lostExp = (int)Math.round((double)(Experience.LEVEL[lvl + 1] - Experience.LEVEL[lvl]) * percentLost / 100.0);
        this._expBeforeDeath = this.getExp();
        _log.fine("is dead, so exp to remove:" + lostExp);
        this.setExp(this.getExp() - lostExp);
        if (this.getExp() < Experience.LEVEL[lvl]) {
            this.decreaseLevel();
        }
        StatusUpdate su = new StatusUpdate(this.getObjectId());
        su.addAttribute(StatusUpdate.EXP, this.getExp());
        this.sendPacket(su);
    }

    public void setPartyMatchingAutomaticRegistration(boolean b) {
        this._partyMatchingAutomaticRegistration = b;
    }

    public void setPartyMatchingShowLevel(boolean b) {
        this._partyMatchingShowLevel = b;
    }

    public void setPartyMatchingShowClass(boolean b) {
        this._partyMatchingShowClass = b;
    }

    public void setPartyMatchingMemo(String memo) {
        this._partyMatchingMemo = memo;
    }

    public boolean isPartyMatchingAutomaticRegistration() {
        return this._partyMatchingAutomaticRegistration;
    }

    public String getPartyMatchingMemo() {
        return this._partyMatchingMemo;
    }

    public boolean isPartyMatchingShowClass() {
        return this._partyMatchingShowClass;
    }

    public boolean isPartyMatchingShowLevel() {
        return this._partyMatchingShowLevel;
    }

    public void setTransactionRequester(L2PcInstance requestor) {
        this._currentTransactionRequester = requestor;
    }

    public L2PcInstance getTransactionRequester() {
        return this._currentTransactionRequester;
    }

    public boolean isTransactionInProgress() {
        return this._currentTransactionRequester != null;
    }

    @Override
    protected int getDistanceToWatchObject(L2Object object) {
        return 4000;
    }

    @Override
    protected int getDistanceToForgetObject(L2Object object) {
        return 6000;
    }

    @Override
    public boolean addKnownObject(L2Object object, L2Character dropper) {
        boolean ret = super.addKnownObject(object, dropper);
        if (!ret) {
            return false;
        }
        if (object.isPolymorphed() && object.getPolytype().equals("item")) {
            this.sendPacket(new SpawnItemPoly(object));
        } else {
            if (object instanceof L2ItemInstance) {
                if (dropper != null) {
                    this.sendPacket(new DropItem((L2ItemInstance)object, dropper.getObjectId()));
                } else {
                    this.sendPacket(new SpawnItem((L2ItemInstance)object));
                }
            } else if (object instanceof L2DoorInstance) {
                this.sendPacket(new DoorInfo((L2DoorInstance)object));
                this.sendPacket(new DoorStatusUpdate((L2DoorInstance)object));
            } else if (object instanceof L2NpcInstance) {
                this.sendPacket(new NpcInfo((L2NpcInstance)object, (L2Character)this));
            } else if (object instanceof L2Summon) {
                L2Summon summon = (L2Summon)object;
                if (this.equals(summon.getOwner())) {
                    this.sendPacket(new PetInfo(summon));
                    if (summon instanceof L2PetInstance) {
                        this.sendPacket(new PetItemList((L2PetInstance)summon));
                    }
                } else {
                    this.sendPacket(new NpcInfo(summon, (L2Character)this));
                }
            } else if (object instanceof L2PcInstance) {
                L2PcInstance otherPlayer = (L2PcInstance)object;
                this.sendPacket(new CharInfo(otherPlayer));
                if ((otherPlayer.getPrivateStoreType() == 3 || otherPlayer.getPrivateStoreType() == 1 || otherPlayer.getPrivateStoreType() == 5) && otherPlayer.getTradeList() != null) {
                    this.sendPacket(new PrivateStoreMsgSell(otherPlayer));
                }
            }
            if (object instanceof L2Character) {
                L2Character obj = (L2Character)object;
                obj.getAI().describeStateToPlayer(this);
            }
        }
        return ret;
    }

    @Override
    public void removeKnownObject(L2Object object) {
        if (this.knowsObject(object)) {
            super.removeKnownObject(object);
            this.sendPacket(new DeleteObject(object));
        }
    }

    public void increaseLevel() {
        if (Config.DEBUG) {
            _log.finest("increasing level of " + this.getName());
        }
        if (this._level < 75) {
            ++this._level;
        }
        this.sendPacket(new SystemMessage(96));
        StatusUpdate su = new StatusUpdate(this.getObjectId());
        su.addAttribute(StatusUpdate.LEVEL, this._level);
        su.addAttribute(StatusUpdate.MAX_HP, this.getMaxHp());
        su.addAttribute(StatusUpdate.MAX_MP, this.getMaxMp());
        this.sendPacket(su);
        this.setCurrentHpMp(this.getMaxHp(), this.getMaxMp());
        if (this.isInParty()) {
            this.getParty().recalculatePartyLevel();
        }
        switch (this.getLevel()) {
            case 10: {
                this.setRecomLeft(this.getRecomLeft() + 3);
                break;
            }
            case 20: {
                this.setRecomLeft(this.getRecomLeft() + 3);
                break;
            }
            case 30: {
                this.setRecomLeft(this.getRecomLeft() + 2);
                break;
            }
            case 40: {
                this.setRecomLeft(this.getRecomLeft() + 2);
                break;
            }
            case 50: {
                this.setRecomLeft(this.getRecomLeft() + 3);
                break;
            }
            case 60: {
                this.setRecomLeft(this.getRecomLeft() + 5);
                break;
            }
            case 70: {
                this.setRecomLeft(this.getRecomLeft() + 7);
                break;
            }
            case 75: {
                this.setRecomLeft(this.getRecomLeft() + 9);
            }
        }
        this.rewardSkills();
    }

    public void decreaseLevel() {
        switch (this.getLevel()) {
            case 10: {
                this.setRecomLeft(this.getRecomLeft() - 3);
                break;
            }
            case 20: {
                this.setRecomLeft(this.getRecomLeft() - 3);
                break;
            }
            case 30: {
                this.setRecomLeft(this.getRecomLeft() - 2);
                break;
            }
            case 40: {
                this.setRecomLeft(this.getRecomLeft() - 2);
                break;
            }
            case 50: {
                this.setRecomLeft(this.getRecomLeft() - 3);
                break;
            }
            case 60: {
                this.setRecomLeft(this.getRecomLeft() - 5);
                break;
            }
            case 70: {
                this.setRecomLeft(this.getRecomLeft() - 7);
                break;
            }
            case 75: {
                this.setRecomLeft(this.getRecomLeft() - 9);
            }
        }
        if (this._level == 1) {
            return;
        }
        if (Config.DEBUG) {
            _log.finest("decreasing level of " + this.getName());
        }
        --this._level;
        StatusUpdate su = new StatusUpdate(this.getObjectId());
        su.addAttribute(StatusUpdate.LEVEL, this._level);
        su.addAttribute(StatusUpdate.MAX_HP, this.getMaxHp());
        su.addAttribute(StatusUpdate.MAX_MP, this.getMaxMp());
        this.sendPacket(su);
        if (this.isInParty()) {
            this.getParty().recalculatePartyLevel();
        }
        this.rewardSkills();
    }

    public void stopAllTimers() {
        this.stopHpMpRegeneration();
    }

    @Override
    public L2Summon getPet() {
        return this._summon;
    }

    public void setPet(L2Summon summon) {
        this._summon = summon;
    }

    public void deleteMe() {
        if (this.inObserverMode()) {
            this.setXYZ(this._obsX, this._obsY, this._obsZ);
        }
        try {
            this.setOnlineStatus(false);
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "deletedMe()", t);
        }
        try {
            this.stopAllTimers();
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "deletedMe()", t);
        }
        try {
            RecipeController.getInstance().requestMakeItemAbort(this);
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "deletedMe()", t);
        }
        try {
            this.setTarget(null);
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "deletedMe()", t);
        }
        if (this.isVisible()) {
            try {
                this.decayMe();
            }
            catch (Throwable t) {
                _log.log(Level.SEVERE, "deletedMe()", t);
            }
        }
        if (this.isInParty()) {
            try {
                this.leaveParty();
            }
            catch (Throwable t) {
                _log.log(Level.SEVERE, "deletedMe()", t);
            }
        }
        if (this.getPet() != null) {
            try {
                this.getPet().unSummon(this);
            }
            catch (Throwable t) {
                _log.log(Level.SEVERE, "deletedMe()", t);
            }
        }
        if (this.getClanId() != 0 && this.getClan() != null) {
            try {
                this.getClan().getClanMember(this.getName()).setPlayerInstance(null);
            }
            catch (Throwable t) {
                _log.log(Level.SEVERE, "deletedMe()", t);
            }
        }
        if (this.getTransactionRequester() != null) {
            this.setTransactionRequester(null);
        }
        if (this.isGM()) {
            try {
                GmListTable.getInstance().deleteGm(this);
            }
            catch (Throwable t) {
                _log.log(Level.SEVERE, "deletedMe()", t);
            }
        }
        try {
            this.getInventory().deleteMe();
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "deletedMe()", t);
        }
        try {
            this.removeAllKnownObjects();
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "deletedMe()", t);
        }
        try {
            this.setNetConnection(null);
        }
        catch (Throwable t) {
            _log.log(Level.SEVERE, "deletedMe()", t);
        }
        this.clearPathNodes();
        L2World.getInstance().removeObject(this);
    }

    public float getExpertisePenalty(int grade) {
        if (this.expertiseIndex >= grade) {
            return 1.0f;
        }
        int d = EXPERTISE_LEVELS[grade] - this.getLevel();
        int dL = EXPERTISE_LEVELS[grade] - EXPERTISE_LEVELS[grade - 1];
        return 1.2f + 0.8f * (float)d / (float)dL;
    }

    @Override
    public float getWeaponExpertisePenalty() {
        L2Weapon wpn = this.getActiveWeaponItem();
        if (wpn == null) {
            return 1.0f;
        }
        int grade = wpn.getItemGrade();
        if (grade <= 0) {
            return 1.0f;
        }
        float penalty = this.getExpertisePenalty(grade);
        return penalty;
    }

    private float addPenalty(float scale, int ppd) {
        L2ItemInstance item = this.getInventory().getPaperdollItem(ppd);
        if (item == null) {
            return 0.0f;
        }
        int grade = item.getItem().getItemGrade();
        if (grade <= 0) {
            return 0.0f;
        }
        return scale * (this.getExpertisePenalty(grade) - 1.0f);
    }

    @Override
    public float getArmourExpertisePenalty() {
        float penalty = 1.0f;
        penalty += this.addPenalty(0.2f, 6);
        penalty += this.addPenalty(0.2f, 9);
        penalty += this.addPenalty(0.2f, 12);
        penalty += this.addPenalty(0.5f, 11);
        return penalty += this.addPenalty(0.8f, 10);
    }

    public void setTradeList(L2TradeList x) {
        this._tradeList = x;
    }

    public L2TradeList getTradeList() {
        return this._tradeList;
    }

    public void setSellList(ArrayList<TradeItem> x) {
        this._sellList = x;
    }

    public ArrayList<TradeItem> getSellList() {
        return this._sellList;
    }

    public L2ManufactureList getCreateList() {
        return this._createList;
    }

    public void setCreateList(L2ManufactureList x) {
        this._createList = x;
    }

    public void setBuyList(ArrayList<TradeItem> x) {
        this._buyList = x;
    }

    public ArrayList<TradeItem> getBuyList() {
        return this._buyList;
    }

    public void setPrivateStoreType(int type) {
        this._privatestore = type;
    }

    public int getPrivateStoreType() {
        return this._privatestore;
    }

    public void setSkillLearningClassId(ClassId classId) {
        this._skillLearningClassId = classId;
    }

    public ClassId getSkillLearningClassId() {
        return this._skillLearningClassId;
    }

    public void setClan(L2Clan clan) {
        this._clan = clan;
        if (clan == null) {
            this._clanId = 0;
            this._clanLeader = false;
            return;
        }
        if (!clan.isMember(this.getName())) {
            this.setClan(null);
            this.setTitle("");
            return;
        }
        this._clanId = clan.getClanId();
        this._clanLeader = this.getObjectId() == clan.getLeaderId();
        this.setTitle("");
    }

    public L2Clan getClan() {
        return this._clan;
    }

    public boolean isClanLeader() {
        return this._clanLeader;
    }

    @Override
    protected void reduceArrowCount() {
        L2ItemInstance arrows = this.getInventory().destroyItem(this.getInventory().getPaperdollObjectId(8), 1);
        if (Config.DEBUG) {
            _log.fine("arrow count:" + (arrows == null ? 0 : arrows.getCount()));
        }
        if (arrows == null || arrows.getCount() == 0) {
            this.getInventory().unEquipItemInSlot(8);
            this._arrowItem = null;
            if (Config.DEBUG) {
                _log.fine("removed arrows count");
            }
            this.sendPacket(new ItemList(this, false));
        } else {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(arrows);
            this.sendPacket(iu);
        }
    }

    @Override
    protected boolean checkAndEquipArrows() {
        if (this.getInventory().getPaperdollItem(8) == null) {
            this._arrowItem = this.getInventory().findArrowForBow(this.getActiveWeaponItem());
            if (this._arrowItem != null) {
                this.getInventory().setPaperdollItem(8, this._arrowItem);
                ItemList il = new ItemList(this, false);
                this.sendPacket(il);
            }
        } else {
            this._arrowItem = this.getInventory().getPaperdollItem(8);
        }
        return this._arrowItem != null;
    }

    @Override
    public boolean isUsingDualWeapon() {
        L2Weapon weaponItem = this.getActiveWeaponItem();
        if (weaponItem.getItemType() == L2WeaponType.DUAL) {
            return true;
        }
        if (weaponItem.getItemType() == L2WeaponType.DUALFIST) {
            return true;
        }
        if (weaponItem.getItemId() == 248) {
            return true;
        }
        return weaponItem.getItemId() == 252;
    }

    public void setUptime(long time) {
        this._uptime = time;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this._uptime;
    }

    public void setIsInvul(boolean b) {
        this._isInvul = b;
    }

    public boolean isInvul() {
        return this._isInvul;
    }

    public boolean isInParty() {
        return this._party != null;
    }

    public void setParty(L2Party party) {
        this._party = party;
    }

    public void joinParty(L2Party party) {
        if (party != null) {
            party.addPartyMember(this);
            this._party = party;
        }
    }

    public void leaveParty() {
        if (this.isInParty()) {
            this._party.removePartyMember(this);
            this._party = null;
        }
    }

    public L2Party getParty() {
        return this._party;
    }

    public void setIsGM(boolean status) {
        this._isGm = status;
    }

    public boolean isGM() {
        return this._isGm;
    }

    public void cancelCastMagic() {
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        this.enableAllSkills();
        MagicSkillCanceld msc = new MagicSkillCanceld(this.getObjectId());
        this.broadcastPacket(msc);
    }

    public void setAccessLevel(int level) {
        this._accessLevel = level;
        if (this._accessLevel > 0 || Config.EVERYBODY_HAS_ADMIN_RIGHTS) {
            this.setIsGM(true);
        }
    }

    public int getAccessLevel() {
        if (Config.EVERYBODY_HAS_ADMIN_RIGHTS) {
            return 200;
        }
        return this._accessLevel;
    }

    @Override
    public double getLevelMod() {
        return (89.0 + (double)this.getLevel()) / 100.0;
    }

    @Override
    public void updateStats() {
        super.updateStats();
        this.broadcastUserInfo();
        this.updateKarma(1);
    }

    public void setKarmaFlag(int id, int flag) {
        StatusUpdate su = new StatusUpdate(this.getObjectId());
        su.addAttribute(StatusUpdate.KARMA, this._karma);
        su.addAttribute(StatusUpdate.PVP_FLAG, flag);
        this.sendPacket(su);
        this.broadcastPacket(su);
    }

    public void updateKarma(int id) {
        StatusUpdate su = new StatusUpdate(this.getObjectId());
        su.addAttribute(StatusUpdate.KARMA, this._karma);
        this.sendPacket(su);
        this.broadcastPacket(su);
    }

    public void setOnlineStatus(boolean isOnline) {
        this._isOnline = isOnline;
        if (isOnline) {
            GmListTable.getInstance().addGm(this);
            this.jbf.setPlayer(this);
            SystemMessage sm = new SystemMessage(614);
            sm.addString(this.jbf.exec("on-player-start"));
            this.sendPacket(sm);
        } else {
            SystemMessage sm = new SystemMessage(614);
            sm.addString(this.jbf.exec("on-player-exit"));
            this.sendPacket(sm);
            GmListTable.getInstance().deleteGm(this);
        }
        this.updateOnlineStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOnlineStatus() {
        GmListTable.getInstance().deleteGm(this);
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET online=?, lastAccess=? WHERE obj_id=?");
            statement.setInt(1, this.isOnline());
            statement.setLong(2, System.currentTimeMillis());
            statement.setInt(3, this.getObjectId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("could not set char online status:" + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public void increaseKarma(int i) {
        this._karma += i;
        this.updateKarma(this.getCharId());
    }

    public void redreaseKarma(int i) {
        this._karma -= i;
        if (this._karma <= 0) {
            this._karma = 0;
            this.setKarmaFlag(this.getCharId(), 0);
            return;
        }
        this.updateKarma(this.getCharId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDb() {
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO characters (account_name,obj_Id,char_name,level,maxHp,curHp,maxMp,curMp,acc,crit,evasion,mAtk,mDef,mSpd,pAtk,pDef,pSpd,runSpd,walkSpd,str,con,dex,_int,men,wit,face,hairStyle,hairColor,sex,movement_multiplier,attack_speed_multiplier,colRad,colHeight,exp,sp,karma,pvpkills,pkkills,clanid,maxload,race,classid,deletetime,cancraft,title,allyId,accesslevel,online) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            statement.setString(1, this._accountName);
            statement.setInt(2, this.getObjectId());
            statement.setString(3, this.getName());
            statement.setInt(4, this.getLevel());
            statement.setInt(5, this.getMaxHp());
            statement.setDouble(6, this.getCurrentHp());
            statement.setInt(7, this.getMaxMp());
            statement.setDouble(8, this.getCurrentMp());
            statement.setInt(9, this.getAccuracy());
            statement.setInt(10, this.getCriticalHit(null, null));
            statement.setInt(11, this.getEvasionRate(null));
            statement.setInt(12, this.getMAtk(null, null));
            statement.setInt(13, this.getMDef(null, null));
            statement.setInt(14, this.getMAtkSpd());
            statement.setInt(15, this.getPAtk(null));
            statement.setInt(16, this.getPDef(null));
            statement.setInt(17, this.getPAtkSpd());
            statement.setInt(18, this.getRunSpeed());
            statement.setInt(19, this.getWalkSpeed());
            statement.setInt(20, this.getSTR());
            statement.setInt(21, this.getCON());
            statement.setInt(22, this.getDEX());
            statement.setInt(23, this.getINT());
            statement.setInt(24, this.getMEN());
            statement.setInt(25, this.getWIT());
            statement.setInt(26, this.getFace());
            statement.setInt(27, this.getHairStyle());
            statement.setInt(28, this.getHairColor());
            statement.setInt(29, this.getSex());
            statement.setDouble(30, 1.0);
            statement.setDouble(31, 1.0);
            statement.setDouble(32, this.getTemplate().collisionRadius);
            statement.setDouble(33, this.getTemplate().collisionHeight);
            statement.setInt(34, this.getExp());
            statement.setInt(35, this.getSp());
            statement.setInt(36, this.getKarma());
            statement.setInt(37, this.getPvpKills());
            statement.setInt(38, this.getPkKills());
            statement.setInt(39, this.getClanId());
            statement.setInt(40, this.getMaxLoad());
            statement.setInt(41, this.getRace().ordinal());
            statement.setInt(42, this.getClassId().getId());
            statement.setInt(43, this.getDeleteTimer());
            statement.setInt(44, this.getCanCraft() ? 1 : 0);
            statement.setString(45, this.getTitle());
            statement.setInt(46, this.getAllyId());
            statement.setInt(47, this.getAccessLevel());
            statement.setInt(48, this.isOnline());
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert char data:", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static L2PcInstance restore(int objectId) {
        L2PcInstance player = null;
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT account_name, obj_Id, char_name, level, maxHp, curHp, maxMp, curMp, acc, crit, evasion, mAtk, mDef, mSpd, pAtk, pDef, pSpd, runSpd, walkSpd, str, con, dex, _int, men, wit, face, hairStyle, hairColor, sex, heading, x, y, z, movement_multiplier, attack_speed_multiplier, colRad, colHeight, exp, sp, karma, pvpkills, pkkills, clanid, maxload, race, classid, deletetime, cancraft, title, allyId, rec_have, rec_left, accesslevel, online, char_slot, lastAccess FROM characters WHERE obj_id=?");
            statement.setInt(1, objectId);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                int classId = rset.getInt("classid");
                boolean female = rset.getInt("sex") != 0;
                L2PcTemplate template = CharTemplateTable.getInstance().getTemplate(classId, female);
                player = new L2PcInstance(objectId, template);
                player._accountName = rset.getString("account_name");
                player.setName(rset.getString("char_name"));
                player._level = rset.getInt("level");
                player.setFace(rset.getInt("face"));
                player.setHairStyle(rset.getInt("hairStyle"));
                player.setHairColor(rset.getInt("hairColor"));
                player.setHeading(rset.getInt("heading"));
                int exp = rset.getInt("exp");
                if (player._level > 75) {
                    player._level = 75;
                }
                if (exp < Experience.LEVEL[player.getLevel()] || exp > Experience.LEVEL[player.getLevel() + 1]) {
                    exp = Experience.LEVEL[player.getLevel()];
                }
                player.setExp(exp);
                player.setSp(rset.getInt("sp"));
                player.setKarma(rset.getInt("karma"));
                player.setPvpKills(rset.getInt("pvpkills"));
                player.setPkKills(rset.getInt("pkkills"));
                int clanId = rset.getInt("clanid");
                if (clanId > 0) {
                    player.setClan(ClanTable.getInstance().getClan(clanId));
                }
                player.setMaxLoad(rset.getInt("maxload"));
                player.setDeleteTimer(rset.getInt("deletetime"));
                player.setTitle(rset.getString("title"));
                player.setAllyId(rset.getInt("allyId"));
                player.setAccessLevel(rset.getInt("accesslevel"));
                player.setFistsWeaponItem(player.findFistsWeaponItem(classId));
                player.setUptime(System.currentTimeMillis());
                player.setCurrentHp(rset.getDouble("curHp"));
                player.setCurrentMp(rset.getDouble("curMp"));
                player.setRecomHave(rset.getInt("rec_have"));
                player.setRecomLeft(rset.getInt("rec_left"));
                player.rewardSkills();
                L2World.getInstance().storeObject(player);
                player.setXYZInvisible(rset.getInt("x"), rset.getInt("y"), rset.getInt("z"));
            }
            rset.close();
            statement.close();
            player.refreshOverloaded();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not restore char data:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        return player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET level=?,maxHp=?,curHp=?,maxMp=?,curMp=?,str=?,con=?,dex=?,_int=?,men=?,wit=?,face=?,hairStyle=?,hairColor=?,heading=?,x=?,y=?,z=?,exp=?,sp=?,karma=?,pvpkills=?,pkkills=?,rec_have=?,rec_left=?,clanid=?,maxload=?,race=?,classid=?,deletetime=?,title=?,allyId=?,accesslevel=?,online=? WHERE obj_id=?");
            statement.setInt(1, this.getLevel());
            statement.setInt(2, this.getMaxHp());
            statement.setDouble(3, this.getCurrentHp());
            statement.setInt(4, this.getMaxMp());
            statement.setDouble(5, this.getCurrentMp());
            statement.setInt(6, this.getSTR());
            statement.setInt(7, this.getCON());
            statement.setInt(8, this.getDEX());
            statement.setInt(9, this.getINT());
            statement.setInt(10, this.getMEN());
            statement.setInt(11, this.getWIT());
            statement.setInt(12, this.getFace());
            statement.setInt(13, this.getHairStyle());
            statement.setInt(14, this.getHairColor());
            statement.setInt(15, this.getHeading());
            statement.setInt(16, this.getX());
            statement.setInt(17, this.getY());
            statement.setInt(18, this.getZ());
            statement.setInt(19, this.getExp());
            statement.setInt(20, this.getSp());
            statement.setInt(21, this.getKarma());
            statement.setInt(22, this.getPvpKills());
            statement.setInt(23, this.getPkKills());
            statement.setInt(24, this.getRecomHave());
            statement.setInt(25, this.getRecomLeft());
            statement.setInt(26, this.getClanId());
            statement.setInt(27, this.getMaxLoad());
            statement.setInt(28, this.getRace().ordinal());
            statement.setInt(29, this.getClassId().getId());
            statement.setInt(30, this.getDeleteTimer());
            statement.setString(31, this.getTitle());
            statement.setInt(32, this.getAllyId());
            statement.setInt(33, this.getAccessLevel());
            statement.setInt(34, this.isOnline());
            statement.setInt(35, this.getObjectId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("could not store char data:" + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public int isOnline() {
        return this._isOnline ? 1 : 0;
    }

    @Override
    public L2Skill addSkill(L2Skill newSkill) {
        L2Skill oldSkill = super.addSkill(newSkill);
        this.storeSkill(newSkill, oldSkill);
        return oldSkill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2Skill removeSkill(L2Skill skill) {
        L2Skill oldSkill = super.removeSkill(skill);
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            if (oldSkill != null) {
                PreparedStatement statement = con.prepareStatement(DELETE_SKILL_FROM_CHAR);
                statement.setInt(1, oldSkill.getId());
                statement.setInt(2, this.getObjectId());
                statement.execute();
                statement.close();
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error could not delete Skill:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return oldSkill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSkill(L2Skill newSkill, L2Skill oldSkill) {
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            if (oldSkill != null && newSkill != null) {
                PreparedStatement statement = con.prepareStatement(UPDATE_CHARACTER_SKILL_LEVEL);
                statement.setInt(1, newSkill.getLevel());
                statement.setInt(2, oldSkill.getId());
                statement.setInt(3, this.getObjectId());
                statement.execute();
                statement.close();
            } else if (newSkill != null) {
                PreparedStatement statement = con.prepareStatement(ADD_NEW_SKILL);
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, newSkill.getId());
                statement.setInt(3, newSkill.getLevel());
                statement.setString(4, newSkill.getName());
                statement.execute();
                statement.close();
            } else {
                _log.warning("could not store new skill. its NULL");
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error could not store Skills:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSkills() {
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(GET_ALL_SKILLS_FOR_CHAR);
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int id = rset.getInt(COLUMN_SKILL_ID);
                int level = rset.getInt(COLUMN_SKILL_LEVEL);
                if (id > 9000) continue;
                L2Skill skill = SkillTable.getInstance().getInfo(id, level);
                super.addSkill(skill);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("count not restore skills:" + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreHenna() {
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("select slot, symbol_id from character_hennas where char_obj_id=?");
            statement.setInt(1, this.getObjectId());
            ResultSet rset = statement.executeQuery();
            for (int i = 0; i < 3; ++i) {
                this._henna[i] = null;
            }
            while (rset.next()) {
                L2Henna tpl;
                int slot = rset.getInt("slot");
                if (slot < 1 || slot > 3) continue;
                int symbol_id = rset.getInt("symbol_id");
                L2HennaInstance sym = null;
                if (symbol_id == 0 || (tpl = HennaTable.getInstance().getTemplate(symbol_id)) == null) continue;
                this._henna[slot - 1] = sym = new L2HennaInstance(tpl);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("could not restore henna: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        this.recalcHennaStats();
    }

    public int getHennaEmptySlots() {
        int totalSlots = 1 + this.getClassId().level();
        for (int i = 0; i < 3; ++i) {
            if (this._henna[i] == null) continue;
            --totalSlots;
        }
        if (totalSlots <= 0) {
            return 0;
        }
        return totalSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHenna(int slot) {
        if (slot < 1 || slot > 3) {
            return false;
        }
        if (this._henna[--slot] == null) {
            return false;
        }
        this._henna[slot] = null;
        java.sql.Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_hennas where char_obj_id=? and slot=?");
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, slot + 1);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("could not remove char henna: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        this.recalcHennaStats();
        HennaInfo hi = new HennaInfo(this);
        this.sendPacket(hi);
        UserInfo ui = new UserInfo(this);
        this.sendPacket(ui);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHenna(L2HennaInstance henna) {
        if (this.getHennaEmptySlots() == 0) {
            this.sendMessage("You have reached henna limit.");
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (this._henna[i] != null) continue;
            this._henna[i] = henna;
            this.recalcHennaStats();
            java.sql.Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("INSERT INTO character_hennas (char_obj_id, symbol_id, slot) VALUES (?, ?, ?)");
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, henna.getSymbolId());
                statement.setInt(3, i + 1);
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.warning("could not save char henna: " + e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
            HennaInfo hi = new HennaInfo(this);
            this.sendPacket(hi);
            UserInfo ui = new UserInfo(this);
            this.sendPacket(ui);
            return true;
        }
        return false;
    }

    private void recalcHennaStats() {
        this._hennaINT = 0;
        this._hennaSTR = 0;
        this._hennaCON = 0;
        this._hennaMEN = 0;
        this._hennaWIT = 0;
        this._hennaDEX = 0;
        for (int i = 0; i < 3; ++i) {
            if (this._henna[i] == null) continue;
            this._hennaINT += this._henna[i].getStatINT();
            this._hennaSTR += this._henna[i].getStatSTR();
            this._hennaMEN += this._henna[i].getStatMEM();
            this._hennaCON += this._henna[i].getStatCON();
            this._hennaWIT += this._henna[i].getStatWIT();
            this._hennaDEX += this._henna[i].getStatDEX();
        }
        if (this._hennaINT > 5) {
            this._hennaINT = 5;
        }
        if (this._hennaSTR > 5) {
            this._hennaSTR = 5;
        }
        if (this._hennaMEN > 5) {
            this._hennaMEN = 5;
        }
        if (this._hennaCON > 5) {
            this._hennaCON = 5;
        }
        if (this._hennaWIT > 5) {
            this._hennaWIT = 5;
        }
        if (this._hennaDEX > 5) {
            this._hennaDEX = 5;
        }
    }

    public L2HennaInstance getHenna(int slot) {
        if (slot < 1 || slot > 3) {
            return null;
        }
        return this._henna[slot - 1];
    }

    public int getHennaStatINT() {
        return this._hennaINT;
    }

    public int getHennaStatSTR() {
        return this._hennaSTR;
    }

    public int getHennaStatCON() {
        return this._hennaCON;
    }

    public int getHennaStatMEN() {
        return this._hennaMEN;
    }

    public int getHennaStatWIT() {
        return this._hennaWIT;
    }

    public int getHennaStatDEX() {
        return this._hennaDEX;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (attacker == this || attacker == this.getPet()) {
            return false;
        }
        if (attacker instanceof L2MonsterInstance) {
            return true;
        }
        if (this.getParty() != null && this.getParty().getPartyMembers().contains(attacker)) {
            return false;
        }
        if (this.getKarma() > 0) {
            return true;
        }
        if (attacker instanceof L2PcInstance) {
            if (L2Siege.isDefender(((L2PcInstance)attacker).getClanId()) && L2Siege.isDefender(this.getClanId())) {
                return false;
            }
            if (L2Siege.isAttacker(((L2PcInstance)attacker).getClanId()) && L2Siege.isAttacker(this.getClanId())) {
                return false;
            }
            if (L2World.isInAttackZone(this)) {
                return true;
            }
        }
        return false;
    }

    public void useMagic(L2Skill skill, boolean forceUse, boolean dontMove) {
        ActionFailed af;
        L2ItemInstance requiredItems;
        L2Object target;
        L2Effect effect;
        if (skill.isToggle() && (effect = this.getEffect(skill)) != null) {
            effect.exit();
            ActionFailed af2 = new ActionFailed();
            this.sendPacket(af2);
            return;
        }
        if (skill.isOffensive()) {
            target = this.getTarget();
            if (this.withinZones(L2World.zones) || target != null && target.withinZones(L2World.zones)) {
                this.sendPacket(new SystemMessage(85));
                ActionFailed af3 = new ActionFailed();
                this.sendPacket(af3);
                return;
            }
            if (target != null && !target.isAutoAttackable(this) && !forceUse && skill.getTargetType() != L2Skill.SkillTargetType.TARGET_AURA && skill.getTargetType() != L2Skill.SkillTargetType.TARGET_AURA_CLOSE) {
                ActionFailed af4 = new ActionFailed();
                this.sendPacket(af4);
                return;
            }
            if (target != null && dontMove) {
                double distance = this.getDistance(target.getX(), target.getY());
                if (skill.getCastRange() > 0 && distance > (double)skill.getCastRange()) {
                    SystemMessage sm = new SystemMessage(614);
                    sm.addString("Target too far.");
                    this.sendPacket(sm);
                    ActionFailed af5 = new ActionFailed();
                    this.sendPacket(af5);
                    return;
                }
            }
        }
        if (skill.getSkillType() == L2Skill.SkillType.SPOIL && (target = this.getTarget()) instanceof L2Attackable && ((L2Attackable)target).hasSpoil()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Already spoiled.");
            this.sendPacket(sm);
            ActionFailed af6 = new ActionFailed();
            this.sendPacket(af6);
            return;
        }
        if (skill.getItemConsume() > 0 && ((requiredItems = this.getInventory().findItemByItemId(skill.getItemConsumeId())) == null || requiredItems.getCount() < skill.getItemConsume())) {
            this.sendPacket(new SystemMessage(351));
            return;
        }
        if (this.isSitting()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("You cannot use magic while sitting.");
            this.sendPacket(sm);
            ActionFailed af7 = new ActionFailed();
            this.sendPacket(af7);
            return;
        }
        if (this.getCurrentMp() < (double)skill.getMpConsume()) {
            this.sendPacket(new SystemMessage(24));
            af = new ActionFailed();
            this.sendPacket(af);
            return;
        }
        if (this.getCurrentHp() < (double)skill.getHpConsume()) {
            this.sendPacket(new SystemMessage(23));
            af = new ActionFailed();
            this.sendPacket(af);
            return;
        }
        if (this.isAllSkillsDisabled()) {
            if (Config.DEBUG) {
                _log.fine("currently casting or sleeping, skill disabled");
            }
            af = new ActionFailed();
            this.sendPacket(af);
            return;
        }
        if (this.isSkillDisabled(skill.getId())) {
            if (Config.DEBUG) {
                _log.fine("skill disabled");
            }
            af = new ActionFailed();
            this.sendPacket(af);
            return;
        }
        if (!skill.getWeaponDependancy(this)) {
            af = new ActionFailed();
            this.sendPacket(af);
            return;
        }
        if (skill.isPassive()) {
            af = new ActionFailed();
            this.sendPacket(af);
            return;
        }
        if (!skill.checkCondition(this)) {
            af = new ActionFailed();
            this.sendPacket(af);
            return;
        }
        super.useMagic(skill);
    }

    @Override
    public void consumeItem(int itemConsumeId, int itemCount) {
        if (itemConsumeId != 0 && itemCount != 0) {
            L2ItemInstance item = this.getInventory().destroyItemByItemId(itemConsumeId, itemCount);
            InventoryUpdate update2 = new InventoryUpdate();
            update2.addItem(item);
            this.sendPacket(update2);
        }
    }

    public boolean isMageClass() {
        L2PcTemplate template = CharTemplateTable.getInstance().getTemplate(this.getClassId(), this.getSex() != 0);
        return template.baseMAtk > 3;
    }

    public boolean isMounted() {
        return this._mountType > 0;
    }

    public void setMountType(int mountType) {
        switch (mountType) {
            case 0: {
                this.setFlying(false);
                this.setRidding(false);
                break;
            }
            case 1: {
                this.setRidding(true);
                break;
            }
            case 2: {
                this.setFlying(true);
            }
        }
        this._mountType = mountType;
        UserInfo ui = new UserInfo(this);
        this.sendPacket(ui);
    }

    public int getMountType() {
        return this._mountType;
    }

    @Override
    public void updateAbnormalEffect() {
        this.broadcastUserInfo();
    }

    public void tempInvetoryDisable() {
        this._inventoryDisable = true;
        ClientScheduler.getInstance().scheduleMed(new InventoryEnable(), 1500L);
    }

    public boolean isInvetoryDisabled() {
        return this._inventoryDisable;
    }

    public void setUsingClanWarehouse(boolean b) {
        this._usingClanWarehouse = b;
    }

    public boolean isUsingClanWarehouse() {
        return this._usingClanWarehouse;
    }

    public HashMap<Integer, L2CubicInstance> getCubics() {
        return this._cubics;
    }

    public void addCubic(int id, int level) {
        L2CubicInstance cubic = new L2CubicInstance(this, id, level);
        this._cubics.put(id, cubic);
    }

    public void delCubic(int id) {
        this._cubics.remove(id);
    }

    public L2CubicInstance getCubic(int id) {
        return this._cubics.get(id);
    }

    @Override
    public String toString() {
        return "player " + this.getName();
    }

    public int getEnchantEffect() {
        L2ItemInstance wpn = this.getActiveWeaponInstance();
        if (wpn == null) {
            return 0;
        }
        return Math.min(127, wpn.getEnchantLevel());
    }

    public void setLastFolkNPC(L2FolkInstance folkNpc) {
        this._lastFolkNpc = folkNpc;
    }

    public L2FolkInstance getLastFolkNPC() {
        return this._lastFolkNpc;
    }

    public void setSilentMoving(boolean flag) {
        this._isSilentMoving = flag;
    }

    public boolean isSilentMoving() {
        return this._isSilentMoving;
    }

    public boolean isInsidePvPZone() {
        boolean inArena = this.withinZones(L2World.arenas);
        boolean inSiege = this.withinZones(L2World.castles) && L2Siege.getSiege() > 0;
        return inArena || inSiege;
    }

    public void checkPvP(L2Character target) {
        if (target instanceof L2PcInstance && ((L2PcInstance)target).getKarma() == 0 && !this.isInsidePvPZone() && this.getKarma() == 0) {
            _log.fine("Attacker is a player with no karma checking for PvPFlag()");
            if (this.getPvpFlag() == 0) {
                this.startPvPFlag();
                _log.fine("setting attackers PvPFlag on");
            }
            if (this.getPvpFlag() != 0) {
                this.setlastPvpAttack(System.currentTimeMillis());
            }
        }
    }

    public void addAutoSoulShot(int itemId) {
        this._activeSoulShots.add(itemId);
        if (this._taskAutoSoulShot == null) {
            this._taskAutoSoulShot = ClientScheduler.getInstance().scheduleMedAtFixedRate(new AutoSoulShot(), 0L, 300L);
        }
    }

    public void removeAutoSoulShot(int itemId) {
        this._activeSoulShots.remove(itemId);
        if (this._activeSoulShots.isEmpty() && this._taskAutoSoulShot != null) {
            this._taskAutoSoulShot.cancel(false);
            this._taskAutoSoulShot = null;
        }
    }

    public void setInvisible() {
        this._invisible = 1;
    }

    public void setVisible() {
        this._invisible = 0;
    }

    public int getInvisible() {
        return this._invisible;
    }

    public void togglePathNodeMode() {
        this.isPathNodeMode = !this.isPathNodeMode;
    }

    public void toggleViewPathNodes() {
        this.isPathNodesVisible = !this.isPathNodesVisible;
    }

    public boolean isPathNodeModeActive() {
        return this.isPathNodeMode;
    }

    public boolean isPathNodeVisible() {
        return this.isPathNodesVisible;
    }

    public Map<WayPointNode, CopyOnWriteArrayList<WayPointNode>> getPathNodeMap() {
        if (this.pathNodeMap == null) {
            this.pathNodeMap = new ConcurrentHashMap<WayPointNode, CopyOnWriteArrayList<WayPointNode>>();
        }
        return this.pathNodeMap;
    }

    public void addPathNodePoint() {
        this.setSelectedNode(WayPointNode.spawn(this));
        this.getPathNodeMap().put(this.getSeltectedNode(), new CopyOnWriteArrayList());
    }

    public void clearPathNodes() {
        if (this.pathNodeMap != null) {
            for (WayPointNode node : this.pathNodeMap.keySet()) {
                this.removePathNodePoint(node);
            }
            this.pathNodeMap.clear();
        }
        this.setSelectedNode(null);
    }

    public void setSelectedNode(WayPointNode decoInstance) {
        CopyOnWriteArrayList<WayPointNode> linkedNodes;
        if (this.selectedNode != null) {
            linkedNodes = this.getPathNodeMap().get(this.selectedNode);
            if (linkedNodes != null) {
                for (WayPointNode node : linkedNodes) {
                    node.setNormal();
                }
            }
            this.selectedNode.setNormal();
        }
        this.selectedNode = decoInstance;
        if (this.selectedNode != null) {
            this.selectedNode.setSelected();
            linkedNodes = this.getPathNodeMap().get(this.selectedNode);
            if (linkedNodes != null) {
                for (WayPointNode linked : linkedNodes) {
                    linked.setLinked();
                }
            }
        }
    }

    public WayPointNode getSeltectedNode() {
        return this.selectedNode;
    }

    public void addLink(WayPointNode target) {
        if (this.selectedNode != null) {
            CopyOnWriteArrayList<WayPointNode> list = this.pathNodeMap.get(this.selectedNode);
            if (list == null) {
                list = new CopyOnWriteArrayList();
            }
            list.add(target);
            this.pathNodeMap.put(this.selectedNode, list);
            CopyOnWriteArrayList<WayPointNode> list2 = this.pathNodeMap.get(target);
            if (list2 == null) {
                list2 = new CopyOnWriteArrayList();
            }
            list2.add(this.selectedNode);
            this.pathNodeMap.put(target, list2);
            target.setLinked();
            WayPointNode.drawLine(target, this.selectedNode);
        }
    }

    public void removeLink(WayPointNode target) {
        if (this.selectedNode != null) {
            CopyOnWriteArrayList<WayPointNode> list = this.pathNodeMap.get(this.selectedNode);
            if (list != null && list.contains(target)) {
                list.remove(target);
                this.pathNodeMap.put(this.selectedNode, list);
                CopyOnWriteArrayList<WayPointNode> list2 = this.pathNodeMap.get(target);
                if (list2 != null && list2.contains(this.selectedNode)) {
                    list2.remove(this.selectedNode);
                    this.pathNodeMap.put(target, list2);
                }
                target.setNormal();
                WayPointNode.eraseLine(target, this.selectedNode);
            } else {
                this.sendPacket(SystemMessage.sendString("Target not a Linked Node."));
            }
        }
    }

    public void removePathNodePoint() {
        this.removePathNodePoint(this.selectedNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePathNodePoint(WayPointNode node) {
        if (node != null) {
            CopyOnWriteArrayList<WayPointNode> list = this.pathNodeMap.get(node);
            if (list != null) {
                CopyOnWriteArrayList<WayPointNode> copyOnWriteArrayList = list;
                synchronized (copyOnWriteArrayList) {
                    try {
                        for (WayPointNode link : list) {
                            this.removeLink(link);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.pathNodeMap.remove(node);
            node.decayMe();
            node = null;
        }
    }

    public void savePathNodes(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream("pathnode/" + fileName + ".bin");
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            ObjectOutputStream out = new ObjectOutputStream(gzos);
            out.writeObject(this.getSaveList());
            out.flush();
            out.close();
            this.sendPacket(SystemMessage.sendString("Path Node table saved to: L2J/pathnode/" + fileName + ".bin"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendPacket(SystemMessage.sendString("Could not Save Path Node Table."));
        }
    }

    public HashMap<Point3D, ArrayList<Point3D>> getSaveList() {
        HashMap saveList = null;
        if (this.pathNodeMap != null) {
            saveList = new HashMap();
            for (WayPointNode node : this.pathNodeMap.keySet()) {
                Point3D nodePoint = Point3D.getPosition(node);
                CopyOnWriteArrayList<WayPointNode> links = this.pathNodeMap.get(node);
                ArrayList<Point3D> linkPoints = null;
                if (links != null) {
                    linkPoints = new ArrayList<Point3D>();
                    for (WayPointNode link : links) {
                        linkPoints.add(Point3D.getPosition(link));
                    }
                }
                saveList.put(nodePoint, linkPoints);
            }
        }
        return saveList;
    }

    public void loadPathNodes(String fileName) {
        HashMap newNodeMap = null;
        try {
            FileInputStream fis = new FileInputStream("pathnode/" + fileName + ".bin");
            GZIPInputStream gzis = new GZIPInputStream(fis);
            ObjectInputStream in = new ObjectInputStream(gzis);
            newNodeMap = (HashMap)in.readObject();
            in.close();
        }
        catch (Exception e) {
            this.sendPacket(SystemMessage.sendString("Could not Load Path Node Table from: L2J/pathnode/" + fileName + ".bin"));
            e.printStackTrace();
            return;
        }
        this.clearPathNodes();
        this.loadNodeList(newNodeMap);
        this.sendPacket(SystemMessage.sendString("Path Node table loaded from: L2J/pathnode/" + fileName + ".bin"));
    }

    private void loadNodeList(HashMap<Point3D, ArrayList<Point3D>> newNodeMap) {
        this.pathNodeMap = new ConcurrentHashMap<WayPointNode, CopyOnWriteArrayList<WayPointNode>>();
        HashMap<Point3D, WayPointNode> map = new HashMap<Point3D, WayPointNode>();
        WayPointNode newNode = null;
        for (Point3D point : newNodeMap.keySet()) {
            newNode = WayPointNode.spawn(point);
            newNode.setNormal();
            map.put(point, newNode);
        }
        for (Point3D point : newNodeMap.keySet()) {
            WayPointNode node = (WayPointNode)map.get(point);
            ArrayList<Point3D> links = newNodeMap.get(point);
            CopyOnWriteArrayList<WayPointNode> nodeLinks = null;
            if (links != null) {
                nodeLinks = new CopyOnWriteArrayList<WayPointNode>();
                for (Point3D link : links) {
                    WayPointNode linkNode = (WayPointNode)map.get(link);
                    nodeLinks.add(linkNode);
                    if (this.pathNodeMap.get(linkNode) == null || this.pathNodeMap.get(linkNode).contains(node)) continue;
                    WayPointNode.drawLine(linkNode, node);
                }
            }
            this.pathNodeMap.put(node, nodeLinks);
        }
    }

    public int getClanPrivileges() {
        return this.clanPrivileges;
    }

    public void setClanPrivileges(int n) {
        this.clanPrivileges = n;
    }

    public void refreshLinks() {
        if (this.linkToggle) {
            for (WayPointNode node : this.pathNodeMap.keySet()) {
                for (WayPointNode lineNode : node.getLineNodes()) {
                    lineNode.decayMe();
                    lineNode.refreshID();
                }
            }
        } else {
            for (WayPointNode node : this.pathNodeMap.keySet()) {
                for (WayPointNode lineNode : node.getLineNodes()) {
                    lineNode.spawnMe();
                }
            }
        }
        this.linkToggle = !this.linkToggle;
    }

    public void sendMessage(String message) {
        this.sendPacket(SystemMessage.sendString(message));
    }

    public void enterObserverMode(int x, int y, int z) {
        this._obsX = this.getX();
        this._obsY = this.getY();
        this._obsZ = this.getZ();
        this.setTarget(null);
        this.stopMove(null);
        this.setParalyzed(true);
        this.setInvisible();
        this.sendPacket(new ObservationMode(this, x, y, z));
        this.setXYZ(x, y, z);
        this._observerMode = true;
        this.broadcastPacket(new CharInfo(this));
    }

    public void leaveObserverMode() {
        this.setTarget(null);
        this.setXYZ(this._obsX, this._obsY, this._obsZ);
        this.setParalyzed(false);
        this.setVisible();
        if (this.getAI() != null) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
        this.sendPacket(new ObservationReturn(this));
        this._observerMode = false;
        this.broadcastPacket(new CharInfo(this));
    }

    public int getObsX() {
        return this._obsX;
    }

    public int getObsY() {
        return this._obsY;
    }

    public int getObsZ() {
        return this._obsZ;
    }

    public boolean inObserverMode() {
        return this._observerMode;
    }

    class AutoSoulShot
    implements Runnable {
        AutoSoulShot() {
        }

        public void run() {
            Integer[] itemIds;
            for (Integer itemId : itemIds = L2PcInstance.this._activeSoulShots.toArray(new Integer[0])) {
                L2ItemInstance item = L2PcInstance.this.getInventory().findItemByItemId(itemId);
                if (item == null) {
                    L2PcInstance.this.removeAutoSoulShot(itemId);
                    continue;
                }
                IItemHandler handler = ItemHandler.getInstance().getItemHandler(item.getItemId());
                handler.useItem(L2PcInstance.this, item);
            }
        }
    }

    class InventoryEnable
    implements Runnable {
        InventoryEnable() {
        }

        public void run() {
            L2PcInstance.this._inventoryDisable = false;
        }
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        protected AIAccessor() {
        }

        public L2PcInstance getPlayer() {
            return L2PcInstance.this;
        }

        public void doPickupItem(L2Object object) {
            L2PcInstance.this.doPickupItem(object);
        }

        public void doInteract(L2Character target) {
            L2PcInstance.this.doInteract(target);
        }

        public void doAttack(L2Character target) {
            super.doAttack(target);
            for (L2CubicInstance cubic : L2PcInstance.this._cubics.values()) {
                if (cubic.getId() == 3) continue;
                cubic.doAction(target);
            }
        }
    }
}

