/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.Collection;
import java.util.HashMap;
import net.sf.l2j.gameserver.model.L2PetData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L2PetDataTable {
    private static L2PetDataTable _instance;
    private static HashMap<Integer, HashMap<Integer, L2PetData>> petTable;

    public static L2PetDataTable getInstance() {
        if (_instance == null) {
            _instance = new L2PetDataTable();
        }
        return _instance;
    }

    private L2PetDataTable() {
        petTable = new HashMap();
    }

    public void addPetData(L2PetData petData) {
        HashMap<Integer, L2PetData> h = petTable.get(petData.getPetID());
        if (h == null) {
            HashMap<Integer, L2PetData> statTable = new HashMap<Integer, L2PetData>();
            statTable.put(petData.getPetLevel(), petData);
            petTable.put(petData.getPetID(), statTable);
        } else {
            h.put(petData.getPetLevel(), petData);
        }
    }

    public void addPetData(Collection<L2PetData> list) {
        for (L2PetData petData : list) {
            this.addPetData(petData);
        }
    }

    public void addPetData(L2PetData[] list) {
        for (int i = 0; i < list.length; ++i) {
            this.addPetData(list[i]);
        }
    }

    public L2PetData getPetData(int petID, int petLevel) {
        HashMap<Integer, L2PetData> h = petTable.get(petID);
        L2PetData t = h.get(petLevel);
        return t;
    }
}

