/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PetData;
import net.sf.l2j.gameserver.model.L2PetDataTable;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2Summon;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.PetInventory;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.PetInfo;
import net.sf.l2j.gameserver.serverpackets.PetInventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.PetItemList;
import net.sf.l2j.gameserver.serverpackets.PetStatusShow;
import net.sf.l2j.gameserver.serverpackets.PetStatusUpdate;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.StopMove;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.Stats;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;
import net.sf.l2j.gameserver.templates.L2Weapon;

public final class L2PetInstance
extends L2Summon {
    protected static Logger _log = Logger.getLogger(L2PetInstance.class.getName());
    private int _level;
    private byte _pvpFlag;
    private int _curFed;
    private PetInventory _inventory;
    private final int _controlItemId;
    private boolean _respawned;
    private Future _feedTask;
    private boolean _mountable;
    private L2PetData _data;

    public static L2PetInstance spawnPet(L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        return L2PetInstance.restore(control, template, owner);
    }

    public L2PetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        super(objectId, template, owner);
        this._controlItemId = control.getObjectId();
        this._inventory = new PetInventory(this);
        this._data = L2PetDataTable.getInstance().getPetData(template.npcId, template.level);
        this._template = template;
        this._level = template.level;
        int npcId = template.npcId;
        this._mountable = npcId == 12526 || npcId == 12527 || npcId == 12528 || npcId == 12621;
    }

    public L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)this._template;
    }

    public final int getLevel() {
        return this._level;
    }

    public boolean isRespawned() {
        return this._respawned;
    }

    public int getSummonType() {
        return 2;
    }

    public void onAction(L2PcInstance player) {
        if (player == this.getOwner() && player.getTarget() == this) {
            player.sendPacket(new PetStatusShow(this));
            player.sendPacket(new ActionFailed());
        } else {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            if (Config.DEBUG) {
                _log.fine("new target selected:" + this.getObjectId());
            }
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
        }
    }

    public int getControlItemId() {
        return this._controlItemId;
    }

    public int getMaxHp() {
        return (int)this.calcStat(Stats.MAX_HP, this._data.getPetHP(), null, null);
    }

    public int getMaxMp() {
        return (int)this.calcStat(Stats.MAX_MP, this._data.getPetMP(), null, null);
    }

    public int getMaxFed() {
        return this._data.getPetMaxFeed();
    }

    public int getMAtk(L2Character target, L2Skill skill) {
        Stats stat;
        double attack = this._data.getPetMAtk();
        Stats stats = stat = skill == null ? null : skill.getStat();
        if (stat != null) {
            switch (stat) {
                case AGGRESSION: {
                    attack += (double)this._template.baseAggression;
                    break;
                }
                case BLEED: {
                    attack += (double)this._template.baseBleed;
                    break;
                }
                case POISON: {
                    attack += (double)this._template.basePoison;
                    break;
                }
                case STUN: {
                    attack += (double)this._template.baseStun;
                    break;
                }
                case ROOT: {
                    attack += (double)this._template.baseRoot;
                    break;
                }
                case MOVEMENT: {
                    attack += (double)this._template.baseMovement;
                    break;
                }
                case CONFUSION: {
                    attack += (double)this._template.baseConfusion;
                    break;
                }
                case SLEEP: {
                    attack += (double)this._template.baseSleep;
                    break;
                }
                case FIRE: {
                    attack += (double)this._template.baseFire;
                    break;
                }
                case WIND: {
                    attack += (double)this._template.baseWind;
                    break;
                }
                case WATER: {
                    attack += (double)this._template.baseWater;
                    break;
                }
                case EARTH: {
                    attack += (double)this._template.baseEarth;
                }
            }
        }
        if (skill != null) {
            attack += skill.getPower();
        }
        return (int)this.calcStat(Stats.MAGIC_ATTACK, attack, target, skill);
    }

    public int getMDef(L2Character target, L2Skill skill) {
        Stats stat;
        double defence = this._data.getPetMDef();
        Stats stats = stat = skill == null ? null : skill.getStat();
        if (stat != null) {
            switch (stat) {
                case AGGRESSION: {
                    defence += (double)this._template.baseAggressionRes;
                    break;
                }
                case BLEED: {
                    defence += (double)this._template.baseBleedRes;
                    break;
                }
                case POISON: {
                    defence += (double)this._template.basePoisonRes;
                    break;
                }
                case STUN: {
                    defence += (double)this._template.baseStunRes;
                    break;
                }
                case ROOT: {
                    defence += (double)this._template.baseRootRes;
                    break;
                }
                case MOVEMENT: {
                    defence += (double)this._template.baseMovementRes;
                    break;
                }
                case CONFUSION: {
                    defence += (double)this._template.baseConfusionRes;
                    break;
                }
                case SLEEP: {
                    defence += (double)this._template.baseSleepRes;
                    break;
                }
                case FIRE: {
                    defence += (double)this._template.baseFireRes;
                    break;
                }
                case WIND: {
                    defence += (double)this._template.baseWindRes;
                    break;
                }
                case WATER: {
                    defence += (double)this._template.baseWaterRes;
                    break;
                }
                case EARTH: {
                    defence += (double)this._template.baseEarthRes;
                }
            }
        }
        return (int)this.calcStat(Stats.MAGIC_DEFENCE, defence, target, skill);
    }

    public int getPAtk(L2Character target) {
        return (int)this.calcStat(Stats.POWER_ATTACK, this._data.getPetPAtk(), target, null);
    }

    public int getPDef(L2Character target) {
        return (int)this.calcStat(Stats.POWER_DEFENCE, this._data.getPetPDef(), target, null);
    }

    public int getCurrentFed() {
        return this._curFed;
    }

    public void setCurrentFed(int num) {
        this._curFed = num;
    }

    public void setPvpFlag(byte pvpFlag) {
        this._pvpFlag = pvpFlag;
    }

    public void setPkKills(int pkKills) {
        this._pkKills = pkKills;
    }

    public void setSp(int sp) {
        this._sp = sp;
    }

    public void addExpAndSp(int addToExp, int addToSp) {
        if (Config.DEBUG) {
            _log.fine("adding " + addToExp + " exp and " + addToSp + " sp to " + this.getName());
        }
        this._exp += addToExp;
        this._sp += addToSp;
        PetInfo pi = new PetInfo(this);
        this.getOwner().sendPacket(pi);
        SystemMessage sm = new SystemMessage(1014);
        sm.addNumber(addToExp);
        this.getOwner().sendPacket(sm);
        if (this._exp >= this.getExpForNextLevel()) {
            sm = new SystemMessage(614);
            sm.addString("Your pet has increased it's level.");
            this.getOwner().sendPacket(sm);
        }
        while (this._exp >= this.getExpForNextLevel()) {
            this.increaseLevel();
        }
    }

    public int getExpForThisLevel() {
        L2PetData data = L2PetDataTable.getInstance().getPetData(this.getNpcId(), this.getLevel());
        return data.getPetExp();
    }

    public int getExpForNextLevel() {
        L2PetData data = L2PetDataTable.getInstance().getPetData(this.getNpcId(), this.getLevel() + 1);
        return data.getPetExp();
    }

    public void increaseLevel() {
        this._data = L2PetDataTable.getInstance().getPetData(this.getTemplate().npcId, this.getLevel() + 1);
        this.stopFeed();
        if (Config.DEBUG) {
            _log.finest("Increasing level of " + this.getName());
        }
        ++this._level;
        PetStatusUpdate ps = new PetStatusUpdate(this);
        this.getOwner().sendPacket(ps);
        StatusUpdate su = new StatusUpdate(this.getObjectId());
        su.addAttribute(StatusUpdate.LEVEL, this.getLevel());
        this.startFeed();
        this.broadcastPacket(su);
    }

    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    public PetInventory getInventory() {
        return this._inventory;
    }

    public void removeItemFromInventory(L2ItemInstance item, int count) {
        L2ItemInstance item2 = this.getInventory().destroyItem(item.getObjectId(), count);
        PetInventoryUpdate iu = new PetInventoryUpdate();
        if (item2.getCount() == 0) {
            iu.addRemovedItem(item2);
        } else {
            iu.addModifiedItem(item2);
        }
        this.getOwner().sendPacket(iu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPickupItem(L2Object object) {
        L2ItemInstance target;
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        StopMove sm = new StopMove(this.getObjectId(), this.getX(), this.getY(), this.getZ(), this.getHeading());
        if (Config.DEBUG) {
            _log.fine("Pet pickup pos: " + object.getX() + " " + object.getY() + " " + object.getZ());
        }
        this.broadcastPacket(sm);
        if (!(object instanceof L2ItemInstance)) {
            _log.warning("trying to pickup wrong target." + object);
            this.getOwner().sendPacket(new ActionFailed());
            return;
        }
        L2ItemInstance l2ItemInstance = target = (L2ItemInstance)object;
        synchronized (l2ItemInstance) {
            if (!target.isVisible()) {
                this.getOwner().sendPacket(new ActionFailed());
                return;
            }
            target.pickupMe(this);
        }
        this.getInventory().addItem(target);
        PetItemList iu = new PetItemList(this);
        this.getOwner().sendPacket(iu);
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        if (this.getFollowStatus()) {
            this.followOwner(this.getOwner());
        }
    }

    public void reduceCurrentHp(double damage, L2Character attacker) {
        super.reduceCurrentHp(damage, attacker);
        if (!this.isDead() && attacker != null) {
            SystemMessage sm = new SystemMessage(1016);
            if (attacker instanceof L2NpcInstance) {
                sm.addNpcName(((L2NpcInstance)attacker).getTemplate().npcId);
            } else {
                sm.addString(attacker.getName());
            }
            sm.addNumber((int)damage);
            this.getOwner().sendPacket(sm);
            this.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, attacker);
        }
    }

    protected synchronized void doDie(L2Character killer) {
        this.stopFeed();
        if (this._decayTask == null) {
            this._decayTask = ClientScheduler.getInstance().scheduleLow(new L2Character.DecayTask(), 180000L);
        }
        super.doDie(killer);
    }

    public void stopDecay() {
        if (this._decayTask != null) {
            this._decayTask.cancel(true);
        }
    }

    public void giveAllToOwner() {
        block4: {
            try {
                PetInventory petInventory = this.getInventory();
                L2ItemInstance[] items = petInventory.getItems();
                for (int i = 0; i < items.length; ++i) {
                    L2ItemInstance giveit = items[i];
                    if (giveit.getItem().getWeight() * giveit.getCount() + this.getOwner().getInventory().getTotalWeight() < this.getOwner().getMaxLoad()) {
                        this.giveItemToOwner(giveit);
                        continue;
                    }
                    this.dropItemHere(giveit);
                }
            }
            catch (Exception e) {
                if (!Config.DEBUG) break block4;
                _log.fine("Give all items error " + e);
            }
        }
    }

    public void giveItemToOwner(L2ItemInstance item) {
        block2: {
            try {
                this.getInventory().dropItem(item, item.getCount());
                this.getOwner().getInventory().addItem(item);
                PetInventoryUpdate petiu = new PetInventoryUpdate();
                ItemList PlayerUI = new ItemList(this.getOwner(), false);
                petiu.addRemovedItem(item);
                this.getOwner().sendPacket(petiu);
                this.getOwner().sendPacket(PlayerUI);
            }
            catch (Exception e) {
                if (!Config.DEBUG) break block2;
                _log.fine("Error while giving item to owner: " + e);
            }
        }
    }

    public void broadcastStatusUpdate() {
        super.broadcastStatusUpdate();
        if (this.getOwner() != null) {
            this.getOwner().sendPacket(new PetStatusUpdate(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyControlItem(L2PcInstance owner) {
        block14: {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");
                statement.setInt(1, this.getControlItemId());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.warning("could not delete pet:" + e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
            try {
                L2ItemInstance removedItem = owner.getInventory().destroyItem(this.getControlItemId(), 1);
                InventoryUpdate iu = new InventoryUpdate();
                iu.addRemovedItem(removedItem);
                owner.sendPacket(iu);
                StatusUpdate su = new StatusUpdate(owner.getObjectId());
                su.addAttribute(StatusUpdate.CUR_LOAD, owner.getCurrentLoad());
                owner.sendPacket(su);
                owner.broadcastUserInfo();
                L2World world = L2World.getInstance();
                world.removeObject(removedItem);
            }
            catch (Exception e) {
                if (!Config.DEBUG) break block14;
                _log.fine("Error while destroying control item: " + e);
            }
        }
    }

    public void dropAllItems() {
        block3: {
            try {
                L2ItemInstance[] items = this.getInventory().getItems();
                for (int i = 0; i < items.length; ++i) {
                    this.dropItemHere(items[i]);
                }
            }
            catch (Exception e) {
                if (!Config.DEBUG) break block3;
                _log.fine("Pet Drop Error: " + e);
            }
        }
    }

    public void dropItemHere(L2ItemInstance dropit) {
        dropit = this.getInventory().dropItem(dropit.getObjectId(), dropit.getCount());
        if (dropit != null) {
            if (Config.DEBUG) {
                _log.fine("Item id to drop: " + dropit.getItemId() + " amount: " + dropit.getCount());
            }
            dropit.dropMe(this, this.getX(), this.getY(), this.getZ() + 100);
        }
    }

    public boolean isMountable() {
        return this._mountable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static L2PetInstance restore(L2ItemInstance control, L2NpcTemplate template, L2PcInstance owner) {
        L2PetInstance l2PetInstance;
        Connection con = null;
        try {
            L2PetInstance pet = new L2PetInstance(IdFactory.getInstance().getNextId(), template, owner, control);
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT item_obj_id, objId, name, level, maxHp, curHp, maxMp, curMp, acc, crit, evasion, mAtk, mDef, mSpd, pAtk, pDef, pSpd, str, con, dex, _int, men, wit, exp, sp, karma, pkkills, maxload, fed, max_fed FROM pets WHERE item_obj_id=?");
            statement.setInt(1, control.getObjectId());
            ResultSet rset = statement.executeQuery();
            if (!rset.next()) {
                L2PetInstance l2PetInstance2 = pet;
                return l2PetInstance2;
            }
            pet._respawned = true;
            pet.setName(rset.getString("name"));
            pet._level = rset.getInt("level");
            pet.setCurrentHpMp(rset.getDouble("curHp"), rset.getInt("curMp"));
            pet.setCurrentCp(pet.getMaxCp());
            pet.setExp(rset.getInt("exp"));
            pet.setSp(rset.getInt("sp"));
            pet.setKarma(rset.getInt("karma"));
            pet.setPkKills(rset.getInt("pkkills"));
            pet.setCurrentFed(rset.getInt("fed"));
            rset.close();
            statement.close();
            l2PetInstance = pet;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "could not restore pet data:", e);
            L2PetInstance l2PetInstance3 = null;
            return l2PetInstance3;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return l2PetInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        if (this.getControlItemId() == 0) {
            return;
        }
        String req = !this.isRespawned() ? "INSERT INTO pets (name,level,curHp,curMp,exp,sp,karma,pkkills,fed,item_obj_id) VALUES (?,?,?,?,?,?,?,?,?,?)" : "UPDATE pets SET name=?,level=?,curHp=?,curMp=?,exp=?,sp=?,karma=?,pkkills=?,fed=? WHERE item_obj_id = ?";
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(req);
            statement.setString(1, this.getName());
            statement.setInt(2, this.getLevel());
            statement.setDouble(3, this.getCurrentHp());
            statement.setDouble(4, this.getCurrentMp());
            statement.setInt(5, this.getExp());
            statement.setInt(6, this.getSp());
            statement.setInt(7, this.getKarma());
            statement.setInt(8, this.getPkKills());
            statement.setInt(9, this.getCurrentFed());
            statement.setInt(10, this.getControlItemId());
            statement.executeUpdate();
            statement.close();
            this._respawned = true;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "could not store pet data:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    protected synchronized void stopFeed() {
        if (this._feedTask != null) {
            this._feedTask.cancel(false);
            this._feedTask = null;
            if (Config.DEBUG) {
                _log.fine("Feed task stop");
            }
        }
    }

    public synchronized void startFeed() {
        if (this._feedTask == null && !this.isDead()) {
            int time;
            if (Config.DEBUG) {
                _log.fine("Feed task started");
            }
            if ((time = this._data.getPetFeedNormal()) == 0) {
                _log.warning("Pet Feed Normal Time is 0. Changing time to 1 to bypass divide by 0");
                time = 1;
            }
            this._feedTask = ClientScheduler.getInstance().scheduleMedAtFixedRate(new FeedTask(), 60000 / time, 60000 / time);
        }
    }

    public synchronized void unSummon(L2PcInstance owner) {
        this.stopFeed();
        super.unSummon(owner);
    }

    class FeedTask
    implements Runnable {
        FeedTask() {
        }

        public void run() {
            try {
                if (L2PetInstance.this.getCurrentFed() > 0) {
                    L2PetInstance.this.setCurrentFed(L2PetInstance.this.getCurrentFed() - 1);
                } else {
                    L2PetInstance.this.setCurrentFed(0);
                    L2PetInstance.this.doDie(null);
                }
                L2ItemInstance food = null;
                switch (L2PetInstance.this.getTemplate().npcId) {
                    case 12077: {
                        food = L2PetInstance.this.getInventory().findItemByItemId(2515);
                        break;
                    }
                    case 12311: {
                        food = L2PetInstance.this.getInventory().findItemByItemId(4038);
                        break;
                    }
                    case 12312: {
                        food = L2PetInstance.this.getInventory().findItemByItemId(4038);
                        break;
                    }
                    case 12313: {
                        food = L2PetInstance.this.getInventory().findItemByItemId(4038);
                        break;
                    }
                    case 12526: {
                        food = L2PetInstance.this.getInventory().findItemByItemId(5168);
                        break;
                    }
                    case 12527: {
                        food = L2PetInstance.this.getInventory().findItemByItemId(5168);
                        break;
                    }
                    case 12528: {
                        food = L2PetInstance.this.getInventory().findItemByItemId(5168);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (food != null && (double)L2PetInstance.this.getCurrentFed() < 0.55 * (double)L2PetInstance.this.getMaxFed()) {
                    L2PetInstance.this.setCurrentFed(L2PetInstance.this.getCurrentFed() + 1);
                    L2PetInstance.this.removeItemFromInventory(food, 1);
                }
                L2PetInstance.this.broadcastStatusUpdate();
            }
            catch (Throwable e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }
}

