/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.MonsterRace;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.DeleteObject;
import net.sf.l2j.gameserver.serverpackets.MonRaceInfo;
import net.sf.l2j.gameserver.serverpackets.PlaySound;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2RaceManagerInstance
extends L2FolkInstance {
    public static final int LANES = 8;
    public static final int WINDOW_START = 0;
    private static ArrayList<Race> history;
    private static ArrayList<L2RaceManagerInstance> managers;
    private static int raceNumber;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static int minutes;
    private static final int ACCEPTING_BETS = 0;
    private static final int WAITING = 1;
    private static final int STARTING_RACE = 2;
    private static final int RACE_END = 3;
    private static int state;
    protected static final int[][] codes;
    private static boolean notInitialized;
    protected static MonRaceInfo packet;

    public L2RaceManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        if (notInitialized) {
            notInitialized = false;
            history = new ArrayList();
            managers = new ArrayList();
            ClientScheduler s = ClientScheduler.getInstance();
            s.scheduleLowAtFixedRate(new Announcement(816), 0L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(817), 30000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(816), 60000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(817), 90000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(818), 120000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(818), 180000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(818), 240000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(818), 300000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(818), 360000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(819), 420000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(820), 420000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(820), 480000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(821), 510000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(822), 530000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(823), 535000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(823), 536000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(823), 537000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(823), 538000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(823), 539000L, 600000L);
            s.scheduleLowAtFixedRate(new Announcement(824), 540000L, 600000L);
        }
        managers.add(this);
    }

    public boolean addKnownObject(L2Object object, L2Character dropper) {
        boolean ret = super.addKnownObject(object, dropper);
        if (!ret) {
            return false;
        }
        if (object instanceof L2PcInstance && packet != null) {
            ((L2PcInstance)object).sendPacket(packet);
        }
        return true;
    }

    public void removeKnownObject(L2Object object) {
        super.removeKnownObject(object);
        if (object instanceof L2PcInstance) {
            DeleteObject obj = null;
            for (int i = 0; i < 8; ++i) {
                obj = new DeleteObject(MonsterRace.getInstance().getMonsters()[i]);
                ((L2PcInstance)object).sendPacket(obj);
            }
        }
    }

    public void makeAnnouncement(int type) {
        SystemMessage sm = new SystemMessage(type);
        switch (type) {
            case 816: 
            case 817: {
                if (state != 0) {
                    state = 0;
                    this.startRace();
                }
                sm.addNumber(raceNumber);
                break;
            }
            case 818: 
            case 820: 
            case 823: {
                sm.addNumber(minutes);
                sm.addNumber(raceNumber);
                --minutes;
                break;
            }
            case 819: {
                sm.addNumber(raceNumber);
                state = 1;
                minutes = 2;
                break;
            }
            case 822: 
            case 825: {
                sm.addNumber(raceNumber);
                minutes = 5;
                break;
            }
            case 826: {
                state = 3;
                ++raceNumber;
                sm.addNumber(MonsterRace.getInstance().getFirstPlace());
                sm.addNumber(MonsterRace.getInstance().getSecondPlace());
            }
        }
        this.broadcast(sm);
        if (type == 824) {
            state = 2;
            this.startRace();
            minutes = 5;
        }
    }

    protected void broadcast(ServerBasePacket pkt) {
        for (L2RaceManagerInstance manager : managers) {
            if (manager.isDead()) continue;
            manager.broadcastPacket(pkt);
        }
    }

    public void sendMonsterInfo() {
        this.broadcast(packet);
    }

    private void startRace() {
        MonsterRace race = MonsterRace.getInstance();
        if (state == 2) {
            PlaySound SRace = new PlaySound(1, "S_Race", 0, 0, 0, 0, 0);
            this.broadcast(SRace);
            PlaySound SRace2 = new PlaySound(0, "ItemSound2.race_start", 1, 121209259, 12125, 182487, -3559);
            this.broadcast(SRace2);
            packet = new MonRaceInfo(codes[1][0], codes[1][1], race.getMonsters(), race.getSpeeds());
            this.sendMonsterInfo();
            ClientScheduler.getInstance().scheduleMed(new RunRace(codes), 5000L);
        } else {
            race.newRace();
            race.newSpeeds();
            packet = new MonRaceInfo(codes[0][0], codes[0][1], race.getMonsters(), race.getSpeeds());
            this.sendMonsterInfo();
        }
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        System.out.println("Command: " + command);
        String content = "";
        if (!(command.equals("viewOddsWin") || command.equals("viewOddsPlace") || command.equals("viewMonsterInfo") || command.equals("buyTicketWin") || command.equals("buyTicketPlace") || command.equals("calculateWin") || command.equals("viewHistory"))) {
            super.onBypassFeedback(player, command);
            return;
        }
        this.insertObjectIdAndShowChatWindow(player, content);
    }

    public void showChatWindow(L2PcInstance player, int val) {
        String content = "<html><body><center>MonsterRace Manager</center><img src=\"L2UI.SquareWhite\" width=270 height=1><img src=\"L2UI.SquareBlank\" width=1 height=3><table width=270 borader=0><tr><td width=270><a action=\"link mr_help.html\">Monster Race Help</a></td></tr><tr><td width=270><a action=\"bypass -h npc_%objectId%_viewOddsWin\">View Odds</a></td></tr><tr><td width=270><a action=\"bypass -h npc_%objectId%_viewMonsterInfo\">View Monster Information</a></td></tr><tr><td width=270><a action=\"bypass -h npc_%objectId%_buyTicketWin\">Purchase Ticket</a></td></tr><tr><td width=270><a action=\"bypass -h npc_%objectId%_calculateWin\">Calculate Winnings</a></td></tr><tr><td width=270><a action=\"bypass -h npc_%objectId%_viewHistory\">View Past Results</a></td></tr><tr><td width=270><a action=\"bypass -h npc_%objectId%_Quest 1101_teleport_to_race_track\">Exit the monster race track.</a></td></tr></table><img src=\"L2UI.SquareBlank\" width=270 height=10><img src=\"L2UI.SquareWhite\" width=270 height=1><img src=\"L2UI.SquareBlank\" width=270 height=5></body></html>";
        this.insertObjectIdAndShowChatWindow(player, content);
    }

    static {
        raceNumber = 4;
        minutes = 5;
        state = 3;
        codes = new int[][]{{-1, 0}, {0, 15322}, {13765, -1}};
        notInitialized = true;
    }

    class RunEnd
    implements Runnable {
        RunEnd() {
        }

        public void run() {
            L2RaceManagerInstance.this.makeAnnouncement(826);
            L2RaceManagerInstance.this.makeAnnouncement(825);
            DeleteObject obj = null;
            for (int i = 0; i < 8; ++i) {
                obj = new DeleteObject(MonsterRace.getInstance().getMonsters()[i]);
                L2RaceManagerInstance.this.broadcast(obj);
            }
        }
    }

    class RunRace
    implements Runnable {
        public RunRace(int[][] codes) {
        }

        public void run() {
            packet = new MonRaceInfo(codes[2][0], codes[2][1], MonsterRace.getInstance().getMonsters(), MonsterRace.getInstance().getSpeeds());
            L2RaceManagerInstance.this.sendMonsterInfo();
            ClientScheduler.getInstance().scheduleMed(new RunEnd(), 30000L);
        }
    }

    public class Race {
        private Info[] info;

        public Race(Info[] info) {
            this.info = info;
        }

        public Info getLaneInfo(int lane) {
            return this.info[lane];
        }

        public class Info {
            private int id;
            private int place;
            private int odds;
            private int payout;

            public Info(int id, int place, int odds, int payout) {
                this.id = id;
                this.place = place;
                this.odds = odds;
                this.payout = payout;
            }

            public int getId() {
                return this.id;
            }

            public int getOdds() {
                return this.odds;
            }

            public int getPayout() {
                return this.payout;
            }

            public int getPlace() {
                return this.place;
            }
        }
    }

    class Announcement
    implements Runnable {
        private int type;

        public Announcement(int type) {
            this.type = type;
        }

        public void run() {
            L2RaceManagerInstance.this.makeAnnouncement(this.type);
        }
    }
}

