/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.Announcements;
import net.sf.l2j.gameserver.ClanTable;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2SiegeNpcInstance
extends L2FolkInstance {
    private static Logger _log = Logger.getLogger(L2SiegeNpcInstance.class.getName());
    private static final String[] castleNames = new String[]{"Nowhere", "Gludio", "Giran", "Dion", "Oren", "Aden"};

    public L2SiegeNpcInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onBypassFeedback(L2PcInstance player, String command) {
        super.onBypassFeedback(player, command);
        if (command.startsWith("siege_attacker_signup")) {
            int castle2 = Integer.parseInt(command.substring(22));
            L2Clan playersClan = player.getClan();
            if (playersClan.getLeaderId() == player.getObjectId() && playersClan.getLevel() > 2) {
                L2Siege.storeSiegeClan(playersClan.getClanId(), castle2, 1);
                String filename = "data/html/siege/" + this.getTemplate().npcId + "-3.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(1);
                html.setFile(filename);
                html.replace("%objectId%", String.valueOf(this.getObjectId()));
                player.sendPacket(html);
                player.sendPacket(new ActionFailed());
                Announcements anounce = new Announcements();
                anounce.announceToAll("Clan " + playersClan.getName() + " will take part in the Siege of " + castleNames[castle2] + " as an Attacker Clan");
                return;
            } else {
                player.sendMessage("You must be the leader of a lvl 3 or higher clan to sign up for a siege.");
            }
            return;
        }
        if (command.startsWith("siege_defender_signup")) {
            int castle3 = Integer.parseInt(command.substring(22, 23));
            L2Clan playersClan = player.getClan();
            if (playersClan.getLeaderId() != player.getObjectId() || playersClan.getLevel() <= 2 || playersClan.getClanId() != L2Siege.getClan(castle3).getClanId()) return;
            L2Siege.storeSiegeClan(playersClan.getClanId(), castle3, 0);
            String filename = "data/html/siege/" + this.getTemplate().npcId + "-3.htm";
            NpcHtmlMessage html = new NpcHtmlMessage(1);
            html.setFile(filename);
            html.replace("%objectId%", String.valueOf(this.getObjectId()));
            player.sendPacket(html);
            player.sendPacket(new ActionFailed());
            Announcements anounce = new Announcements();
            anounce.announceToAll("Clan " + playersClan.getName() + " will take part in the Siege of " + castleNames[castle3] + " as a Defender Clan");
            return;
        }
        if (command.startsWith("siege_unsign")) {
            int castle4 = Integer.parseInt(command.substring(13));
            L2Clan playersClan = player.getClan();
            if (playersClan == null || playersClan.getLeaderId() != player.getObjectId()) return;
            L2Siege.deleteSiegeClan(castle4, playersClan.getClanId());
            Announcements anounce = new Announcements();
            anounce.announceToAll(playersClan.getName() + " cowardly unsign from the Siege of " + castleNames[castle4]);
            return;
        }
        if (command.startsWith("siege_surrender")) {
            int clan = Integer.parseInt(command.substring(16));
            L2Clan clan1 = player.getClan();
            L2Clan clan2 = ClanTable.getInstance().getClan(clan);
            if (clan1 == null || clan2 == null || !clan1.isAtWarWith(clan2.getClanId()) || clan1.getLeaderId() != player.getObjectId()) return;
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("SELECT clan1, clan2, wantspeace1, wantspeace2 FROM clan_wars WHERE clan1=? AND clan2=?");
                statement.setString(1, clan1.getName());
                statement.setString(2, clan2.getName());
                ResultSet rset = statement.executeQuery();
                int position = 2;
                if (rset.next()) {
                    position = 1;
                }
                statement = con.prepareStatement("UPDATE clan_wars SET VALUES wantspeace" + position + "=1 WHERE clan1=? AND clan2=?");
                statement.setString(1, clan2.getName());
                statement.setString(2, clan1.getName());
                if (position == 1) {
                    statement.setString(1, clan1.getName());
                    statement.setString(2, clan2.getName());
                }
                statement.execute();
                Announcements anounce = new Announcements();
                anounce.announceToAll("The pathetic clan " + clan1.getName() + " surrenders to the great clan " + clan2.getName());
                return;
            }
            catch (Exception e) {
                _log.warning("could not store clan wars data:" + e);
                return;
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        if (command.startsWith("siege_acceptpeace")) {
            int clan = Integer.parseInt(command.substring(18));
            L2Clan clan1 = player.getClan();
            L2Clan clan2 = ClanTable.getInstance().getClan(clan);
            if (clan1 == null || clan2 == null || !clan1.isAtWarWith(clan2.getClanId()) || clan1.getLeaderId() != player.getObjectId()) return;
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("SELECT clan1, clan2, wantspeace1, wantspeace2 FROM clan_wars WHERE clan1=? AND clan2=?");
                statement.setString(1, clan1.getName());
                statement.setString(2, clan2.getName());
                ResultSet rset = statement.executeQuery();
                if (rset.next()) {
                    if (rset.getInt("wantspeace2") != 1) return;
                    clan1.deleteEnemyClan(clan2);
                    clan2.deleteEnemyClan(clan1);
                    statement = con.prepareStatement("DELETE FROM clan_wars WHERE clan1=? AND clan2=?");
                    statement.setString(1, clan1.getName());
                    statement.setString(2, clan2.getName());
                    statement.execute();
                    Announcements anounce = new Announcements();
                    anounce.announceToAll(clan1.getName() + " accepts peace with " + clan2.getName());
                    return;
                }
                if (rset.getInt("wantspeace1") != 1) return;
                clan1.deleteEnemyClan(clan2);
                clan2.deleteEnemyClan(clan1);
                statement = con.prepareStatement("DELETE FROM clan_wars WHERE clan2=? AND clan1=?");
                statement.setString(1, clan1.getName());
                statement.setString(2, clan2.getName());
                statement.execute();
                Announcements anounce = new Announcements();
                anounce.announceToAll(clan1.getName() + " accepts peace with " + clan2.getName());
                return;
            }
            catch (Exception e) {
                _log.warning("could not store clan wars data:" + e);
                return;
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        if (!command.startsWith("siege_declarewar")) return;
        int clan = Integer.parseInt(command.substring(17));
        L2Clan clan1 = player.getClan();
        L2Clan clan2 = ClanTable.getInstance().getClan(clan);
        if (clan1 == null || clan2 == null || clan1.isAtWarWith(clan2.getClanId()) || clan1.getLeaderId() != player.getObjectId()) return;
        clan1.setEnemyClan(clan2);
        clan2.setEnemyClan(clan1);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO clan_wars (clan1,clan2,wantspeace1,wantspeace2) VALUES(?,?,0,0)");
            statement.setString(1, clan1.getName());
            statement.setString(2, clan2.getName());
            statement.execute();
            Announcements anounce = new Announcements();
            anounce.announceToAll("Clan " + clan1.getName() + " has declared war to clan " + clan2.getName());
            return;
        }
        catch (Exception e) {
            _log.warning("could not store clan wars data:" + e);
            return;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public void onAction(L2PcInstance player) {
        player.sendPacket(new ActionFailed());
        if (player.getTarget() == this) {
            this.showMessageWindow(player, 1);
        }
        player.setTarget(this);
        MyTargetSelected my = new MyTargetSelected(this.getObjectId(), -15);
        player.sendPacket(my);
        ActionFailed af = new ActionFailed();
        player.sendPacket(af);
    }

    public void showMessageWindow(L2PcInstance player, int val) {
        int castle2 = -1;
        switch (this.getTemplate().npcId) {
            case 12253: {
                castle2 = 1;
                break;
            }
            case 12153: {
                castle2 = 2;
                break;
            }
            case 12122: {
                castle2 = 3;
                break;
            }
            case 12241: {
                castle2 = 4;
                break;
            }
        }
        L2Clan playersClan = player.getClan();
        String filename = playersClan != null && castle2 != -1 ? (playersClan.getLeaderId() == player.getObjectId() ? (playersClan.getHasCastle() == castle2 ? "data/html/siege/" + this.getTemplate().npcId + "-1.htm" : (!L2Siege.checkIfSignedUp(castle2, playersClan.getClanId()) ? "data/html/siege/" + this.getTemplate().npcId + "-4.htm" : "data/html/siege/" + this.getTemplate().npcId + "-2.htm")) : "data/html/siege/" + this.getTemplate().npcId + ".htm") : "data/html/siege/" + this.getTemplate().npcId + ".htm";
        NpcHtmlMessage html = new NpcHtmlMessage(1);
        html.setFile(filename);
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
        player.sendPacket(new ActionFailed());
    }
}

