/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.Territory;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2Spawn {
    protected static Logger _log = Logger.getLogger(L2Spawn.class.getName());
    private static final String DEFAULT_LOCATION = "unset";
    private L2NpcTemplate _template;
    private int _id;
    private int _location;
    private int _maximumCount;
    private int _currentCount;
    protected int _scheduledCount;
    private int _locx;
    private int _locy;
    private int _locz;
    private int _randomy;
    private int _heading;
    private int _respawnDelay;
    private Constructor _constructor;
    private boolean _doRespawn;

    public L2Spawn(L2NpcTemplate mobTemplate) throws SecurityException, ClassNotFoundException {
        this._template = mobTemplate;
        String implementationName = this._template.type;
        if (mobTemplate.npcId == 7995) {
            implementationName = "L2RaceManager";
        }
        if (mobTemplate.npcId >= 8046 && mobTemplate.npcId <= 8053) {
            implementationName = "L2SymbolMaker";
        }
        this._constructor = Class.forName("net.sf.l2j.gameserver.model." + implementationName + "Instance").getConstructors()[0];
    }

    public int getAmount() {
        return this._maximumCount;
    }

    public int getId() {
        return this._id;
    }

    public int getLocation() {
        return this._location;
    }

    public int getLocx() {
        return this._locx;
    }

    public int getLocy() {
        return this._locy;
    }

    public int getLocz() {
        return this._locz;
    }

    public int getNpcid() {
        return this._template.npcId;
    }

    public int getHeading() {
        return this._heading;
    }

    public int getRespawnDelay() {
        return this._respawnDelay;
    }

    public void setAmount(int amount) {
        this._maximumCount = amount;
    }

    public void setId(int id) {
        this._id = id;
    }

    public void setLocation(int location) {
        this._location = location;
    }

    public void setLocx(int locx) {
        this._locx = locx;
    }

    public void setLocy(int locy) {
        this._locy = locy;
    }

    public void setLocz(int locz) {
        this._locz = locz;
    }

    public void setHeading(int heading) {
        this._heading = heading;
    }

    public void decreaseCount(int npcId) {
        --this._currentCount;
        if (this._doRespawn && this._scheduledCount + this._currentCount < this._maximumCount) {
            ++this._scheduledCount;
            ClientScheduler.getInstance().scheduleLow(new SpawnTask(npcId), this._respawnDelay);
        }
    }

    public int init() {
        while (this._currentCount < this._maximumCount) {
            this.doSpawn();
        }
        this._doRespawn = true;
        return this._currentCount;
    }

    public L2NpcInstance spawnOne() {
        return this.doSpawn();
    }

    public void stopRespawn() {
        this._doRespawn = false;
    }

    public L2NpcInstance doSpawn() {
        L2NpcInstance mob = null;
        try {
            int newlocz;
            int newlocy;
            int newlocx;
            if (this._template.type.equalsIgnoreCase("L2Pet") || this._template.type.equalsIgnoreCase("L2Minion")) {
                ++this._currentCount;
                return mob;
            }
            Object[] parameters = new Object[]{IdFactory.getInstance().getNextId(), this._template};
            Object tmp = this._constructor.newInstance(parameters);
            if (!(tmp instanceof L2NpcInstance)) {
                return mob;
            }
            mob = (L2NpcInstance)tmp;
            if (this.getLocx() == 0 && this.getLocy() == 0) {
                if (this.getLocation() == 0) {
                    return mob;
                }
                int[] p = Territory.getInstance().getRandomPoint(this.getLocation());
                newlocx = p[0];
                newlocy = p[1];
                newlocz = p[2];
            } else {
                newlocx = this.getLocx();
                newlocy = this.getLocy();
                newlocz = this.getLocz();
            }
            mob.setCurrentHpMp(mob.getMaxHp(), mob.getMaxMp());
            if (this.getHeading() == -1) {
                mob.setHeading(L2Character.getRnd().nextInt(61794));
            } else {
                mob.setHeading(this.getHeading());
            }
            mob.setSpawn(this);
            mob.spawnMe(newlocx, newlocy, newlocz);
            mob.OnSpawn();
            if (Config.DEBUG) {
                _log.finest("spawned Mob ID: " + this._template.npcId + " ,at: " + mob.getX() + " x, " + mob.getY() + " y, " + mob.getZ() + " z");
            }
            ++this._currentCount;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "NPC class not found", e);
        }
        return mob;
    }

    public void setRespawnDelay(int i) {
        if (i < 0) {
            _log.warning("respawn delay is negative for spawnId:" + this._id);
        }
        if (i < 60) {
            i = 60;
        }
        this._respawnDelay = i * 1000;
    }

    class SpawnTask
    implements Runnable {
        L2NpcInstance _instance;
        int _objId;

        public SpawnTask(int objid) {
            this._objId = objid;
        }

        public void run() {
            try {
                L2Spawn.this.doSpawn();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "", e);
            }
            --L2Spawn.this._scheduledCount;
        }
    }
}

