/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.concurrent.Future;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.ai.L2SummonAI;
import net.sf.l2j.gameserver.model.Experience;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Party;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PlayableInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.PetInventory;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.MyTargetSelected;
import net.sf.l2j.gameserver.serverpackets.NpcInfo;
import net.sf.l2j.gameserver.serverpackets.PetDelete;
import net.sf.l2j.gameserver.serverpackets.PetStatusShow;
import net.sf.l2j.gameserver.serverpackets.PetStatusUpdate;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;
import net.sf.l2j.gameserver.templates.L2Weapon;

public abstract class L2Summon
extends L2PlayableInstance {
    private static Logger _log = Logger.getLogger(L2Summon.class.getName());
    protected int _exp = 0;
    protected int _sp = 0;
    protected int _pkKills;
    private int _pvpKills;
    private byte _pvpFlag;
    private final L2PcInstance _owner;
    private int _karma = 0;
    private int _attackRange = 36;
    private boolean _follow = true;
    protected Future _decayTask;
    private L2Character _lastTarget;
    private int _maxLoad;
    private boolean _showSummonAnimation = true;

    public L2Summon(int objectId, L2NpcTemplate template, L2PcInstance owner) {
        super(objectId, template);
        this._owner = owner;
        this._ai = new L2SummonAI(new AIAccessor());
        this.setXYZInvisible(owner.getX() + 50, owner.getY() + 100, owner.getZ() + 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CharacterAI getAI() {
        if (this._ai == null) {
            L2Summon l2Summon = this;
            synchronized (l2Summon) {
                if (this._ai == null) {
                    this._ai = new L2SummonAI(new AIAccessor());
                }
            }
        }
        return this._ai;
    }

    public L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)super.getTemplate();
    }

    public abstract int getSummonType();

    public void updateAbnormalEffect() {
        for (L2PcInstance player : this.getKnownPlayers()) {
            player.sendPacket(new NpcInfo(this, (L2Character)player));
        }
    }

    public boolean isMountable() {
        return false;
    }

    public void onAction(L2PcInstance player) {
        if (player == this._owner && player.getTarget() == this) {
            player.sendPacket(new PetStatusShow(this));
            player.sendPacket(new ActionFailed());
        } else {
            if (Config.DEBUG) {
                _log.fine("new target selected:" + this.getObjectId());
            }
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
        }
    }

    public int getExpForThisLevel() {
        return Experience.LEVEL[this.getLevel()];
    }

    public int getExpForNextLevel() {
        return Experience.LEVEL[this.getLevel() + 1];
    }

    public final int getKarma() {
        return this._karma;
    }

    public void setKarma(int karma) {
        this._karma = karma;
    }

    public final L2PcInstance getOwner() {
        return this._owner;
    }

    public final int getNpcId() {
        return this.getTemplate().npcId;
    }

    public void setPvpFlag(byte pvpFlag) {
        this._pvpFlag = pvpFlag;
    }

    public void setPkKills(int pkKills) {
        this._pkKills = pkKills;
    }

    public final int getPkKills() {
        return this._pkKills;
    }

    public final int getExp() {
        return this._exp;
    }

    public final void setExp(int exp) {
        this._exp = exp;
    }

    public final int getSp() {
        return this._sp;
    }

    public void setSp(int sp) {
        this._sp = sp;
    }

    public final int getMaxLoad() {
        return this._maxLoad;
    }

    public void setMaxLoad(int maxLoad) {
        this._maxLoad = maxLoad;
    }

    public void followOwner(L2PcInstance owner) {
        this.setFollowStatus(true);
    }

    protected synchronized void doDie(L2Character killer) {
        if (this._decayTask == null) {
            this._decayTask = ClientScheduler.getInstance().scheduleLow(new L2Character.DecayTask(), 3000L);
        }
        super.doDie(killer);
    }

    public void stopDecay() {
        if (this._decayTask != null) {
            this._decayTask.cancel(true);
        }
    }

    public void onDecay() {
        this.deleteMe(this._owner);
    }

    public void broadcastStatusUpdate() {
        super.broadcastStatusUpdate();
        if (this.getOwner() != null && this.isVisible()) {
            this.getOwner().sendPacket(new PetStatusUpdate(this));
        }
    }

    public void deleteMe(L2PcInstance owner) {
        this.unSummon(owner);
        this.destroyControlItem(owner);
    }

    public void PetdeleteMe(L2PcInstance owner) {
        this.unSummon(owner);
    }

    public synchronized void unSummon(L2PcInstance owner) {
        if (this.isVisible()) {
            this.getAI().stopFollow();
            owner.sendPacket(new PetDelete(this.getObjectId(), 2));
            this.store();
            this.giveAllToOwner();
            this.decayMe();
            this.removeAllKnownObjects();
            owner.setPet(null);
            this.setTarget(null);
        }
    }

    protected int getDistanceToWatchObject(L2Object object) {
        return 1500;
    }

    protected int getDistanceToForgetObject(L2Object object) {
        if (object == this._owner || object == this.getTarget()) {
            return 6000;
        }
        return 3000;
    }

    public int getAttackRange() {
        return this._attackRange;
    }

    public void setAttackRange(int range) {
        if (range < 36) {
            range = 36;
        }
        this._attackRange = range;
    }

    public void setFollowStatus(boolean state2) {
        this._follow = state2;
        if (this._follow) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, this.getOwner());
        } else {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
        }
    }

    public boolean getFollowStatus() {
        return this._follow;
    }

    public boolean isAutoAttackable(L2Character attacker) {
        return this._owner.isAutoAttackable(attacker);
    }

    public boolean isShowSummonAnimation() {
        return this._showSummonAnimation;
    }

    public void setShowSummonAnimation(boolean showSummonAnimation) {
        this._showSummonAnimation = showSummonAnimation;
    }

    public int getControlItemId() {
        return 0;
    }

    public L2Weapon getActiveWeapon() {
        return null;
    }

    public PetInventory getInventory() {
        return null;
    }

    public void destroyControlItem(L2PcInstance owner) {
    }

    protected void doPickupItem(L2Object object) {
    }

    public void giveAllToOwner() {
    }

    public void store() {
    }

    protected void displayHitMessage(int damage, boolean crit, boolean miss) {
    }

    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    public L2Party getParty() {
        return this._owner.getParty();
    }

    public boolean isInParty() {
        return this._owner.getParty() != null;
    }

    public void useMagic(L2Skill skill) {
        super.useMagic(skill);
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        protected AIAccessor() {
        }

        public L2Summon getSummon() {
            return L2Summon.this;
        }

        public boolean isAutoFollow() {
            return L2Summon.this.getFollowStatus();
        }

        public void doPickupItem(L2Object object) {
            L2Summon.this.doPickupItem(object);
        }
    }
}

