/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.HennaTreeTable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2HennaInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.HennaEquipList;
import net.sf.l2j.gameserver.templates.L2Henna;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class L2SymbolMakerInstance
extends L2FolkInstance {
    private static Logger _log = Logger.getLogger(L2SymbolMakerInstance.class.getName());
    private int _heading;
    private double _collisionRadius;
    private double _collisionHeight;
    private ArrayList<L2Henna> _hennaEList;

    public double getCollisionHeight() {
        return this._collisionHeight;
    }

    public void setCollisionHeight(double offset) {
        this._collisionHeight = offset;
    }

    public double getCollisionRadius() {
        return this._collisionRadius;
    }

    public void setCollisionRadius(double collisionRadius) {
        this._collisionRadius = collisionRadius;
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.equals("Draw")) {
            L2HennaInstance[] henna = HennaTreeTable.getInstance().getAvailableHenna(player, player.getClassId());
            HennaEquipList hel = new HennaEquipList(player, henna);
            player.sendPacket(hel);
        } else if (command.equals("RemoveList")) {
            this.showRemoveChat(player);
        } else if (command.startsWith("Remove ")) {
            int slot = Integer.parseInt(command.substring(7));
            player.removeHenna(slot);
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    private void showRemoveChat(L2PcInstance player) {
        StringBuffer html1 = new StringBuffer("<html><body>");
        html1.append("Select symbol you would like to remove:<br><br>");
        boolean hasHennas = false;
        for (int i = 1; i <= 3; ++i) {
            L2HennaInstance henna = player.getHenna(i);
            if (henna == null) continue;
            hasHennas = true;
            html1.append("<a action=\"bypass -h npc_%objectId%_Remove " + i + "\">" + henna.getName() + "</a><br>");
        }
        if (!hasHennas) {
            html1.append("You don't have any symbol to remove!");
        }
        html1.append("</body></html>");
        this.insertObjectIdAndShowChatWindow(player, html1.toString());
    }

    public L2SymbolMakerInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
    }

    public void onAction(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("Symbol Maker activated");
        }
        player.setLastFolkNPC(this);
        super.onAction(player);
    }

    public String getHtmlPath(int npcId, int val) {
        String pom = "";
        pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/symbolmaker/" + pom + ".htm";
    }

    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }
}

