/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.TeleportLocationTable;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2TeleportLocation;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public final class L2TeleporterInstance
extends L2FolkInstance {
    private static Logger _log = Logger.getLogger(L2TeleporterInstance.class.getName());
    private ArrayList _tpLocs;
    private int _tpId;

    public L2TeleporterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        super.onBypassFeedback(player, command);
        if (command.startsWith("goto")) {
            int val = Integer.parseInt(command.substring(5));
            this.doTeleport(player, val);
        }
    }

    public String getHtmlPath(int npcId, int val) {
        String pom = "";
        pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/teleporter/" + pom + ".htm";
    }

    public void onAction(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("Teleporter activated");
        }
        super.onAction(player);
    }

    private void doTeleport(L2PcInstance player, int val) {
        L2TeleportLocation list = TeleportLocationTable.getInstance().getTemplate(val);
        if (list != null) {
            if (player.getAdena() >= list.getPrice()) {
                if (Config.DEBUG) {
                    _log.fine("Teleporting to new location: " + list.getLocX() + ":" + list.getLocY() + ":" + list.getLocZ());
                }
                player.reduceAdena(list.getPrice());
                if (Config.DEBUG) {
                    _log.fine("Took: " + list.getPrice() + " Adena from player for teleport");
                }
                player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ());
            } else {
                if (Config.DEBUG) {
                    _log.fine("Not enough adena to teleport");
                }
                SystemMessage sm = new SystemMessage(279);
                player.sendPacket(sm);
            }
        } else {
            _log.warning("No teleport destination with id:" + val);
        }
        player.sendPacket(new ActionFailed());
    }
}

