/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.lib.Rnd;
import net.sf.l2j.gameserver.model.L2Character;

public class L2Territory {
    private static Logger _log = Logger.getLogger(L2Territory.class.getName());
    private ArrayList<Point> _points = new ArrayList();
    private int _terr;
    private int _x_min;
    private int _x_max;
    private int _y_min;
    private int _y_max;
    private int _z_min;
    private int _z_max;
    private int _proc_max;

    public L2Territory(int terr) {
        this._terr = terr;
        this._x_min = 999999;
        this._x_max = -999999;
        this._y_min = 999999;
        this._y_max = -999999;
        this._z_min = 999999;
        this._z_max = -999999;
        this._proc_max = 0;
    }

    public void add(int x, int y, int zmin, int zmax, int proc) {
        this._points.add(new Point(x, y, zmin, zmax, proc));
        if (x < this._x_min) {
            this._x_min = x;
        }
        if (y < this._y_min) {
            this._y_min = y;
        }
        if (x > this._x_max) {
            this._x_max = x;
        }
        if (y > this._y_max) {
            this._y_max = y;
        }
        if (zmin < this._z_min) {
            this._z_min = zmin;
        }
        if (zmax > this._z_max) {
            this._z_max = zmax;
        }
        this._proc_max += proc;
    }

    public void print() {
        for (Point p : this._points) {
            System.out.println("(" + p.x + "," + p.y + ")");
        }
    }

    public boolean isIntersect(int x, int y, Point p1, Point p2) {
        int dy1 = p1.y - y;
        int dy2 = p2.y - y;
        if (Math.signum(dy1) == Math.signum(dy2)) {
            return false;
        }
        int dx1 = p1.x - x;
        int dx2 = p2.x - x;
        if (dx1 >= 0 && dx2 >= 0) {
            return true;
        }
        if (dx1 < 0 && dx2 < 0) {
            return false;
        }
        int dx0 = dy1 * (p1.x - p2.x) / (p1.y - p2.y);
        return dx0 <= dx1;
    }

    public boolean isInside(int x, int y) {
        int intersect_count = 0;
        for (int i = 0; i < this._points.size(); ++i) {
            Point p2;
            Point p1 = this._points.get(i > 0 ? i - 1 : this._points.size() - 1);
            if (!this.isIntersect(x, y, p1, p2 = this._points.get(i))) continue;
            ++intersect_count;
        }
        return intersect_count % 2 == 1;
    }

    public int[] getRandomPoint() {
        Point p1;
        int i;
        int[] p = new int[4];
        if (this._proc_max > 0) {
            int pos = 0;
            int rnd = L2Character.getRnd().nextInt(this._proc_max);
            for (i = 0; i < this._points.size(); ++i) {
                p1 = this._points.get(i);
                if (rnd > (pos += p1.proc)) continue;
                p[0] = p1.x;
                p[1] = p1.y;
                p[2] = p1.zmin;
                p[3] = p1.zmax;
                return p;
            }
        }
        for (i = 0; i < 100; ++i) {
            p[0] = Rnd.get(this._x_min, this._x_max);
            p[1] = Rnd.get(this._y_min, this._y_max);
            if (!this.isInside(p[0], p[1])) continue;
            double curdistance = 0.0;
            p[2] = this._z_min + 100;
            p[3] = this._z_max;
            for (i = 0; i < this._points.size(); ++i) {
                p1 = this._points.get(i);
                long dx = p1.x - p[0];
                long dy = p1.y - p[1];
                double distance = Math.sqrt(dx * dx + dy * dy);
                if (curdistance != 0.0 && !(distance < curdistance)) continue;
                curdistance = distance;
                p[2] = p1.zmin + 100;
            }
            return p;
        }
        _log.warning("Can't make point for territory" + this._terr);
        return p;
    }

    public int getProcMax() {
        return this._proc_max;
    }

    protected class Point {
        protected int x;
        protected int y;
        protected int zmin;
        protected int zmax;
        protected int proc;

        Point(int _x, int _y, int _zmin, int _zmax, int _proc) {
            this.x = _x;
            this.y = _y;
            this.zmin = _zmin;
            this.zmax = _zmax;
            this.proc = _proc;
        }
    }
}

