/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ClanTable;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.PledgeShowInfoUpdate;
import net.sf.l2j.gameserver.serverpackets.PledgeStatusChanged;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.serverpackets.UserInfo;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public final class L2VillageMasterInstance
extends L2FolkInstance {
    private static Logger _log = Logger.getLogger(L2VillageMasterInstance.class.getName());

    public L2VillageMasterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        super.onBypassFeedback(player, command);
        if (command.startsWith("create_clan")) {
            String val = command.substring(12);
            this.createClan(player, val);
        } else if (command.startsWith("dissolve_clan")) {
            this.dissolveClan(player, player.getClanId());
        } else if (command.startsWith("increase_clan_level")) {
            this.levelUpClan(player, player.getClanId());
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public String getHtmlPath(int npcId, int val) {
        String pom = "";
        pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/villagemaster/" + pom + ".htm";
    }

    public void onAction(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("Village Master activated");
        }
        super.onAction(player);
    }

    public void createClan(L2PcInstance player, String clanName) {
        if (Config.DEBUG) {
            _log.fine(player.getObjectId() + "(" + player.getName() + ") requested clan creation from " + this.getObjectId() + "(" + this.getName() + ")");
        }
        if (player.getLevel() < 10) {
            SystemMessage sm = new SystemMessage(190);
            player.sendPacket(sm);
            return;
        }
        if (player.getClanId() != 0) {
            SystemMessage sm = new SystemMessage(190);
            player.sendPacket(sm);
            return;
        }
        if (clanName.length() > 16) {
            SystemMessage sm = new SystemMessage(262);
            player.sendPacket(sm);
            return;
        }
        L2Clan clan = ClanTable.getInstance().createClan(player, clanName);
        if (clan == null) {
            SystemMessage sm = new SystemMessage(261);
            player.sendPacket(sm);
            return;
        }
        PledgeShowInfoUpdate pu = new PledgeShowInfoUpdate(clan, player);
        player.sendPacket(pu);
        UserInfo ui = new UserInfo(player);
        player.sendPacket(ui);
        SystemMessage sm = new SystemMessage(189);
        player.sendPacket(sm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dissolveClan(L2PcInstance player, int clanId) {
        if (player.getClan() != null && player.getObjectId() != player.getClan().getLeaderId()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Only clan leader can dissolve a clan.");
            player.sendPacket(sm);
            return;
        }
        L2PcInstance[] clanMembers = player.getClan().getOnlineMembers(player.getName());
        player.setClan(null);
        player.setTitle(null);
        L2Siege.removeSiegeSkills(player);
        SystemMessage sm = new SystemMessage(614);
        sm.addString("The clan has been dissolved.");
        for (int i = 0; i < clanMembers.length; ++i) {
            clanMembers[i].setClan(null);
            clanMembers[i].setTitle(null);
            clanMembers[i].sendPacket(sm);
            clanMembers[i].broadcastUserInfo();
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET clanid = 0 WHERE clanid=?");
            statement.setInt(1, clanId);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM clan_data WHERE clan_id=?");
            statement.setInt(1, clanId);
            statement.execute();
            statement.close();
            player.sendPacket(sm);
            player.broadcastUserInfo();
            con.close();
        }
        catch (Exception e) {
            _log.warning("could not dissolve clan:" + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void levelUpClan(L2PcInstance player, int clanId) {
        L2Clan clan = player.getClan();
        if (clan == null) {
            return;
        }
        if (player.getObjectId() != player.getClan().getLeaderId()) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Only clan leader can increase the clan level.");
            player.sendPacket(sm);
            return;
        }
        boolean increaseClanLevel = false;
        switch (clan.getLevel()) {
            case 0: {
                if (player.getSp() < 35000 || player.getAdena() < 650000) break;
                player.setSp(player.getSp() - 35000);
                player.reduceAdena(650000);
                increaseClanLevel = true;
                break;
            }
            case 1: {
                if (player.getSp() < 150000 || player.getAdena() < 2500000) break;
                player.setSp(player.getSp() - 150000);
                player.reduceAdena(2500000);
                increaseClanLevel = true;
                break;
            }
            case 2: {
                if (player.getSp() < 500000 || player.getInventory().findItemByItemId(1419) == null) break;
                player.setSp(player.getSp() - 500000);
                player.getInventory().destroyItemByItemId(1419, 1);
                increaseClanLevel = true;
                break;
            }
            case 3: {
                if (player.getSp() < 1400000 || player.getInventory().findItemByItemId(3874) == null && player.getAdena() < 16000000) break;
                player.setSp(player.getSp() - 1400000);
                if (player.getInventory().findItemByItemId(3874) != null) {
                    player.getInventory().destroyItemByItemId(3874, 1);
                } else {
                    player.reduceAdena(16000000);
                }
                increaseClanLevel = true;
                break;
            }
            case 4: {
                if (player.getSp() < 3500000 || player.getInventory().findItemByItemId(3870) == null && player.getAdena() < 30000000) break;
                player.setSp(player.getSp() - 3500000);
                if (player.getInventory().findItemByItemId(3870) != null) {
                    player.getInventory().destroyItemByItemId(3870, 1);
                } else {
                    player.reduceAdena(30000000);
                }
                increaseClanLevel = true;
            }
        }
        if (increaseClanLevel) {
            StatusUpdate su = new StatusUpdate(player.getObjectId());
            su.addAttribute(StatusUpdate.SP, player.getSp());
            this.sendPacket(su);
            ItemList il = new ItemList(player, false);
            player.sendPacket(il);
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET clan_level = ? WHERE clan_id = ?");
                statement.setInt(1, clan.getLevel() + 1);
                statement.setInt(2, clanId);
                statement.execute();
                statement.close();
                con.close();
            }
            catch (Exception e) {
                _log.warning("could not increase clan level:" + e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
            clan.setLevel(clan.getLevel() + 1);
            if (clan.getLevel() > 3) {
                L2Siege.addSiegeSkills(player);
            }
            SystemMessage sm = new SystemMessage(274);
            player.sendPacket(sm);
            L2PcInstance[] members = clan.getOnlineMembers(player.getName());
            for (int i = 0; i < members.length; ++i) {
                members[i].sendPacket(sm);
            }
            clan.broadcastToOnlineMembers(new PledgeStatusChanged(clan));
        } else {
            SystemMessage sm = new SystemMessage(275);
            player.sendPacket(sm);
        }
    }
}

