/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.Warehouse;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.serverpackets.WareHouseDepositList;
import net.sf.l2j.gameserver.serverpackets.WareHouseWithdrawalList;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public final class L2WarehouseInstance
extends L2FolkInstance {
    private static Logger _log = Logger.getLogger(L2WarehouseInstance.class.getName());

    public L2WarehouseInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    public void onAction(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("Warehouse activated");
        }
        player.setLastFolkNPC(this);
        super.onAction(player);
    }

    public String getHtmlPath(int npcId, int val) {
        String pom = "";
        pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/warehouse/" + pom + ".htm";
    }

    private void showRetrieveWindow(L2PcInstance player) {
        Warehouse list;
        player.setUsingClanWarehouse(false);
        if (Config.DEBUG) {
            _log.fine("Showing stored items");
        }
        if ((list = player.getWarehouse()) != null) {
            WareHouseWithdrawalList wl = new WareHouseWithdrawalList(player);
            player.sendPacket(wl);
        } else {
            _log.warning("no items stored");
        }
        player.sendPacket(new ActionFailed());
    }

    private void showDepositWindow(L2PcInstance player) {
        player.setUsingClanWarehouse(false);
        player.tempInvetoryDisable();
        if (Config.DEBUG) {
            _log.fine("Showing items to deposit");
        }
        WareHouseDepositList dl = new WareHouseDepositList(player);
        player.sendPacket(dl);
        player.sendPacket(new ActionFailed());
    }

    private void showDepositWindowClan(L2PcInstance player) {
        player.setUsingClanWarehouse(true);
        if (player.getClan() != null) {
            if (player.getClan().getLevel() == 0) {
                player.sendPacket(new SystemMessage(710));
            } else {
                player.sendPacket(new SystemMessage(1039));
                player.tempInvetoryDisable();
                if (Config.DEBUG) {
                    _log.fine("Showing items to deposit - clan");
                }
                WareHouseDepositList dl = new WareHouseDepositList(player);
                player.sendPacket(dl);
            }
        }
        player.sendPacket(new ActionFailed());
    }

    private void showWithdrawWindowClan(L2PcInstance player) {
        player.setUsingClanWarehouse(true);
        if (player.getClan() != null) {
            if (player.getClan().getLevel() == 0) {
                player.sendPacket(new SystemMessage(710));
            } else {
                Warehouse list = player.getClan().getWarehouse();
                if (list != null) {
                    if (Config.DEBUG) {
                        _log.fine("Showing items to deposit - clan");
                    }
                    WareHouseWithdrawalList wl = new WareHouseWithdrawalList(player, player.getClan());
                    player.sendPacket(wl);
                }
            }
        } else {
            _log.warning("no items stored");
        }
        player.sendPacket(new ActionFailed());
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("WithdrawP")) {
            this.showRetrieveWindow(player);
        } else if (command.equals("DepositP")) {
            this.showDepositWindow(player);
        } else if (command.equals("WithdrawC")) {
            this.showWithdrawWindowClan(player);
        } else if (command.equals("DepositC")) {
            this.showDepositWindowClan(player);
        } else {
            super.onBypassFeedback(player, command);
        }
    }
}

