/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.GmListTable;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2WorldRegion;
import net.sf.l2j.util.L2ObjectHashMap;
import net.sf.l2j.util.L2ObjectMap;
import net.sf.l2j.util.WorldObjectMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class L2World {
    private static Logger _log = Logger.getLogger(L2World.class.getName());
    private static final int SHIFT_BY = 13;
    private static final int MAP_MIN_X = -131072;
    private static final int MAP_MAX_X = 196608;
    private static final int MAP_MIN_Y = -393216;
    private static final int MAP_MAX_Y = 262144;
    private static final int OFFSET_X = Math.abs(-16);
    private static final int OFFSET_Y = Math.abs(-48);
    private static final int REGIONS_X = 24 + OFFSET_X;
    private static final int REGIONS_Y = 32 + OFFSET_Y;
    private ConcurrentHashMap<String, L2PcInstance> _allPlayers;
    private L2ObjectMap<L2Object> _allObjects;
    private IdFactory _idFactory;
    private static final L2World _instance = new L2World();
    public static final int[][] zones = new int[][]{{6063, 19664, 17248, 14019}, {-87312, 240096, -81129, 246345}, {48294, 52995, 43193, 45911}, {-42078, -109785, -47648, -117366}, {-84892, 149075, -76820, 156125}, {117395, -176766, 114824, -184347}, {-11853, 126610, -16652, 121003}, {15300, 141609, 21570, 147635}, {76995, 141424, 90565, 153614}, {76696, 57199, 84511, 50120}, {121308, 73941, 114667, 80383}, {142312, 32317, 152163, 19708}, {147121, 46232, 148016, 47213}, {150945, 47214, 151895, 46225}, {103598, 216010, 118991, 225905}};
    public static final int[][] arenas = new int[][]{{73482, 142269, 72507, 143247}, {-88412, 142709, -87392, 141696}, {148089, 48067, 150938, 45359}};
    public static final int[][] arenaspawn = new int[][]{{73890, 142656, -3778}, {-86979, 142402, -3643}, {147451, 46728, -3410}};
    public static final int[][] castles = new int[][]{{-22900, 104000, -14567, 116513}, {105737, 140128, 121331, 149842}, {18438, 152343, 25757, 164097}, {72876, 32336, 87556, 40457}, {134790, -2552, 154760, 20850}};
    public static int[][] castlespawns = new int[][]{{-14272, 116545, -3095}, {-18105, 110303, -2146}, {106912, 146553, -3169}, {115621, 145097, -2214}, {19842, 152076, -3076}, {22080, 159450, -2441}, {73265, 38930, -3116}, {81707, 37208, -1941}, {138485, 20179, -3397}, {147456, 6048, 253}};
    public static final int[][] castleownerspawns = new int[][]{{-18325, 112682, -2659}, {113291, 144631, -2328}, {22339, 157110, -2953}, {79289, 36896, -2464}, {147485, 8192, -470}};
    public static final int[][] castlewinareas = new int[][]{{-18178, 108056, -18064, 108169, -2450}, {117759, 145037, 117872, 145144, -2516}, {22019, 161585, 22129, 161700, -2650}, {83839, 37102, 83944, 37288, -2243}, {147424, 1607, 147521, 1716, -340}};
    public static final int[][] castlestatuespawns = new int[][]{{-18120, 107976, -2482}, {117950, 145087, -2515}, {22083, 161762, -2677}, {84028, 37180, -2277}, {147465, 1523, -373}};
    private L2WorldRegion[][] _worldRegions;

    public static boolean isInAttackZone(L2Character player) {
        int y2;
        int x2;
        int y1;
        int x1;
        boolean isIn = false;
        for (int i = 0; i < arenas.length; ++i) {
            x1 = arenas[i][0];
            y1 = arenas[i][1];
            x2 = arenas[i][2];
            y2 = arenas[i][3];
            if (player.getX() < Math.min(x1, x2) || player.getX() > Math.max(x1, x2) || player.getY() < Math.min(y1, y2) || player.getY() > Math.max(y1, y2)) continue;
            isIn = true;
        }
        if (L2Siege.getSiege() != 0) {
            int theCastle = L2Siege.getSiege() - 1;
            x1 = castles[theCastle][0];
            y1 = castles[theCastle][1];
            x2 = castles[theCastle][2];
            y2 = castles[theCastle][3];
            if (player.getX() >= Math.min(x1, x2) && player.getX() <= Math.max(x1, x2) && player.getY() >= Math.min(y1, y2) && player.getY() <= Math.max(y1, y2)) {
                isIn = true;
            }
        }
        return isIn;
    }

    private L2World() {
        switch (Config.MAP_TYPE) {
            case WorldObjectMap: {
                this._allObjects = new WorldObjectMap<L2Object>();
                break;
            }
            default: {
                this._allObjects = new L2ObjectHashMap<L2Object>();
            }
        }
        this._allPlayers = new ConcurrentHashMap();
        this._idFactory = IdFactory.getInstance();
        this.initRegions();
    }

    public static L2World getInstance() {
        return _instance;
    }

    public void storeObject(L2Object object) {
        this._allObjects.put(object);
    }

    public long timeStoreObject(L2Object object) {
        long time = System.currentTimeMillis();
        this._allObjects.put(object);
        return time -= System.currentTimeMillis();
    }

    public void removeObject(L2Object object) {
        this._allObjects.remove(object);
    }

    public long timeRemoveObject(L2Object object) {
        long time = System.currentTimeMillis();
        this._allObjects.remove(object);
        return time -= System.currentTimeMillis();
    }

    public L2Object findObject(int oID) {
        return this._allObjects.get(oID);
    }

    public long timeFindObject(int objectID) {
        long time = System.currentTimeMillis();
        this._allObjects.get(objectID);
        return time -= System.currentTimeMillis();
    }

    public L2PcInstance[] getAllGMs() {
        return GmListTable.getInstance().getAllGms();
    }

    public Collection<L2PcInstance> getAllPlayers() {
        return this._allPlayers.values();
    }

    public L2PcInstance getPlayer(String name) {
        return this._allPlayers.get(name.toLowerCase());
    }

    public void addVisibleObject(L2Object object, L2WorldRegion newRegion, L2Character dropper) {
        if (object instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)object;
            this._allPlayers.put(player.getName().toLowerCase(), player);
            if (player.isGM()) {
                GmListTable.getInstance().addGm(player);
            }
        }
        L2Object[] visible = this.getVisibleObjects(object, 2000);
        if (Config.DEBUG) {
            _log.finest("objects in range:" + visible.length);
        }
        for (int i = 0; i < visible.length; ++i) {
            visible[i].addKnownObject(object, dropper);
            object.addKnownObject(visible[i], dropper);
        }
    }

    public void removeFromAllPlayers(L2PcInstance cha) {
        this._allPlayers.remove(cha.getName().toLowerCase());
    }

    public void removeVisibleObject(L2Object object, L2WorldRegion oldRegion) {
        if (oldRegion != null) {
            oldRegion.removeVisibleObject(object);
            ArrayList<L2WorldRegion> regions = oldRegion.getSurroundingRegions();
            for (L2WorldRegion reg : regions) {
                Iterator<L2Object> iter = reg.iterateVisibleObjects();
                while (iter.hasNext()) {
                    L2Object obj = iter.next();
                    obj.removeKnownObject(object);
                    object.removeKnownObject(obj);
                }
            }
            object.removeAllKnownObjects();
            if (object instanceof L2PcInstance) {
                this.removeFromAllPlayers((L2PcInstance)object);
                if (((L2PcInstance)object).isGM()) {
                    GmListTable.getInstance().deleteGm((L2PcInstance)object);
                }
            }
        }
    }

    public L2Object[] getVisibleObjects(L2Object object) {
        L2WorldRegion reg = object.getCurrentWorldRegion();
        if (reg == null) {
            return new L2Object[0];
        }
        ArrayList<L2Object> result = new ArrayList<L2Object>();
        ArrayList<L2WorldRegion> _regions = reg.getSurroundingRegions();
        for (int i = 0; i < _regions.size(); ++i) {
            Iterator<L2Object> _objects = _regions.get(i).iterateVisibleObjects();
            while (_objects.hasNext()) {
                L2Object _object = _objects.next();
                if (_object.equals(object) || !_object.isVisible()) continue;
                result.add(_object);
            }
        }
        return result.toArray(new L2Object[result.size()]);
    }

    public L2Object[] getVisibleObjects(L2Object object, int radius) {
        if (object == null || !object.isVisible()) {
            return new L2Object[0];
        }
        int x = object.getX();
        int y = object.getY();
        int sqRadius = radius * radius;
        ArrayList<L2Object> result = new ArrayList<L2Object>();
        ArrayList<L2WorldRegion> _regions = object.getCurrentWorldRegion().getSurroundingRegions();
        for (int i = 0; i < _regions.size(); ++i) {
            Iterator<L2Object> _objects = _regions.get(i).iterateVisibleObjects();
            while (_objects.hasNext()) {
                int y1;
                int dy;
                int x1;
                int dx;
                L2Object _object = _objects.next();
                if (_object.equals(object) || (dx = (x1 = _object.getX()) - x) * dx + (dy = (y1 = _object.getY()) - y) * dy >= sqRadius) continue;
                result.add(_object);
            }
        }
        return result.toArray(new L2Object[result.size()]);
    }

    public L2Object[] getVisibleObjects3D(L2Object object, int radius) {
        if (object == null || !object.isVisible()) {
            return new L2Object[0];
        }
        int x = object.getX();
        int y = object.getY();
        int z = object.getZ();
        int sqRadius = radius * radius;
        ArrayList<L2Object> result = new ArrayList<L2Object>();
        ArrayList<L2WorldRegion> _regions = object.getCurrentWorldRegion().getSurroundingRegions();
        for (int i = 0; i < _regions.size(); ++i) {
            Iterator<L2Object> _objects = _regions.get(i).iterateVisibleObjects();
            while (_objects.hasNext()) {
                int z1;
                int dz;
                int y1;
                int dy;
                int x1;
                int dx;
                L2Object _object = _objects.next();
                if (_object.equals(object) || (dx = (x1 = _object.getX()) - x) * dx + (dy = (y1 = _object.getY()) - y) * dy + (dz = (z1 = _object.getZ()) - z) * dz >= sqRadius) continue;
                result.add(_object);
            }
        }
        return result.toArray(new L2Object[result.size()]);
    }

    public L2WorldRegion getRegion(int x, int y) {
        return this._worldRegions[(x >> 13) + OFFSET_X][(y >> 13) + OFFSET_Y];
    }

    private boolean validRegion(int x, int y) {
        return x >= 0 && x < REGIONS_X && y >= 0 && y < REGIONS_Y;
    }

    private void initRegions() {
        _log.config("L2World: Setting up World Regions");
        this._worldRegions = new L2WorldRegion[REGIONS_X + 1][REGIONS_Y + 1];
        for (int i = 0; i <= REGIONS_X; ++i) {
            for (int j = 0; j <= REGIONS_Y; ++j) {
                this._worldRegions[i][j] = new L2WorldRegion();
            }
        }
        for (int x = 0; x < REGIONS_X; ++x) {
            for (int y = 0; y < REGIONS_Y; ++y) {
                for (int a = -1; a <= 1; ++a) {
                    for (int b = -1; b <= 1; ++b) {
                        if (!this.validRegion(x + a, y + b)) continue;
                        this._worldRegions[x + a][y + b].addSurroundingRegion(this._worldRegions[x][y]);
                    }
                }
            }
        }
        _log.config("L2World: (" + REGIONS_X + " by " + REGIONS_Y + ") World Region Grid set up.");
    }
}

