/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.util.L2ObjectHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class L2WorldRegion {
    private L2ObjectHashSet<L2PcInstance> _allPlayers = new L2ObjectHashSet();
    private L2ObjectHashSet<L2Object> _visibleObjects = new L2ObjectHashSet();
    private ArrayList<L2WorldRegion> _surroundingRegions = new ArrayList();

    public void addVisibleObject(L2Object object) {
        if (Config.ASSERT) assert (object.getCurrentWorldRegion() == this);
        this._visibleObjects.put(object);
        if (object instanceof L2PcInstance) {
            this._allPlayers.put((L2PcInstance)object);
        }
    }

    public void removeVisibleObject(L2Object object) {
        if (Config.ASSERT) assert (object.getCurrentWorldRegion() == this || object.getCurrentWorldRegion() == null);
        this._visibleObjects.remove(object);
        if (object instanceof L2PcInstance) {
            this._allPlayers.remove((L2PcInstance)object);
        }
    }

    public void addSurroundingRegion(L2WorldRegion region) {
        this._surroundingRegions.add(region);
    }

    public ArrayList<L2WorldRegion> getSurroundingRegions() {
        return this._surroundingRegions;
    }

    public Iterator<L2PcInstance> iterateAllPlayers() {
        return this._allPlayers.iterator();
    }

    public Iterator<L2Object> iterateVisibleObjects() {
        return this._visibleObjects.iterator();
    }
}

