/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2ShortCut;

public class ShortCuts {
    private static Logger _log = Logger.getLogger(ShortCuts.class.getName());
    private L2PcInstance _owner;
    private Map<Integer, L2ShortCut> _shortCuts = new TreeMap<Integer, L2ShortCut>();

    public ShortCuts(L2PcInstance owner) {
        this._owner = owner;
    }

    public L2ShortCut[] getAllShortCuts() {
        return this._shortCuts.values().toArray(new L2ShortCut[this._shortCuts.values().size()]);
    }

    public L2ShortCut getShortCut(int slot, int page) {
        L2ShortCut sc = this._shortCuts.get(slot + page * 12);
        if (sc != null && sc.type == 1 && this._owner.getInventory().getItemByObjectId(sc.id) == null) {
            this.deleteShortCut(sc.slot, sc.page);
            sc = null;
        }
        return sc;
    }

    public void registerShortCut(L2ShortCut shortcut) {
        L2ShortCut oldShortCut = this._shortCuts.put(shortcut.slot + 12 * shortcut.page, shortcut);
        this.registerShortCutInDb(shortcut, oldShortCut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerShortCutInDb(L2ShortCut shortcut, L2ShortCut oldShortCut) {
        if (oldShortCut != null) {
            this.deleteShortCutFromDb(shortcut);
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO character_shortcuts (char_obj_id,slot,page,type,shortcut_id,level,unknown) values(?,?,?,?,?,?,?)");
            statement.setInt(1, this._owner.getObjectId());
            statement.setInt(2, shortcut.slot);
            statement.setInt(3, shortcut.page);
            statement.setInt(4, shortcut.type);
            statement.setInt(5, shortcut.id);
            statement.setInt(6, shortcut.level);
            statement.setInt(7, shortcut.unk);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not store shortcuts:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteShortCutFromDb(L2ShortCut shortcut) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_shortcuts WHERE char_obj_id=? AND slot=? AND page=?");
            statement.setInt(1, this._owner.getObjectId());
            statement.setInt(2, shortcut.slot);
            statement.setInt(3, shortcut.page);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not store shortcuts:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public void deleteShortCut(int slot, int page) {
        L2ShortCut old = this._shortCuts.remove(slot + page * 12);
        if (old != null) {
            this.deleteShortCutFromDb(old);
        }
    }

    public void deleteShortCutByObjectId(int objectId) {
        L2ShortCut toRemove = null;
        for (L2ShortCut shortcut : this._shortCuts.values()) {
            if (shortcut.type != 1 || shortcut.id != objectId) continue;
            toRemove = shortcut;
            break;
        }
        if (toRemove != null) {
            this.deleteShortCut(toRemove.slot, toRemove.page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        this._shortCuts.clear();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT char_obj_id, slot, page, type, shortcut_id, level, unknown FROM character_shortcuts WHERE char_obj_id=?");
            statement.setInt(1, this._owner.getObjectId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int slot = rset.getInt("slot");
                int page = rset.getInt("page");
                int type = rset.getInt("type");
                int id = rset.getInt("shortcut_id");
                int level = rset.getInt("level");
                int unk = rset.getInt("unknown");
                L2ShortCut sc = new L2ShortCut(slot, page, type, id, level, unk);
                this._shortCuts.put(slot + page * 12, sc);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not store shortcuts:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        for (L2ShortCut sc : this.getAllShortCuts()) {
            if (sc.type != 1 || this._owner.getInventory().getItemByObjectId(sc.id) != null) continue;
            this.deleteShortCut(sc.slot, sc.page);
        }
    }
}

